/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.FallingSlabBlock;
import btw.client.render.util.RenderUtils;
import btw.util.MiscUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class LooseSnowSlabBlock
extends FallingSlabBlock {
    @Environment(value=EnvType.CLIENT)
    private lx[] iconsHardening;

    public LooseSnowSlabBlock(int iBlockID) {
        super(iBlockID, aif.x);
        this.c(0.2f);
        this.setShovelsEffectiveOn();
        this.setBuoyant();
        this.a(o);
        this.c("fcBlockSnowLooseSlab");
        this.b(true);
        this.k(2);
        apa.w[iBlockID] = true;
        this.a(ve.b);
    }

    @Override
    public int a(int iMetadata, Random rand, int iFortuneModifier) {
        return wk.aE.cp;
    }

    @Override
    public int a(Random rand) {
        return 4;
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        this.c(world, i2, j2, k, iMetadata, 0);
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        if (world.t.e) {
            world.i(i2, j2, k);
            world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "random.fizz", 0.5f, 2.6f + (world.s.nextFloat() - world.s.nextFloat()) * 0.8f);
            for (int iTempCount = 0; iTempCount < 8; ++iTempCount) {
                world.a("largesmoke", (double)i2 + Math.random(), (double)j2 + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            this.scheduleCheckForFall(world, i2, j2, k);
        }
    }

    @Override
    public int getCombinedBlockID(int iMetadata) {
        return BTWBlocks.looseSnow.cz;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        if ((!this.hasStickySnowNeighborInContact(world, i2, j2, k) || this.getIsUpsideDown(world, i2, j2, k) && this.hasFallingBlockRestingOn(world, i2, j2, k)) && !this.checkForFall(world, i2, j2, k) && this.getIsUpsideDown(world, i2, j2, k)) {
            this.setIsUpsideDown(world, i2, j2, k, false);
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (MiscUtils.isIKInColdBiome(world, i2, k)) {
            if (rand.nextInt(1) == 0) {
                int iHardeningLevel = this.getHardeningLevel(world, i2, j2, k);
                if (iHardeningLevel < 7) {
                    this.setHardeningLevel(world, i2, j2, k, iHardeningLevel + 1);
                } else {
                    this.convertToSolidSnow(world, i2, j2, k);
                }
            }
        } else if (rand.nextInt(1) == 0) {
            int iHardeningLevel = this.getHardeningLevel(world, i2, j2, k);
            if (iHardeningLevel > 0) {
                this.setHardeningLevel(world, i2, j2, k, iHardeningLevel - 1);
            } else {
                this.melt(world, i2, j2, k);
            }
        }
    }

    @Override
    public boolean canBePlacedUpsideDownAtLocation(aab world, int i2, int j2, int k) {
        return this.hasStickySnowNeighborInContact(world, i2, j2, k, true);
    }

    @Override
    public void onPlayerWalksOnBlock(aab world, int i2, int j2, int k, sq player) {
        if (!this.checkForFall(world, i2, j2, k) && this.getIsUpsideDown(world, i2, j2, k)) {
            this.setIsUpsideDown(world, i2, j2, k, false);
        }
    }

    @Override
    public float getMovementModifier(aab world, int i2, int j2, int k) {
        return 0.8f;
    }

    @Override
    public boolean getCanBeSetOnFireDirectly(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean getCanBeSetOnFireDirectlyByItem(aak blockAccess, int i2, int j2, int k) {
        return false;
    }

    @Override
    public boolean setOnFireDirectly(aab world, int i2, int j2, int k) {
        this.melt(world, i2, j2, k);
        return true;
    }

    @Override
    public int getChanceOfFireSpreadingDirectlyTo(aak blockAccess, int i2, int j2, int k) {
        return 60;
    }

    @Override
    protected boolean r_() {
        return true;
    }

    @Override
    protected wm c_(int iMetadata) {
        return new wm(this.cz, 1, 0);
    }

    @Override
    public boolean canBePistonShoveled(aab world, int i2, int j2, int k) {
        return true;
    }

    public int getHardeningLevel(aak blockAccess, int i2, int j2, int k) {
        return this.getHardeningLevel(blockAccess.h(i2, j2, k));
    }

    public int getHardeningLevel(int iMetadata) {
        return (iMetadata & 0xE) >> 1;
    }

    public void setHardeningLevel(aab world, int i2, int j2, int k, int iLevel) {
        int iMetadata = this.setHardeningLevel(world.h(i2, j2, k), iLevel);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public int setHardeningLevel(int iMetadata, int iLevel) {
        return (iMetadata &= 0xFFFFFFF1) | iLevel << 1;
    }

    private void convertToSolidSnow(aab world, int i2, int j2, int k) {
        int iNewMetadata = BTWBlocks.solidSnowSlab.setIsUpsideDown(0, this.getIsUpsideDown(world, i2, j2, k));
        world.setBlockAndMetadataWithNotify(i2, j2, k, BTWBlocks.solidSnowSlab.cz, iNewMetadata);
    }

    private void melt(aab world, int i2, int j2, int k) {
        MiscUtils.placeNonPersistentWaterMinorSpread(world, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconsHardening = new lx[8];
        for (int iTempIndex = 0; iTempIndex < 8; ++iTempIndex) {
            this.iconsHardening[iTempIndex] = register.a("fcOverlaySnowLoose_" + iTempIndex);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf renderBlocks, int i2, int j2, int k, boolean bFirstPassResult) {
        int iHardeningLevel;
        if (bFirstPassResult && (iHardeningLevel = this.getHardeningLevel(renderBlocks.a, i2, j2, k)) >= 0 && iHardeningLevel <= 7) {
            this.renderBlockWithTexture(renderBlocks, i2, j2, k, this.iconsHardening[iHardeningLevel]);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        renderBlocks.renderBlockAsItemVanilla(this, iItemDamage, fBrightness);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, this.iconsHardening[0]);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderFallingBlock(bgf renderBlocks, int i2, int j2, int k, int iMetadata) {
        renderBlocks.setRenderAllFaces(true);
        renderBlocks.setRenderBounds(this.getBlockBoundsFromPoolFromMetadata(iMetadata));
        renderBlocks.p(this, i2, j2, k);
        RenderUtils.renderStandardBlockWithTexture(renderBlocks, this, i2, j2, k, this.iconsHardening[this.getHardeningLevel(iMetadata)]);
        renderBlocks.setRenderAllFaces(false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random rand) {
        this.emitHardeningParticles(world, (double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, rand);
    }

    @Environment(value=EnvType.CLIENT)
    private void emitHardeningParticles(aab world, double dCenterX, double dCenterY, double dCenterZ, Random rand) {
        for (int iTempCount = 0; iTempCount < 1; ++iTempCount) {
            double xPos = dCenterX - 0.6 + rand.nextDouble() * 1.2;
            double yPos = dCenterY - 0.6 + rand.nextDouble() * 1.2;
            double zPos = dCenterZ - 0.6 + rand.nextDouble() * 1.2;
            world.a("fcwhitecloud", xPos, yPos, zPos, 0.0, 0.0, 0.0);
        }
    }
}

