/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.MechanicalBlock;
import btw.block.tileentity.LoomTileEntity;
import btw.block.util.Flammability;
import btw.block.util.MechPowerUtils;
import btw.inventory.util.InventoryUtils;
import btw.util.MiscUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class LoomBlock
extends akz
implements MechanicalBlock {
    private static final int TICK_RATE = 10;
    @Environment(value=EnvType.CLIENT)
    private lx iconFront;
    @Environment(value=EnvType.CLIENT)
    private lx iconTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconBottom;

    public LoomBlock(int blockID) {
        super(blockID, BTWBlocks.plankMaterial);
        this.c(1.0f);
        this.b(5.0f);
        this.setAxesEffectiveOn(true);
        this.setBuoyant();
        this.setFireProperties(Flammability.PLANKS);
        this.a(g);
        this.b(true);
        this.a(ve.d);
        this.c("fcBlockLoom");
    }

    public aqp b(aab var1) {
        return new LoomTileEntity();
    }

    public int a(aab world) {
        return 10;
    }

    public void a(aab world, int x2, int y2, int z2) {
        super.a(world, x2, y2, z2);
        world.a(x2, y2, z2, this.cz, this.a(world));
    }

    public void a(aab world, int x2, int y2, int z2, int blockID, int metadata) {
        InventoryUtils.ejectInventoryContents(world, x2, y2, z2, (lt)world.r(x2, y2, z2));
        super.a(world, x2, y2, z2, blockID, metadata);
    }

    public int a(aab world, int x2, int y2, int z2, int side, float hitX, float hitY, float hitZ, int metadata) {
        return this.setFacing(metadata, side);
    }

    public int preBlockPlacedBy(aab world, int x2, int y2, int z2, int metadata, ng entityLiving) {
        int facing = MiscUtils.convertOrientationToFlatBlockFacing(entityLiving);
        return this.setFacing(metadata, facing);
    }

    public boolean a(aab world, int x2, int y2, int z2, sq player, int side, float hitX, float hitY, float hitZ) {
        if (!world.I) {
            LoomTileEntity var13 = (LoomTileEntity)world.r(x2, y2, z2);
            if (player instanceof jc) {
                // empty if block
            }
        }
        return true;
    }

    public void a(aab world, int i2, int j2, int k, Random random) {
        boolean isReceivingPower = this.isInputtingMechanicalPower(world, i2, j2, k);
        boolean isPowered = this.isMechPowered(world, i2, j2, k);
        if (isPowered != isReceivingPower) {
            this.setMechPowered(world, i2, j2, k, isReceivingPower);
        }
    }

    public void randomUpdateTick(aab world, int x2, int y2, int z2, Random rand) {
        if (!this.isCurrentStateValid(world, x2, y2, z2) && !world.isUpdateScheduledForBlock(x2, y2, z2, this.cz)) {
            world.a(x2, y2, z2, this.cz, this.a(world));
        }
    }

    public void a(aab world, int x2, int y2, int z2, int blockID) {
        if (!this.isCurrentStateValid(world, x2, y2, z2) && !world.isUpdatePendingThisTickForBlock(x2, y2, z2, this.cz)) {
            world.a(x2, y2, z2, this.cz, this.a(world));
        }
    }

    public int getFacing(int metadata) {
        return (metadata & 3) + 2;
    }

    public int setFacing(int metadata, int facing) {
        int poweredMetadata = metadata & 0xC;
        int clampedFacing = kx.a(facing, 2, 5);
        return clampedFacing - 2 & 3 | poweredMetadata;
    }

    public boolean isMechPowered(int metadata) {
        return (metadata & 4) >> 2 == 1;
    }

    public boolean isMechPowered(aab world, int x2, int y2, int z2) {
        return this.isMechPowered(world.h(x2, y2, z2));
    }

    public int setMechPowered(int metadata, boolean isPowered) {
        int poweredState = isPowered ? 1 : 0;
        int poweredMetadata = poweredState << 2;
        return metadata & 0xB | poweredMetadata;
    }

    public void setMechPowered(aab world, int x2, int y2, int z2, boolean isPowered) {
        int newMetadata;
        int metadata = world.h(x2, y2, z2);
        if (metadata != (newMetadata = this.setMechPowered(metadata, isPowered))) {
            world.setBlockMetadataWithNotify(x2, y2, z2, newMetadata);
        }
    }

    public boolean isProcessing(int metadata) {
        return (metadata & 8) >> 3 == 1;
    }

    public boolean isProcessing(aab world, int x2, int y2, int z2) {
        return this.isProcessing(world.h(x2, y2, z2));
    }

    public int setProcessing(int metadata, boolean isPowered) {
        int processingState = isPowered ? 1 : 0;
        int processingMetadata = processingState << 3;
        return metadata & 7 | processingMetadata;
    }

    public void setProcessing(aab world, int x2, int y2, int z2, boolean isProcessing) {
        int newMetadata;
        int metadata = world.h(x2, y2, z2);
        if (metadata != (newMetadata = this.setProcessing(metadata, isProcessing))) {
            world.setBlockMetadataWithNotify(x2, y2, z2, newMetadata);
        }
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechanicalPower(aab world, int x2, int y2, int z2) {
        return MechPowerUtils.isBlockPoweredByAxle(world, x2, y2, z2, this);
    }

    @Override
    public boolean isOutputtingMechanicalPower(aab world, int x2, int y2, int z2) {
        return false;
    }

    @Override
    public boolean canInputAxlePowerToFacing(aab world, int x2, int y2, int z2, int facing) {
        return facing != 1 && facing != s.a[this.getFacing(world, x2, y2, z2)];
    }

    @Override
    public void overpower(aab world, int x2, int y2, int z2) {
    }

    public boolean isCurrentStateValid(aab world, int x2, int y2, int z2) {
        boolean isReceivingPower = this.isInputtingMechanicalPower(world, x2, y2, z2);
        boolean isMechPowered = this.isMechPowered(world, x2, y2, z2);
        return isMechPowered == isReceivingPower;
    }

    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconFront = register.a("fcBlockLoom_front");
        this.iconTop = register.a("fcBlockLoom_top");
        this.iconBottom = register.a("fcBlockLoom_bottom");
    }

    @Environment(value=EnvType.CLIENT)
    public lx a(int side, int meta) {
        if (side == 0) {
            return this.iconBottom;
        }
        if (side == 1) {
            return this.iconTop;
        }
        if (side == s.a[this.getFacing(meta)]) {
            return this.iconFront;
        }
        return this.cQ;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf render, int x2, int y2, int z2) {
        int facing = this.getFacing(render.a.h(x2, y2, z2));
        switch (facing) {
            case 3: {
                render.setUVRotateTop(0);
                break;
            }
            case 2: {
                render.setUVRotateTop(3);
                break;
            }
            case 5: {
                render.setUVRotateTop(2);
                break;
            }
            case 4: {
                render.setUVRotateTop(1);
            }
        }
        boolean success = super.renderBlock(render, x2, y2, z2);
        render.clearUVRotation();
        return success;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf render, int metadata, float brightness) {
        render.setUVRotateTop(3);
        render.renderBlockAsItemVanilla((apa)((Object)this), metadata, brightness);
        render.clearUVRotation();
    }

    @Environment(value=EnvType.CLIENT)
    public void clientNotificationOfMetadataChange(aab world, int x2, int y2, int z2, int oldMetadata, int newMetadata) {
        if (!this.isMechPowered(oldMetadata) && this.isMechPowered(newMetadata)) {
            boolean isProcessing = this.isProcessing(newMetadata);
            this.playSound(world, x2, y2, z2, world.s, isProcessing);
            this.emitParticles(world, x2, y2, z2, world.s, isProcessing);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int x2, int y2, int z2, Random random) {
        if (this.isMechPowered(world, x2, y2, z2)) {
            boolean isProcessing = this.isProcessing(world, x2, y2, z2);
            this.playSound(world, x2, y2, z2, world.s, isProcessing);
            this.emitParticles(world, x2, y2, z2, world.s, isProcessing);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void emitParticles(aab world, int x2, int y2, int z2, Random rand, boolean isProcessing) {
        String particle = isProcessing ? "fcwhitesmoke" : "smoke";
        for (int i2 = 0; i2 < 5; ++i2) {
            float smokeX = (float)x2 + rand.nextFloat();
            float smokeY = (float)y2 + rand.nextFloat() * 0.5f + 1.0f;
            float smokeZ = (float)z2 + rand.nextFloat();
            world.a(particle, (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void playSound(aab world, int x2, int y2, int z2, Random rand, boolean isProcessing) {
    }
}

