/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.PlanksBlock;
import btw.block.util.Flammability;
import btw.item.BTWItems;
import btw.item.items.ChiselItem;
import btw.item.util.ItemUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class LogBlock
extends apk {
    public static apa[] chewedLogArray;
    @Environment(value=EnvType.CLIENT)
    public static final String[] topTextureTypes;
    @Environment(value=EnvType.CLIENT)
    private lx[] topIconArray;
    @Environment(value=EnvType.CLIENT)
    public static final String[] trunkTextureTypes;
    @Environment(value=EnvType.CLIENT)
    private lx[] trunkIconArray;
    @Environment(value=EnvType.CLIENT)
    public static final String[] trunkTopTextureTypes;
    @Environment(value=EnvType.CLIENT)
    private lx[] trunkTopIconArray;

    public LogBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.logMaterial);
        this.c(1.25f);
        this.b(3.33f);
        this.setAxesEffectiveOn();
        this.setChiselsEffectiveOn();
        this.setBuoyant();
        this.setFireProperties(Flammability.LOGS);
        this.a(g);
        this.c("log");
    }

    @Override
    public float l(aab world, int i2, int j2, int k) {
        float fHardness = super.l(world, i2, j2, k);
        int iMetadata = world.h(i2, j2, k);
        if (this.getIsStump(iMetadata)) {
            fHardness *= 3.0f;
        }
        return fHardness;
    }

    @Override
    public boolean getIsProblemToRemove(wm toolStack, aak blockAccess, int i2, int j2, int k) {
        if (this.getIsStump(blockAccess, i2, j2, k)) {
            return !this.isWorkStumpItemConversionTool(toolStack, (aab)blockAccess, i2, j2, k);
        }
        return false;
    }

    @Override
    public boolean getDoesStumpRemoverWorkOnBlock(aak blockAccess, int i2, int j2, int k) {
        return this.getIsStump(blockAccess, i2, j2, k);
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int x2, int y2, int z2, int iFromSide) {
        int oldMetadata = world.h(x2, y2, z2);
        int newMetadata = 0;
        int chewedLogID = LogBlock.chewedLogArray[oldMetadata & 3].cz;
        if (this.getIsStump(oldMetadata)) {
            if (this.isWorkStumpItemConversionTool(stack, world, x2, y2, z2)) {
                world.e(2268, x2, y2, z2, 0);
                world.setBlockAndMetadataWithNotify(x2, y2, z2, BTWBlocks.workStump.cz, oldMetadata & 3 | 8);
                return true;
            }
            newMetadata = BTWBlocks.oakChewedLog.setIsStump(oldMetadata & 0xC);
        } else {
            int orientation = oldMetadata >> 2 & 3;
            newMetadata = BTWBlocks.oakChewedLog.setOrientation(oldMetadata & 0xC, orientation);
        }
        world.setBlockAndMetadataWithNotify(x2, y2, z2, chewedLogID, newMetadata);
        if (!world.I) {
            ItemUtils.ejectStackFromBlockTowardsFacing(world, x2, y2, z2, new wm(BTWItems.bark, 1, oldMetadata & 3), iFromSide);
        }
        return true;
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, int blockID, int metadata) {
        int leafCheckRange = 4;
        int chunkCheckRange = leafCheckRange + 1;
        if (world.e(x2 - chunkCheckRange, y2 - chunkCheckRange, z2 - chunkCheckRange, x2 + chunkCheckRange, y2 + chunkCheckRange, z2 + chunkCheckRange)) {
            for (int i2 = -leafCheckRange; i2 <= leafCheckRange; ++i2) {
                for (int j2 = -leafCheckRange; j2 <= leafCheckRange; ++j2) {
                    for (int k = -leafCheckRange; k <= leafCheckRange; ++k) {
                        int oldMetadata;
                        int offsetBlockID = world.a(x2 + i2, y2 + j2, z2 + k);
                        apa offsetBlock = apa.r[offsetBlockID];
                        if (offsetBlock == null || !offsetBlock.isLeafBlock(world, x2, y2, z2) || ((oldMetadata = world.h(x2 + i2, y2 + j2, z2 + k)) & 8) != 0) continue;
                        world.b(x2 + i2, y2 + j2, z2 + k, oldMetadata | 8, 4);
                    }
                }
            }
        }
    }

    @Override
    public boolean getCanBlockBeIncinerated(aab world, int i2, int j2, int k) {
        return !this.getIsStump(world, i2, j2, k);
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, 6, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.bark.cp, 1, iMetadata & 3, fChanceOfDrop);
        return true;
    }

    @Override
    public void onDestroyedByFire(aab world, int i2, int j2, int k, int iFireAge, boolean bForcedFireSpread) {
        this.convertToSmouldering(world, i2, j2, k);
    }

    @Override
    public int rotateMetadataAroundJAxis(int iMetadata, boolean bReverse) {
        int iAxisAlignment = iMetadata & 0xC;
        if (iAxisAlignment != 0) {
            if (iAxisAlignment == 4) {
                iAxisAlignment = 8;
            } else if (iAxisAlignment == 8) {
                iAxisAlignment = 4;
            }
            iMetadata = iMetadata & 0xFFFFFFF3 | iAxisAlignment;
        }
        return iMetadata;
    }

    @Override
    public int getFurnaceBurnTime(int iItemDamage) {
        return PlanksBlock.getFurnaceBurnTimeByWoodType(iItemDamage) * 4;
    }

    @Override
    public boolean isLog(aak blockAccess, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean canSupportLeaves(aak blockAccess, int x2, int y2, int z2) {
        return !this.isDeadStump(blockAccess, x2, y2, z2);
    }

    public void convertToSmouldering(aab world, int i2, int j2, int k) {
        int iNewMetadata = BTWBlocks.smolderingLog.setIsStump(0, this.getIsStump(world, i2, j2, k));
        world.setBlockAndMetadataWithNotify(i2, j2, k, BTWBlocks.smolderingLog.cz, iNewMetadata);
    }

    public boolean getIsStump(int iMetadata) {
        return (iMetadata & 0xC) == 12;
    }

    public boolean getIsStump(aak blockAccess, int i2, int j2, int k) {
        int iMetadata;
        int iBlockID = blockAccess.a(i2, j2, k);
        return iBlockID == apa.N.cz && this.getIsStump(iMetadata = blockAccess.h(i2, j2, k));
    }

    public boolean isDeadStump(aak blockAccess, int i2, int j2, int k) {
        int iBlockAboveID;
        return this.getIsStump(blockAccess, i2, j2, k) && (iBlockAboveID = blockAccess.h(i2, j2 + 1, k)) != apa.N.cz;
    }

    public boolean isWorkStumpItemConversionTool(wm stack, aab world, int i2, int j2, int k) {
        if (stack != null && stack.b() instanceof ChiselItem) {
            int iToolLevel = ((ChiselItem)stack.b()).toolMaterial.d();
            return iToolLevel >= 2;
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int side, int metadata) {
        int facing = metadata >> 2 & 3;
        if ((metadata & 0xC) == 12) {
            if (side > 1) {
                return this.trunkIconArray[metadata & 3];
            }
            return this.trunkTopIconArray[metadata & 3];
        }
        if (facing == 0 && (side == 0 || side == 1)) {
            return this.topIconArray[metadata & 3];
        }
        if (facing == 1 && (side == 4 || side == 5)) {
            return this.topIconArray[metadata & 3];
        }
        if (facing == 2 && (side == 2 || side == 3)) {
            return this.topIconArray[metadata & 3];
        }
        return super.a(side, metadata);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly iconRegister) {
        this.topIconArray = new lx[trunkTextureTypes.length];
        this.trunkIconArray = new lx[trunkTextureTypes.length];
        this.trunkTopIconArray = new lx[trunkTextureTypes.length];
        for (int i2 = 0; i2 < this.trunkIconArray.length; ++i2) {
            this.topIconArray[i2] = iconRegister.a(topTextureTypes[i2]);
            this.trunkIconArray[i2] = iconRegister.a(trunkTextureTypes[i2]);
            this.trunkTopIconArray[i2] = iconRegister.a(trunkTopTextureTypes[i2]);
        }
        super.a(iconRegister);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        renderer.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return renderer.q(this, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf renderBlocks, int i2, int j2, int k, boolean bFirstPassResult) {
        this.renderCookingByKiLnOverlay(renderBlocks, i2, j2, k, bFirstPassResult);
    }

    static {
        topTextureTypes = new String[]{"tree_top", "fcBlockLogTopSpruce", "fcBlockLogTopBirch", "fcBlockLogTopJungle"};
        trunkTextureTypes = new String[]{"fcBlockTrunkOak", "fcBlockTrunkSpruce", "fcBlockTrunkBirch", "fcBlockTrunkJungle"};
        trunkTopTextureTypes = new String[]{"fcBlockTrunkTop", "fcBlockTrunkTopSpruce", "fcBlockTrunkTopBirch", "fcBlockTrunkTopJungle"};
    }
}

