/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.DetectorBlock;
import btw.block.blocks.DetectorLogicBlock;
import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class LensBlock
extends apa {
    public static final int LENS_MAX_RANGE = 128;
    private static final int LENS_TICK_RATE = 1;
    private static final float MIN_TRIGGER_LIGHT_VALUE = 12.0f;
    @Environment(value=EnvType.CLIENT)
    private lx iconOutput;
    @Environment(value=EnvType.CLIENT)
    private lx iconInput;

    public LensBlock(int iBlockID) {
        super(iBlockID, aif.f);
        this.c(3.5f);
        this.b(true);
        this.a(apa.j);
        this.c("fcBlockLens");
        this.a(ve.d);
    }

    @Override
    public int a(aab world) {
        return 1;
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        world.a(i2, j2, k, this.cz, this.a(world));
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        return this.setFacing(iMetadata, apa.getOppositeFacing(iFacing));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, ng entityLiving, wm stack) {
        int iFacing = MiscUtils.convertPlacingEntityOrientationToBlockFacingReversed(entityLiving);
        this.setFacing(world, i2, j2, k, iFacing);
    }

    @Override
    public void k(aab world, int i2, int j2, int k, int iMetadata) {
        this.setupBeam(world, i2, j2, k);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID, int iMetadata) {
        this.removeBeam(world, i2, j2, k);
        super.a(world, i2, j2, k, iBlockID, iMetadata);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int l2) {
        if (!world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        int iFacing = this.getFacing(world, i2, j2, k);
        boolean bIsLightDetector = this.isDirectlyFacingBlockDetector(world, i2, j2, k);
        if (!bIsLightDetector) {
            boolean bLightOn = this.checkForInputLight(world, i2, j2, k);
            if (this.isLit(world, i2, j2, k) != bLightOn) {
                this.setLit(world, i2, j2, k, bLightOn);
                if (bLightOn) {
                    this.turnBeamOn(world, i2, j2, k);
                } else {
                    this.turnBeamOff(world, i2, j2, k);
                }
            }
            BlockPos targetPos = new BlockPos(i2, j2, k);
            targetPos.addFacingAsOffset(iFacing);
            if (world.a(targetPos.x, targetPos.y, targetPos.z) == 0) {
                DetectorLogicBlock logicBlock = (DetectorLogicBlock)BTWBlocks.detectorLogic;
                logicBlock.propagateBeamsThroughBlock(world, targetPos.x, targetPos.y, targetPos.z);
            }
        } else {
            boolean bShouldBeOn;
            BlockPos sourcePos = new BlockPos(i2, j2, k);
            sourcePos.addFacingAsOffset(apa.getOppositeFacing(iFacing));
            int iSourceLightValue = world.n(sourcePos.x, sourcePos.y, sourcePos.z);
            boolean bl = bShouldBeOn = iSourceLightValue >= 8;
            if (this.isLit(world, i2, j2, k) != bShouldBeOn) {
                this.setLit(world, i2, j2, k, bShouldBeOn);
            }
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    @Override
    public int h() {
        return 2;
    }

    @Override
    public int getFacing(int iMetadata) {
        return (iMetadata & 0xFFFFFFFE) >> 1;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata = iMetadata & 1 | iFacing << 1;
        return iMetadata;
    }

    @Override
    public boolean canRotateOnTurntable(aak iBlockAccess, int i2, int j2, int k) {
        return false;
    }

    @Override
    public boolean canTransmitRotationHorizontallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return false;
    }

    @Override
    public boolean canTransmitRotationVerticallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return false;
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iFacing = this.getFacing(world, i2, j2, k);
        iFacing = apa.cycleFacing(iFacing, bReverse);
        this.setFacing(world, i2, j2, k, iFacing);
        world.g(i2, j2, k, i2, j2, k);
        return true;
    }

    public boolean isLit(aak iblockaccess, int i2, int j2, int k) {
        return (iblockaccess.h(i2, j2, k) & 1) > 0;
    }

    public void setLit(aab world, int i2, int j2, int k, boolean bOn) {
        if (bOn != this.isLit(world, i2, j2, k)) {
            int iMetaData = world.h(i2, j2, k);
            iMetaData = bOn ? (iMetaData |= 1) : (iMetaData &= 0xFFFFFFFE);
            world.setBlockMetadataWithNotify(i2, j2, k, iMetaData);
            world.f(i2, j2, k, this.cz);
            world.g(i2, j2, k, i2, j2, k);
        }
    }

    private boolean checkForInputLight(aab world, int i2, int j2, int k) {
        int iFacing = this.getFacing(world, i2, j2, k);
        int iTargetFacing = apa.getOppositeFacing(iFacing);
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iTargetFacing);
        int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
        if (iTargetBlockID > 0) {
            if ((float)apa.getLightValueForBlock(world, i2, j2, k, apa.r[iTargetBlockID]) > 12.0f) {
                if (iTargetBlockID != BTWBlocks.glowingDetectorLogic.cz) {
                    return true;
                }
                DetectorLogicBlock logicBlock = (DetectorLogicBlock)BTWBlocks.glowingDetectorLogic;
                if (logicBlock.shouldBeProjectingToFacing(world, targetPos.x, targetPos.y, targetPos.z, iFacing)) {
                    return true;
                }
            } else if (iTargetBlockID == this.cz && this.isLit(world, targetPos.x, targetPos.y, targetPos.z) && this.getFacing(world, targetPos.x, targetPos.y, targetPos.z) == iFacing) {
                return true;
            }
        }
        return false;
    }

    public void setupBeam(aab world, int i2, int j2, int k) {
        DetectorLogicBlock logicBlock = (DetectorLogicBlock)BTWBlocks.detectorLogic;
        logicBlock.createLensBeamFromBlock(world, i2, j2, k, this.getFacing(world, i2, j2, k), 128);
    }

    private void removeBeam(aab world, int i2, int j2, int k) {
        DetectorLogicBlock logicBlock = (DetectorLogicBlock)BTWBlocks.detectorLogic;
        logicBlock.removeLensBeamFromBlock(world, i2, j2, k, this.getFacing(world, i2, j2, k), 128);
    }

    private void turnBeamOn(aab world, int i2, int j2, int k) {
        DetectorLogicBlock logicBlock = (DetectorLogicBlock)BTWBlocks.detectorLogic;
        logicBlock.turnBeamOnFromBlock(world, i2, j2, k, this.getFacing(world, i2, j2, k), 128);
    }

    private void turnBeamOff(aab world, int i2, int j2, int k) {
        DetectorLogicBlock logicBlock = (DetectorLogicBlock)BTWBlocks.detectorLogic;
        logicBlock.turnBeamOffFromBlock(world, i2, j2, k, this.getFacing(world, i2, j2, k), 128);
    }

    private boolean isDirectlyFacingBlockDetector(aab world, int i2, int j2, int k) {
        int iDetectorFacing;
        int iFacing = this.getFacing(world, i2, j2, k);
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iFacing);
        int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
        return iTargetBlockID == BTWBlocks.detectorBlock.cz && (iDetectorFacing = ((DetectorBlock)BTWBlocks.detectorBlock).getFacing(world, targetPos.x, targetPos.y, targetPos.z)) == apa.getOppositeFacing(iFacing);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconOutput = register.a("fcBlockLens_output");
        this.iconInput = register.a("fcBlockLens_input");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 5) {
            return this.iconOutput;
        }
        if (iSide == 4) {
            return this.iconInput;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (iSide == iFacing) {
            return this.iconOutput;
        }
        if (iSide == apa.getOppositeFacing(iFacing)) {
            return this.iconInput;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        aak blockAccess = renderer.a;
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(blockAccess, i2, j2, k));
        if (!this.isLit(blockAccess, i2, j2, k)) {
            return renderer.p(this, i2, j2, k);
        }
        return this.renderLitLens(renderer, blockAccess, i2, j2, k, this);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderLitLens(bgf renderer, aak blockAccess, int i2, int j2, int k, apa block) {
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        boolean flag = false;
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        int iColorMultiplier = block.c(blockAccess, i2, j2, k);
        float f2 = (float)(iColorMultiplier >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(iColorMultiplier >> 8 & 0xFF) / 255.0f;
        float f22 = (float)(iColorMultiplier & 0xFF) / 255.0f;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4 * f2;
        float f8 = f4 * f1;
        float f9 = f4 * f22;
        float f10 = f3 * f2;
        float f11 = f5 * f2;
        float f12 = f6 * f2;
        float f13 = f3 * f1;
        float f14 = f5 * f1;
        float f15 = f6 * f1;
        float f16 = f3 * f22;
        float f17 = f5 * f22;
        float f18 = f6 * f22;
        bgd tessellator = bgd.a;
        if (renderer.getRenderAllFaces() || block.a(blockAccess, i2, j2 - 1, k, 0)) {
            if (iFacing == 0) {
                tessellator.a(1.0f, 1.0f, 1.0f);
                tessellator.c(blockAccess.h(i2, j2, k, 15));
            } else {
                tessellator.c(block.e(blockAccess, i2, j2 - 1, k));
                tessellator.a(f10, f13, f16);
            }
            renderer.a(block, (double)i2, (double)j2, (double)k, block.b_(blockAccess, i2, j2, k, 0));
            flag = true;
        }
        if (renderer.getRenderAllFaces() || block.a(blockAccess, i2, j2 + 1, k, 1)) {
            if (iFacing == 1) {
                tessellator.a(1.0f, 1.0f, 1.0f);
                tessellator.c(blockAccess.h(i2, j2, k, 15));
            } else {
                tessellator.c(block.e(blockAccess, i2, j2 + 1, k));
                tessellator.a(f7, f8, f9);
            }
            renderer.b(block, (double)i2, (double)j2, (double)k, block.b_(blockAccess, i2, j2, k, 1));
            flag = true;
        }
        if (renderer.getRenderAllFaces() || block.a(blockAccess, i2, j2, k - 1, 2)) {
            if (iFacing == 2) {
                tessellator.a(1.0f, 1.0f, 1.0f);
                tessellator.c(blockAccess.h(i2, j2, k, 15));
            } else {
                tessellator.c(block.e(blockAccess, i2, j2, k - 1));
                tessellator.a(f11, f14, f17);
            }
            renderer.c(block, (double)i2, (double)j2, (double)k, block.b_(blockAccess, i2, j2, k, 2));
            flag = true;
        }
        if (renderer.getRenderAllFaces() || block.a(blockAccess, i2, j2, k + 1, 3)) {
            if (iFacing == 3) {
                tessellator.a(1.0f, 1.0f, 1.0f);
                tessellator.c(blockAccess.h(i2, j2, k, 15));
            } else {
                tessellator.c(block.e(blockAccess, i2, j2, k + 1));
                tessellator.a(f11, f14, f17);
            }
            renderer.d(block, i2, j2, k, block.b_(blockAccess, i2, j2, k, 3));
            flag = true;
        }
        if (renderer.getRenderAllFaces() || block.a(blockAccess, i2 - 1, j2, k, 4)) {
            if (iFacing == 4) {
                tessellator.a(1.0f, 1.0f, 1.0f);
                tessellator.c(blockAccess.h(i2, j2, k, 15));
            } else {
                tessellator.c(block.e(blockAccess, i2 - 1, j2, k));
                tessellator.a(f12, f15, f18);
            }
            renderer.e(block, i2, j2, k, block.b_(blockAccess, i2, j2, k, 4));
            flag = true;
        }
        if (renderer.getRenderAllFaces() || block.a(blockAccess, i2 + 1, j2, k, 5)) {
            if (iFacing == 5) {
                tessellator.a(1.0f, 1.0f, 1.0f);
                tessellator.c(blockAccess.h(i2, j2, k, 15));
            } else {
                tessellator.c(block.e(blockAccess, i2 + 1, j2, k));
                tessellator.a(f12, f15, f18);
            }
            renderer.f(block, i2, j2, k, block.b_(blockAccess, i2, j2, k, 5));
            flag = true;
        }
        return flag;
    }
}

