/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.MortarReceiverBlock;
import btw.client.render.util.RenderUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public abstract class LavaReceiverBlock
extends MortarReceiverBlock {
    public static final int LAVA_FILL_TICK_RATE = 20;
    public static final int LAVA_HARDEN_TICK_RATE = 2;

    public LavaReceiverBlock(int iBlockID, aif material) {
        super(iBlockID, material);
        this.b(true);
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        if (!this.scheduleUpdatesForLavaAndWaterContact(world, i2, j2, k)) {
            super.a(world, i2, j2, k);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        if (!this.checkForFall(world, i2, j2, k)) {
            if (this.getHasLavaInCracks(world, i2, j2, k)) {
                if (this.hasWaterAbove(world, i2, j2, k)) {
                    world.e(2227, i2, j2, k, 0);
                    world.setBlockAndMetadataWithNotify(i2, j2, k, apa.x.cz, this.getStrata(world, i2, j2, k));
                    return;
                }
            } else if (this.hasLavaAbove(world, i2, j2, k)) {
                this.setHasLavaInCracks(world, i2, j2, k, true);
            }
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (this.getHasLavaInCracks(world, i2, j2, k) && world.isRainingAtPos(i2, j2 + 1, k)) {
            world.e(2227, i2, j2, k, 0);
            world.setBlockAndMetadataWithNotify(i2, j2, k, apa.x.cz, this.getStrata(world, i2, j2, k));
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        if (!this.scheduleUpdatesForLavaAndWaterContact(world, i2, j2, k)) {
            super.a(world, i2, j2, k, iNeighborBlockID);
        }
    }

    @Override
    protected boolean r_() {
        return false;
    }

    @Override
    public boolean getIsBlockWarm(aak blockAccess, int i2, int j2, int k) {
        return this.getHasLavaInCracks(blockAccess, i2, j2, k);
    }

    public int getStrata(aak blockAccess, int i2, int j2, int k) {
        return this.getStrata(blockAccess.h(i2, j2, k));
    }

    public int getStrata(int iMetadata) {
        return (iMetadata & 0xC) >>> 2;
    }

    protected boolean getHasLavaInCracks(int iMetadata) {
        return (iMetadata & 1) != 0;
    }

    protected boolean getHasLavaInCracks(aak blockAccess, int i2, int j2, int k) {
        return this.getHasLavaInCracks(blockAccess.h(i2, j2, k));
    }

    protected int setHasLavaInCracks(int iMetadata, boolean bHasLava) {
        iMetadata = bHasLava ? (iMetadata |= 1) : (iMetadata &= 0xFFFFFFFE);
        return iMetadata;
    }

    protected void setHasLavaInCracks(aab world, int i2, int j2, int k, boolean bHasLava) {
        int iMetadata = this.setHasLavaInCracks(world.h(i2, j2, k), bHasLava);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    protected boolean hasLavaAbove(aak blockAccess, int i2, int j2, int k) {
        apa blockAbove = apa.r[blockAccess.a(i2, j2 + 1, k)];
        return blockAbove != null && blockAbove.cO == aif.i;
    }

    protected boolean hasWaterAbove(aak blockAccess, int i2, int j2, int k) {
        apa blockAbove = apa.r[blockAccess.a(i2, j2 + 1, k)];
        return blockAbove != null && blockAbove.cO == aif.h;
    }

    protected boolean scheduleUpdatesForLavaAndWaterContact(aab world, int i2, int j2, int k) {
        if (this.getHasLavaInCracks(world, i2, j2, k)) {
            if (this.hasWaterAbove(world, i2, j2, k)) {
                if (!world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
                    world.a(i2, j2, k, this.cz, 2);
                }
                return true;
            }
        } else if (this.hasLavaAbove(world, i2, j2, k)) {
            if (!world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
                world.a(i2, j2, k, this.cz, 20);
            }
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract lx getLavaCracksOverlay();

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf renderBlocks, int i2, int j2, int k, boolean bFirstPassResult) {
        if (bFirstPassResult && this.getHasLavaInCracks(renderBlocks.a, i2, j2, k)) {
            RenderUtils.renderBlockFullBrightWithTexture(renderBlocks, renderBlocks.a, i2, j2, k, this.getLavaCracksOverlay());
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderFallingBlock(bgf renderBlocks, int i2, int j2, int k, int iMetadata) {
        renderBlocks.setRenderAllFaces(true);
        renderBlocks.setRenderBounds(this.getFixedBlockBoundsFromPool());
        renderBlocks.renderStandardFallingBlock(this, i2, j2, k, iMetadata);
        if (this.getHasLavaInCracks(iMetadata)) {
            RenderUtils.renderBlockFullBrightWithTexture(renderBlocks, renderBlocks.a, i2, j2, k, this.getLavaCracksOverlay());
        }
        renderBlocks.setRenderAllFaces(false);
    }
}

