/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.FireBlock;
import btw.block.blocks.LadderBlockBase;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class LadderBlockFlaming
extends LadderBlockBase {
    private static final int CHANCE_OF_LIGHTING_LADDER_ABOVE = 4;
    private static final int TICK_RATE = 60;
    private static final int TICK_RATE_VARIANCE = 30;

    public LadderBlockFlaming(int iBlockID) {
        super(iBlockID);
        this.a(1.0f);
        this.b(true);
        this.c("fcBlockLadderOnFire");
    }

    @Override
    public int a(int iMetadata, Random rand, int iFortuneModifier) {
        return 0;
    }

    @Override
    public int a(aab world) {
        return 60;
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        world.a(i2, j2, k, this.cz, this.a(world) + world.s.nextInt(30));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        if (this.isRainingOnLadder(world, i2, j2, k)) {
            this.extinguish(world, i2, j2, k);
        } else {
            FireBlock.checkForFireSpreadFromLocation(world, i2, j2, k, rand, 0);
            int iCounter = this.getBurnCounter(world, i2, j2, k);
            if (iCounter < 3) {
                if (rand.nextInt(4) == 0) {
                    this.lightLadderAtLocationIfPresent(world, i2, j2 + 1, k);
                }
                this.setBurnCounter(world, i2, j2, k, iCounter + 1);
                world.a(i2, j2, k, this.cz, this.a(world) + rand.nextInt(30));
            } else {
                this.lightLadderAtLocationIfPresent(world, i2, j2 + 1, k);
                world.i(i2, j2, k);
            }
        }
    }

    @Override
    public boolean getDoesFireDamageToEntities(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean getCanBlockLightItemOnFire(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean canBeCrushedByFallingEntity(aab world, int i2, int j2, int k, rg entity) {
        return true;
    }

    protected void lightLadderAtLocationIfPresent(aab world, int i2, int j2, int k) {
        int iBlockID = world.a(i2, j2, k);
        if (iBlockID == BTWBlocks.ladder.cz) {
            BTWBlocks.ladder.setOnFireDirectly(world, i2, j2, k);
        }
    }

    protected void extinguish(aab world, int i2, int j2, int k) {
        int iNewMetadata = BTWBlocks.ladder.setFacing(0, this.getFacing(world, i2, j2, k));
        world.setBlockAndMetadataWithNotify(i2, j2, k, BTWBlocks.ladder.cz, iNewMetadata);
    }

    protected boolean isRainingOnLadder(aab world, int i2, int j2, int k) {
        return world.isRainingAtPos(i2, j2, k);
    }

    protected int getBurnCounter(aak blockAccess, int i2, int j2, int k) {
        return this.getBurnCounter(blockAccess.h(i2, j2, k));
    }

    protected int getBurnCounter(int iMetadata) {
        return iMetadata >> 2 & 3;
    }

    protected void setBurnCounter(aab world, int i2, int j2, int k, int iCounter) {
        int iMetadata = this.setBurnCounter(world.h(i2, j2, k), iCounter);
        world.setBlockMetadata(i2, j2, k, iMetadata);
    }

    protected int setBurnCounter(int iMetadata, int iCounter) {
        return (iMetadata &= 0xFFFFFFF3) | iCounter << 2;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int y2, int z2) {
        boolean bReturnValue = super.renderBlock(renderBlocks, i2, y2, z2);
        if (bReturnValue) {
            this.renderFirePortion(renderBlocks, i2, y2, z2);
        }
        return bReturnValue;
    }

    @Environment(value=EnvType.CLIENT)
    private void renderFirePortion(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        bgd tessellator = bgd.a;
        lx fireIcon = (i2 + j2 + k & 1) != 0 ? apa.av.c(1) : apa.av.c(0);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(apa.av.e(blockAccess, i2, j2, k));
        double dMinU = fireIcon.e();
        double dMinV = fireIcon.g();
        double dMaxU = fireIcon.f();
        double dMaxV = fireIcon.h();
        float dFireHeight = 1.4f;
        double dFireWidth = 0.2f;
        double dFireHorizontalOffset = 0.0;
        float fVerticalOffset = 0.0625f;
        if ((i2 / 2 + j2 / 2 + k / 2 & 1) != 0) {
            double dTempU = dMaxU;
            dMaxU = dMinU;
            dMinU = dTempU;
        }
        if (iFacing == 5) {
            tessellator.a((double)i2 + dFireWidth + dFireHorizontalOffset, (float)j2 + dFireHeight + fVerticalOffset, k + 1, dMaxU, dMinV);
            tessellator.a((double)i2 + dFireHorizontalOffset, (float)j2 + fVerticalOffset, k + 1, dMaxU, dMaxV);
            tessellator.a((double)i2 + dFireHorizontalOffset, (float)j2 + fVerticalOffset, k, dMinU, dMaxV);
            tessellator.a((double)i2 + dFireWidth + dFireHorizontalOffset, (float)j2 + dFireHeight + fVerticalOffset, k, dMinU, dMinV);
            tessellator.a((double)i2 + dFireWidth + dFireHorizontalOffset, (float)j2 + dFireHeight + fVerticalOffset, k, dMinU, dMinV);
            tessellator.a((double)i2 + dFireHorizontalOffset, (float)j2 + fVerticalOffset, k, dMinU, dMaxV);
            tessellator.a((double)i2 + dFireHorizontalOffset, (float)j2 + fVerticalOffset, k + 1, dMaxU, dMaxV);
            tessellator.a((double)i2 + dFireWidth + dFireHorizontalOffset, (float)j2 + dFireHeight + fVerticalOffset, k + 1, dMaxU, dMinV);
        } else if (iFacing == 4) {
            tessellator.a((double)i2 + 1.0 - dFireWidth - dFireHorizontalOffset, (float)j2 + dFireHeight + fVerticalOffset, k, dMinU, dMinV);
            tessellator.a((double)(i2 + 1) - dFireHorizontalOffset, (float)j2 + fVerticalOffset, k, dMinU, dMaxV);
            tessellator.a((double)(i2 + 1) - dFireHorizontalOffset, (float)j2 + fVerticalOffset, k + 1, dMaxU, dMaxV);
            tessellator.a((double)i2 + 1.0 - dFireWidth - dFireHorizontalOffset, (float)j2 + dFireHeight + fVerticalOffset, k + 1, dMaxU, dMinV);
            tessellator.a((double)i2 + 1.0 - dFireWidth - dFireHorizontalOffset, (float)j2 + dFireHeight + fVerticalOffset, k + 1, dMaxU, dMinV);
            tessellator.a((double)(i2 + 1) - dFireHorizontalOffset, (float)j2 + fVerticalOffset, k + 1, dMaxU, dMaxV);
            tessellator.a((double)(i2 + 1) - dFireHorizontalOffset, (float)j2 + fVerticalOffset, k, dMinU, dMaxV);
            tessellator.a((double)i2 + 1.0 - dFireWidth - dFireHorizontalOffset, (float)j2 + dFireHeight + fVerticalOffset, k, dMinU, dMinV);
        } else if (iFacing == 3) {
            tessellator.a(i2, (float)j2 + dFireHeight + fVerticalOffset, (double)k + dFireWidth + dFireHorizontalOffset, dMaxU, dMinV);
            tessellator.a(i2, (float)j2 + fVerticalOffset, (double)k + dFireHorizontalOffset, dMaxU, dMaxV);
            tessellator.a(i2 + 1, (float)j2 + fVerticalOffset, (double)k + dFireHorizontalOffset, dMinU, dMaxV);
            tessellator.a(i2 + 1, (float)j2 + dFireHeight + fVerticalOffset, (double)k + dFireWidth + dFireHorizontalOffset, dMinU, dMinV);
            tessellator.a(i2 + 1, (float)j2 + dFireHeight + fVerticalOffset, (double)k + dFireWidth + dFireHorizontalOffset, dMinU, dMinV);
            tessellator.a(i2 + 1, (float)j2 + fVerticalOffset, (double)k + dFireHorizontalOffset, dMinU, dMaxV);
            tessellator.a(i2, (float)j2 + fVerticalOffset, (double)k + dFireHorizontalOffset, dMaxU, dMaxV);
            tessellator.a(i2, (float)j2 + dFireHeight + fVerticalOffset, (double)k + dFireWidth + dFireHorizontalOffset, dMaxU, dMinV);
        } else if (iFacing == 2) {
            tessellator.a(i2 + 1, (float)j2 + dFireHeight + fVerticalOffset, (double)k + 1.0 - dFireWidth - dFireHorizontalOffset, dMinU, dMinV);
            tessellator.a(i2 + 1, (float)j2 + fVerticalOffset, (double)(k + 1) - dFireHorizontalOffset, dMinU, dMaxV);
            tessellator.a(i2, (float)j2 + fVerticalOffset, (double)(k + 1) - dFireHorizontalOffset, dMaxU, dMaxV);
            tessellator.a(i2, (float)j2 + dFireHeight + fVerticalOffset, (double)k + 1.0 - dFireWidth - dFireHorizontalOffset, dMaxU, dMinV);
            tessellator.a(i2, (float)j2 + dFireHeight + fVerticalOffset, (double)k + 1.0 - dFireWidth - dFireHorizontalOffset, dMaxU, dMinV);
            tessellator.a(i2, (float)j2 + fVerticalOffset, (double)(k + 1) - dFireHorizontalOffset, dMaxU, dMaxV);
            tessellator.a(i2 + 1, (float)j2 + fVerticalOffset, (double)(k + 1) - dFireHorizontalOffset, dMinU, dMaxV);
            tessellator.a(i2 + 1, (float)j2 + dFireHeight + fVerticalOffset, (double)k + 1.0 - dFireWidth - dFireHorizontalOffset, dMinU, dMinV);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random rand) {
        if (rand.nextInt(24) == 0) {
            world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "fire.fire", 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int iTempCount = 0; iTempCount < 3; ++iTempCount) {
            double xPos = (double)i2 + rand.nextDouble();
            double yPos = (double)j2 + rand.nextDouble() * 0.5 + 0.5;
            double zPos = (double)k + rand.nextDouble();
            world.a("largesmoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
        }
    }
}

