/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class LadderBlockBase
extends apa {
    protected static final float LADDER_THICKNESS = 0.1875f;
    protected static final aqx boxCollision = new aqx(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    @Environment(value=EnvType.CLIENT)
    protected static final double LADDER_HORIZONTAL_OFFSET = (double)0.05f;
    @Environment(value=EnvType.CLIENT)
    private lx filterIcon;

    protected LadderBlockBase(int iBlockID) {
        super(iBlockID, aif.q);
        this.c(0.4f);
        this.setAxesEffectiveOn(true);
        this.setBuoyant();
        this.a(p);
    }

    @Override
    public int a(int iMetadata, Random rand, int iFortuneModifier) {
        return BTWBlocks.ladder.cz;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        aqx transformedBox = boxCollision.makeTemporaryCopy();
        transformedBox.rotateAroundYToFacing(this.getFacing(blockAccess, i2, j2, k));
        return transformedBox;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean c(aab world, int i2, int j2, int k) {
        for (int iTempFacing = 2; iTempFacing <= 5; ++iTempFacing) {
            if (!this.canAttachToFacing(world, i2, j2, k, apa.getOppositeFacing(iTempFacing))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        if (this.canAttachToFacing(world, i2, j2, k, apa.getOppositeFacing(iFacing))) {
            iMetadata = this.setFacing(iMetadata, iFacing);
        } else {
            for (int iTempFacing = 2; iTempFacing <= 5; ++iTempFacing) {
                if (!this.canAttachToFacing(world, i2, j2, k, iTempFacing)) continue;
                iMetadata = this.setFacing(iMetadata, apa.getOppositeFacing(iTempFacing));
                break;
            }
        }
        return iMetadata;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iChangedBlockID) {
        int iMetadata = world.h(i2, j2, k);
        if (!this.canAttachToFacing(world, i2, j2, k, apa.getOppositeFacing(this.getFacing(iMetadata)))) {
            this.c(world, i2, j2, k, iMetadata, 0);
            world.i(i2, j2, k);
        }
        super.a(world, i2, j2, k, iChangedBlockID);
    }

    @Override
    public int d() {
        return 8;
    }

    @Override
    public boolean isBlockClimbable(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public int getFacing(int iMetadata) {
        return (iMetadata & 3) + 2;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        int iFlatFacing = kx.a(iFacing, 2, 5) - 2;
        return (iMetadata &= 0xFFFFFFFC) | iFlatFacing;
    }

    @Override
    public boolean canRotateAroundBlockOnTurntableToFacing(aab world, int i2, int j2, int k, int iFacing) {
        return iFacing == apa.getOppositeFacing(this.getFacing(world, i2, j2, k));
    }

    @Override
    public int getNewMetadataRotatedAroundBlockOnTurntableToFacing(aab world, int i2, int j2, int k, int iInitialFacing, int iRotatedFacing) {
        int iOldMetadata = world.h(i2, j2, k);
        return this.setFacing(iOldMetadata, apa.getOppositeFacing(iRotatedFacing));
    }

    @Override
    public boolean canItemPassIfFilter(wm filteredItem) {
        int iFilterableProperties = filteredItem.b().getFilterableProperties(filteredItem);
        return (iFilterableProperties & 1) == 0;
    }

    @Override
    public boolean canMobsSpawnOn(aab world, int i2, int j2, int k) {
        return false;
    }

    protected boolean canAttachToFacing(aab world, int i2, int j2, int k, int iFacing) {
        if (iFacing >= 2) {
            BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
            return WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(world, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iFacing));
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("ladder");
        this.filterIcon = register.a("fcBlockHopper_ladder");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx getHopperFilterIcon() {
        return this.filterIcon;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int x2, int y2, int z2) {
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, x2, y2, z2));
        return this.renderLadder(renderer, x2, y2, z2);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderLadder(bgf renderBlocks, int x2, int y2, int z2) {
        aak blockAccess = renderBlocks.a;
        int facing = this.getFacing(blockAccess, x2, y2, z2);
        bgd tessellator = bgd.a;
        tessellator.c(this.e(blockAccess, x2, y2, z2));
        float brightness = 1.0f;
        tessellator.a(brightness, brightness, brightness);
        lx icon = this.cQ;
        if (renderBlocks.b()) {
            icon = renderBlocks.getOverrideTexture();
        }
        double minU = icon.e();
        double minV = icon.g();
        double maxU = icon.f();
        double maxV = icon.h();
        if (facing == 5) {
            tessellator.a((double)x2 + (double)0.05f, y2 + 1, z2 + 1, minU, minV);
            tessellator.a((double)x2 + (double)0.05f, y2 + 0, z2 + 1, minU, maxV);
            tessellator.a((double)x2 + (double)0.05f, y2 + 0, z2 + 0, maxU, maxV);
            tessellator.a((double)x2 + (double)0.05f, y2 + 1, z2 + 0, maxU, minV);
            tessellator.a((double)x2 + (double)0.05f, y2 + 1, z2 + 0, maxU, minV);
            tessellator.a((double)x2 + (double)0.05f, y2 + 0, z2 + 0, maxU, maxV);
            tessellator.a((double)x2 + (double)0.05f, y2 + 0, z2 + 1, minU, maxV);
            tessellator.a((double)x2 + (double)0.05f, y2 + 1, z2 + 1, minU, minV);
        } else if (facing == 4) {
            tessellator.a((double)(x2 + 1) - (double)0.05f, y2 + 0, z2 + 1, maxU, maxV);
            tessellator.a((double)(x2 + 1) - (double)0.05f, y2 + 1, z2 + 1, maxU, minV);
            tessellator.a((double)(x2 + 1) - (double)0.05f, y2 + 1, z2 + 0, minU, minV);
            tessellator.a((double)(x2 + 1) - (double)0.05f, y2 + 0, z2 + 0, minU, maxV);
            tessellator.a((double)(x2 + 1) - (double)0.05f, y2 + 0, z2 + 0, minU, maxV);
            tessellator.a((double)(x2 + 1) - (double)0.05f, y2 + 1, z2 + 0, minU, minV);
            tessellator.a((double)(x2 + 1) - (double)0.05f, y2 + 1, z2 + 1, maxU, minV);
            tessellator.a((double)(x2 + 1) - (double)0.05f, y2 + 0, z2 + 1, maxU, maxV);
        } else if (facing == 3) {
            tessellator.a(x2 + 1, y2 + 0, (double)z2 + (double)0.05f, maxU, maxV);
            tessellator.a(x2 + 1, y2 + 1, (double)z2 + (double)0.05f, maxU, minV);
            tessellator.a(x2 + 0, y2 + 1, (double)z2 + (double)0.05f, minU, minV);
            tessellator.a(x2 + 0, y2 + 0, (double)z2 + (double)0.05f, minU, maxV);
            tessellator.a(x2 + 0, y2 + 0, (double)z2 + (double)0.05f, minU, maxV);
            tessellator.a(x2 + 0, y2 + 1, (double)z2 + (double)0.05f, minU, minV);
            tessellator.a(x2 + 1, y2 + 1, (double)z2 + (double)0.05f, maxU, minV);
            tessellator.a(x2 + 1, y2 + 0, (double)z2 + (double)0.05f, maxU, maxV);
        } else if (facing == 2) {
            tessellator.a(x2 + 1, y2 + 1, (double)(z2 + 1) - (double)0.05f, minU, minV);
            tessellator.a(x2 + 1, y2 + 0, (double)(z2 + 1) - (double)0.05f, minU, maxV);
            tessellator.a(x2 + 0, y2 + 0, (double)(z2 + 1) - (double)0.05f, maxU, maxV);
            tessellator.a(x2 + 0, y2 + 1, (double)(z2 + 1) - (double)0.05f, maxU, minV);
            tessellator.a(x2 + 0, y2 + 1, (double)(z2 + 1) - (double)0.05f, maxU, minV);
            tessellator.a(x2 + 0, y2 + 0, (double)(z2 + 1) - (double)0.05f, maxU, maxV);
            tessellator.a(x2 + 1, y2 + 0, (double)(z2 + 1) - (double)0.05f, minU, maxV);
            tessellator.a(x2 + 1, y2 + 1, (double)(z2 + 1) - (double)0.05f, minU, minV);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }
}

