/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class KilnBlock
extends apa {
    private static final int MIN_FIRE_FACTOR_BASE_TICK_RATE = 40;
    private static final int MAX_FIRE_FACTOR_BASE_TICK_RATE = 160;
    @Environment(value=EnvType.CLIENT)
    private lx[] cookIcons;

    public KilnBlock(int iBlockID) {
        super(iBlockID, aif.e);
        this.c(2.0f);
        this.b(10.0f);
        this.a(j);
        this.b(true);
        this.c("fcBlockKiln");
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        if (this.canBlockBeCooked(world, i2, j2 + 1, k)) {
            this.scheduleUpdateBasedOnCookState(world, i2, j2, k);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        int iOldCookCounter = this.getCookCounter(world, i2, j2, k);
        int iNewCookCounter = 0;
        if (this.canBlockBeCooked(world, i2, j2 + 1, k)) {
            if (this.checkKiLnIntegrity(world, i2, j2, k)) {
                if (iOldCookCounter >= 15) {
                    this.cookBlock(world, i2, j2 + 1, k);
                } else {
                    iNewCookCounter = iOldCookCounter + 1;
                    this.scheduleUpdateBasedOnCookState(world, i2, j2, k);
                }
            } else {
                this.scheduleUpdateBasedOnCookState(world, i2, j2, k);
            }
        }
        if (iOldCookCounter != iNewCookCounter) {
            this.setCookCounter(world, i2, j2, k, iNewCookCounter);
        }
    }

    @Override
    public int a(int iMetaData, Random random, int iFortuneModifier) {
        return apa.ap.cz;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        if (world.a(i2, j2 - 1, k) != BTWBlocks.stokedFire.cz) {
            world.setBlockWithNotify(i2, j2, k, apa.ap.cz);
        } else if (this.canBlockBeCooked(world, i2, j2 + 1, k)) {
            if (!world.isUpdateScheduledForBlock(i2, j2, k, this.cz) && !world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
                this.scheduleUpdateBasedOnCookState(world, i2, j2, k);
            }
        } else if (this.getCookCounter(world, i2, j2, k) > 0) {
            this.setCookCounterNoNotify(world, i2, j2, k, 0);
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (!world.isUpdateScheduledForBlock(i2, j2, k, this.cz) && this.canBlockBeCooked(world, i2, j2 + 1, k)) {
            this.scheduleUpdateBasedOnCookState(world, i2, j2, k);
        }
    }

    @Override
    public boolean hasMortar(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    public int getCookCounter(int iMetadata) {
        return iMetadata;
    }

    public int getCookCounter(aak blockAccess, int i2, int j2, int k) {
        return this.getCookCounter(blockAccess.h(i2, j2, k));
    }

    public int setCookCounter(int iMetadata, int iCounter) {
        return iCounter;
    }

    public void setCookCounter(aab world, int i2, int j2, int k, int iCounter) {
        int iMetadata = this.setCookCounter(world.h(i2, j2, k), iCounter);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public void setCookCounterNoNotify(aab world, int i2, int j2, int k, int iCounter) {
        int iMetadata = this.setCookCounter(world.h(i2, j2, k), iCounter);
        world.setBlockMetadataWithClient(i2, j2, k, iMetadata);
    }

    protected void scheduleUpdateBasedOnCookState(aab world, int i2, int j2, int k) {
        int iTickRate = this.computeTickRateBasedOnFireFactor(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, iTickRate *= this.getBlockCookTimeMultiplier(world, i2, j2 + 1, k));
    }

    private boolean canBlockBeCooked(aak blockAccess, int i2, int j2, int k) {
        int iBlockID = blockAccess.a(i2, j2, k);
        apa block = apa.r[iBlockID];
        if (block != null) {
            return block.getCanBeCookedByKiLn(blockAccess, i2, j2, k);
        }
        return false;
    }

    private void cookBlock(aab world, int i2, int j2, int k) {
        int iBlockID = world.a(i2, j2, k);
        apa block = apa.r[iBlockID];
        if (block != null && block.getCanBeCookedByKiLn(world, i2, j2, k)) {
            block.onCookedByKiLn(world, i2, j2, k);
        }
    }

    private boolean checkKiLnIntegrity(aak blockAccess, int i2, int j2, int k) {
        int iBrickCount = 0;
        for (int iTempFacing = 1; iTempFacing <= 5; ++iTempFacing) {
            BlockPos tempPos = new BlockPos(i2, j2 + 1, k);
            tempPos.addFacingAsOffset(iTempFacing);
            int iTempBlockID = blockAccess.a(tempPos.x, tempPos.y, tempPos.z);
            if (iTempBlockID != apa.ap.cz && iTempBlockID != BTWBlocks.kiln.cz || ++iBrickCount < 3) continue;
            return true;
        }
        return false;
    }

    private int computeTickRateBasedOnFireFactor(aak blockAccess, int i2, int j2, int k) {
        int iSecondaryFireFactor = 0;
        for (int iOffset = -1; iOffset <= 1; ++iOffset) {
            for (int kOffset = -1; kOffset <= 1; ++kOffset) {
                if (iOffset == 0 && kOffset == 0 || blockAccess.a(i2 + iOffset, j2 - 1, k + kOffset) != BTWBlocks.stokedFire.cz) continue;
                ++iSecondaryFireFactor;
            }
        }
        int iTickRate = 120 * (8 - iSecondaryFireFactor) / 8 + 40;
        return iTickRate;
    }

    private int getBlockCookTimeMultiplier(aak blockAccess, int i2, int j2, int k) {
        int iBlockID = blockAccess.a(i2, j2, k);
        apa block = apa.r[iBlockID];
        if (block != null) {
            return block.getCookTimeMultiplierInKiLn(blockAccess, i2, j2, k);
        }
        return 1;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("brick");
        this.cookIcons = new lx[7];
        for (int iTempIndex = 0; iTempIndex < 7; ++iTempIndex) {
            this.cookIcons[iTempIndex] = register.a("fcOverlayCook_" + (iTempIndex + 1));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aab world, int i2, int j2, int k) {
        return this.a(world.h(i2, j2, k), world.s, 0);
    }

    @Environment(value=EnvType.CLIENT)
    public lx getCookTextureForCurrentState(aak blockAccess, int i2, int j2, int k) {
        int iTextureIndex = this.getCookCounter(blockAccess, i2, j2, k) / 2 - 1;
        if (iTextureIndex >= 0 && iTextureIndex <= 6) {
            return this.cookIcons[iTextureIndex];
        }
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random rand) {
        block11: {
            apa blockAbove = apa.r[world.a(i2, j2 + 1, k)];
            if (blockAbove == null || !blockAbove.getCanBeCookedByKiLn(world, i2, j2 + 1, k) || !this.checkKiLnIntegrity(world, i2, j2, k)) break block11;
            if (!blockAbove.b()) {
                for (int iTempCount = 0; iTempCount < 2; ++iTempCount) {
                    double xPos = (double)i2 + rand.nextDouble();
                    double yPos = (double)j2 + 1.0 + rand.nextDouble() * 0.75;
                    double zPos = (double)k + rand.nextDouble();
                    world.a("fcwhitesmoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
                }
            } else {
                for (int iTempFacing = 2; iTempFacing < 6; ++iTempFacing) {
                    double xPos = (double)i2 + 0.5;
                    double yPos = (double)j2 + 1.0 + rand.nextDouble() * 0.75;
                    double zPos = (double)k + 0.5;
                    double dFacingOffset = 0.75;
                    double dHorizontalOffset = -0.75 + rand.nextDouble() * 1.5;
                    if (iTempFacing == 2) {
                        xPos += dHorizontalOffset;
                        zPos -= dFacingOffset;
                    } else if (iTempFacing == 3) {
                        xPos += dHorizontalOffset;
                        zPos += dFacingOffset;
                    } else if (iTempFacing == 4) {
                        xPos -= dFacingOffset;
                        zPos += dHorizontalOffset;
                    } else if (iTempFacing == 5) {
                        xPos += dFacingOffset;
                        zPos += dHorizontalOffset;
                    }
                    world.a("fcwhitesmoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

