/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.WeedsBlock;
import btw.block.util.Flammability;
import btw.item.BTWItems;
import btw.item.items.ShearsItem;
import btw.item.util.ItemUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class HempCropBlock
extends alu {
    private static final double COLLISION_BOX_WIDTH = (double)0.4f;
    private static final double COLLISION_BOX_HALF_WIDTH = (double)0.2f;
    private static final float BASE_GROWTH_CHANCE = 0.1f;
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBottomByGrowthArray = new lx[8];
    @Environment(value=EnvType.CLIENT)
    private lx iconTop;

    public HempCropBlock(int iBlockID) {
        super(iBlockID);
        this.c(0.2f);
        this.setAxesEffectiveOn(true);
        this.setBuoyant();
        this.setFireProperties(Flammability.CROPS);
        this.initBlockBounds(0.29999999701976776, 0.0, 0.29999999701976776, 0.7000000029802322, 1.0, 0.7000000029802322);
        this.c("fcBlockHemp");
    }

    @Override
    public int a(int iMetadata, Random random, int iFortuneModifier) {
        if (iMetadata >= 7) {
            return this.k();
        }
        return 0;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iGrowthLevel = blockAccess.h(i2, j2, k);
        iGrowthLevel = kx.a(iGrowthLevel, 0, 7);
        double dBoundsHeight = (double)(1 + iGrowthLevel) / 8.0;
        double dHalfWidth = 0.2f;
        int iWeedsGrowthLevel = this.getWeedsGrowthLevel(blockAccess, i2, j2, k);
        if (iWeedsGrowthLevel > 0) {
            dBoundsHeight = Math.max(dBoundsHeight, WeedsBlock.getWeedsBoundsHeight(iWeedsGrowthLevel));
            dHalfWidth = 0.375;
        }
        return aqx.a().a(0.5 - dHalfWidth, 0.0, 0.5 - dHalfWidth, 0.5 + dHalfWidth, dBoundsHeight, 0.5 + dHalfWidth);
    }

    @Override
    public boolean doesBlockDropAsItemOnSaw(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean f(aab world, int i2, int j2, int k) {
        return super.f(world, i2, j2, k) || world.a(i2, j2 - 1, k) == this.cz && !this.getIsTopBlock(world, i2, j2 - 1, k);
    }

    @Override
    protected void attemptToGrow(aab world, int i2, int j2, int k, Random rand) {
        apa blockBelow;
        if (!this.getIsTopBlock(world, i2, j2, k) && this.getWeedsGrowthLevel(world, i2, j2, k) == 0 && (world.n(i2, j2, k) >= 15 || world.a(i2, j2 + 1, k) == BTWBlocks.lightBlockOn.cz || world.a(i2, j2 + 2, k) == BTWBlocks.lightBlockOn.cz) && (blockBelow = apa.r[world.a(i2, j2 - 1, k)]) != null && blockBelow.isBlockHydratedForPlantGrowthOn(world, i2, j2 - 1, k)) {
            int iMetadata = world.h(i2, j2, k);
            if (this.getGrowthLevel(world, i2, j2, k) < 7) {
                float fChanceOfGrowth = this.getBaseGrowthChance(world, i2, j2, k) * blockBelow.getPlantGrowthOnMultiplier(world, i2, j2 - 1, k, this);
                if (rand.nextFloat() <= fChanceOfGrowth) {
                    this.incrementGrowthLevel(world, i2, j2, k);
                }
            } else if (world.c(i2, j2 + 1, k)) {
                float fChanceOfGrowth = this.getBaseGrowthChance(world, i2, j2, k) / 4.0f * blockBelow.getPlantGrowthOnMultiplier(world, i2, j2 - 1, k, this);
                if (rand.nextFloat() <= fChanceOfGrowth) {
                    int iNewMetadata = this.setIsTopBlock(0, true);
                    world.setBlockAndMetadataWithNotify(i2, j2 + 1, k, this.cz, iNewMetadata);
                    blockBelow.notifyOfFullStagePlantGrowthOn(world, i2, j2 - 1, k, this);
                }
            }
        }
    }

    @Override
    public void dropSeeds(aab world, int i2, int j2, int k, int iMetadata, float fChance, int iFortuneModifier) {
        if (this.getIsTopBlock(iMetadata) && world.s.nextInt(100) < 50) {
            ItemUtils.dropStackAsIfBlockHarvested(world, i2, j2, k, new wm(this.j(), 1, 0));
        }
    }

    @Override
    protected int j() {
        return BTWItems.hempSeeds.cp;
    }

    @Override
    protected int k() {
        return BTWItems.hemp.cp;
    }

    @Override
    public float getBaseGrowthChance(aab world, int i2, int j2, int k) {
        return 0.1f;
    }

    @Override
    public void a(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        super.a(world, player, i2, j2, k, iMetadata);
        if (!(world.I || player.cd() != null && player.cd().b() instanceof ShearsItem || world.a(i2, j2 - 1, k) != this.cz)) {
            this.c(world, i2, j2 - 1, k, world.h(i2, j2 - 1, k), 0);
            world.i(i2, j2 - 1, k);
        }
    }

    protected boolean getIsTopBlock(aak blockAccess, int i2, int j2, int k) {
        return this.getIsTopBlock(blockAccess.h(i2, j2, k));
    }

    protected boolean getIsTopBlock(int iMetadata) {
        return (iMetadata & 8) != 0;
    }

    protected void setIsTopBlock(aab world, int i2, int j2, int k, boolean bTop) {
        int iMetadata = this.setIsTopBlock(world.h(i2, j2, k), bTop);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    protected int setIsTopBlock(int iMetadata, boolean bTop) {
        iMetadata = bTop ? (iMetadata |= 8) : (iMetadata &= 0xFFFFFFF7);
        return iMetadata;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = this.iconTop = register.a("fcBlockHemp_top");
        this.iconBottomByGrowthArray[0] = register.a("fcBlockHemp_bottom_00");
        this.iconBottomByGrowthArray[1] = register.a("fcBlockHemp_bottom_01");
        this.iconBottomByGrowthArray[2] = register.a("fcBlockHemp_bottom_02");
        this.iconBottomByGrowthArray[3] = register.a("fcBlockHemp_bottom_03");
        this.iconBottomByGrowthArray[4] = register.a("fcBlockHemp_bottom_04");
        this.iconBottomByGrowthArray[5] = register.a("fcBlockHemp_bottom_05");
        this.iconBottomByGrowthArray[6] = register.a("fcBlockHemp_bottom_06");
        this.iconBottomByGrowthArray[7] = register.a("fcBlockHemp_bottom_07");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (this.getIsTopBlock(iMetadata)) {
            return this.iconTop;
        }
        return this.iconBottomByGrowthArray[iMetadata];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        renderer.k(this, i2, j2, k);
        if (!this.getIsTopBlock(renderer.a, i2, j2, k)) {
            BTWBlocks.weeds.renderWeeds(this, renderer, i2, j2, k);
        }
        return true;
    }
}

