/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.MechanicalBlock;
import btw.block.util.RayTraceUtils;
import btw.client.render.util.RenderUtils;
import btw.item.BTWItems;
import btw.item.util.ItemUtils;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class HandCrankBlock
extends apa
implements MechanicalBlock {
    private static final int HAND_CRANK_TICK_RATE = 3;
    private static final int HAND_CRANK_DELAY_BEFORE_RESET = 15;
    private static final double BASE_HEIGHT = 0.25;
    private static final double SHAFT_SELECTION_WIDTH = 0.25;
    private static final double SHAFT_SELECTION_HALF_WIDTH = 0.125;
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBySideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private lx iconShaft;

    public HandCrankBlock(int iBlockID) {
        super(iBlockID, aif.q);
        this.c(0.5f);
        this.setPicksEffectiveOn();
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.a(g);
        this.c("fcBlockHandCrank");
        this.b(true);
        this.a(ve.d);
    }

    @Override
    public int a(aab world) {
        return 3;
    }

    @Override
    public aqx b(aab world, int i2, int j2, int k) {
        return null;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean c(aab world, int i2, int j2, int k) {
        return this.canRestAtPosition(world, i2, j2, k) && super.c(world, i2, j2, k);
    }

    @Override
    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        int iMetaData = world.h(i2, j2, k);
        if (iMetaData == 0) {
            if (player.cn().a() > 18) {
                float exhaustionAmount = 2.0f;
                player.j(exhaustionAmount * world.getDifficulty().getHungerIntensiveActionCostMultiplier());
                if (!world.I) {
                    if (!this.checkForOverpower(world, i2, j2, k)) {
                        world.setBlockMetadataWithNotify(i2, j2, k, 1);
                        world.g(i2, j2, k, i2, j2, k);
                        world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "random.click", 1.0f, 2.0f);
                        world.a(i2, j2, k, this.cz, this.a(world));
                        world.j(i2, j2, k);
                    } else {
                        this.breakCrankWithDrop(world, i2, j2, k);
                    }
                }
            } else if (world.I) {
                player.b(this.a() + ".playerExhausted");
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        int iMetaData = world.h(i2, j2, k);
        if (iMetaData > 0) {
            if (iMetaData < 7) {
                if (iMetaData <= 6) {
                    world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "random.click", 1.0f, 2.0f);
                }
                if (iMetaData <= 5) {
                    world.a(i2, j2, k, this.cz, this.a(world) + iMetaData);
                } else {
                    world.a(i2, j2, k, this.cz, 15);
                }
                world.setBlockMetadata(i2, j2, k, iMetaData + 1);
            } else {
                world.setBlockMetadataWithNotify(i2, j2, k, 0);
                world.g(i2, j2, k, i2, j2, k);
                world.j(i2, j2, k);
                world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "random.click", 0.3f, 0.7f);
            }
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        int iMetaData = world.h(i2, j2, k);
        if (iMetaData > 0 && !world.isUpdateScheduledForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        if (!this.canRestAtPosition(world, i2, j2, k)) {
            this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
            world.setBlockWithNotify(i2, j2, k, 0);
        }
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startRay, endRay);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(this.getBaseBoundsFromPool());
        rayTrace.addBoxWithLocalCoordsToIntersectionList(this.getShaftSelectionBoundsFromPool());
        return rayTrace.getFirstIntersection();
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return true;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputAxlePowerToFacing(aab world, int i2, int j2, int k, int iFacing) {
        return false;
    }

    @Override
    public boolean isInputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return false;
    }

    @Override
    public boolean isOutputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return world.h(i2, j2, k) > 0;
    }

    @Override
    public void overpower(aab world, int i2, int j2, int k) {
    }

    public boolean canRestAtPosition(aab world, int i2, int j2, int k) {
        return WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(world, i2, j2 - 1, k, 1, true);
    }

    public boolean checkForOverpower(aab world, int i2, int j2, int k) {
        int iNumPotentialDevicesToPower = 0;
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            MechanicalBlock tempDevice;
            if (iTempFacing == 1) continue;
            BlockPos tempPos = new BlockPos(i2, j2, k);
            tempPos.addFacingAsOffset(iTempFacing);
            int iTempBlockID = world.a(tempPos.x, tempPos.y, tempPos.z);
            apa tempBlock = apa.r[iTempBlockID];
            if (tempBlock == null || !(tempBlock instanceof MechanicalBlock) || !(tempDevice = (MechanicalBlock)((Object)tempBlock)).canInputMechanicalPower()) continue;
            ++iNumPotentialDevicesToPower;
        }
        return iNumPotentialDevicesToPower > 1;
    }

    public void breakCrankWithDrop(aab world, int i2, int j2, int k) {
        ItemUtils.ejectSingleItemWithRandomOffset(world, i2, j2, k, wk.E.cp, 0);
        ItemUtils.ejectSingleItemWithRandomOffset(world, i2, j2, k, BTWItems.gear.cp, 0);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.stone.cp, 12, 0, 0.75f);
        world.e(2235, i2, j2, k, 0);
        world.setBlockWithNotify(i2, j2, k, 0);
    }

    protected aqx getBaseBoundsFromPool() {
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    }

    protected aqx getShaftSelectionBoundsFromPool() {
        return aqx.a().a(0.0, 0.25, 0.375, 1.0, 1.0, 0.625);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        lx sideIcon;
        this.cQ = register.a("stone");
        this.iconShaft = register.a("fcBlockHandCrank_shaft");
        this.iconBySideArray[0] = register.a("fcBlockHandCrank_bottom");
        this.iconBySideArray[1] = register.a("fcBlockHandCrank_top");
        this.iconBySideArray[2] = sideIcon = register.a("fcBlockHandCrank_side");
        this.iconBySideArray[3] = sideIcon;
        this.iconBySideArray[4] = sideIcon;
        this.iconBySideArray[5] = sideIcon;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        return this.iconBySideArray[iSide];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int i2, int j2, int k, int iSide) {
        if (iSide != 1) {
            return super.a(blockAccess, i2, j2, k, iSide);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        bgd tessellator = bgd.a;
        renderBlocks.setRenderBounds(this.getBaseBoundsFromPool());
        renderBlocks.p(this, i2, j2, k);
        float fBlockBrightness = this.f(blockAccess, i2, j2, k);
        if (this.getLightValue(blockAccess, i2, j2, k) > 0) {
            fBlockBrightness = 1.0f;
        }
        tessellator.a(fBlockBrightness, fBlockBrightness, fBlockBrightness);
        lx iTextureID = this.iconShaft;
        if (renderBlocks.b()) {
            iTextureID = renderBlocks.getOverrideTexture();
        }
        double f4 = iTextureID.e();
        double f5 = iTextureID.f();
        double f6 = iTextureID.g();
        double f7 = iTextureID.h();
        arc[] avec3d = new arc[8];
        float f8 = 0.0625f;
        float f9 = 0.0625f;
        float f10 = 0.9f;
        avec3d[0] = arc.a(-f8, 0.0, -f9);
        avec3d[1] = arc.a(f8, 0.0, -f9);
        avec3d[2] = arc.a(f8, 0.0, f9);
        avec3d[3] = arc.a(-f8, 0.0, f9);
        avec3d[4] = arc.a(-f8, f10, -f9);
        avec3d[5] = arc.a(f8, f10, -f9);
        avec3d[6] = arc.a(f8, f10, f9);
        avec3d[7] = arc.a(-f8, f10, f9);
        boolean bIsOn = blockAccess.h(i2, j2, k) > 0;
        for (int i22 = 0; i22 < 8; ++i22) {
            if (bIsOn) {
                avec3d[i22].e -= 0.0625;
                avec3d[i22].a(0.35f);
            } else {
                avec3d[i22].e += 0.0625;
                avec3d[i22].a(-0.35f);
            }
            avec3d[i22].b(1.570796f);
            avec3d[i22].c += (double)i2 + 0.5;
            avec3d[i22].d += (double)((float)j2 + 0.125f);
            avec3d[i22].e += (double)k + 0.5;
        }
        arc vec3d = null;
        arc vec3d1 = null;
        arc vec3d2 = null;
        arc vec3d3 = null;
        for (int j22 = 0; j22 < 6; ++j22) {
            if (j22 == 0) {
                f4 = iTextureID.a(7.0);
                f5 = iTextureID.a(9.0);
                f6 = iTextureID.g();
                f7 = iTextureID.b(2.0);
            } else if (j22 == 2) {
                f4 = iTextureID.a(7.0);
                f5 = iTextureID.a(9.0);
                f6 = iTextureID.g();
                f7 = iTextureID.h();
            }
            if (j22 == 0) {
                vec3d = avec3d[0];
                vec3d1 = avec3d[1];
                vec3d2 = avec3d[2];
                vec3d3 = avec3d[3];
            } else if (j22 == 1) {
                vec3d = avec3d[7];
                vec3d1 = avec3d[6];
                vec3d2 = avec3d[5];
                vec3d3 = avec3d[4];
            } else if (j22 == 2) {
                vec3d = avec3d[1];
                vec3d1 = avec3d[0];
                vec3d2 = avec3d[4];
                vec3d3 = avec3d[5];
            } else if (j22 == 3) {
                vec3d = avec3d[2];
                vec3d1 = avec3d[1];
                vec3d2 = avec3d[5];
                vec3d3 = avec3d[6];
            } else if (j22 == 4) {
                vec3d = avec3d[3];
                vec3d1 = avec3d[2];
                vec3d2 = avec3d[6];
                vec3d3 = avec3d[7];
            } else if (j22 == 5) {
                vec3d = avec3d[0];
                vec3d1 = avec3d[3];
                vec3d2 = avec3d[7];
                vec3d3 = avec3d[4];
            }
            tessellator.a(vec3d.c, vec3d.d, vec3d.e, f4, f7);
            tessellator.a(vec3d1.c, vec3d1.d, vec3d1.e, f5, f7);
            tessellator.a(vec3d2.c, vec3d2.d, vec3d2.e, f5, f6);
            tessellator.a(vec3d3.c, vec3d3.d, vec3d3.e, f4, f6);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        renderBlocks.setRenderBounds(this.getBaseBoundsFromPool());
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, this, -0.5f, -0.5f, -0.5f, 0);
        float fHalfWidth = 0.0625f;
        renderBlocks.a(0.5f - fHalfWidth, 0.25, (double)(0.5f - fHalfWidth), (double)(0.5f + fHalfWidth), 1.0, (double)(0.5f + fHalfWidth));
        RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, this.iconShaft);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public aqx c_(aab world, int i2, int j2, int k) {
        return this.getShaftSelectionBoundsFromPool().d(i2, j2, k);
    }
}

