/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.BTWMod;
import btw.block.blocks.BasketBlock;
import btw.block.model.BlockModel;
import btw.block.model.HamperModel;
import btw.block.tileentity.HamperTileEntity;
import btw.inventory.BTWContainers;
import btw.inventory.container.HamperContainer;
import btw.item.BTWItems;
import btw.world.util.WorldUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class HamperBlock
extends BasketBlock {
    public static final HamperModel model = new HamperModel();
    @Environment(value=EnvType.CLIENT)
    private boolean renderingBase = false;
    @Environment(value=EnvType.CLIENT)
    private lx iconBaseOpenTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconFront;
    @Environment(value=EnvType.CLIENT)
    private lx iconTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconBottom;

    public HamperBlock(int iBlockID) {
        super(iBlockID);
        this.c("fcBlockHamper");
        this.initBlockBounds(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    }

    public aqp b(aab world) {
        return new HamperTileEntity();
    }

    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        if (!(world.I || WorldUtils.doesBlockHaveCenterHardpointToFacing(world, i2, j2 + 1, k, 0, true) || WorldUtils.isBlockRestingOnThatBelow(world, i2, j2 + 1, k))) {
            HamperTileEntity tileEntity = (HamperTileEntity)world.r(i2, j2, k);
            if (player instanceof jc) {
                HamperContainer container = new HamperContainer(player.bK, tileEntity);
                BTWMod.serverOpenCustomInterface((jc)player, container, BTWContainers.hamperContainerID);
            }
        }
        return true;
    }

    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return iFacing == 0 || iFacing == 1 && !this.getIsOpen(blockAccess, i2, j2, k);
    }

    public void onCrushedByFallingEntity(aab world, int i2, int j2, int k, rg entity) {
        if (!world.I) {
            this.dropItemsIndividually(world, i2, j2, k, BTWItems.wickerPane.cp, 2, 0, 0.75f);
        }
    }

    @Override
    public BlockModel getLidModel(int iMetadata) {
        return HamperBlock.model.lid;
    }

    @Override
    public arc getLidRotationPoint() {
        return model.getLidRotationPoint();
    }

    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        int iFacing = this.getFacing(world, i2, j2, k);
        BlockModel transformedModel = model.makeTemporaryCopy();
        transformedModel.rotateAroundYToFacing(iFacing);
        return transformedModel.collisionRayTrace(world, i2, j2, k, startRay, endRay);
    }

    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconBaseOpenTop = register.a("fcBlockHamper_open_top");
        this.iconFront = register.a("fcBlockHamper_front");
        this.iconTop = register.a("fcBlockHamper_top");
        this.iconBottom = register.a("fcBlockHamper_bottom");
    }

    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 1) {
            if (this.renderingBase) {
                return this.iconBaseOpenTop;
            }
            return this.iconTop;
        }
        if (iSide == 0) {
            return this.iconBottom;
        }
        int iFacing = this.getFacing(iMetadata);
        if (iSide == iFacing) {
            return this.iconFront;
        }
        return super.a(iSide, iMetadata);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        int iMetadata = renderBlocks.a.h(i2, j2, k);
        int iFacing = this.getFacing(iMetadata);
        BlockModel transformedModel = model.makeTemporaryCopy();
        transformedModel.rotateAroundYToFacing(iFacing);
        renderBlocks.setUVRotateTop(this.convertFacingToTopTextureRotation(iFacing));
        renderBlocks.setUVRotateBottom(this.convertFacingToBottomTextureRotation(iFacing));
        this.renderingBase = true;
        boolean bReturnValue = transformedModel.renderAsBlock(renderBlocks, (apa)((Object)this), i2, j2, k);
        this.renderingBase = false;
        if (!this.getIsOpen(iMetadata)) {
            transformedModel = HamperBlock.model.lid.makeTemporaryCopy();
            transformedModel.rotateAroundYToFacing(iFacing);
            transformedModel.renderAsBlock(renderBlocks, (apa)((Object)this), i2, j2, k);
        }
        renderBlocks.clearUVRotation();
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        model.renderAsItemBlock(renderBlocks, (apa)((Object)this), iItemDamage);
        HamperBlock.model.lid.renderAsItemBlock(renderBlocks, (apa)((Object)this), iItemDamage);
    }

    @Environment(value=EnvType.CLIENT)
    public aqx c_(aab world, int i2, int j2, int k) {
        int iMetadata = world.h(i2, j2, k);
        aqx transformedBox = this.getIsOpen(iMetadata) ? HamperBlock.model.selectionBoxOpen.makeTemporaryCopy() : HamperBlock.model.selectionBox.makeTemporaryCopy();
        transformedBox.rotateAroundYToFacing(this.getFacing(iMetadata));
        transformedBox.d(i2, j2, k);
        return transformedBox;
    }
}

