/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.AttachedSlabBlock;
import btw.block.blocks.GrassBlock;
import btw.client.render.util.RenderUtils;
import btw.item.BTWItems;
import btw.world.util.BlockPos;
import com.prupe.mcpatcher.cc.ColorizeBlock;
import com.prupe.mcpatcher.mal.block.RenderBlocksUtils;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class GrassSlabBlock
extends AttachedSlabBlock {
    @Environment(value=EnvType.CLIENT)
    private boolean hasSnowOnTop;
    @Environment(value=EnvType.CLIENT)
    public static boolean secondPass;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassTopSparse;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassTopSparseDirt;
    @Environment(value=EnvType.CLIENT)
    private lx iconSnowSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconSnowSideHalf;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassSideOverlay;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassSideOverlayHalf;

    public GrassSlabBlock(int blockID) {
        super(blockID, aif.c);
        this.c(0.5f);
        this.setShovelsEffectiveOn(true);
        this.a(apa.i);
        this.c("fcBlockSlabDirt");
        this.b(true);
        this.a(ve.b);
        this.c("fcBlockGrassSlab");
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, Random rand) {
        if (!GrassBlock.canGrassSurviveAtLocation(world, x2, y2, z2)) {
            this.revertToDirt(world, x2, y2, z2);
        } else if (GrassBlock.canGrassSpreadFromLocation(world, x2, y2, z2)) {
            if (rand.nextFloat() <= 0.8f) {
                GrassBlock.checkForGrassSpreadFromLocation(world, x2, y2, z2);
            }
            if (this.isSparse(world, x2, y2, z2) && rand.nextInt(12) == 0) {
                this.setFullyGrown(world, x2, y2, z2);
            }
        }
    }

    @Override
    public int a(int metadata, Random random, int fortuneModifier) {
        return BTWBlocks.looseDirtSlab.cz;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int x2, int y2, int z2, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, x2, y2, z2, BTWItems.dirtPile.cp, 3, 0, fChanceOfDrop);
        return true;
    }

    @Override
    protected void onAnchorBlockLost(aab world, int i2, int j2, int k) {
        world.f(i2, j2, k, BTWBlocks.looseDirtSlab.cz, world.h(i2, j2, k) & 3, 2);
    }

    @Override
    public int getCombinedBlockID(int iMetadata) {
        return apa.y.cz;
    }

    @Override
    public boolean attemptToCombineWithFallingEntity(aab world, int x2, int y2, int z2, rg entity) {
        if (entity.a == BTWBlocks.looseDirtSlab.cz && !this.getIsUpsideDown(world, x2, y2, z2)) {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
            return true;
        }
        return super.attemptToCombineWithFallingEntity(world, x2, y2, z2, entity);
    }

    @Override
    public boolean canBePistonShoveled(aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean canBeGrazedOn(aak blockAccess, int x2, int y2, int z2, qh animal) {
        return !this.isSparse(blockAccess, x2, y2, z2) || animal.isStarving() || animal.getDisruptsEarthOnGraze();
    }

    @Override
    public void onGrazed(aab world, int x2, int y2, int z2, qh animal) {
        if (!animal.getDisruptsEarthOnGraze()) {
            if (this.isSparse(world, x2, y2, z2)) {
                world.setBlockWithNotify(x2, y2, z2, BTWBlocks.dirtSlab.cz);
            } else {
                this.setSparse(world, x2, y2, z2);
            }
        } else {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirtSlab.cz);
            this.notifyNeighborsBlockDisrupted(world, x2, y2, z2);
        }
    }

    @Override
    public void onVegetationAboveGrazed(aab world, int x2, int y2, int z2, qh animal) {
        if (animal.getDisruptsEarthOnGraze()) {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
            this.notifyNeighborsBlockDisrupted(world, x2, y2, z2);
        }
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        super.onBlockDestroyedWithImproperTool(world, player, i2, j2, k, iMetadata);
        this.onDirtSlabDugWithImproperTool(world, i2, j2, k, this.getIsUpsideDown(iMetadata));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        super.a(world, i2, j2, k, explosion);
        this.onDirtSlabDugWithImproperTool(world, i2, j2, k, this.getIsUpsideDown(world, i2, j2, k));
    }

    public void revertToDirt(aab world, int x2, int y2, int z2) {
        boolean isUpsideDown = this.getIsUpsideDown(world, x2, y2, z2);
        world.setBlockWithNotify(x2, y2, z2, BTWBlocks.dirtSlab.cz);
        BTWBlocks.dirtSlab.setSubtype(world, x2, y2, z2, 0);
        BTWBlocks.dirtSlab.setIsUpsideDown(world, x2, y2, z2, isUpsideDown);
    }

    public boolean isSparse(aak blockAccess, int x2, int y2, int z2) {
        return this.isSparse(blockAccess.h(x2, y2, z2));
    }

    public boolean isSparse(int metadata) {
        return (metadata & 0xFFFFFFFF) == 2;
    }

    public void setSparse(aab world, int x2, int y2, int z2) {
        int metadata = world.h(x2, y2, z2);
        world.setBlockMetadataWithNotify(x2, y2, z2, metadata | 2);
    }

    public void setFullyGrown(aab world, int x2, int y2, int z2) {
        int metadata = world.h(x2, y2, z2);
        world.setBlockMetadataWithNotify(x2, y2, z2, metadata & 1);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = apa.z.cQ;
        this.iconGrassTop = register.a("grass_top");
        this.iconGrassTopSparse = register.a("fcBlockGrassSparse");
        this.iconGrassTopSparseDirt = register.a("fcBlockGrassSparseDirt");
        this.iconSnowSide = register.a("snow_side");
        this.iconSnowSideHalf = register.a("FCBlockSlabDirt_grass_snow_side");
        this.iconGrassSideOverlay = register.a("grass_side_overlay");
        this.iconGrassSideOverlayHalf = register.a("FCBlockSlabDirt_grass_side_overlay");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int c(aak blockAccess, int x2, int y2, int z2) {
        if (this.hasSnowOnTop || !secondPass) {
            return 0xFFFFFF;
        }
        if (ColorizeBlock.colorizeBlock(this, blockAccess, x2, y2, z2)) {
            return ColorizeBlock.blockColor;
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int k = -1; k <= 1; ++k) {
                int iBiomeGrassColor = blockAccess.a(x2 + i2, z2 + k).k();
                red += (iBiomeGrassColor & 0xFF0000) >> 16;
                green += (iBiomeGrassColor & 0xFF00) >> 8;
                blue += iBiomeGrassColor & 0xFF;
            }
        }
        return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int neighborX, int neighborY, int neighborZ, int side) {
        BlockPos pos = new BlockPos(neighborX, neighborY, neighborZ, s.a[side]);
        if (!secondPass) {
            if (side == 1 && !this.isSparse(blockAccess, pos.x, pos.y, pos.z) && !this.hasSnowOnTop) {
                // empty if block
            }
        } else {
            if (side == 0) {
                return false;
            }
            if (side >= 2 && this.hasSnowOnTop) {
                return false;
            }
        }
        return super.a(blockAccess, neighborX, neighborY, neighborZ, side);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int x2, int y2, int z2, int side) {
        if (!secondPass) {
            if (side == 1 && this.isSparse(blockAccess, x2, y2, z2)) {
                return this.iconGrassTopSparseDirt;
            }
            if (side > 1 && this.hasSnowOnTop) {
                lx betterGrassIcon = RenderBlocksUtils.getGrassTexture(this, blockAccess, x2, y2, z2, side, this.iconGrassTop);
                if (betterGrassIcon != null && betterGrassIcon != this.iconGrassTop && betterGrassIcon != this.iconGrassTopSparse) {
                    return betterGrassIcon;
                }
                if (this.getIsUpsideDown(blockAccess, x2, y2, z2)) {
                    return this.iconSnowSide;
                }
                return this.iconSnowSideHalf;
            }
            return apa.z.m(side);
        }
        return this.getBlockTextureSecondPass(blockAccess, x2, y2, z2, side);
    }

    @Environment(value=EnvType.CLIENT)
    public lx getBlockTextureSecondPass(aak blockAccess, int x2, int y2, int z2, int side) {
        lx topIcon = this.isSparse(blockAccess, x2, y2, z2) ? this.iconGrassTopSparse : this.iconGrassTop;
        lx betterGrassIcon = RenderBlocksUtils.getGrassTexture(this, blockAccess, x2, y2, z2, side, topIcon);
        if (betterGrassIcon != null) {
            return betterGrassIcon;
        }
        if (side == 1) {
            return topIcon;
        }
        if (side > 1) {
            if (this.getIsUpsideDown(blockAccess, x2, y2, z2)) {
                return this.iconGrassSideOverlay;
            }
            return this.iconGrassSideOverlayHalf;
        }
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf render, int x2, int y2, int z2) {
        this.hasSnowOnTop = this.isSnowCoveringTopSurface(render.a, x2, y2, z2);
        aqx bounds = this.getBlockBoundsFromPoolBasedOnState(render.a, x2, y2, z2);
        render.setRenderBounds(bounds);
        return render.p(this, x2, y2, z2);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf render, int x2, int y2, int z2, boolean firstPassResult) {
        secondPass = true;
        aqx bounds = this.getBlockBoundsFromPoolBasedOnState(render.a, x2, y2, z2);
        render.setRenderBounds(bounds);
        render.p(this, x2, y2, z2);
        secondPass = false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int itemDamage, float brightness) {
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        itemDamage = 1;
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, BTWBlocks.dirtSlab, -0.5f, -0.5f, -0.5f, itemDamage << 1);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int blockID, ve creativeTabs, List list) {
        list.add(new wm(blockID, 1, 0));
    }
}

