/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.GroundCoverBlock;
import btw.item.BTWItems;
import btw.item.items.HoeItem;
import btw.item.util.ItemUtils;
import btw.world.util.BlockPos;
import com.prupe.mcpatcher.mal.block.RenderBlocksUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class GrassBlock
extends amp {
    public static final int SPREAD_LIGHT_LEVEL = 9;
    public static final int SURVIVE_LIGHT_LEVEL = 9;
    public static final float GROWTH_CHANCE = 0.8f;
    public static final int SELF_GROWTH_CHANCE = 12;
    @Environment(value=EnvType.CLIENT)
    private boolean hasSnowOnTop;
    @Environment(value=EnvType.CLIENT)
    public static boolean secondPass;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassTopSparse;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassTopSparseDirt;
    @Environment(value=EnvType.CLIENT)
    private lx iconSnowSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassSideOverlay;

    public GrassBlock(int blockID) {
        super(blockID);
        this.c(0.6f);
        this.setShovelsEffectiveOn();
        this.setHoesEffectiveOn();
        this.a(i);
        this.c("grass");
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, Random rand) {
        if (!GrassBlock.canGrassSurviveAtLocation(world, x2, y2, z2)) {
            world.setBlockWithNotify(x2, y2, z2, apa.z.cz);
        } else if (GrassBlock.canGrassSpreadFromLocation(world, x2, y2, z2)) {
            if (rand.nextFloat() <= 0.8f) {
                GrassBlock.checkForGrassSpreadFromLocation(world, x2, y2, z2);
            }
            if (this.isSparse(world, x2, y2, z2) && rand.nextInt(12) == 0) {
                this.setFullyGrown(world, x2, y2, z2);
            }
        }
    }

    @Override
    protected wm c_(int metadata) {
        if (this.isSparse(metadata)) {
            return new wm(apa.z);
        }
        return new wm(this);
    }

    @Override
    public int a(int metadata, Random rand, int fortuneModifier) {
        return BTWBlocks.looseDirt.cz;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int x2, int y2, int z2, int metadata, float chanceOfDrop) {
        this.dropItemsIndividually(world, x2, y2, z2, BTWItems.dirtPile.cp, 6, 0, chanceOfDrop);
        return true;
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int x2, int y2, int z2, int metadata) {
        super.onBlockDestroyedWithImproperTool(world, player, x2, y2, z2, metadata);
        this.onDirtDugWithImproperTool(world, x2, y2, z2);
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, zw explosion) {
        super.a(world, x2, y2, z2, explosion);
        this.onDirtDugWithImproperTool(world, x2, y2, z2);
    }

    @Override
    protected void onNeighborDirtDugWithImproperTool(aab world, int x2, int y2, int z2, int toFacing) {
        if (toFacing == 0) {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
        }
    }

    @Override
    public boolean canBePistonShoveled(aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean canBeGrazedOn(aak blockAccess, int x2, int y2, int z2, qh animal) {
        return !this.isSparse(blockAccess, x2, y2, z2) || animal.isStarving() || animal.getDisruptsEarthOnGraze();
    }

    @Override
    public void onGrazed(aab world, int x2, int y2, int z2, qh animal) {
        if (!animal.getDisruptsEarthOnGraze()) {
            if (this.isSparse(world, x2, y2, z2)) {
                world.setBlockWithNotify(x2, y2, z2, apa.z.cz);
            } else {
                this.setSparse(world, x2, y2, z2);
            }
        } else {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
            this.notifyNeighborsBlockDisrupted(world, x2, y2, z2);
        }
    }

    @Override
    public void onVegetationAboveGrazed(aab world, int x2, int y2, int z2, qh animal) {
        if (animal.getDisruptsEarthOnGraze()) {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
            this.notifyNeighborsBlockDisrupted(world, x2, y2, z2);
        }
    }

    @Override
    public boolean canReedsGrowOnBlock(aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean canSaplingsGrowOnBlock(aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean canWildVegetationGrowOnBlock(aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean getCanBlightSpreadToBlock(aab world, int x2, int y2, int z2, int blightLevel) {
        return true;
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int x2, int y2, int z2) {
        return stack != null && stack.b() instanceof HoeItem;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int x2, int y2, int z2, int fromSide) {
        world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
        if (!world.I && world.s.nextInt(25) == 0) {
            ItemUtils.ejectStackFromBlockTowardsFacing(world, x2, y2, z2, new wm(BTWItems.hempSeeds), fromSide);
        }
        return true;
    }

    @Override
    public boolean getCanGrassSpreadToBlock(aab world, int x2, int y2, int z2) {
        return this.isSparse(world, x2, y2, z2);
    }

    @Override
    public boolean spreadGrassToBlock(aab world, int x2, int y2, int z2) {
        if (this.isSparse(world, x2, y2, z2)) {
            this.setFullyGrown(world, x2, y2, z2);
            return true;
        }
        return false;
    }

    public static boolean canGrassSurviveAtLocation(aab world, int x2, int y2, int z2) {
        int blockAboveID = world.a(x2, y2 + 1, z2);
        apa blockAbove = apa.r[blockAboveID];
        int blockAboveMaxNaturalLight = world.getBlockNaturalLightValueMaximum(x2, y2 + 1, z2);
        int blockAboveCurrentNaturalLight = blockAboveMaxNaturalLight - world.j;
        return blockAboveMaxNaturalLight >= 9 && apa.t[blockAboveID] <= 2 && (blockAbove == null || blockAbove.getCanGrassGrowUnderBlock(world, x2, y2 + 1, z2, false));
    }

    public static boolean canGrassSpreadFromLocation(aab world, int x2, int y2, int z2) {
        int blockAboveCurrentBlockLight;
        int blockAboveID = world.a(x2, y2 + 1, z2);
        apa blockAbove = apa.r[blockAboveID];
        int blockAboveMaxNaturalLight = world.getBlockNaturalLightValueMaximum(x2, y2 + 1, z2);
        int blockAboveCurrentNaturalLight = blockAboveMaxNaturalLight - world.j;
        int currentLight = Math.max(blockAboveCurrentNaturalLight, blockAboveCurrentBlockLight = world.n(x2, y2 + 1, z2));
        return currentLight >= 9;
    }

    public static void checkForGrassSpreadFromLocation(aab world, int x2, int y2, int z2) {
        int k;
        int j2;
        int i2;
        apa targetBlock;
        if (world.t.h != 1 && !GroundCoverBlock.isGroundCoverRestingOnBlock(world, x2, y2, z2) && (targetBlock = apa.r[world.a(i2 = x2 + world.s.nextInt(3) - 1, j2 = y2 + world.s.nextInt(4) - 2, k = z2 + world.s.nextInt(3) - 1)]) != null) {
            GrassBlock.attempToSpreadGrassToLocation(world, i2, j2, k);
        }
    }

    public static boolean attempToSpreadGrassToLocation(aab world, int x2, int y2, int z2) {
        int targetBlockID = world.a(x2, y2, z2);
        apa targetBlock = apa.r[targetBlockID];
        if (GrassBlock.canGrassSurviveAtLocation(world, x2, y2, z2) && targetBlock.getCanGrassSpreadToBlock(world, x2, y2, z2) && apa.t[world.a(x2, y2 + 1, z2)] <= 2 && !GroundCoverBlock.isGroundCoverRestingOnBlock(world, x2, y2, z2)) {
            return targetBlock.spreadGrassToBlock(world, x2, y2, z2);
        }
        return false;
    }

    public boolean isSparse(aak blockAccess, int x2, int y2, int z2) {
        return this.isSparse(blockAccess.h(x2, y2, z2));
    }

    public boolean isSparse(int metadata) {
        return metadata == 1;
    }

    public void setSparse(aab world, int x2, int y2, int z2) {
        world.setBlockMetadataWithNotify(x2, y2, z2, 1);
    }

    public void setFullyGrown(aab world, int x2, int y2, int z2) {
        world.setBlockMetadataWithNotify(x2, y2, z2, 0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconGrassTop = register.a("grass_top");
        this.iconSnowSide = register.a("snow_side");
        this.iconGrassSideOverlay = register.a("grass_side_overlay");
        this.iconGrassTopSparse = register.a("fcBlockGrassSparse");
        this.iconGrassTopSparseDirt = register.a("fcBlockGrassSparseDirt");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int c(aak blockAccess, int x2, int y2, int z2) {
        if (this.hasSnowOnTop || !secondPass) {
            return 0xFFFFFF;
        }
        return super.c(blockAccess, x2, y2, z2);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int neighborX, int neighborY, int neighborZ, int side) {
        BlockPos pos = new BlockPos(neighborX, neighborY, neighborZ, s.a[side]);
        if (!secondPass) {
            if (side == 1 && !this.isSparse(blockAccess, pos.x, pos.y, pos.z) && !this.hasSnowOnTop) {
                // empty if block
            }
        } else {
            if (side == 0) {
                return false;
            }
            if (side >= 2 && this.hasSnowOnTop) {
                return false;
            }
        }
        return super.a(blockAccess, neighborX, neighborY, neighborZ, side);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int x2, int y2, int z2, int side) {
        if (!secondPass) {
            if (side == 1 && this.isSparse(blockAccess, x2, y2, z2)) {
                return this.iconGrassTopSparseDirt;
            }
            if (side > 1 && this.hasSnowOnTop) {
                lx betterGrassIcon = RenderBlocksUtils.getGrassTexture(this, blockAccess, x2, y2, z2, side, this.iconGrassTop);
                if (betterGrassIcon != null && betterGrassIcon != this.iconGrassTop && betterGrassIcon != this.iconGrassTopSparse) {
                    return betterGrassIcon;
                }
                return this.iconSnowSide;
            }
            return apa.y.m(side);
        }
        return this.getBlockTextureSecondPass(blockAccess, x2, y2, z2, side);
    }

    @Environment(value=EnvType.CLIENT)
    public lx getBlockTextureSecondPass(aak blockAccess, int x2, int y2, int z2, int side) {
        lx topIcon = this.isSparse(blockAccess, x2, y2, z2) ? this.iconGrassTopSparse : this.iconGrassTop;
        lx betterGrassIcon = RenderBlocksUtils.getGrassTexture(this, blockAccess, x2, y2, z2, side, topIcon);
        if (betterGrassIcon != null) {
            return betterGrassIcon;
        }
        if (side == 1) {
            return topIcon;
        }
        if (side > 1) {
            return this.iconGrassSideOverlay;
        }
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf render, int x2, int y2, int z2) {
        this.hasSnowOnTop = this.isSnowCoveringTopSurface(render.a, x2, y2, z2);
        render.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return render.p(this, x2, y2, z2);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf render, int x2, int y2, int z2, boolean firstPassResult) {
        secondPass = true;
        render.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        render.p(this, x2, y2, z2);
        secondPass = false;
    }
}

