/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.FallingBlock;
import btw.block.blocks.StemBlock;
import btw.world.util.BlockPos;
import java.util.ArrayList;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public abstract class GourdBlock
extends FallingBlock {
    private static final double ARROW_SPEED_SQUARED_TO_EXPLODE = 1.1;
    @Environment(value=EnvType.CLIENT)
    protected lx iconTop;

    protected GourdBlock(int iBlockID) {
        super(iBlockID, aif.A);
        this.setAxesEffectiveOn(true);
        this.setBuoyant();
        this.b(true);
        this.a(ve.b);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        super.a(world, i2, j2, k, rand);
        if (world.a(i2, j2, k) == this.cz) {
            this.validateConnectionState(world, i2, j2, k);
        }
    }

    @Override
    public int h() {
        return 0;
    }

    @Override
    public void onArrowImpact(aab world, int i2, int j2, int k, ss arrow) {
        if (!world.I) {
            double dArrowSpeedSq = arrow.x * arrow.x + arrow.y * arrow.y + arrow.z * arrow.z;
            if (dArrowSpeedSq >= 1.1) {
                world.setBlockWithNotify(i2, j2, k, 0);
                this.explode(world, (double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5);
            } else {
                world.e(2251, i2, j2, k, 0);
            }
        }
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        world.e(this.auxFXIDOnExplode(), i2, j2, k, 0);
    }

    @Override
    public boolean onFinishedFalling(rg entity, float fFallDistance) {
        entity.b = 0;
        if (!entity.q.I) {
            int i2 = kx.c(entity.u);
            int j2 = kx.c(entity.v);
            int k = kx.c(entity.w);
            int iFallDistance = kx.f(entity.T - 5.0f);
            if (iFallDistance >= 0) {
                this.damageCollidingEntitiesOnFall(entity, fFallDistance);
                if (!aif.h.equals(entity.q.g(i2, j2, k)) && entity.ab.nextInt(10) < iFallDistance) {
                    this.explode(entity.q, (double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5);
                    return false;
                }
            }
            entity.q.e(2251, i2, j2, k, 0);
        }
        return true;
    }

    @Override
    public int adjustMetadataForPistonMove(int iMetadata) {
        iMetadata = 0;
        return 0;
    }

    @Override
    public boolean isBlockAttachedToFacing(aak blockAccess, int i2, int j2, int k, int iFacing) {
        int iMetadata = blockAccess.h(i2, j2, k);
        return iMetadata >= 2 && iFacing == iMetadata;
    }

    @Override
    public void attachToFacing(aab world, int i2, int j2, int k, int iFacing) {
        if (iFacing >= 2 && iFacing <= 5) {
            world.setBlockMetadataWithClient(i2, j2, k, iFacing);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        super.a(world, i2, j2, k, iBlockID);
        this.validateConnectionState(world, i2, j2, k);
    }

    @Override
    public boolean canBeGrazedOn(aak access, int i2, int j2, int k, qh animal) {
        return animal.canGrazeOnRoughVegetation();
    }

    protected abstract wk itemToDropOnExplode();

    protected abstract int itemCountToDropOnExplode();

    protected abstract int auxFXIDOnExplode();

    protected abstract mg getFallDamageSource();

    private void explode(aab world, double posX, double posY, double posZ) {
        wk itemToDrop = this.itemToDropOnExplode();
        if (itemToDrop != null) {
            for (int iTempCount = 0; iTempCount < this.itemCountToDropOnExplode(); ++iTempCount) {
                wm itemStack = new wm(itemToDrop, 1, 0);
                rh entityItem = (rh)mv.createEntityOfType(rh.class, world, posX, posY + 0.5, posZ, itemStack);
                entityItem.x = (world.s.nextDouble() - 0.5) * 0.5;
                entityItem.y = 0.2 + world.s.nextDouble() * 0.3;
                entityItem.z = (world.s.nextDouble() - 0.5) * 0.5;
                entityItem.b = 10;
                world.d(entityItem);
            }
        }
        this.notifyNearbyAnimalsFinishedFalling(world, kx.c(posX), kx.c(posY), kx.c(posZ));
        world.e(this.auxFXIDOnExplode(), kx.c(posX), kx.c(posY), kx.c(posZ), 0);
    }

    private void damageCollidingEntitiesOnFall(rg entity, float fFallDistance) {
        int var2 = kx.f(fFallDistance - 1.0f);
        if (var2 > 0) {
            ArrayList collisionList = new ArrayList(entity.q.b((mp)entity, entity.E));
            mg source = this.getFallDamageSource();
            for (mp tempEntity : collisionList) {
                tempEntity.a(source, 1);
            }
        }
    }

    protected void validateConnectionState(aab world, int i2, int j2, int k) {
        int iMetadata = world.h(i2, j2, k);
        if (iMetadata > 0) {
            BlockPos targetPos = new BlockPos(i2, j2, k);
            if (iMetadata >= 2 && iMetadata <= 5) {
                targetPos.addFacingAsOffset(iMetadata);
                int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
                if (apa.r[iTargetBlockID] == null || !(apa.r[iTargetBlockID] instanceof StemBlock) || world.h(targetPos.x, targetPos.y, targetPos.z) != 15) {
                    world.setBlockMetadata(i2, j2, k, 0);
                }
            } else {
                world.setBlockMetadata(i2, j2, k, 0);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 1 || iSide == 0) {
            return this.iconTop;
        }
        return this.cQ;
    }
}

