/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.BTWMod;
import btw.block.BTWBlocks;
import btw.block.MechanicalBlock;
import btw.block.blocks.AxleBlock;
import btw.block.util.Flammability;
import btw.block.util.MechPowerUtils;
import btw.item.BTWItems;
import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class GearBoxBlock
extends apa
implements MechanicalBlock {
    public static final int TICK_RATE = 10;
    private static final int TURN_ON_TICK_RATE = 10;
    private static final int TURN_OFF_TICK_RATE = 9;
    @Environment(value=EnvType.CLIENT)
    private lx iconInput;
    @Environment(value=EnvType.CLIENT)
    private lx iconOutput;

    public GearBoxBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.plankMaterial);
        this.c(2.0f);
        this.setAxesEffectiveOn(true);
        this.setBuoyant();
        this.setFireProperties(Flammability.PLANKS);
        this.a(g);
        this.b(true);
        this.c("fcBlockGearBox");
        this.a(ve.d);
    }

    @Override
    public int a(aab world) {
        return 10;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        return this.setFacing(iMetadata, apa.getOppositeFacing(iFacing));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, ng entityLiving, wm stack) {
        int iFacing = MiscUtils.convertPlacingEntityOrientationToBlockFacingReversed(entityLiving);
        this.setFacing(world, i2, j2, k, iFacing);
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, this.a(world));
    }

    @Override
    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        if (player.cd() == null && !MechPowerUtils.doesBlockHaveAnyFacingAxles(world, i2, j2, k)) {
            if (!world.I) {
                this.toggleFacing(world, i2, j2, k, false);
                MiscUtils.playPlaceSoundForBlock(world, i2, j2, k);
            }
            return true;
        }
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        boolean bMechPowered = this.isInputtingMechanicalPower(world, i2, j2, k);
        this.updateMechPoweredState(world, i2, j2, k, bMechPowered);
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (!this.isCurrentStateValid(world, i2, j2, k) && !world.isUpdateScheduledForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        if (!(this.isCurrentStateValid(world, i2, j2, k) || world.isUpdateScheduledForBlock(i2, j2, k, this.cz) || world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz))) {
            if (!BTWMod.disableGearBoxPowerDrain && this.isGearBoxOn(world, i2, j2, k)) {
                world.a(i2, j2, k, this.cz, 9);
            } else {
                world.a(i2, j2, k, this.cz, 10);
            }
        }
    }

    @Override
    public int getMechanicalPowerLevelProvidedToAxleAtFacing(aab world, int i2, int j2, int k, int iFacing) {
        if (this.isGearBoxOn(world, i2, j2, k) && this.getFacing(world, i2, j2, k) != iFacing) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 2;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, i2, j2, k, wk.E.cp, 2, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, 3, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.gear.cp, 2, 0, fChanceOfDrop);
        return true;
    }

    @Override
    public int getFacing(int iMetadata) {
        return iMetadata & 7;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata &= 8;
        return iMetadata |= iFacing;
    }

    @Override
    public boolean rotateAroundJAxis(aab world, int i2, int j2, int k, boolean bReverse) {
        int iFacing = this.getFacing(world, i2, j2, k);
        int iNewFacing = apa.rotateFacingAroundY(iFacing, bReverse);
        if (iNewFacing != iFacing) {
            if (this.isGearBoxOn(world, i2, j2, k)) {
                this.setGearBoxOn(world, i2, j2, k, false);
            }
            this.setFacing(world, i2, j2, k, iNewFacing);
            world.g(i2, j2, k, i2, j2, k);
            world.a(i2, j2, k, this.cz, this.a(world));
            MechPowerUtils.destroyHorizontallyAttachedAxles(world, i2, j2, k);
            return true;
        }
        return false;
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        if (this.isGearBoxOn(world, i2, j2, k)) {
            this.setGearBoxOn(world, i2, j2, k, false);
        }
        int iFacing = this.getFacing(world, i2, j2, k);
        iFacing = apa.cycleFacing(iFacing, bReverse);
        this.setFacing(world, i2, j2, k, iFacing);
        world.g(i2, j2, k, i2, j2, k);
        world.a(i2, j2, k, this.cz, this.a(world));
        world.d(i2, j2, k, this.cz);
        return true;
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return true;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return MechPowerUtils.isBlockPoweredByAxleToSide(world, i2, j2, k, this.getFacing(world, i2, j2, k));
    }

    @Override
    public boolean canInputAxlePowerToFacing(aab world, int i2, int j2, int k, int iFacing) {
        int iBlockFacing = this.getFacing(world, i2, j2, k);
        return iFacing == iBlockFacing;
    }

    @Override
    public boolean isOutputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return this.isGearBoxOn(world, i2, j2, k);
    }

    @Override
    public void overpower(aab world, int i2, int j2, int k) {
        if (this.isGearBoxOn(world, i2, j2, k)) {
            this.breakGearBox(world, i2, j2, k);
        }
    }

    protected void updateMechPoweredState(aab world, int i2, int j2, int k, boolean bShouldBePowered) {
        if (this.isGearBoxOn(world, i2, j2, k) != bShouldBePowered) {
            this.setGearBoxOn(world, i2, j2, k, bShouldBePowered);
        }
    }

    protected boolean isCurrentStateValid(aab world, int i2, int j2, int k) {
        return this.isGearBoxOn(world, i2, j2, k) == this.isInputtingMechanicalPower(world, i2, j2, k);
    }

    public boolean isGearBoxOn(aak blockAccess, int i2, int j2, int k) {
        return this.isGearBoxOn(blockAccess.h(i2, j2, k));
    }

    public boolean isGearBoxOn(int iMetadata) {
        return (iMetadata & 8) > 0;
    }

    public int setGearBoxOn(int iMetadata, boolean bOn) {
        iMetadata &= 7;
        if (bOn) {
            iMetadata |= 8;
        }
        return iMetadata;
    }

    public void setGearBoxOn(aab world, int i2, int j2, int k, boolean bOn) {
        int iMetadata = this.setGearBoxOn(world.h(i2, j2, k), bOn);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public void breakGearBox(aab world, int i2, int j2, int k) {
        this.dropComponentItemsOnBadBreak(world, i2, j2, k, world.h(i2, j2, k), 1.0f);
        world.e(2235, i2, j2, k, 0);
        world.setBlockWithNotify(i2, j2, k, 0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconInput = register.a(this.B() + "_input");
        this.iconOutput = register.a(this.B() + "_output");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 3) {
            return this.iconInput;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (iSide == iFacing) {
            return this.iconInput;
        }
        BlockPos sideBlockPos = new BlockPos(i2, j2, k);
        sideBlockPos.addFacingAsOffset(iSide);
        if (blockAccess.a(sideBlockPos.x, sideBlockPos.y, sideBlockPos.z) == BTWBlocks.axle.cz && ((AxleBlock)BTWBlocks.axle).isAxleOrientedTowardsFacing(blockAccess, sideBlockPos.x, sideBlockPos.y, sideBlockPos.z, iSide)) {
            return this.iconOutput;
        }
        if (iSide == apa.getOppositeFacing(iFacing)) {
            for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
                if (iTempFacing == iFacing || !MechPowerUtils.doesBlockHaveFacingAxleToSide(blockAccess, i2, j2, k, iTempFacing)) continue;
                return this.cQ;
            }
            return this.iconOutput;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random random) {
        if (this.isGearBoxOn(world, i2, j2, k)) {
            this.emitGearBoxParticles(world, i2, j2, k, random);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientNotificationOfMetadataChange(aab world, int i2, int j2, int k, int iOldMetadata, int iNewMetadata) {
        if (!this.isGearBoxOn(iOldMetadata) && this.isGearBoxOn(iNewMetadata)) {
            world.playSound((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "random.chestopen", 0.25f, world.s.nextFloat() * 0.25f + 0.25f);
            this.emitGearBoxParticles(world, i2, j2, k, world.s);
        }
        world.g(i2 - 3, j2 - 3, k - 3, i2 + 3, j2 + 3, k + 3);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientBreakBlock(aab world, int i2, int j2, int k, int iBlockID, int iMetadata) {
        world.g(i2 - 3, j2 - 3, k - 3, i2 + 3, j2 + 3, k + 3);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientBlockAdded(aab world, int i2, int j2, int k) {
        world.g(i2 - 3, j2 - 3, k - 3, i2 + 3, j2 + 3, k + 3);
    }

    @Environment(value=EnvType.CLIENT)
    private void emitGearBoxParticles(aab world, int i2, int j2, int k, Random random) {
        for (int iTempCount = 0; iTempCount < 5; ++iTempCount) {
            float smokeX = (float)i2 + random.nextFloat();
            float smokeY = (float)j2 + random.nextFloat() * 0.5f + 1.0f;
            float smokeZ = (float)k + random.nextFloat();
            world.a("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }
}

