/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.client.texture.FireTexture;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class FireBlock
extends aml {
    @Environment(value=EnvType.CLIENT)
    private lx[] stokedFireTopTextureArray;

    public FireBlock(int iBlockID) {
        super(iBlockID);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        if (!this.c(world, i2, j2, k)) {
            world.setBlockWithNotify(i2, j2, k, 0);
            return;
        }
        if (this.doesBlockBelowExtiguishFire(world, i2, j2, k)) {
            world.setBlockWithNotify(i2, j2, k, 0);
            return;
        }
        int iBlockBelowID = world.a(i2, j2 - 1, k);
        boolean bInfiniteBurn = false;
        if (iBlockBelowID == apa.bf.cz) {
            bInfiniteBurn = true;
        } else if (world.t.h == 1 && iBlockBelowID == apa.D.cz) {
            bInfiniteBurn = true;
        } else if (this.hasInfiniteBurnNeighbor(world, i2, j2, k)) {
            bInfiniteBurn = true;
        }
        if (!bInfiniteBurn && world.P() && (world.isRainingAtPos(i2, j2, k) || world.isRainingAtPos(i2 - 1, j2, k) || world.isRainingAtPos(i2 + 1, j2, k) || world.isRainingAtPos(i2, j2, k - 1) || world.isRainingAtPos(i2, j2, k + 1))) {
            world.setBlockWithNotify(i2, j2, k, 0);
        } else if (world.N().b("doFireTick")) {
            int iMetadata = world.h(i2, j2, k);
            if (iMetadata < 15) {
                world.setBlockMetadata(i2, j2, k, iMetadata + random.nextInt(3) / 2);
            }
            world.a(i2, j2, k, this.cz, this.a(world) + random.nextInt(10));
            if (!bInfiniteBurn && !this.k(world, i2, j2, k)) {
                if (!world.w(i2, j2 - 1, k) || iMetadata > 3) {
                    world.setBlockWithNotify(i2, j2, k, 0);
                }
            } else if (!bInfiniteBurn && !this.d((aak)world, i2, j2 - 1, k) && iMetadata == 15 && random.nextInt(4) == 0) {
                world.setBlockWithNotify(i2, j2, k, 0);
            } else {
                boolean bHighHumidity = world.G(i2, j2, k);
                int bDestroyModifier = 0;
                if (bHighHumidity) {
                    bDestroyModifier = -50;
                }
                this.tryToDestroyBlockWithFire(world, i2 + 1, j2, k, 300 + bDestroyModifier, random, iMetadata);
                this.tryToDestroyBlockWithFire(world, i2 - 1, j2, k, 300 + bDestroyModifier, random, iMetadata);
                this.tryToDestroyBlockWithFire(world, i2, j2 - 1, k, 250 + bDestroyModifier, random, iMetadata);
                this.tryToDestroyBlockWithFire(world, i2, j2 + 1, k, 250 + bDestroyModifier, random, iMetadata);
                this.tryToDestroyBlockWithFire(world, i2, j2, k - 1, 300 + bDestroyModifier, random, iMetadata);
                this.tryToDestroyBlockWithFire(world, i2, j2, k + 1, 300 + bDestroyModifier, random, iMetadata);
                FireBlock.checkForFireSpreadFromLocation(world, i2, j2, k, random, iMetadata);
            }
        }
    }

    @Override
    public boolean d(aak blockAccess, int i2, int j2, int k) {
        int iSubtype;
        int iBlockID = blockAccess.a(i2, j2, k);
        if (iBlockID == BTWBlocks.aestheticOpaque.cz && (iSubtype = blockAccess.h(i2, j2, k)) == 3) {
            return true;
        }
        return super.d(blockAccess, i2, j2, k);
    }

    @Override
    public boolean getDoesFireDamageToEntities(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean getCanBlockLightItemOnFire(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public wm getStackRetrievedByBlockDispenser(aab world, int i2, int j2, int k) {
        return null;
    }

    public boolean hasInfiniteBurnNeighbor(aab world, int i2, int j2, int k) {
        for (int iTempFacing = 0; iTempFacing < 6; ++iTempFacing) {
            BlockPos targetPos = new BlockPos(i2, j2, k);
            targetPos.addFacingAsOffset(iTempFacing);
            int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
            apa targetBlock = apa.r[iTargetBlockID];
            if (targetBlock == null || !targetBlock.doesInfiniteBurnToFacing(world, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iTempFacing))) continue;
            return true;
        }
        return false;
    }

    public boolean doesBlockBelowExtiguishFire(aab world, int i2, int j2, int k) {
        int iBlockBelowID = world.a(i2, j2 - 1, k);
        apa blockBelow = apa.r[iBlockBelowID];
        if (blockBelow != null) {
            return blockBelow.doesExtinguishFireAbove(world, i2, j2 - 1, k);
        }
        return false;
    }

    protected void tryToDestroyBlockWithFire(aab world, int i2, int j2, int k, int iChanceToDestroy, Random random, int iSourceMetadata) {
        int iAbilityToCatchFire = b[world.a(i2, j2, k)];
        if (random.nextInt(iChanceToDestroy) < iAbilityToCatchFire && world.N().b("doFireTick")) {
            FireBlock.onBlockDestroyedByFire(world, i2, j2, k, iSourceMetadata, false);
        }
    }

    protected static void onBlockDestroyedByFire(aab world, int i2, int j2, int k, int iFireAge, boolean bForcedFireSpread) {
        int iBlockID = world.a(i2, j2, k);
        apa block = apa.r[iBlockID];
        if (block != null) {
            block.onDestroyedByFire(world, i2, j2, k, iFireAge, bForcedFireSpread);
        }
    }

    public static void checkForFireSpreadFromLocation(aab world, int i2, int j2, int k, Random rand, int iSourceFireAge) {
        if (world.N().b("doFireTick")) {
            boolean bHighHumidity = world.G(i2, j2, k);
            for (int iTempI = i2 - 1; iTempI <= i2 + 1; ++iTempI) {
                for (int iTempK = k - 1; iTempK <= k + 1; ++iTempK) {
                    for (int iTempJ = j2 - 1; iTempJ <= j2 + 4; ++iTempJ) {
                        if (iTempI == i2 && iTempJ == j2 && iTempK == k) continue;
                        int iSpreadTopBound = 100;
                        if (iTempJ > j2 + 1) {
                            iSpreadTopBound += (iTempJ - (j2 + 1)) * 100;
                        }
                        FireBlock.checkForFireSpreadToOneBlockLocation(world, iTempI, iTempJ, iTempK, rand, iSourceFireAge, bHighHumidity, iSpreadTopBound);
                    }
                }
            }
        }
    }

    public static void checkForSmoulderingSpreadFromLocation(aab world, int i2, int j2, int k) {
        if (world.N().b("doFireTick")) {
            boolean bHighHumidity = world.G(i2, j2, k);
            for (int iTempI = i2 - 1; iTempI <= i2 + 1; ++iTempI) {
                for (int iTempK = k - 1; iTempK <= k + 1; ++iTempK) {
                    for (int iTempJ = j2; iTempJ <= j2 + 1; ++iTempJ) {
                        if (iTempI == i2 && iTempJ == j2 && iTempK == k) continue;
                        int iSpreadTopBound = 50;
                        FireBlock.checkForFireSpreadToOneBlockLocation(world, iTempI, iTempJ, iTempK, world.s, 0, bHighHumidity, iSpreadTopBound);
                    }
                }
            }
        }
    }

    public static boolean hasFlammableNeighborsWithinSmoulderRange(aab world, int i2, int j2, int k) {
        for (int iTempI = i2 - 1; iTempI <= i2 + 1; ++iTempI) {
            for (int iTempK = k - 1; iTempK <= k + 1; ++iTempK) {
                for (int iTempJ = j2; iTempJ <= j2 + 1; ++iTempJ) {
                    if (iTempI == i2 && iTempJ == j2 && iTempK == k || !FireBlock.isFlammableOrHasFlammableNeighbors(world, iTempI, iTempJ, iTempK)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isFlammableOrHasFlammableNeighbors(aab world, int i2, int j2, int k) {
        int iBlockID = world.a(i2, j2, k);
        apa block = apa.r[iBlockID];
        return b[iBlockID] > 0 || a[iBlockID] > 0 || block != null && block.getCanBeSetOnFireDirectly(world, i2, j2, k) || FireBlock.canFireReplaceBlock(world, i2, j2, k) && (a[world.a(i2 - 1, j2, k)] > 0 || a[world.a(i2 + 1, j2, k)] > 0 || a[world.a(i2, j2 - 1, k)] > 0 || a[world.a(i2, j2 + 1, k)] > 0 || a[world.a(i2, j2, k - 1)] > 0 || a[world.a(i2, j2, k + 1)] > 0);
    }

    private static void checkForFireSpreadToOneBlockLocation(aab world, int iTempI, int iTempJ, int iTempK, Random rand, int iSourceFireAge, boolean bHighHumidity, int iSpreadTopBound) {
        int iNeighborChance;
        if (world.N().b("doFireTick") && (iNeighborChance = FireBlock.getChanceOfNeighborsEncouragingFireCustom(world, iTempI, iTempJ, iTempK)) > 0) {
            int iSpreadChance = (iNeighborChance + 61) / (iSourceFireAge + 30);
            if (bHighHumidity) {
                iSpreadChance /= 2;
            }
            if (!(iSpreadChance <= 0 || rand.nextInt(iSpreadTopBound) > iSpreadChance || world.P() && world.isRainingAtPos(iTempI, iTempJ, iTempK) || world.isRainingAtPos(iTempI - 1, iTempJ, iTempK) || world.isRainingAtPos(iTempI + 1, iTempJ, iTempK) || world.isRainingAtPos(iTempI, iTempJ, iTempK - 1) || world.isRainingAtPos(iTempI, iTempJ, iTempK + 1))) {
                int iStartMetadata = iSourceFireAge + rand.nextInt(5) / 4;
                if (iStartMetadata > 15) {
                    iStartMetadata = 15;
                }
                if (world.N().b("doFireTick")) {
                    if (FireBlock.canFireReplaceBlock(world, iTempI, iTempJ, iTempK)) {
                        world.setBlockAndMetadataWithNotify(iTempI, iTempJ, iTempK, apa.av.cz, iStartMetadata);
                    } else {
                        apa block = apa.r[world.a(iTempI, iTempJ, iTempK)];
                        if (block != null && block.getCanBeSetOnFireDirectly(world, iTempI, iTempJ, iTempK)) {
                            block.setOnFireDirectly(world, iTempI, iTempJ, iTempK);
                        }
                    }
                }
            }
        }
    }

    public static void checkForFireSpreadAndDestructionToOneBlockLocation(aab world, int i2, int j2, int k) {
        FireBlock.checkForFireSpreadAndDestructionToOneBlockLocation(world, i2, j2, k, world.s, 0, 100);
    }

    public static void checkForFireSpreadAndDestructionToOneBlockLocation(aab world, int i2, int j2, int k, Random rand, int iSourceFireAge, int iSpreadTopBound) {
        if (world.N().b("doFireTick")) {
            int iAbilityToCatchFire = b[world.a(i2, j2, k)];
            boolean bHighHumidity = world.G(i2, j2, k);
            int iChanceToDestroy = 250;
            if (bHighHumidity) {
                iChanceToDestroy -= 50;
            }
            if (rand.nextInt(iChanceToDestroy) < iAbilityToCatchFire) {
                FireBlock.onBlockDestroyedByFire(world, i2, j2, k, iSourceFireAge, true);
            } else {
                FireBlock.checkForFireSpreadToOneBlockLocation(world, i2, j2, k, rand, iSourceFireAge, bHighHumidity, iSpreadTopBound);
            }
        }
    }

    protected static int getChanceOfNeighborsEncouragingFireCustom(aab world, int i2, int j2, int k) {
        if (!FireBlock.canFireReplaceBlock(world, i2, j2, k)) {
            apa block = apa.r[world.a(i2, j2, k)];
            if (block != null && block.getCanBeSetOnFireDirectly(world, i2, j2, k)) {
                return block.getChanceOfFireSpreadingDirectlyTo(world, i2, j2, k);
            }
            return 0;
        }
        int iChance = FireBlock.getChanceToEncourageFire(world, i2 + 1, j2, k, 0);
        iChance = FireBlock.getChanceToEncourageFire(world, i2 - 1, j2, k, iChance);
        iChance = FireBlock.getChanceToEncourageFire(world, i2, j2 - 1, k, iChance);
        iChance = FireBlock.getChanceToEncourageFire(world, i2, j2 + 1, k, iChance);
        iChance = FireBlock.getChanceToEncourageFire(world, i2, j2, k - 1, iChance);
        iChance = FireBlock.getChanceToEncourageFire(world, i2, j2, k + 1, iChance);
        return iChance;
    }

    public static int getChanceToEncourageFire(aab par1World, int par2, int par3, int par4, int iPrevChance) {
        int iChance = a[par1World.a(par2, par3, par4)];
        return iChance > iPrevChance ? iChance : iPrevChance;
    }

    public static boolean canBlockBeDestroyedByFire(int iBlockID) {
        return b[iBlockID] > 0;
    }

    public static boolean canFireReplaceBlock(aab world, int i2, int j2, int k) {
        apa block = apa.r[world.a(i2, j2, k)];
        return block == null || world.N().b("doFireTick") && block.getCanBlockBeReplacedByFire(world, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.stokedFireTopTextureArray = new lx[]{register.registerIcon("fcBlockFireStokedTopStub_0", new FireTexture("fcBlockFireStokedTopStub_0", 0)), register.registerIcon("fcBlockFireStokedTopStub_1", new FireTexture("fcBlockFireStokedTopStub_1", 1))};
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        aak blockAccess = renderer.a;
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        renderer.a(this, i2, j2, k);
        if (blockAccess.a(i2, j2 - 1, k) == BTWBlocks.stokedFire.cz) {
            bgd tessellator = bgd.a;
            lx texture1 = this.stokedFireTopTextureArray[0];
            lx texture2 = this.stokedFireTopTextureArray[1];
            if ((i2 + k & 1) != 0) {
                texture1 = this.stokedFireTopTextureArray[1];
                texture2 = this.stokedFireTopTextureArray[0];
            }
            tessellator.a(1.0f, 1.0f, 1.0f);
            tessellator.c(this.e(blockAccess, i2, j2, k));
            float fRenderHeight = 1.0f;
            double var18 = (double)i2 + 0.5 - 0.5;
            double var20 = (double)i2 + 0.5 + 0.5;
            double var22 = (double)k + 0.5 - 0.5;
            double var24 = (double)k + 0.5 + 0.5;
            double var26 = (double)i2 + 0.5 - 0.5;
            double var28 = (double)i2 + 0.5 + 0.5;
            double var30 = (double)k + 0.5 - 0.5;
            double var32 = (double)k + 0.5 + 0.5;
            double dMinU = texture2.e();
            double dMinV = texture2.g();
            double dMaxU = texture2.f();
            double dMaxV = texture2.h();
            tessellator.a(var26, (float)j2 + fRenderHeight, k + 0, dMinU, dMinV);
            tessellator.a(var18, j2 + 0, k + 0, dMinU, dMaxV);
            tessellator.a(var18, j2 + 0, k + 1, dMaxU, dMaxV);
            tessellator.a(var26, (float)j2 + fRenderHeight, k + 1, dMaxU, dMinV);
            tessellator.a(var28, (float)j2 + fRenderHeight, k + 1, dMinU, dMinV);
            tessellator.a(var20, j2 + 0, k + 1, dMinU, dMaxV);
            tessellator.a(var20, j2 + 0, k + 0, dMaxU, dMaxV);
            tessellator.a(var28, (float)j2 + fRenderHeight, k + 0, dMaxU, dMinV);
            dMinU = texture1.e();
            dMinV = texture1.g();
            dMaxU = texture1.f();
            dMaxV = texture1.h();
            tessellator.a(i2 + 0, (float)j2 + fRenderHeight, var32, dMinU, dMinV);
            tessellator.a(i2 + 0, j2 + 0, var24, dMinU, dMaxV);
            tessellator.a(i2 + 1, j2 + 0, var24, dMaxU, dMaxV);
            tessellator.a(i2 + 1, (float)j2 + fRenderHeight, var32, dMaxU, dMinV);
            tessellator.a(i2 + 1, (float)j2 + fRenderHeight, var30, dMinU, dMinV);
            tessellator.a(i2 + 1, j2 + 0, var22, dMinU, dMaxV);
            tessellator.a(i2 + 0, j2 + 0, var22, dMaxU, dMaxV);
            tessellator.a(i2 + 0, (float)j2 + fRenderHeight, var30, dMaxU, dMinV);
        }
        return true;
    }
}

