/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.FarmlandBlockBase;
import java.util.Random;

public class FarmlandBlock
extends FarmlandBlockBase {
    public static final int LIGHT_LEVEL_FOR_WEED_GROWTH = 11;

    public FarmlandBlock(int iBlockID) {
        super(iBlockID);
        this.c("fcBlockFarmlandNew");
        this.a(ve.c);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        super.a(world, i2, j2, k, iNeighborBlockID);
        if (world.g(i2, j2 + 1, k).a() || this.canFallIntoBlockAtPos(world, i2, j2 - 1, k)) {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirt.cz);
        } else if (this.getWeedsGrowthLevel(world, i2, j2, k) > 0 && !this.canWeedsShareSpaceWithBlockAt(world, i2, j2 + 1, k)) {
            this.setWeedsGrowthLevel(world, i2, j2, k, 0);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        super.a(world, i2, j2, k, rand);
        if (world.a(i2, j2, k) == this.cz && !this.checkForSnowReversion(world, i2, j2, k, rand)) {
            this.updateWeedGrowth(world, i2, j2, k, rand);
        }
    }

    @Override
    public void notifyOfPlantAboveRemoved(aab world, int i2, int j2, int k, apa plantBlock) {
        if (world.a(i2, j2 + 1, k) != apa.ab.cz) {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirt.cz);
        }
    }

    @Override
    protected boolean isHydrated(int iMetadata) {
        return (iMetadata & 1) > 0;
    }

    @Override
    public int setFullyHydrated(int iMetadata) {
        return iMetadata | 1;
    }

    @Override
    protected void dryIncrementally(aab world, int i2, int j2, int k) {
        int iMetadata = world.h(i2, j2, k);
        int iHydrationLevel = iMetadata & 1;
        if (iHydrationLevel > 0) {
            world.setBlockMetadataWithNotify(i2, j2, k, iMetadata &= 0xFFFFFFFE);
        }
    }

    @Override
    protected boolean isFertilized(aak blockAccess, int i2, int j2, int k) {
        return false;
    }

    @Override
    protected void setFertilized(aab world, int i2, int j2, int k) {
        int iTargetBlockMetadata = world.h(i2, j2, k);
        world.setBlockAndMetadataWithNotify(i2, j2, k, BTWBlocks.fertilizedFarmland.cz, iTargetBlockMetadata);
    }

    @Override
    public int getWeedsGrowthLevel(aak blockAccess, int i2, int j2, int k) {
        return this.getWeedsGrowthLevel(blockAccess.h(i2, j2, k));
    }

    @Override
    public void removeWeeds(aab world, int i2, int j2, int k) {
        this.setWeedsGrowthLevel(world, i2, j2, k, 0);
    }

    @Override
    protected void checkForSoilReversion(aab world, int i2, int j2, int k) {
        if (world.s.nextInt(8) == 0) {
            super.checkForSoilReversion(world, i2, j2, k);
        }
    }

    @Override
    protected int getHorizontalHydrationRange(aab world, int i2, int j2, int k) {
        aav biome = world.a(i2, k);
        if (biome.c() || biome.canRainInBiome()) {
            return 4;
        }
        return 2;
    }

    public boolean canWeedsShareSpaceWithBlockAt(aab world, int i2, int j2, int k) {
        apa block = apa.r[world.a(i2, j2, k)];
        if (block != null) {
            return block.canWeedsGrowInBlock(world, i2, j2, k);
        }
        return false;
    }

    protected int getWeedsGrowthLevel(int iMetadata) {
        return (iMetadata & 0xE) >> 1;
    }

    protected void setWeedsGrowthLevel(aab world, int i2, int j2, int k, int iGrowthLevel) {
        int iMetadata = this.setWeedsGrowthLevel(world.h(i2, j2, k), iGrowthLevel);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    protected int setWeedsGrowthLevel(int iMetadata, int iGrowthLevel) {
        return (iMetadata &= 0xFFFFFFF1) | iGrowthLevel << 1;
    }

    public boolean checkForSnowReversion(aab world, int i2, int j2, int k, Random rand) {
        if (world.isSnowingAtPos(i2, j2 + 1, k) && rand.nextInt(2) == 0) {
            if (world.b(aam.b, i2, j2 + 1, k) < 10) {
                world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirt.cz);
                if (apa.aW.c(world, i2, j2 + 1, k)) {
                    world.setBlockWithNotify(i2, j2 + 1, k, apa.aW.cz);
                }
            }
            return true;
        }
        return false;
    }

    public void updateWeedGrowth(aab world, int i2, int j2, int k, Random rand) {
        if (world.a(i2, j2, k) == this.cz) {
            int iWeedsLevel = this.getWeedsGrowthLevel(world, i2, j2, k);
            int iTimeOfDay = (int)(world.x.g() % 24000L);
            if (world.c(i2, j2 + 1, k)) {
                if (iTimeOfDay > 14000 && iTimeOfDay < 22000 && rand.nextInt(20) == 0 && world.getBlockNaturalLightValueMaximum(i2, j2 + 1, k) >= 11) {
                    world.setBlockWithNotify(i2, j2 + 1, k, BTWBlocks.weeds.cz);
                    this.setWeedsGrowthLevel(world, i2, j2, k, 1);
                }
            } else if (this.canWeedsShareSpaceWithBlockAt(world, i2, j2 + 1, k)) {
                if (iTimeOfDay > 14000 && iTimeOfDay < 22000) {
                    if (iWeedsLevel == 0) {
                        if (rand.nextInt(20) == 0) {
                            this.setWeedsGrowthLevel(world, i2, j2, k, 1);
                        }
                    } else if (iWeedsLevel % 2 == 0) {
                        this.setWeedsGrowthLevel(world, i2, j2, k, iWeedsLevel + 1);
                    }
                } else if (world.getBlockNaturalLightValue(i2, j2 + 1, k) >= 11) {
                    if (iWeedsLevel == 7 && world.getDifficulty().canWeedsKillPlants()) {
                        this.setWeedsGrowthLevel(world, i2, j2, k, 0);
                        world.setBlockAndMetadataWithNotify(i2, j2 + 1, k, apa.ab.cz, 1);
                    } else if (iWeedsLevel % 2 == 1) {
                        this.setWeedsGrowthLevel(world, i2, j2, k, iWeedsLevel + 1);
                    }
                }
            } else if (iWeedsLevel > 0) {
                this.setWeedsGrowthLevel(world, i2, j2, k, 0);
            }
        }
    }
}

