/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.AttachedSlabBlock;
import btw.client.render.util.RenderUtils;
import btw.item.BTWItems;
import btw.world.util.WorldUtils;
import com.prupe.mcpatcher.cc.ColorizeBlock;
import com.prupe.mcpatcher.mal.block.RenderBlocksUtils;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;

public class DirtSlabBlock
extends AttachedSlabBlock {
    public static final int SUBTYPE_DIRT = 0;
    public static final int SUBTYPE_GRASS = 1;
    public static final int SUBTYPE_MYCELIUM = 2;
    public static final int SUBTYPE_PACKED_EARTH = 3;
    public static final int NUM_SUBTYPES = 4;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassSideOverlay;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassTopItem;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassSideHalf;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassSideOverlayHalf;
    @Environment(value=EnvType.CLIENT)
    private lx iconPackedEarth;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassWithSnowSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassWithSnowSideHalf;

    public DirtSlabBlock(int iBlockID) {
        super(iBlockID, aif.c);
        this.c(0.5f);
        this.setShovelsEffectiveOn(true);
        this.a(apa.i);
        this.c("fcBlockSlabDirt");
        this.b(true);
        this.a(ve.b);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        int iSubType = this.getSubtype(world, i2, j2, k);
        if (iSubType == 1) {
            world.c(i2, j2, k, BTWBlocks.grassSlab.cz);
            BTWBlocks.grassSlab.a(world, i2, j2, k, rand);
        }
    }

    @Override
    public int a(int iMetadata) {
        int iSubtype = this.getSubtype(iMetadata);
        if (iSubtype == 3) {
            return iSubtype;
        }
        return 0;
    }

    @Override
    public int a(int iMetadata, Random random, int iFortuneModifier) {
        int iSubtype = this.getSubtype(iMetadata);
        if (iSubtype == 3) {
            return super.a(iMetadata, random, iFortuneModifier);
        }
        return BTWBlocks.looseDirtSlab.cz;
    }

    @Override
    public float getMovementModifier(aab world, int i2, int j2, int k) {
        float fModifier = 1.0f;
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if (iSubtype == 3) {
            fModifier = 1.2f;
        }
        return fModifier;
    }

    @Override
    public ape getStepSound(aab world, int i2, int j2, int k) {
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if (iSubtype == 0 || iSubtype == 3) {
            return apa.h;
        }
        return this.cM;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfDrop) {
        int iNumDropped = 3;
        if (this.getSubtype(iMetadata) == 3) {
            iNumDropped = 6;
        }
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.dirtPile.cp, iNumDropped, 0, fChanceOfDrop);
        return true;
    }

    @Override
    public boolean getCanGrassSpreadToBlock(aab world, int i2, int j2, int k) {
        int iSubType = this.getSubtype(world, i2, j2, k);
        if (iSubType == 0) {
            apa blockAbove = apa.r[world.a(i2, j2 + 1, k)];
            boolean bIsUpsideDown = this.getIsUpsideDown(world, i2, j2, k);
            if (blockAbove == null || blockAbove.getCanGrassGrowUnderBlock(world, i2, j2 + 1, k, !bIsUpsideDown)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean spreadGrassToBlock(aab world, int x2, int y2, int z2) {
        boolean isUpsideDown = this.getIsUpsideDown(world, x2, y2, z2);
        world.setBlockWithNotify(x2, y2, z2, BTWBlocks.grassSlab.cz);
        BTWBlocks.grassSlab.setSparse(world, x2, y2, z2);
        BTWBlocks.grassSlab.setIsUpsideDown(world, x2, y2, z2, isUpsideDown);
        return true;
    }

    @Override
    public boolean getCanMyceliumSpreadToBlock(aab world, int i2, int j2, int k) {
        int iSubType = this.getSubtype(world, i2, j2, k);
        if (iSubType == 0) {
            return !this.getIsUpsideDown(world, i2, j2, k) || !WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(world, i2, j2 + 1, k, 0);
        }
        return false;
    }

    @Override
    public boolean spreadMyceliumToBlock(aab world, int x2, int y2, int z2) {
        boolean isUpsideDown = this.getIsUpsideDown(world, x2, y2, z2);
        world.setBlockWithNotify(x2, y2, z2, BTWBlocks.myceliumSlab.cz);
        BTWBlocks.myceliumSlab.setSparse(world, x2, y2, z2);
        BTWBlocks.myceliumSlab.setIsUpsideDown(world, x2, y2, z2, isUpsideDown);
        return true;
    }

    @Override
    public boolean attemptToCombineWithFallingEntity(aab world, int i2, int j2, int k, rg entity) {
        int iMetadata;
        if (entity.a == BTWBlocks.looseDirtSlab.cz && this.getSubtype(iMetadata = world.h(i2, j2, k)) != 3 && !this.getIsUpsideDown(iMetadata)) {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirt.cz);
            return true;
        }
        return super.attemptToCombineWithFallingEntity(world, i2, j2, k, entity);
    }

    @Override
    protected void onAnchorBlockLost(aab world, int i2, int j2, int k) {
        if (this.getSubtype(world.h(i2, j2, k)) != 3) {
            world.f(i2, j2, k, BTWBlocks.looseDirtSlab.cz, world.h(i2, j2, k) & 3, 2);
        } else {
            this.dropComponentItemsOnBadBreak(world, i2, j2, k, world.h(i2, j2, k), 1.0f);
            world.i(i2, j2, k);
        }
    }

    @Override
    public int getCombinedBlockID(int iMetadata) {
        int iSubtype = this.getSubtype(iMetadata);
        if (iSubtype == 3) {
            return BTWBlocks.aestheticEarth.cz;
        }
        return apa.z.cz;
    }

    @Override
    public int getCombinedMetadata(int iMetadata) {
        int iSubtype = this.getSubtype(iMetadata);
        if (iSubtype == 3) {
            return 6;
        }
        return 0;
    }

    @Override
    public boolean canBePistonShoveled(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    protected boolean r_() {
        return true;
    }

    @Override
    protected wm c_(int metadata) {
        int subtype = this.getSubtype(metadata);
        if (subtype == 1) {
            return new wm(BTWBlocks.grassSlab);
        }
        return new wm(this.cz, 1, subtype);
    }

    @Override
    public boolean canBeGrazedOn(aak blockAccess, int i2, int j2, int k, qh byAnimal) {
        return this.getSubtype(blockAccess, i2, j2, k) == 1;
    }

    @Override
    public void onGrazed(aab world, int i2, int j2, int k, qh animal) {
        if (!animal.getDisruptsEarthOnGraze()) {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.grassSlab.cz);
            BTWBlocks.grassSlab.setSparse(world, i2, j2, k);
        } else {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirtSlab.cz);
            this.notifyNeighborsBlockDisrupted(world, i2, j2, k);
        }
    }

    @Override
    public void onVegetationAboveGrazed(aab world, int i2, int j2, int k, qh animal) {
        if (animal.getDisruptsEarthOnGraze()) {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirtSlab.cz);
            this.notifyNeighborsBlockDisrupted(world, i2, j2, k);
        }
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        super.onBlockDestroyedWithImproperTool(world, player, i2, j2, k, iMetadata);
        if (this.getSubtype(iMetadata) != 3) {
            this.onDirtSlabDugWithImproperTool(world, i2, j2, k, this.getIsUpsideDown(iMetadata));
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        super.a(world, i2, j2, k, explosion);
        if (this.getSubtype(world, i2, j2, k) != 3) {
            this.onDirtSlabDugWithImproperTool(world, i2, j2, k, this.getIsUpsideDown(world, i2, j2, k));
        }
    }

    @Override
    protected void onNeighborDirtDugWithImproperTool(aab world, int i2, int j2, int k, int iToFacing) {
        boolean bIsUpsideDown;
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if (!(iSubtype == 3 || iSubtype == 1 && iToFacing != 0 || (bIsUpsideDown = this.getIsUpsideDown(world, i2, j2, k)) && iToFacing == 0 || !bIsUpsideDown && iToFacing == 1)) {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirtSlab.cz);
        }
    }

    public int getSubtype(aak blockAccess, int i2, int j2, int k) {
        return this.getSubtype(blockAccess.h(i2, j2, k));
    }

    public int getSubtype(int iMetadata) {
        return (iMetadata & 0xFFFFFFFE) >> 1;
    }

    public void setSubtype(aab world, int i2, int j2, int k, int iSubtype) {
        int iMetadata = world.h(i2, j2, k) & 1;
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata |= iSubtype << 1);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("dirt");
        this.iconGrassSide = register.a("grass_side");
        this.iconGrassSideOverlay = register.a("grass_side_overlay");
        this.iconGrassTop = register.a("grass_top");
        this.iconGrassTopItem = register.a("fcBlockSlabDirt_grass_top_item");
        this.iconGrassSideHalf = register.a("FCBlockSlabDirt_grass_side");
        this.iconGrassSideOverlayHalf = register.a("FCBlockSlabDirt_grass_side_overlay");
        this.iconPackedEarth = register.a("FCBlockPackedEarth");
        this.iconGrassWithSnowSide = register.a("snow_side");
        this.iconGrassWithSnowSideHalf = register.a("FCBlockSlabDirt_grass_snow_side");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 1 && this.getSubtype(iMetadata) == 1) {
            return this.iconGrassTopItem;
        }
        return this.getIconFromMetadata(iSide, iMetadata);
    }

    @Environment(value=EnvType.CLIENT)
    private lx getIconFromMetadata(int iSide, int iMetadata) {
        int iSubtype = this.getSubtype(iMetadata);
        if (iSubtype == 1 && iSide != 0) {
            if (iSide != 1) {
                boolean bIsUpsideDown;
                boolean bl = bIsUpsideDown = (iMetadata & 1) > 0;
                if (bIsUpsideDown) {
                    return this.iconGrassSide;
                }
                return this.iconGrassSideHalf;
            }
            return this.iconGrassTop;
        }
        if (iSubtype == 3) {
            return this.iconPackedEarth;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iMetadata = blockAccess.h(i2, j2, k);
        int iSubtype = this.getSubtype(iMetadata);
        if (iSubtype == 1 && iSide > 1 && this.isSnowCoveringTopSurface(blockAccess, i2, j2, k)) {
            lx betterGrassIcon = RenderBlocksUtils.getGrassTexture(apa.y, blockAccess, i2, j2, k, iSide, this.iconGrassTop);
            if (betterGrassIcon != null) {
                return betterGrassIcon;
            }
            if (this.getIsUpsideDown(iMetadata)) {
                return this.iconGrassWithSnowSide;
            }
            return this.iconGrassWithSnowSideHalf;
        }
        lx icon = RenderBlocksUtils.getGrassTexture(apa.y, blockAccess, i2, j2, k, iSide, this.iconGrassTop);
        if (icon != null && iSubtype == 1 && iSide >= 1) {
            return icon;
        }
        return this.getIconFromMetadata(iSide, iMetadata);
    }

    @Environment(value=EnvType.CLIENT)
    public lx getSideOverlayTexture(aak blockAccess, int i2, int j2, int k) {
        if (!this.getIsUpsideDown(blockAccess, i2, j2, k)) {
            return this.iconGrassSideOverlayHalf;
        }
        return this.iconGrassSideOverlay;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int iBlockID, ve creativeTabs, List list) {
        list.add(new wm(iBlockID, 1, 0));
        list.add(new wm(iBlockID, 1, 3));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        aak blockAccess = renderer.a;
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        int iSubtype = BTWBlocks.dirtSlab.getSubtype(blockAccess, i2, j2, k);
        if (iSubtype == 1 && !this.isSnowCoveringTopSurface(blockAccess, i2, j2, k)) {
            int iColorMultiplier = this.c(blockAccess, i2, j2, k);
            float fRed = (float)(iColorMultiplier >> 16 & 0xFF) / 255.0f;
            float fGreen = (float)(iColorMultiplier >> 8 & 0xFF) / 255.0f;
            float fBlue = (float)(iColorMultiplier & 0xFF) / 255.0f;
            if (Minecraft.u()) {
                return renderer.renderGrassBlockWithAmbientOcclusion(this, i2, j2, k, fRed, fGreen, fBlue, this.getSideOverlayTexture(blockAccess, i2, j2, k));
            }
            return renderer.renderGrassBlockWithColorMultiplier(this, i2, j2, k, fRed, fGreen, fBlue, this.getSideOverlayTexture(blockAccess, i2, j2, k));
        }
        return renderer.p(this, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, this, -0.5f, -0.5f, -0.5f, iItemDamage << 1);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int c(aak blockAccess, int i2, int j2, int k) {
        int iSubtype = this.getSubtype(blockAccess, i2, j2, k);
        if (iSubtype == 1 && !this.isSnowCoveringTopSurface(blockAccess, i2, j2, k)) {
            if (ColorizeBlock.colorizeBlock(this, blockAccess, i2, j2, k)) {
                return ColorizeBlock.blockColor;
            }
            int iRed = 0;
            int iGreen = 0;
            int iBlue = 0;
            for (int iKOffset = -1; iKOffset <= 1; ++iKOffset) {
                for (int iIOffset = -1; iIOffset <= 1; ++iIOffset) {
                    int iBiomeGrassColor = blockAccess.a(i2 + iIOffset, k + iKOffset).k();
                    iRed += (iBiomeGrassColor & 0xFF0000) >> 16;
                    iGreen += (iBiomeGrassColor & 0xFF00) >> 8;
                    iBlue += iBiomeGrassColor & 0xFF;
                }
            }
            return (iRed / 9 & 0xFF) << 16 | (iGreen / 9 & 0xFF) << 8 | iBlue / 9 & 0xFF;
        }
        return super.c(blockAccess, i2, j2, k);
    }
}

