/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.FullBlock;
import btw.block.blocks.GrassBlock;
import btw.block.blocks.MyceliumBlock;
import btw.item.BTWItems;
import btw.item.items.HoeItem;
import btw.world.util.WorldUtils;
import java.util.Random;

public class DirtBlock
extends FullBlock {
    public DirtBlock(int iBlockID) {
        super(iBlockID, aif.c);
        this.c(0.5f);
        this.setShovelsEffectiveOn();
        this.setHoesEffectiveOn();
        this.a(apa.h);
        this.c("dirt");
        this.a(ve.b);
    }

    @Override
    public int a(int iMetadata, Random rand, int iFortuneModifier) {
        return BTWBlocks.looseDirt.cz;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.dirtPile.cp, 6, 0, fChanceOfDrop);
        return true;
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        super.onBlockDestroyedWithImproperTool(world, player, i2, j2, k, iMetadata);
        this.onDirtDugWithImproperTool(world, i2, j2, k);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        super.a(world, i2, j2, k, explosion);
        this.onDirtDugWithImproperTool(world, i2, j2, k);
    }

    @Override
    protected void onNeighborDirtDugWithImproperTool(aab world, int i2, int j2, int k, int iToFacing) {
        world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirt.cz);
    }

    @Override
    public boolean getCanGrassSpreadToBlock(aab world, int i2, int j2, int k) {
        apa blockAbove = apa.r[world.a(i2, j2 + 1, k)];
        return blockAbove == null || blockAbove.getCanGrassGrowUnderBlock(world, i2, j2 + 1, k, false);
    }

    @Override
    public boolean spreadGrassToBlock(aab world, int x2, int y2, int z2) {
        world.setBlockWithNotify(x2, y2, z2, apa.y.cz);
        ((GrassBlock)apa.y).setSparse(world, x2, y2, z2);
        return true;
    }

    @Override
    public boolean getCanMyceliumSpreadToBlock(aab world, int i2, int j2, int k) {
        return !WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(world, i2, j2 + 1, k, 0);
    }

    @Override
    public boolean spreadMyceliumToBlock(aab world, int x2, int y2, int z2) {
        world.setBlockWithNotify(x2, y2, z2, apa.bC.cz);
        ((MyceliumBlock)apa.bC).setSparse(world, x2, y2, z2);
        return true;
    }

    @Override
    public boolean canBePistonShoveled(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public void onVegetationAboveGrazed(aab world, int i2, int j2, int k, qh animal) {
        if (animal.getDisruptsEarthOnGraze()) {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirt.cz);
            this.notifyNeighborsBlockDisrupted(world, i2, j2, k);
        }
    }

    @Override
    public boolean canReedsGrowOnBlock(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean canSaplingsGrowOnBlock(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean canWildVegetationGrowOnBlock(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean getCanBlightSpreadToBlock(aab world, int i2, int j2, int k, int iBlightLevel) {
        return true;
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        return stack != null && stack.b() instanceof HoeItem;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int i2, int j2, int k, int iFromSide) {
        world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirt.cz);
        if (!world.I) {
            world.e(2001, i2, j2, k, this.cz);
        }
        return true;
    }
}

