/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.BTWMod;
import btw.block.BTWBlocks;
import btw.block.blocks.DetectorBlock;
import btw.block.blocks.LensBlock;
import btw.entity.mechanical.platform.BlockLiftedByPlatformEntity;
import btw.world.util.BlockPos;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.server.MinecraftServer;

public class DetectorLogicBlock
extends apa {
    private static final int DETECTOR_LOGIC_TICK_RATE = 5;
    public static final boolean LOGIC_DEBUG_DISPLAY = false;

    public DetectorLogicBlock(int iBlockID) {
        super(iBlockID, aif.a);
        this.b(true);
    }

    @Override
    public int a(aab world) {
        return 5;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public int h() {
        return 1;
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID, int iMetadata) {
        if (!(BTWMod.isLensBeamBeingRemoved || this.isDetectorLogicFlagOn(world, i2, j2, k) && !this.isIntersectionPointFlagOn(world, i2, j2, k))) {
            for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
                int iBeamRangeRemaining;
                int iRangeToSource = this.getRangeToValidLensSourceToFacing(world, i2, j2, k, iTempFacing);
                if (iRangeToSource <= 0 || (iBeamRangeRemaining = 128 - iRangeToSource) <= 0) continue;
                this.removeLensBeamFromBlock(world, i2, j2, k, apa.getOppositeFacing(iTempFacing), iBeamRangeRemaining);
            }
        }
    }

    @Override
    public int a(int i2, Random random, int iFortuneModifier) {
        return 0;
    }

    @Override
    public boolean a(int i2, boolean flag) {
        return false;
    }

    @Override
    public int a(Random random) {
        return 0;
    }

    @Override
    public aqx b(aab world, int i2, int j2, int k) {
        return null;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        if (this.isDetectorLogicFlagOn(world, i2, j2, k)) {
            if (!this.checkForNeighboringDetector(world, i2, j2, k)) {
                if (this.isIntersectionPointFlagOn(world, i2, j2, k)) {
                    this.setIsDetectorLogicFlag(world, i2, j2, k, false);
                    if (!this.hasMultipleValidLensSources(world, i2, j2, k)) {
                        this.setIsIntersectionPointFlag(world, i2, j2, k, false);
                    }
                } else {
                    this.removeSelf(world, i2, j2, k);
                }
            } else {
                this.notifyNeighboringDetectorBlocksOfChange(world, i2, j2, k);
            }
        }
        if (!(this.isDetectorLogicFlagOn(world, i2, j2, k) && !this.isIntersectionPointFlagOn(world, i2, j2, k) || world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz))) {
            world.a(i2, j2, k, world.a(i2, j2, k), this.a(world));
        }
        if (this.isLitFlagOn(world, i2, j2, k) && this.isBlockGlowing(world, i2, j2, k)) {
            world.g(i2, j2, k, i2, j2, k);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, mp entity) {
        boolean bIsOn;
        if (!world.I && this.isEntityWithinBounds(world, i2, j2, k) && !(bIsOn = this.isEntityCollidingFlagOn(world, i2, j2, k))) {
            this.changeStateToRegisterEntityCollision(world, i2, j2, k);
            world.a(i2, j2, k, world.a(i2, j2, k), this.a(world));
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        boolean bIsOn = this.isEntityCollidingFlagOn(world, i2, j2, k);
        boolean bShouldBeOn = this.isEntityWithinBounds(world, i2, j2, k);
        if (bShouldBeOn) {
            if (!bIsOn) {
                this.changeStateToRegisterEntityCollision(world, i2, j2, k);
            }
            world.a(i2, j2, k, world.a(i2, j2, k), this.a(world));
        } else if (bIsOn) {
            this.changeStateToClearEntityCollision(world, i2, j2, k);
        }
        this.fullyValidateBlock(world, i2, j2, k);
    }

    @Override
    public boolean isAirBlock() {
        return true;
    }

    @Override
    public boolean triggersBuddy() {
        return false;
    }

    protected void removeSelf(aab world, int i2, int j2, int k) {
        world.f(i2, j2, k, 0, 0, 0);
    }

    public boolean isEntityCollidingFlagOn(aak iBlockAccess, int i2, int j2, int k) {
        int iMetaData = iBlockAccess.h(i2, j2, k);
        return (iMetaData & 1) > 0;
    }

    public void setEntityCollidingFlag(aab world, int i2, int j2, int k, boolean bEntityColliding) {
        int iMetaData = world.h(i2, j2, k) & 0xFFFFFFFE;
        if (bEntityColliding) {
            iMetaData |= 1;
        }
        world.setBlockMetadataWithNotifyNoClient(i2, j2, k, iMetaData);
    }

    public boolean isDetectorLogicFlagOn(aak iBlockAccess, int i2, int j2, int k) {
        int iMetaData = iBlockAccess.h(i2, j2, k);
        return (iMetaData & 2) > 0;
    }

    public void setIsDetectorLogicFlag(aab world, int i2, int j2, int k, boolean bIsDetectorLogic) {
        int iMetaData = world.h(i2, j2, k) & 0xFFFFFFFD;
        if (bIsDetectorLogic) {
            iMetaData |= 2;
        }
        world.setBlockMetadata(i2, j2, k, iMetaData);
    }

    public boolean isIntersectionPointFlagOn(aak iBlockAccess, int i2, int j2, int k) {
        int iMetaData = iBlockAccess.h(i2, j2, k);
        return (iMetaData & 4) > 0;
    }

    public void setIsIntersectionPointFlag(aab world, int i2, int j2, int k, boolean bIsIntersectionPoint) {
        int iMetaData = world.h(i2, j2, k) & 0xFFFFFFFB;
        if (bIsIntersectionPoint) {
            iMetaData |= 4;
        }
        world.setBlockMetadata(i2, j2, k, iMetaData);
    }

    public boolean isLitFlagOn(aak iBlockAccess, int i2, int j2, int k) {
        int iMetaData = iBlockAccess.h(i2, j2, k);
        return (iMetaData & 8) > 0;
    }

    public void setIsLitFlag(aab world, int i2, int j2, int k, boolean bIsLitByLens) {
        int iMetaData = world.h(i2, j2, k) & 0xFFFFFFF7;
        if (bIsLitByLens) {
            iMetaData |= 8;
        }
        world.setBlockMetadata(i2, j2, k, iMetaData);
    }

    public boolean isBlockGlowing(aab world, int i2, int j2, int k) {
        int iBlockID = world.a(i2, j2, k);
        return iBlockID == BTWBlocks.glowingDetectorLogic.cz;
    }

    public void setBlockAsGlowing(aab world, int i2, int j2, int k) {
        int iMetaData = world.h(i2, j2, k);
        BTWMod.isLensBeamBeingRemoved = true;
        world.setBlockAndMetadataWithNotify(i2, j2, k, BTWBlocks.glowingDetectorLogic.cz, iMetaData);
        BTWMod.isLensBeamBeingRemoved = false;
        if (this.isEntityCollidingFlagOn(world, i2, j2, k)) {
            world.a(i2, j2, k, world.a(i2, j2, k), this.a(world));
        }
    }

    public void setBlockAsNotGlowing(aab world, int i2, int j2, int k) {
        int iMetaData = world.h(i2, j2, k);
        BTWMod.isLensBeamBeingRemoved = true;
        world.setBlockAndMetadataWithNotify(i2, j2, k, BTWBlocks.detectorLogic.cz, iMetaData);
        BTWMod.isLensBeamBeingRemoved = false;
        if (this.isEntityCollidingFlagOn(world, i2, j2, k)) {
            world.a(i2, j2, k, world.a(i2, j2, k), this.a(world));
        }
    }

    private boolean isEntityWithinBounds(aab world, int i2, int j2, int k) {
        List list = world.a(mp.class, aqx.a().a(i2, j2, k, i2 + 1, j2 + 1, k + 1));
        if (list != null && list.size() > 0) {
            for (int listIndex = 0; listIndex < list.size(); ++listIndex) {
                mp targetEntity = (mp)list.get(listIndex);
                if (targetEntity instanceof bet && !MinecraftServer.getIsServer() || targetEntity instanceof BlockLiftedByPlatformEntity) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkForNeighboringDetector(aab world, int i2, int j2, int k) {
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            BlockPos tempPos = new BlockPos(i2, j2, k);
            tempPos.addFacingAsOffset(iTempFacing);
            if (world.a(tempPos.x, tempPos.y, tempPos.z) != BTWBlocks.detectorBlock.cz || ((DetectorBlock)BTWBlocks.detectorBlock).getFacing(world, tempPos.x, tempPos.y, tempPos.z) != apa.getOppositeFacing(iTempFacing)) continue;
            return true;
        }
        return false;
    }

    public void notifyNeighboringDetectorBlocksOfChange(aab world, int i2, int j2, int k) {
        for (int iFacing = 0; iFacing <= 5; ++iFacing) {
            BlockPos targetPos = new BlockPos(i2, j2, k);
            targetPos.addFacingAsOffset(iFacing);
            int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
            if (iTargetBlockID != BTWBlocks.detectorBlock.cz) continue;
            apa.r[iTargetBlockID].a(world, targetPos.x, targetPos.y, targetPos.z, world.a(i2, j2, k));
        }
    }

    public boolean hasValidLensSource(aab world, int i2, int j2, int k) {
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            if (!this.hasValidLensSourceToFacing(world, i2, j2, k, iTempFacing)) continue;
            return true;
        }
        return false;
    }

    public boolean hasValidLensSourceIgnoreFacing(aab world, int i2, int j2, int k, int iIgnoreFacing) {
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            if (iTempFacing == iIgnoreFacing || !this.hasValidLensSourceToFacing(world, i2, j2, k, iTempFacing)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMultipleValidLensSources(aab world, int i2, int j2, int k) {
        int iLensCount = 0;
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            if (!this.hasValidLensSourceToFacing(world, i2, j2, k, iTempFacing) || ++iLensCount <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean hasMultipleValidLensSourcesIgnoreFacing(aab world, int i2, int j2, int k, int iIgnoreFacing) {
        int iLensCount = 0;
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            if (iTempFacing == iIgnoreFacing || !this.hasValidLensSourceToFacing(world, i2, j2, k, iTempFacing) || ++iLensCount <= 1) continue;
            return true;
        }
        return false;
    }

    public int countValidLensSources(aab world, int i2, int j2, int k) {
        int iLensCount = 0;
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            if (!this.hasValidLensSourceToFacing(world, i2, j2, k, iTempFacing)) continue;
            ++iLensCount;
        }
        return iLensCount;
    }

    public int countValidLensSourcesIgnoreFacing(aab world, int i2, int j2, int k, int iIgnoreFacing) {
        int iLensCount = 0;
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            if (iTempFacing == iIgnoreFacing || !this.hasValidLensSourceToFacing(world, i2, j2, k, iTempFacing)) continue;
            ++iLensCount;
        }
        return iLensCount;
    }

    public boolean hasValidLensSourceToFacing(aab world, int i2, int j2, int k, int iFacing) {
        return this.getRangeToValidLensSourceToFacing(world, i2, j2, k, iFacing) > 0;
    }

    public int getRangeToValidLensSourceToFacing(aab world, int i2, int j2, int k, int iFacing) {
        BlockPos tempPos = new BlockPos(i2, j2, k);
        for (int iDistance = 1; iDistance <= 128; ++iDistance) {
            tempPos.addFacingAsOffset(iFacing);
            int iTempBlockID = world.a(tempPos.x, tempPos.y, tempPos.z);
            if (iTempBlockID == BTWBlocks.lens.cz) {
                LensBlock lensBlock = (LensBlock)BTWBlocks.lens;
                if (lensBlock.getFacing(world, tempPos.x, tempPos.y, tempPos.z) == apa.getOppositeFacing(iFacing)) {
                    return iDistance;
                }
                return 0;
            }
            if (DetectorLogicBlock.isLogicBlock(iTempBlockID)) continue;
            return 0;
        }
        return 0;
    }

    public boolean verifyLitByLens(aab world, int i2, int j2, int k) {
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            if (!this.hasValidLitLensSourceToFacing(world, i2, j2, k, iTempFacing)) continue;
            return true;
        }
        return false;
    }

    public boolean verifyLitByLensIgnoreFacing(aab world, int i2, int j2, int k, int iIgnoreFacing) {
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            if (iTempFacing == iIgnoreFacing || !this.hasValidLitLensSourceToFacing(world, i2, j2, k, iTempFacing)) continue;
            return true;
        }
        return false;
    }

    public boolean hasValidLitLensSourceToFacing(aak blockAccess, int i2, int j2, int k, int iFacing) {
        return this.getRangeToValidLitLensSourceToFacing(blockAccess, i2, j2, k, iFacing) > 0;
    }

    public int getRangeToValidLitLensSourceToFacing(aak blockAccess, int i2, int j2, int k, int iFacing) {
        BlockPos tempPos = new BlockPos(i2, j2, k);
        for (int iDistance = 1; iDistance <= 128; ++iDistance) {
            tempPos.addFacingAsOffset(iFacing);
            int iTempBlockID = blockAccess.a(tempPos.x, tempPos.y, tempPos.z);
            if (iTempBlockID == BTWBlocks.lens.cz) {
                LensBlock lensBlock = (LensBlock)BTWBlocks.lens;
                if (lensBlock.getFacing(blockAccess, tempPos.x, tempPos.y, tempPos.z) == apa.getOppositeFacing(iFacing) && lensBlock.isLit(blockAccess, tempPos.x, tempPos.y, tempPos.z)) {
                    return iDistance;
                }
                return 0;
            }
            if (DetectorLogicBlock.isLogicBlock(iTempBlockID)) {
                if (this.isLitFlagOn(blockAccess, tempPos.x, tempPos.y, tempPos.z) && !this.isEntityCollidingFlagOn(blockAccess, tempPos.x, tempPos.y, tempPos.z)) continue;
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public void createLensBeamFromBlock(aab world, int i2, int j2, int k, int iFacing, int iMaxRange) {
        BlockPos tempPos = new BlockPos(i2, j2, k);
        for (int iDistance = 1; iDistance <= iMaxRange; ++iDistance) {
            tempPos.addFacingAsOffset(iFacing);
            int iTempBlockID = world.a(tempPos.x, tempPos.y, tempPos.z);
            if (iTempBlockID == 0) {
                if (world.f(tempPos.x, tempPos.y, tempPos.z, BTWBlocks.detectorLogic.cz, 0, 0)) continue;
                break;
            }
            if (!DetectorLogicBlock.isLogicBlock(iTempBlockID)) break;
            this.setIsIntersectionPointFlag(world, tempPos.x, tempPos.y, tempPos.z, true);
        }
    }

    public void removeLensBeamFromBlock(aab world, int i2, int j2, int k, int iFacing, int iMaxRange) {
        BTWMod.isLensBeamBeingRemoved = true;
        BlockPos tempPos = new BlockPos(i2, j2, k);
        int iOppositeFacing = apa.getOppositeFacing(iFacing);
        for (int iDistance = 1; iDistance <= 128; ++iDistance) {
            tempPos.addFacingAsOffset(iFacing);
            if (!DetectorLogicBlock.isLogicBlock(world, tempPos.x, tempPos.y, tempPos.z)) break;
            if (this.isIntersectionPointFlagOn(world, tempPos.x, tempPos.y, tempPos.z)) {
                if (this.isDetectorLogicFlagOn(world, tempPos.x, tempPos.y, tempPos.z)) {
                    if (!this.hasValidLensSourceIgnoreFacing(world, tempPos.x, tempPos.y, tempPos.z, iOppositeFacing)) {
                        this.setIsIntersectionPointFlag(world, tempPos.x, tempPos.y, tempPos.z, false);
                    }
                } else if (!this.hasMultipleValidLensSourcesIgnoreFacing(world, tempPos.x, tempPos.y, tempPos.z, iOppositeFacing)) {
                    this.setIsIntersectionPointFlag(world, tempPos.x, tempPos.y, tempPos.z, false);
                }
                if (!this.isLitFlagOn(world, tempPos.x, tempPos.y, tempPos.z)) continue;
                if (!this.verifyLitByLensIgnoreFacing(world, tempPos.x, tempPos.y, tempPos.z, iOppositeFacing)) {
                    this.unlightBlock(world, tempPos.x, tempPos.y, tempPos.z);
                    continue;
                }
                if (!this.isBlockGlowing(world, tempPos.x, tempPos.y, tempPos.z) || this.shouldBeGlowing(world, tempPos.x, tempPos.y, tempPos.z)) continue;
                this.setBlockAsNotGlowing(world, tempPos.x, tempPos.y, tempPos.z);
                continue;
            }
            if (!this.isBlockGlowing(world, tempPos.x, tempPos.y, tempPos.z) ? !world.f(tempPos.x, tempPos.y, tempPos.z, 0, 0, 0) : !world.setBlockWithNotify(tempPos.x, tempPos.y, tempPos.z, 0)) break;
        }
        BTWMod.isLensBeamBeingRemoved = false;
    }

    public void lightBlock(aab world, int i2, int j2, int k) {
        this.setIsLitFlag(world, i2, j2, k, true);
        if (this.isDetectorLogicFlagOn(world, i2, j2, k)) {
            this.notifyNeighboringDetectorBlocksOfChange(world, i2, j2, k);
        }
    }

    public void unlightBlock(aab world, int i2, int j2, int k) {
        this.setIsLitFlag(world, i2, j2, k, false);
        if (this.isBlockGlowing(world, i2, j2, k)) {
            this.setBlockAsNotGlowing(world, i2, j2, k);
        }
        if (this.isDetectorLogicFlagOn(world, i2, j2, k)) {
            this.notifyNeighboringDetectorBlocksOfChange(world, i2, j2, k);
        }
    }

    public void changeStateToRegisterEntityCollision(aab world, int i2, int j2, int k) {
        this.setEntityCollidingFlag(world, i2, j2, k, true);
        if (this.isLitFlagOn(world, i2, j2, k)) {
            if (!this.isBlockGlowing(world, i2, j2, k)) {
                this.setBlockAsGlowing(world, i2, j2, k);
            } else {
                world.g(i2, j2, k, i2, j2, k);
            }
            for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
                int iBeamRangeRemaining;
                int iRangeToSource = this.getRangeToValidLitLensSourceToFacing(world, i2, j2, k, iTempFacing);
                if (iRangeToSource <= 0 || (iBeamRangeRemaining = 128 - iRangeToSource) <= 0) continue;
                this.turnBeamOffFromBlock(world, i2, j2, k, apa.getOppositeFacing(iTempFacing), iBeamRangeRemaining);
            }
        }
    }

    public void changeStateToClearEntityCollision(aab world, int i2, int j2, int k) {
        this.setEntityCollidingFlag(world, i2, j2, k, false);
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            int iBeamRangeRemaining;
            int iRangeToSource = this.getRangeToValidLitLensSourceToFacing(world, i2, j2, k, iTempFacing);
            if (iRangeToSource <= 0 || (iBeamRangeRemaining = 128 - iRangeToSource) <= 0) continue;
            this.turnBeamOnFromBlock(world, i2, j2, k, apa.getOppositeFacing(iTempFacing), iBeamRangeRemaining);
        }
        if (this.isLitFlagOn(world, i2, j2, k) && this.isBlockGlowing(world, i2, j2, k)) {
            if (!this.shouldBeGlowing(world, i2, j2, k)) {
                this.setBlockAsNotGlowing(world, i2, j2, k);
            } else {
                world.g(i2, j2, k, i2, j2, k);
            }
        }
    }

    public void turnBeamOnFromBlock(aab world, int i2, int j2, int k, int iFacing, int iMaxRange) {
        BlockPos tempPos = new BlockPos(i2, j2, k);
        for (int iDistance = 1; iDistance <= iMaxRange; ++iDistance) {
            tempPos.addFacingAsOffset(iFacing);
            int iTempBlockID = world.a(tempPos.x, tempPos.y, tempPos.z);
            if (DetectorLogicBlock.isLogicBlock(iTempBlockID)) {
                this.lightBlock(world, tempPos.x, tempPos.y, tempPos.z);
                if (!this.isEntityCollidingFlagOn(world, tempPos.x, tempPos.y, tempPos.z)) continue;
                if (!DetectorLogicBlock.isLogicBlock(world, tempPos.x, tempPos.y, tempPos.z) || this.isBlockGlowing(world, tempPos.x, tempPos.y, tempPos.z)) break;
                this.setBlockAsGlowing(world, tempPos.x, tempPos.y, tempPos.z);
                break;
            }
            if (world.c(tempPos.x, tempPos.y, tempPos.z)) break;
            BlockPos previousPos = new BlockPos(tempPos.x, tempPos.y, tempPos.z);
            previousPos.addFacingAsOffset(apa.getOppositeFacing(iFacing));
            if (!DetectorLogicBlock.isLogicBlock(world, previousPos.x, previousPos.y, previousPos.z) || this.isBlockGlowing(world, previousPos.x, previousPos.y, previousPos.z)) break;
            this.setBlockAsGlowing(world, previousPos.x, previousPos.y, previousPos.z);
            break;
        }
    }

    public void turnBeamOffFromBlock(aab world, int i2, int j2, int k, int iFacing, int iMaxRange) {
        BlockPos tempPos = new BlockPos(i2, j2, k);
        int iOppositeFacing = apa.getOppositeFacing(iFacing);
        for (int iDistance = 1; iDistance <= iMaxRange; ++iDistance) {
            tempPos.addFacingAsOffset(iFacing);
            int iTempBlockID = world.a(tempPos.x, tempPos.y, tempPos.z);
            if (!DetectorLogicBlock.isLogicBlock(iTempBlockID)) break;
            if (this.isIntersectionPointFlagOn(world, tempPos.x, tempPos.y, tempPos.z)) {
                if (!this.verifyLitByLensIgnoreFacing(world, tempPos.x, tempPos.y, tempPos.z, iOppositeFacing)) {
                    this.unlightBlock(world, tempPos.x, tempPos.y, tempPos.z);
                } else if (this.isBlockGlowing(world, tempPos.x, tempPos.y, tempPos.z) && !this.shouldBeGlowing(world, tempPos.x, tempPos.y, tempPos.z)) {
                    this.setBlockAsNotGlowing(world, tempPos.x, tempPos.y, tempPos.z);
                }
            } else {
                this.unlightBlock(world, tempPos.x, tempPos.y, tempPos.z);
            }
            if (this.isEntityCollidingFlagOn(world, tempPos.x, tempPos.y, tempPos.z)) break;
        }
    }

    protected boolean shouldBeProjectingToFacing(aak blockAccess, int i2, int j2, int k, int iFacing) {
        if (this.isEntityCollidingFlagOn(blockAccess, i2, j2, k)) {
            return false;
        }
        BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
        return blockAccess.u(targetPos.x, targetPos.y, targetPos.z) && this.hasValidLitLensSourceToFacing(blockAccess, i2, j2, k, apa.getOppositeFacing(iFacing));
    }

    protected boolean shouldBeGlowingToFacing(aab world, int i2, int j2, int k, int iFacing) {
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iFacing);
        return !world.c(targetPos.x, targetPos.y, targetPos.z) && this.hasValidLitLensSourceToFacing(world, i2, j2, k, apa.getOppositeFacing(iFacing));
    }

    private boolean shouldBeGlowing(aab world, int i2, int j2, int k) {
        if (this.isEntityCollidingFlagOn(world, i2, j2, k)) {
            return true;
        }
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            if (!this.shouldBeGlowingToFacing(world, i2, j2, k, iTempFacing)) continue;
            return true;
        }
        return false;
    }

    static boolean isLogicBlock(aak blockAccess, int i2, int j2, int k) {
        int iBlockID = blockAccess.a(i2, j2, k);
        return DetectorLogicBlock.isLogicBlock(iBlockID);
    }

    static boolean isLogicBlock(int iBlockID) {
        return iBlockID == BTWBlocks.detectorLogic.cz || iBlockID == BTWBlocks.glowingDetectorLogic.cz;
    }

    void propagateBeamsThroughBlock(aab world, int i2, int j2, int k) {
        boolean bIsLit = false;
        int iSourceCount = 0;
        if (!world.f(i2, j2, k, BTWBlocks.detectorLogic.cz, 0, 0)) {
            return;
        }
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            int iRangeToSource = this.getRangeToValidLensSourceToFacing(world, i2, j2, k, iTempFacing);
            if (iRangeToSource <= 0) continue;
            ++iSourceCount;
            int iRangeRemaining = 128 - iRangeToSource;
            if (iRangeRemaining > 0) {
                int iOppositeFacing = apa.getOppositeFacing(iTempFacing);
                this.createLensBeamFromBlock(world, i2, j2, k, iOppositeFacing, iRangeRemaining);
                if (!this.hasValidLitLensSourceToFacing(world, i2, j2, k, iTempFacing)) continue;
                this.turnBeamOnFromBlock(world, i2, j2, k, iOppositeFacing, iRangeRemaining);
                bIsLit = true;
                continue;
            }
            if (!this.hasValidLitLensSourceToFacing(world, i2, j2, k, iTempFacing)) continue;
            bIsLit = true;
        }
        if (bIsLit) {
            this.lightBlock(world, i2, j2, k);
            if (this.shouldBeGlowing(world, i2, j2, k)) {
                this.setBlockAsGlowing(world, i2, j2, k);
            }
        }
        if (iSourceCount > 1) {
            this.setIsIntersectionPointFlag(world, i2, j2, k, true);
        }
    }

    public void fullyValidateBlock(aab world, int i2, int j2, int k) {
        boolean bShouldGlow;
        boolean bHasDetector = this.checkForNeighboringDetector(world, i2, j2, k);
        if (bHasDetector != this.isDetectorLogicFlagOn(world, i2, j2, k)) {
            this.setIsDetectorLogicFlag(world, i2, j2, k, bHasDetector);
        }
        boolean bShouldBeLit = false;
        int iNumLensSources = 0;
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            int iRangeRemaining;
            int iRangeToSource = this.getRangeToValidLensSourceToFacing(world, i2, j2, k, iTempFacing);
            if (iRangeToSource <= 0) continue;
            ++iNumLensSources;
            if (!bShouldBeLit && this.hasValidLitLensSourceToFacing(world, i2, j2, k, iTempFacing)) {
                bShouldBeLit = true;
            }
            if ((iRangeRemaining = 128 - iRangeToSource) <= 0) continue;
            BlockPos targetPos = new BlockPos(i2, j2, k);
            targetPos.addFacingAsOffset(apa.getOppositeFacing(iTempFacing));
            if (world.a(targetPos.x, targetPos.y, targetPos.z) != 0) continue;
            this.propagateBeamsThroughBlock(world, targetPos.x, targetPos.y, targetPos.z);
        }
        if (iNumLensSources == 0 && !this.isDetectorLogicFlagOn(world, i2, j2, k)) {
            BTWMod.isLensBeamBeingRemoved = true;
            this.removeSelf(world, i2, j2, k);
            BTWMod.isLensBeamBeingRemoved = false;
        } else {
            boolean bShouldBeIntersectionPoint = false;
            if (iNumLensSources > 1 || iNumLensSources == 1 && this.isDetectorLogicFlagOn(world, i2, j2, k)) {
                bShouldBeIntersectionPoint = true;
            }
            if (bShouldBeIntersectionPoint != this.isIntersectionPointFlagOn(world, i2, j2, k)) {
                this.setIsIntersectionPointFlag(world, i2, j2, k, bShouldBeIntersectionPoint);
            }
            if (bShouldBeLit != this.isLitFlagOn(world, i2, j2, k)) {
                if (bShouldBeLit) {
                    this.lightBlock(world, i2, j2, k);
                } else {
                    this.unlightBlock(world, i2, j2, k);
                }
            }
        }
        if (this.isLitFlagOn(world, i2, j2, k) && (bShouldGlow = this.shouldBeGlowing(world, i2, j2, k)) != this.isBlockGlowing(world, i2, j2, k)) {
            if (bShouldGlow) {
                this.setBlockAsGlowing(world, i2, j2, k);
            } else {
                this.setBlockAsNotGlowing(world, i2, j2, k);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("fcBlockLens_spotlight");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderDetectorLogicDebug(bgf renderBlocks, aak blockAccess, int i2, int j2, int k, apa block) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderDetectorLogicDebugInvBlock(bgf renderBlocks, apa block, int iItemDamage, int iRenderType) {
    }
}

