/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.DetectorLogicBlock;
import btw.block.blocks.LensBlock;
import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class DetectorBlock
extends apa {
    private static final int DETECTOR_TICK_RATE = 4;
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBySideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private lx iconFront;
    @Environment(value=EnvType.CLIENT)
    private lx iconFrontOn;

    public DetectorBlock(int iBlockID) {
        super(iBlockID, aif.e);
        this.c(3.5f);
        this.a(apa.j);
        this.c("fcBlockDetectorBlock");
        this.b(true);
        this.a(ve.d);
    }

    @Override
    public int a(aab world) {
        return 4;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        return this.setFacing(iMetadata, apa.getOppositeFacing(iFacing));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, ng entityLiving, wm stack) {
        int iFacing = MiscUtils.convertPlacingEntityOrientationToBlockFacingReversed(entityLiving);
        this.setFacing(world, i2, j2, k, iFacing);
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        this.setBlockOn(world, i2, j2, k, false);
        world.a(i2, j2, k, this.cz, this.a(world));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int l2) {
        if (!world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        boolean bPlacedLogic = this.placeDetectorLogicIfNecessary(world, i2, j2, k);
        boolean bDetected = this.checkForDetection(world, i2, j2, k);
        int iFacingDirection = this.getFacing(world, i2, j2, k);
        if (iFacingDirection == 1) {
            if (!bDetected && world.isPrecipitatingAtPos(i2, j2 + 1, k)) {
                bDetected = true;
            }
            world.a(i2, j2, k, this.cz, this.a(world));
        }
        if (bDetected) {
            if (!this.isBlockOn(world, i2, j2, k)) {
                this.setBlockOn(world, i2, j2, k, true);
            }
        } else if (this.isBlockOn(world, i2, j2, k)) {
            if (!bPlacedLogic) {
                this.setBlockOn(world, i2, j2, k, false);
            } else {
                world.a(i2, j2, k, this.cz, this.a(world));
            }
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (!world.isUpdateScheduledForBlock(i2, j2, k, this.cz)) {
            int iFacing = this.getFacing(world, i2, j2, k);
            if (iFacing == 1) {
                world.a(i2, j2, k, this.cz, this.a(world));
            } else if (this.checkForDetection(world, i2, j2, k) != this.isBlockOn(world, i2, j2, k)) {
                world.a(i2, j2, k, this.cz, this.a(world));
            }
        }
    }

    @Override
    public int b(aak iblockaccess, int i2, int j2, int k, int l2) {
        if (this.isBlockOn(iblockaccess, i2, j2, k)) {
            return 15;
        }
        return 0;
    }

    @Override
    public int c(aak blockAccess, int i2, int j2, int k, int iFacing) {
        return 0;
    }

    @Override
    public boolean f() {
        return true;
    }

    @Override
    public void onArrowCollide(aab world, int i2, int j2, int k, ss arrow) {
        if (!world.I) {
            int iFacingDirection = this.getFacing(world, i2, j2, k);
            BlockPos logicBlockPos = new BlockPos(i2, j2, k);
            logicBlockPos.addFacingAsOffset(iFacingDirection);
            if (world.a(logicBlockPos.x, logicBlockPos.y, logicBlockPos.z) == BTWBlocks.detectorLogic.cz) {
                BTWBlocks.detectorLogic.a(world, logicBlockPos.x, logicBlockPos.y, logicBlockPos.z, arrow);
            }
        }
    }

    @Override
    public int getFacing(int iMetadata) {
        return (iMetadata & 0xFFFFFFFE) >> 1;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata = iMetadata & 1 | iFacing << 1;
        return iMetadata;
    }

    @Override
    public boolean rotateAroundJAxis(aab world, int i2, int j2, int k, boolean bReverse) {
        if (super.rotateAroundJAxis(world, i2, j2, k, bReverse)) {
            world.a(i2, j2, k, this.cz, this.a(world));
            return true;
        }
        return false;
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iFacing = this.getFacing(world, i2, j2, k);
        iFacing = apa.cycleFacing(iFacing, bReverse);
        this.setFacing(world, i2, j2, k, iFacing);
        world.a(i2, j2, k, this.cz, this.a(world));
        world.g(i2, j2, k, i2, j2, k);
        world.d(i2, j2, k, this.cz);
        return true;
    }

    public boolean isBlockOn(aak blockAccess, int i2, int j2, int k) {
        return this.isBlockOnFromMetadata(blockAccess.h(i2, j2, k));
    }

    public boolean isBlockOnFromMetadata(int iMetadata) {
        return (iMetadata & 1) > 0;
    }

    public void setBlockOn(aab world, int i2, int j2, int k, boolean bOn) {
        if (bOn != this.isBlockOn(world, i2, j2, k)) {
            int iMetaData = world.h(i2, j2, k);
            if (bOn) {
                iMetaData |= 1;
                world.e(2234, i2, j2, k, 0);
            } else {
                iMetaData &= 0xFFFFFFFE;
            }
            world.setBlockMetadataWithNotify(i2, j2, k, iMetaData);
            world.f(i2, j2 - 1, k, this.cz);
            world.f(i2, j2 + 1, k, this.cz);
            world.f(i2 - 1, j2, k, this.cz);
            world.f(i2 + 1, j2, k, this.cz);
            world.f(i2, j2, k - 1, this.cz);
            world.f(i2, j2, k + 1, this.cz);
            world.g(i2, j2, k, i2, j2, k);
        }
    }

    public boolean placeDetectorLogicIfNecessary(aab world, int i2, int j2, int k) {
        DetectorLogicBlock logicBlock;
        int iFacing = this.getFacing(world, i2, j2, k);
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iFacing);
        int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
        if (iTargetBlockID == 0) {
            DetectorLogicBlock logicBlock2 = (DetectorLogicBlock)BTWBlocks.detectorLogic;
            world.f(targetPos.x, targetPos.y, targetPos.z, logicBlock2.cz, 0, 0);
            logicBlock2.setIsDetectorLogicFlag(world, targetPos.x, targetPos.y, targetPos.z, true);
            logicBlock2.fullyValidateBlock(world, targetPos.x, targetPos.y, targetPos.z);
            return true;
        }
        if (!(iTargetBlockID != BTWBlocks.detectorLogic.cz && iTargetBlockID != BTWBlocks.glowingDetectorLogic.cz || (logicBlock = (DetectorLogicBlock)BTWBlocks.detectorLogic).isDetectorLogicFlagOn(world, targetPos.x, targetPos.y, targetPos.z))) {
            logicBlock.setIsDetectorLogicFlag(world, targetPos.x, targetPos.y, targetPos.z, true);
            if (logicBlock.hasValidLensSource(world, targetPos.x, targetPos.y, targetPos.z)) {
                logicBlock.setIsIntersectionPointFlag(world, targetPos.x, targetPos.y, targetPos.z, true);
            }
        }
        return false;
    }

    public boolean checkForDetection(aab world, int i2, int j2, int k) {
        int iFacing = this.getFacing(world, i2, j2, k);
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iFacing);
        int targetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
        if (targetBlockID > 0) {
            if (DetectorLogicBlock.isLogicBlock(targetBlockID)) {
                DetectorLogicBlock logicBlock = (DetectorLogicBlock)BTWBlocks.detectorLogic;
                if (logicBlock.isEntityCollidingFlagOn(world, targetPos.x, targetPos.y, targetPos.z) || logicBlock.isLitFlagOn(world, targetPos.x, targetPos.y, targetPos.z)) {
                    return true;
                }
                int iBlockBelowID = world.a(targetPos.x, targetPos.y - 1, targetPos.z);
                if (iBlockBelowID == apa.aD.cz && world.h(targetPos.x, targetPos.y - 1, targetPos.z) >= 7) {
                    return true;
                }
            } else {
                LensBlock lensBlock;
                if (targetBlockID == BTWBlocks.lens.cz && (lensBlock = (LensBlock)BTWBlocks.lens).getFacing(world, targetPos.x, targetPos.y, targetPos.z) == apa.getOppositeFacing(iFacing)) {
                    return lensBlock.isLit(world, targetPos.x, targetPos.y, targetPos.z);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        lx sideIcon;
        lx topIcon;
        this.cQ = topIcon = register.a("fcBlockDetectorBlock_top");
        this.iconFront = register.a("fcBlockDetectorBlock_front");
        this.iconFrontOn = register.a("fcBlockDetectorBlock_front_on");
        this.iconBySideArray[0] = register.a("fcBlockDetectorBlock_bottom");
        this.iconBySideArray[1] = topIcon;
        this.iconBySideArray[2] = sideIcon = register.a("fcBlockDetectorBlock_side");
        this.iconBySideArray[3] = sideIcon;
        this.iconBySideArray[4] = sideIcon;
        this.iconBySideArray[5] = sideIcon;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 3) {
            return this.iconFront;
        }
        return this.iconBySideArray[iSide];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iMetadata = blockAccess.h(i2, j2, k);
        int iFacing = this.getFacing(iMetadata);
        if (iFacing == iSide) {
            if (this.isBlockOnFromMetadata(iMetadata)) {
                return this.iconFrontOn;
            }
            return this.iconFront;
        }
        return this.iconBySideArray[iSide];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random random) {
        if (this.isBlockOn(world, i2, j2, k)) {
            int iFacingDirection = this.getFacing(world, i2, j2, k);
            float targeti = i2;
            float targetj = j2;
            float targetk = k;
            float targeti2 = targeti;
            float targetj2 = targetj;
            float targetk2 = targetk;
            if (iFacingDirection == 0) {
                targetj2 = targetj -= 0.2f;
                targetk2 = targetk += 0.25f;
                targeti += 0.33f;
                targeti2 += 0.66f;
            } else if (iFacingDirection == 1) {
                targetj2 = targetj += 1.1f;
                targetk2 = targetk += 0.25f;
                targeti += 0.33f;
                targeti2 += 0.66f;
            } else if (iFacingDirection == 3) {
                targetj2 = targetj += 0.75f;
                targetk2 = targetk += 1.1f;
                targeti += 0.33f;
                targeti2 += 0.66f;
            } else if (iFacingDirection == 2) {
                targetj2 = targetj += 0.75f;
                targetk2 = targetk -= 0.1f;
                targeti += 0.33f;
                targeti2 += 0.66f;
            } else if (iFacingDirection == 5) {
                targeti2 = targeti += 1.1f;
                targetj2 = targetj += 0.75f;
                targetk = (float)((double)targetk + 0.33);
                targetk2 += 0.66f;
            } else {
                targeti2 = targeti -= 0.1f;
                targetj2 = targetj += 0.75f;
                targetk += 0.33f;
                targetk2 += 0.66f;
            }
            targeti += (random.nextFloat() - 0.5f) * 0.1f;
            targetj += (random.nextFloat() - 0.5f) * 0.1f;
            targetk += (random.nextFloat() - 0.5f) * 0.1f;
            float f2 = 0.06666667f;
            float f1 = f2 * 0.6f + 0.4f;
            float f22 = f2 * f2 * 0.7f - 0.5f;
            float f3 = f2 * f2 * 0.6f - 0.7f;
            if (f22 < 0.0f) {
                f22 = 0.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            if (random.nextFloat() >= 0.5f) {
                world.a("reddust", (double)targeti, (double)targetj, (double)targetk, (double)f1, (double)f22, f3);
            } else {
                world.a("reddust", (double)targeti2, (double)targetj2, (double)targetk2, (double)f1, (double)f22, f3);
            }
        }
    }
}

