/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.CropsBlock;
import java.util.Random;

public abstract class DailyGrowthCropsBlock
extends CropsBlock {
    protected DailyGrowthCropsBlock(int iBlockID) {
        super(iBlockID);
    }

    @Override
    public float getBaseGrowthChance(aab world, int i2, int j2, int k) {
        return 0.4f;
    }

    @Override
    protected void attemptToGrow(aab world, int x2, int y2, int z2, Random rand) {
        apa blockBelow;
        int timeOfDay = (int)(world.x.g() % 24000L);
        if (timeOfDay > 14000 && timeOfDay < 22000) {
            if (this.getHasGrownToday(world, x2, y2, z2)) {
                this.setHasGrownToday(world, x2, y2, z2, false);
            }
        } else if (!this.getHasGrownToday(world, x2, y2, z2) && this.getWeedsGrowthLevel(world, x2, y2, z2) == 0 && this.canGrowAtCurrentLightLevel(world, x2, y2, z2) && (blockBelow = apa.r[world.a(x2, y2 - 1, z2)]) != null && blockBelow.isBlockHydratedForPlantGrowthOn(world, x2, y2 - 1, z2)) {
            float growthChance = this.getBaseGrowthChance(world, x2, y2, z2);
            if (blockBelow.getIsFertilizedForPlantGrowth(world, x2, y2 - 1, z2)) {
                growthChance *= 2.0f;
            }
            if (rand.nextFloat() <= growthChance) {
                this.incrementGrowthLevel(world, x2, y2, z2);
                this.updateFlagForGrownToday(world, x2, y2, z2);
            }
        }
    }

    protected void updateFlagForGrownToday(aab world, int i2, int j2, int k) {
        apa blockBelow = apa.r[world.a(i2, j2 - 1, k)];
        if (!(blockBelow == null || blockBelow.getIsFertilizedForPlantGrowth(world, i2, j2 - 1, k) && this.getGrowthLevel(world, i2, j2, k) % 2 != 0)) {
            this.setHasGrownToday(world, i2, j2, k, true);
        }
    }

    protected boolean getHasGrownToday(aak blockAccess, int i2, int j2, int k) {
        return this.getHasGrownToday(blockAccess.h(i2, j2, k));
    }

    protected boolean getHasGrownToday(int iMetadata) {
        return (iMetadata & 8) != 0;
    }

    protected void setHasGrownToday(aab world, int i2, int j2, int k, boolean bHasGrown) {
        int iMetadata = this.setHasGrownToday(world.h(i2, j2, k), bHasGrown);
        world.setBlockMetadata(i2, j2, k, iMetadata);
    }

    protected int setHasGrownToday(int iMetadata, boolean bHasGrown) {
        iMetadata = bHasGrown ? (iMetadata |= 8) : (iMetadata &= 0xFFFFFFF7);
        return iMetadata;
    }
}

