/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.PlantsBlock;
import btw.block.blocks.WeedsBlock;
import btw.block.util.Flammability;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public abstract class CropsBlock
extends PlantsBlock {
    protected static final double BOUNDS_WIDTH = 0.75;
    protected static final double BOUNDS_HALF_WIDTH = 0.375;

    protected CropsBlock(int iBlockID) {
        super(iBlockID, aif.k);
        this.c(0.0f);
        this.setBuoyant();
        this.setFireProperties(Flammability.CROPS);
        this.initBlockBounds(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
        this.a(apa.i);
        this.b(true);
        this.D();
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        super.a(world, i2, j2, k, iNeighborBlockID);
        this.updateIfBlockStays(world, i2, j2, k);
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, int metadata, float chance, int fortuneModifier) {
        if (world.I) {
            return;
        }
        if (this.onlyDropWhenFullyGrown() && !this.isFullyGrown(metadata)) {
            return;
        }
        super.a(world, x2, y2, z2, metadata, chance, 0);
        this.dropSeeds(world, x2, y2, z2, metadata);
    }

    protected boolean onlyDropWhenFullyGrown() {
        return true;
    }

    @Override
    public int a(int iMetadata, Random rand, int iFortuneModifier) {
        if (this.isFullyGrown(iMetadata)) {
            return this.getCropItemID();
        }
        return 0;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iMetadata;
        float dVerticalOffset = 0.0f;
        apa blockBelow = apa.r[blockAccess.a(i2, j2 - 1, k)];
        if (blockBelow != null) {
            dVerticalOffset = blockBelow.groundCoverRestingOnVisualOffset(blockAccess, i2, j2 - 1, k);
        }
        if (this.isFullyGrown(iMetadata = blockAccess.h(i2, j2, k))) {
            return aqx.a().a(0.125, 0.0 + (double)dVerticalOffset, 0.125, 0.875, 1.0 + (double)dVerticalOffset, 0.875);
        }
        int iGrowthLevel = this.getGrowthLevel(iMetadata);
        double dBoundsHeight = (double)(1 + iGrowthLevel) / 8.0;
        int iWeedsGrowthLevel = this.getWeedsGrowthLevel(blockAccess, i2, j2, k);
        if (iWeedsGrowthLevel > 0) {
            dBoundsHeight = Math.max(dBoundsHeight, WeedsBlock.getWeedsBoundsHeight(iWeedsGrowthLevel));
        }
        return aqx.a().a(0.125, 0.0f + dVerticalOffset, 0.125, 0.875, dBoundsHeight + (double)dVerticalOffset, 0.875);
    }

    @Override
    public boolean canBeGrazedOn(aak blockAccess, int i2, int j2, int k, qh animal) {
        return true;
    }

    @Override
    public void onGrazed(aab world, int i2, int j2, int k, qh animal) {
        this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
        super.onGrazed(world, i2, j2, k, animal);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        if (this.updateIfBlockStays(world, i2, j2, k) && world.t.h != 1 && !this.isFullyGrown(world, i2, j2, k)) {
            this.attemptToGrow(world, i2, j2, k, rand);
        }
    }

    @Override
    public boolean canWeedsGrowInBlock(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean getConvertsLegacySoil(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    protected boolean canGrowOnBlock(aab world, int i2, int j2, int k) {
        apa blockOn = apa.r[world.a(i2, j2, k)];
        return blockOn != null && blockOn.canDomesticatedCropsGrowOnBlock(world, i2, j2, k);
    }

    protected abstract int getCropItemID();

    protected abstract int getSeedItemID();

    protected boolean updateIfBlockStays(aab world, int i2, int j2, int k) {
        if (!this.f(world, i2, j2, k)) {
            this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
            world.i(i2, j2, k);
            return false;
        }
        return true;
    }

    protected void attemptToGrow(aab world, int x2, int y2, int z2, Random rand) {
        apa blockBelow;
        if (this.getWeedsGrowthLevel(world, x2, y2, z2) == 0 && this.canGrowAtCurrentLightLevel(world, x2, y2, z2) && (blockBelow = apa.r[world.a(x2, y2 - 1, z2)]) != null && blockBelow.isBlockHydratedForPlantGrowthOn(world, x2, y2 - 1, z2)) {
            float fGrowthChance = this.getBaseGrowthChance(world, x2, y2, z2) * blockBelow.getPlantGrowthOnMultiplier(world, x2, y2 - 1, z2, this);
            if (rand.nextFloat() <= fGrowthChance) {
                this.incrementGrowthLevel(world, x2, y2, z2);
            }
        }
    }

    public void dropSeeds(aab world, int i2, int j2, int k, int iMetadata) {
        int iSeedItemID = this.getSeedItemID();
        if (iSeedItemID > 0) {
            this.b(world, i2, j2, k, new wm(iSeedItemID, 1, 0));
        }
    }

    public float getBaseGrowthChance(aab world, int i2, int j2, int k) {
        return 0.05f;
    }

    protected void incrementGrowthLevel(aab world, int i2, int j2, int k) {
        apa blockBelow;
        int iGrowthLevel = this.getGrowthLevel(world, i2, j2, k) + 1;
        this.setGrowthLevel(world, i2, j2, k, iGrowthLevel);
        if (this.isFullyGrown(world, i2, j2, k) && (blockBelow = apa.r[world.a(i2, j2 - 1, k)]) != null) {
            blockBelow.notifyOfFullStagePlantGrowthOn(world, i2, j2 - 1, k, this);
        }
    }

    protected int getGrowthLevel(aak blockAccess, int i2, int j2, int k) {
        return this.getGrowthLevel(blockAccess.h(i2, j2, k));
    }

    protected int getGrowthLevel(int iMetadata) {
        return iMetadata & 7;
    }

    protected void setGrowthLevel(aab world, int i2, int j2, int k, int iLevel) {
        int iMetadata = world.h(i2, j2, k) & 0xFFFFFFF8;
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata | iLevel);
    }

    protected void setGrowthLevelNoNotify(aab world, int i2, int j2, int k, int iLevel) {
        int iMetadata = world.h(i2, j2, k) & 0xFFFFFFF8;
        world.setBlockMetadata(i2, j2, k, iMetadata | iLevel);
    }

    protected boolean isFullyGrown(aab world, int i2, int j2, int k) {
        return this.isFullyGrown(world.h(i2, j2, k));
    }

    protected boolean isFullyGrown(int iMetadata) {
        return this.getGrowthLevel(iMetadata) >= 7;
    }

    protected int getLightLevelForGrowth() {
        return 9;
    }

    protected boolean canGrowAtCurrentLightLevel(aab world, int x2, int y2, int z2) {
        if (this.requiresNaturalLight()) {
            return world.getBlockNaturalLightValue(x2, y2, z2) >= this.getLightLevelForGrowth() || world.a(x2, y2 + 1, z2) == BTWBlocks.lightBlockOn.cz || world.a(x2, y2 + 2, z2) == BTWBlocks.lightBlockOn.cz;
        }
        return world.n(x2, y2, z2) >= this.getLightLevelForGrowth();
    }

    protected boolean requiresNaturalLight() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        this.renderCrops(renderer, i2, j2, k);
        BTWBlocks.weeds.renderWeeds(this, renderer, i2, j2, k);
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderCrops(bgf renderer, int i2, int j2, int k) {
        bgd tessellator = bgd.a;
        tessellator.c(this.e(renderer.a, i2, j2, k));
        tessellator.a(1.0f, 1.0f, 1.0f);
        double dVerticalOffset = 0.0;
        apa blockBelow = apa.r[renderer.a.a(i2, j2 - 1, k)];
        if (blockBelow != null) {
            dVerticalOffset = blockBelow.groundCoverRestingOnVisualOffset(renderer.a, i2, j2 - 1, k);
        }
        this.renderCrossHatch(renderer, i2, j2, k, this.b_(renderer.a, i2, j2, k, 0), 0.25, dVerticalOffset);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aab world, int i2, int j2, int k) {
        return this.getSeedItemID();
    }
}

