/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.LogSpikeBlock;
import btw.block.model.BlockModel;
import btw.item.BTWItems;
import btw.item.items.AxeItem;
import btw.item.items.ChiselItem;
import btw.item.util.ItemUtils;
import btw.world.util.BlockPos;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class ChewedLogBlock
extends apa {
    public static final float HARDNESS = 2.0f;
    private BlockModel[] blockModels;
    private BlockModel[] blockModelsNarrowOneSide;
    private BlockModel[] blockModelsNarrowTwoSides;
    private aqx[] boxSelectionArray;
    protected String sideTexture;
    protected String topTexture;
    protected String stumpTopTexture;
    apa logSpike;
    private static final float RIM_WIDTH = 0.0625f;
    private static final float LAYER_HEIGHT = 0.125f;
    private static final float FIRST_LAYER_HEIGHT = 0.1875f;
    private static final float LAYER_WIDTH_GAP = 0.0625f;
    private boolean tempPosNarrow = false;
    private boolean tempNegNarrow = false;
    private BlockModel currentModel;
    @Environment(value=EnvType.CLIENT)
    private lx iconSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconStumpTop;

    public ChewedLogBlock(int blockID, String sideTexture, String topTexture, String stumpTopTexture, apa logSpike) {
        super(blockID, BTWBlocks.logMaterial);
        this.c(2.0f);
        this.setAxesEffectiveOn();
        this.setChiselsEffectiveOn();
        this.setBuoyant();
        this.setFireProperties(5, 5);
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.initModels();
        apa.w[blockID] = true;
        this.k(8);
        this.a(g);
        this.sideTexture = sideTexture;
        this.topTexture = topTexture;
        this.stumpTopTexture = stumpTopTexture;
        this.logSpike = logSpike;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public float l(aab world, int i2, int j2, int k) {
        float fHardness = super.l(world, i2, j2, k);
        int iMetadata = world.h(i2, j2, k);
        if (ChewedLogBlock.getIsStump(world, i2, j2, k)) {
            fHardness *= 3.0f;
        }
        return fHardness;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        iMetadata = iFacing <= 1 ? this.setOrientation(iMetadata, 0) : (iFacing <= 3 ? this.setOrientation(iMetadata, 2) : this.setOrientation(iMetadata, 1));
        return iMetadata;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        int iMetadata = world.h(i2, j2, k);
        this.checkForReplaceWithSpike(world, i2, j2, k, iMetadata);
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        int iFacing = this.setCurrentModelForBlock(world, i2, j2, k);
        BlockModel transformedModel = this.currentModel.makeTemporaryCopy();
        transformedModel.tiltToFacingAlongY(iFacing);
        return transformedModel.collisionRayTrace(world, i2, j2, k, startRay, endRay);
    }

    @Override
    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        int iOrientation = this.getOrientation(blockAccess, i2, j2, k);
        if (iOrientation == 0) {
            return iFacing <= 1;
        }
        if (iOrientation == 1) {
            return iFacing >= 4;
        }
        return iFacing == 2 || iFacing == 3;
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        boolean bIsStump = ChewedLogBlock.getIsStump(iMetadata);
        if (bIsStump) {
            this.b(world, i2, j2, k, new wm(BTWItems.sawDust));
        }
        this.b(world, i2, j2, k, new wm(BTWItems.sawDust));
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int i2, int j2, int k, int iFromSide) {
        int iOldMetadata = world.h(i2, j2, k);
        int iDamageLevel = this.getDamageLevel(iOldMetadata);
        if (iDamageLevel < 3) {
            this.setDamageLevel(world, i2, j2, k, ++iDamageLevel);
            if (!world.I) {
                if (ChewedLogBlock.getIsStump(iOldMetadata)) {
                    ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.sawDust, 1), iFromSide);
                    ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.sawDust, 1), iFromSide);
                } else if (iDamageLevel == 1 || iDamageLevel == 3) {
                    world.e(2268, i2, j2, k, 0);
                    ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(wk.E, 1), iFromSide);
                } else {
                    ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.sawDust, 1), iFromSide);
                }
            }
            return true;
        }
        if (!world.I) {
            if (ChewedLogBlock.getIsStump(iOldMetadata)) {
                ItemUtils.dropStackAsIfBlockHarvested(world, i2, j2, k, new wm(BTWItems.sawDust, 1));
            }
            ItemUtils.dropStackAsIfBlockHarvested(world, i2, j2, k, new wm(BTWItems.sawDust, 1));
        }
        return false;
    }

    @Override
    public boolean getIsProblemToRemove(wm toolStack, aak blockAccess, int i2, int j2, int k) {
        return ChewedLogBlock.getIsStump(blockAccess, i2, j2, k);
    }

    @Override
    public boolean getDoesStumpRemoverWorkOnBlock(aak blockAccess, int i2, int j2, int k) {
        return ChewedLogBlock.getIsStump(blockAccess, i2, j2, k);
    }

    @Override
    public boolean a(zw explosion) {
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        float fChanceOfPileDrop = 1.0f;
        if (explosion != null) {
            fChanceOfPileDrop = 1.0f / explosion.g;
        }
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, 1, 0, fChanceOfPileDrop);
    }

    @Override
    public boolean getCanBlockBeIncinerated(aab world, int i2, int j2, int k) {
        return !ChewedLogBlock.getIsStump(world, i2, j2, k);
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 1000;
    }

    @Override
    public void onDestroyedByFire(aab world, int i2, int j2, int k, int iFireAge, boolean bForcedFireSpread) {
        if (ChewedLogBlock.getIsStump(world, i2, j2, k)) {
            int iNewMetadata = BTWBlocks.charredStump.setDamageLevel(0, this.getDamageLevel(world, i2, j2, k));
            world.setBlockAndMetadataWithNotify(i2, j2, k, BTWBlocks.charredStump.cz, iNewMetadata);
        } else {
            super.onDestroyedByFire(world, i2, j2, k, iFireAge, bForcedFireSpread);
        }
    }

    protected void initModels() {
        int iTempIndex;
        this.blockModels = new BlockModel[4];
        this.blockModelsNarrowOneSide = new BlockModel[4];
        this.blockModelsNarrowTwoSides = new BlockModel[4];
        this.boxSelectionArray = new aqx[4];
        for (iTempIndex = 0; iTempIndex < 4; ++iTempIndex) {
            BlockModel tempModel = this.blockModels[iTempIndex] = new BlockModel();
            BlockModel tempNarrowOneSide = this.blockModelsNarrowOneSide[iTempIndex] = new BlockModel();
            BlockModel tempNarrowTwoSides = this.blockModelsNarrowTwoSides[iTempIndex] = new BlockModel();
            float fCenterColumnWidthGap = 0.0625f + 0.0625f * (float)iTempIndex;
            float fCenterColumnHeightGap = 0.0f;
            if (iTempIndex > 0) {
                fCenterColumnHeightGap = 0.1875f + 0.125f * (float)(iTempIndex - 1);
            }
            tempModel.addBox(fCenterColumnWidthGap, fCenterColumnHeightGap, fCenterColumnWidthGap, 1.0f - fCenterColumnWidthGap, 1.0f - fCenterColumnHeightGap, 1.0f - fCenterColumnWidthGap);
            tempNarrowOneSide.addBox(fCenterColumnWidthGap, fCenterColumnHeightGap, fCenterColumnWidthGap, 1.0f - fCenterColumnWidthGap, 1.0, 1.0f - fCenterColumnWidthGap);
            tempNarrowTwoSides.addBox(fCenterColumnWidthGap, 0.0, fCenterColumnWidthGap, 1.0f - fCenterColumnWidthGap, 1.0, 1.0f - fCenterColumnWidthGap);
            aqx aqx2 = this.boxSelectionArray[iTempIndex] = new aqx(fCenterColumnWidthGap, 0.0, fCenterColumnWidthGap, 1.0f - fCenterColumnWidthGap, 1.0, 1.0f - fCenterColumnWidthGap);
        }
        for (iTempIndex = 1; iTempIndex < 4; ++iTempIndex) {
            this.blockModels[iTempIndex].addBox(0.0625, 0.0, 0.0625, 0.9375, 0.1875, 0.9375);
            this.blockModelsNarrowOneSide[iTempIndex].addBox(0.0625, 0.0, 0.0625, 0.9375, 0.1875, 0.9375);
            this.blockModels[iTempIndex].addBox(0.0625, 0.8125, 0.0625, 0.9375, 1.0, 0.9375);
        }
        float fWidthGap = 0.125f;
        float fHeightGap = 0.1875f;
        for (int iTempIndex2 = 2; iTempIndex2 < 4; ++iTempIndex2) {
            this.blockModels[iTempIndex2].addBox(fWidthGap, fHeightGap, fWidthGap, 1.0f - fWidthGap, fHeightGap + 0.125f, 1.0f - fWidthGap);
            this.blockModelsNarrowOneSide[iTempIndex2].addBox(fWidthGap, fHeightGap, fWidthGap, 1.0f - fWidthGap, fHeightGap + 0.125f, 1.0f - fWidthGap);
            this.blockModels[iTempIndex2].addBox(fWidthGap, 1.0f - fHeightGap - 0.125f, fWidthGap, 1.0f - fWidthGap, 1.0f - fHeightGap, 1.0f - fWidthGap);
        }
        fWidthGap = 0.1875f;
        fHeightGap = 0.3125f;
        this.blockModels[3].addBox(fWidthGap, fHeightGap, fWidthGap, 1.0f - fWidthGap, fHeightGap + 0.125f, 1.0f - fWidthGap);
        this.blockModelsNarrowOneSide[3].addBox(fWidthGap, fHeightGap, fWidthGap, 1.0f - fWidthGap, fHeightGap + 0.125f, 1.0f - fWidthGap);
        this.blockModels[3].addBox(fWidthGap, 1.0f - fHeightGap - 0.125f, fWidthGap, 1.0f - fWidthGap, 0.875, 1.0f - fWidthGap);
    }

    public void setDamageLevel(aab world, int i2, int j2, int k, int iDamageLevel) {
        int iMetadata = world.h(i2, j2, k) & 0xFFFFFFFC;
        if (!this.checkForReplaceWithSpike(world, i2, j2, k, iMetadata |= iDamageLevel)) {
            world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
        }
    }

    private boolean checkForReplaceWithSpike(aab world, int i2, int j2, int k, int iMetadata) {
        if (this.getDamageLevel(iMetadata) == 3 && !ChewedLogBlock.getIsStump(iMetadata)) {
            int iFacing = this.setConnectionFlagsForBlock(world, i2, j2, k, iMetadata);
            if (this.tempPosNarrow != this.tempNegNarrow) {
                BlockPos targetPos = new BlockPos(i2, j2, k);
                targetPos.addFacingAsOffset(iFacing);
                int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
                apa targetBlock = apa.r[iTargetBlockID];
                if (iTargetBlockID != this.cz || this.getOrientation(iMetadata) != this.getOrientation(world, targetPos.x, targetPos.y, targetPos.z)) {
                    world.setBlockAndMetadataWithNotify(i2, j2, k, this.logSpike.cz, iFacing);
                    return true;
                }
            }
        }
        return false;
    }

    public int getDamageLevel(aak blockAccess, int i2, int j2, int k) {
        return this.getDamageLevel(blockAccess.h(i2, j2, k));
    }

    public int getDamageLevel(int iMetadata) {
        return iMetadata & 3;
    }

    public int getOrientation(aak blockAccess, int i2, int j2, int k) {
        return this.getOrientation(blockAccess.h(i2, j2, k));
    }

    public int getOrientation(int iMetadata) {
        int iOrientation = iMetadata >> 2 & 3;
        if (iOrientation == 3) {
            iOrientation = 0;
        }
        return iOrientation;
    }

    public int setOrientation(int iMetadata, int iOrientation) {
        if (!ChewedLogBlock.getIsStump(iMetadata)) {
            iMetadata |= iOrientation << 2;
        }
        return iMetadata;
    }

    public static boolean getIsStump(aak blockAccess, int i2, int j2, int k) {
        return ChewedLogBlock.getIsStump(blockAccess.h(i2, j2, k));
    }

    public static boolean getIsStump(int iMetadata) {
        return (iMetadata & 0xC) == 12;
    }

    public int setIsStump(int iMetadata) {
        return iMetadata |= 0xC;
    }

    public int setCurrentModelForBlock(aak blockAccess, int i2, int j2, int k) {
        int iFacing = this.setConnectionFlagsForBlock(blockAccess, i2, j2, k);
        int iDamageLevel = this.getDamageLevel(blockAccess, i2, j2, k);
        this.currentModel = this.tempPosNarrow ? (this.tempNegNarrow ? this.blockModelsNarrowTwoSides[iDamageLevel] : this.blockModelsNarrowOneSide[iDamageLevel]) : this.blockModels[iDamageLevel];
        return iFacing;
    }

    public int setConnectionFlagsForBlock(aak blockAccess, int i2, int j2, int k) {
        return this.setConnectionFlagsForBlock(blockAccess, i2, j2, k, blockAccess.h(i2, j2, k));
    }

    public int setConnectionFlagsForBlock(aak blockAccess, int i2, int j2, int k, int iMetadata) {
        int iOrientation = this.getOrientation(iMetadata);
        int iFacing = 1;
        if (iOrientation == 1) {
            iFacing = 5;
        } else if (iOrientation == 2) {
            iFacing = 3;
        }
        this.tempPosNarrow = true;
        this.tempNegNarrow = true;
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iFacing);
        int iTargetBlockID = blockAccess.a(targetPos.x, targetPos.y, targetPos.z);
        apa targetBlock = apa.r[iTargetBlockID];
        if (this.doesTargetBlockConnectToFacing(iOrientation, blockAccess, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iFacing))) {
            this.tempPosNarrow = false;
        }
        targetPos.set(i2, j2, k);
        targetPos.addFacingAsOffset(apa.getOppositeFacing(iFacing));
        iTargetBlockID = blockAccess.a(targetPos.x, targetPos.y, targetPos.z);
        targetBlock = apa.r[iTargetBlockID];
        if (ChewedLogBlock.getIsStump(iMetadata) || this.doesTargetBlockConnectToFacing(iOrientation, blockAccess, targetPos.x, targetPos.y, targetPos.z, iFacing)) {
            this.tempNegNarrow = false;
        }
        if (!this.tempPosNarrow && this.tempNegNarrow) {
            iFacing = apa.getOppositeFacing(iFacing);
            this.tempPosNarrow = true;
            this.tempNegNarrow = false;
        }
        return iFacing;
    }

    public boolean doesTargetBlockConnectToFacing(int iMyOrientation, aak blockAccess, int i2, int j2, int k, int iFacing) {
        int targetBlockID = blockAccess.a(i2, j2, k);
        apa targetBlock = apa.r[targetBlockID];
        if (targetBlock == null) {
            return false;
        }
        if (targetBlock instanceof ChewedLogBlock) {
            return this.getDamageLevel(blockAccess, i2, j2, k) == 0 && iMyOrientation == this.getOrientation(blockAccess, i2, j2, k);
        }
        if (targetBlock instanceof LogSpikeBlock) {
            return BTWBlocks.oakLogSpike.getFacing(blockAccess, i2, j2, k) == apa.getOppositeFacing(iFacing);
        }
        return targetBlock.isLog(blockAccess, i2, j2, k);
    }

    public boolean isItemEffectiveConversionTool(wm stack, aab world, int i2, int j2, int k) {
        wk item;
        return stack != null && ((item = stack.b()) instanceof ChiselItem || item instanceof AxeItem || item == BTWItems.battleaxe);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a(this.sideTexture);
        this.iconSide = register.a(this.topTexture);
        this.iconStumpTop = register.a(this.stumpTopTexture);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        int iOrientation = this.getOrientation(iMetadata);
        lx icon = this.cQ;
        if (iOrientation == 0) {
            if (iSide >= 2) {
                icon = this.iconSide;
            } else if (iSide == 1 && ChewedLogBlock.getIsStump(iMetadata)) {
                icon = this.iconStumpTop;
            }
        } else if (iOrientation == 1) {
            if (iSide != 4 && iSide != 5) {
                icon = this.iconSide;
            }
        } else if (iSide != 2 && iSide != 3) {
            icon = this.iconSide;
        }
        return icon;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int x2, int y2, int z2) {
        int facing = this.setCurrentModelForBlock(renderBlocks.a, x2, y2, z2);
        BlockModel transformedModel = this.currentModel.makeTemporaryCopy();
        transformedModel.tiltToFacingAlongY(facing);
        int metadata = renderBlocks.a.h(x2, y2, z2);
        if (metadata == 4 || metadata == 5 || metadata == 6 || metadata == 7) {
            renderBlocks.setUVRotateTop(1);
            renderBlocks.setUVRotateBottom(1);
            renderBlocks.setUVRotateWest(1);
            renderBlocks.setUVRotateEast(1);
        } else if (metadata == 8 || metadata == 9 || metadata == 10 || metadata == 11) {
            renderBlocks.setUVRotateNorth(1);
            renderBlocks.setUVRotateSouth(1);
        }
        transformedModel.renderAsBlock(renderBlocks, this, x2, y2, z2);
        renderBlocks.clearUVRotation();
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        this.blockModelsNarrowOneSide[iItemDamage].renderAsItemBlock(renderBlocks, this, iItemDamage);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int iBlockID, ve creativeTabs, List list) {
        for (int iTempIndex = 0; iTempIndex < 4; ++iTempIndex) {
            list.add(new wm(iBlockID, 1, iTempIndex));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public aqx c_(aab world, int i2, int j2, int k) {
        int iFacing = this.setConnectionFlagsForBlock(world, i2, j2, k);
        int iDamageLevel = this.getDamageLevel(world, i2, j2, k);
        aqx tempSelectionBox = this.boxSelectionArray[iDamageLevel].makeTemporaryCopy();
        tempSelectionBox.tiltToFacingAlongY(iFacing);
        return tempSelectionBox.d(i2, j2, k);
    }
}

