/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.model.BlockModel;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class CharredStumpBlock
extends apa {
    public static final float HARDNESS = 3.0f;
    private BlockModel[] blockModelsNarrowOneSide;
    private static final float RIM_WIDTH = 0.0625f;
    private static final float LAYER_HEIGHT = 0.125f;
    private static final float FIRST_LAYER_HEIGHT = 0.1875f;
    private static final float LAYER_WIDTH_GAP = 0.0625f;
    private BlockModel tempCurrentModel;

    public CharredStumpBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.logMaterial);
        this.c(3.0f);
        this.setAxesEffectiveOn();
        this.setChiselsEffectiveOn();
        this.setBuoyant();
        this.initModels();
        apa.w[iBlockID] = true;
        this.k(8);
        this.a(h);
        this.c("fcBlockStumpCharred");
    }

    @Override
    public int a(int iMetadata, Random rand, int iFortuneModifier) {
        return 0;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        return this.getCurrentModelForBlock(world, i2, j2, k).collisionRayTrace(world, i2, j2, k, startRay, endRay);
    }

    @Override
    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return iFacing <= 1;
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int i2, int j2, int k, int iFromSide) {
        int iOldMetadata = world.h(i2, j2, k);
        int iDamageLevel = this.getDamageLevel(iOldMetadata);
        if (iDamageLevel < 3) {
            this.setDamageLevel(world, i2, j2, k, ++iDamageLevel);
            return true;
        }
        return false;
    }

    @Override
    public boolean getIsProblemToRemove(wm toolStack, aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean getDoesStumpRemoverWorkOnBlock(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean getCanBlockBeIncinerated(aab world, int i2, int j2, int k) {
        return false;
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 1000;
    }

    protected void initModels() {
        int iTempIndex;
        this.blockModelsNarrowOneSide = new BlockModel[4];
        for (iTempIndex = 0; iTempIndex < 4; ++iTempIndex) {
            BlockModel tempNarrowOneSide = this.blockModelsNarrowOneSide[iTempIndex] = new BlockModel();
            float fCenterColumnWidthGap = 0.0625f + 0.0625f * (float)iTempIndex;
            float fCenterColumnHeightGap = 0.0f;
            if (iTempIndex > 0) {
                fCenterColumnHeightGap = 0.1875f + 0.125f * (float)(iTempIndex - 1);
            }
            tempNarrowOneSide.addBox(fCenterColumnWidthGap, fCenterColumnHeightGap, fCenterColumnWidthGap, 1.0f - fCenterColumnWidthGap, 1.0, 1.0f - fCenterColumnWidthGap);
        }
        for (iTempIndex = 1; iTempIndex < 4; ++iTempIndex) {
            this.blockModelsNarrowOneSide[iTempIndex].addBox(0.0625, 0.0, 0.0625, 0.9375, 0.1875, 0.9375);
        }
        float fWidthGap = 0.125f;
        float fHeightGap = 0.1875f;
        for (int iTempIndex2 = 2; iTempIndex2 < 4; ++iTempIndex2) {
            this.blockModelsNarrowOneSide[iTempIndex2].addBox(fWidthGap, fHeightGap, fWidthGap, 1.0f - fWidthGap, fHeightGap + 0.125f, 1.0f - fWidthGap);
        }
        fWidthGap = 0.1875f;
        fHeightGap = 0.3125f;
        this.blockModelsNarrowOneSide[3].addBox(fWidthGap, fHeightGap, fWidthGap, 1.0f - fWidthGap, fHeightGap + 0.125f, 1.0f - fWidthGap);
    }

    public void setDamageLevel(aab world, int i2, int j2, int k, int iDamageLevel) {
        int iMetadata = this.setDamageLevel(world.h(i2, j2, k), iDamageLevel);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public int setDamageLevel(int iMetadata, int iDamageLevel) {
        return (iMetadata &= 0xFFFFFFFC) | iDamageLevel;
    }

    public int getDamageLevel(aak blockAccess, int i2, int j2, int k) {
        return this.getDamageLevel(blockAccess.h(i2, j2, k));
    }

    public int getDamageLevel(int iMetadata) {
        return iMetadata & 3;
    }

    public BlockModel getCurrentModelForBlock(aak blockAccess, int i2, int j2, int k) {
        int iDamageLevel = this.getDamageLevel(blockAccess, i2, j2, k);
        return this.blockModelsNarrowOneSide[iDamageLevel];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        return this.getCurrentModelForBlock(renderBlocks.a, i2, j2, k).renderAsBlock(renderBlocks, this, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        this.blockModelsNarrowOneSide[iItemDamage].renderAsItemBlock(renderBlocks, this, iItemDamage);
    }
}

