/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.tileentity.CementTileEntity;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class CementBlock
extends akz {
    private final int cementTexture;
    private final int cementPartiallyDryTexture;
    public static final int MAX_CEMENT_SPREAD_DIST = 16;
    public static final int CEMENT_TICKS_TO_DRY = 12;
    public static final int CEMENT_TICKS_TO_PARTIALLY_DRY = 8;
    boolean[] tempSpreadToSideFlags;
    int[] tempClosestDownslopeToSideDist;
    @Environment(value=EnvType.CLIENT)
    private lx iconDrying;

    public CementBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.cementMaterial);
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.c(100.0f);
        this.k(255);
        this.c("fcBlockCement");
        this.a(apa.n);
        this.cementTexture = 15;
        this.cementPartiallyDryTexture = 16;
        this.tempSpreadToSideFlags = new boolean[4];
        this.tempClosestDownslopeToSideDist = new int[4];
        apa.w[iBlockID] = true;
        this.b(true);
    }

    public aqp b(aab world) {
        return new CementTileEntity();
    }

    public boolean b() {
        return false;
    }

    public boolean c() {
        return false;
    }

    public boolean a(int i2, boolean flag) {
        return flag && i2 == 0;
    }

    public aqx b(aab world, int i2, int j2, int k) {
        if (world.a(i2, j2 + 1, k) != this.cz) {
            return aqx.a().a(i2, j2, k, i2 + 1, (float)j2 + 0.5f, k + 1);
        }
        return aqx.a().a(i2, j2, k, i2 + 1, j2 + 1, k + 1);
    }

    public int a(int i2, Random random, int iFortuneModifier) {
        return 0;
    }

    public int a(Random random) {
        return 0;
    }

    public int a(aab world) {
        return 20;
    }

    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        if (world.a(i2, j2, k) == this.cz) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    public void a(aab world, int i2, int j2, int k, Random random) {
        int cementDist = this.getCementSpreadDist(world, i2, j2, k);
        if (cementDist > 0) {
            int newCementDist = -100;
            newCementDist = this.checkForLesserSpreadDist(world, i2 - 1, j2, k, newCementDist);
            newCementDist = this.checkForLesserSpreadDist(world, i2 + 1, j2, k, newCementDist);
            newCementDist = this.checkForLesserSpreadDist(world, i2, j2, k - 1, newCementDist);
            newCementDist = this.checkForLesserSpreadDist(world, i2, j2, k + 1, newCementDist);
            newCementDist = (newCementDist = this.checkForLesserSpreadDist(world, i2, j2 + 1, k, newCementDist)) < 0 ? -1 : ++newCementDist;
            int cementDistUp = this.getCementSpreadDist(world, i2, j2 + 1, k);
            if (cementDistUp >= 0 && cementDistUp < newCementDist) {
                newCementDist = cementDistUp + 1;
            }
            if (newCementDist > 0 && newCementDist < cementDist) {
                cementDist = newCementDist;
                this.setCementSpreadDist(world, i2, j2, k, cementDist);
                this.setCementDryTime(world, i2, j2, k, 0);
            }
        }
        int iDryTime = this.getCementDryTime(world, i2, j2, k);
        int minDryTime = this.checkNeighboursCloserToSourceForMinDryTime(world, i2, j2, k);
        if (minDryTime <= ++iDryTime) {
            iDryTime = minDryTime <= 0 ? 0 : minDryTime - 1;
        }
        if (iDryTime > 12) {
            world.setBlockWithNotify(i2, j2, k, apa.x.cz);
        } else {
            this.setCementDryTime(world, i2, j2, k, iDryTime);
            world.a(i2, j2, k, this.cz, this.a(world));
            if (this.isBlockOpenToSpread(world, i2, j2 - 1, k)) {
                int targetCementDist = cementDist + 1;
                if (targetCementDist <= 16) {
                    world.setBlockWithNotify(i2, j2 - 1, k, this.cz);
                    this.setCementSpreadDist(world, i2, j2 - 1, k, targetCementDist);
                }
            } else if (cementDist >= 0 && (cementDist == 0 || this.blockBlocksFlow(world, i2, j2 - 1, k))) {
                boolean[] spreadToSideFlags = this.checkSideBlocksForPotentialSpread(world, i2, j2, k);
                int spreadDist = cementDist + 1;
                if (spreadDist <= 16) {
                    if (spreadToSideFlags[0]) {
                        this.attemptToSpreadToBlock(world, i2 - 1, j2, k, spreadDist);
                    }
                    if (spreadToSideFlags[1]) {
                        this.attemptToSpreadToBlock(world, i2 + 1, j2, k, spreadDist);
                    }
                    if (spreadToSideFlags[2]) {
                        this.attemptToSpreadToBlock(world, i2, j2, k - 1, spreadDist);
                    }
                    if (spreadToSideFlags[3]) {
                        this.attemptToSpreadToBlock(world, i2, j2, k + 1, spreadDist);
                    }
                }
            }
        }
    }

    public boolean getCanBlockBeIncinerated(aab world, int i2, int j2, int k) {
        return false;
    }

    public wm getStackRetrievedByBlockDispenser(aab world, int i2, int j2, int k) {
        return null;
    }

    private boolean isPowered(aak blockAccess, int i2, int j2, int k) {
        int iMetaData = blockAccess.h(i2, j2, k);
        return (iMetaData & 1) > 0;
    }

    public float getRenderHeight(aak blockAccess, int i2, int j2, int k) {
        float fRenderHeight = 1.0f;
        if (blockAccess.g(i2, j2, k) == this.cO) {
            int dist = this.getCementSpreadDist(blockAccess, i2, j2, k);
            fRenderHeight = (float)(dist + 1) / 18.0f;
            fRenderHeight = this.isCementPartiallyDry(blockAccess, i2, j2, k) ? (fRenderHeight *= 0.1f) : (fRenderHeight *= 0.5f);
        }
        return fRenderHeight;
    }

    public int getCementSpreadDist(aak blockAccess, int i2, int j2, int k) {
        if (blockAccess.g(i2, j2, k) != this.cO) {
            return -1;
        }
        CementTileEntity tileEntity = (CementTileEntity)blockAccess.r(i2, j2, k);
        return tileEntity.getSpreadDist();
    }

    public void setCementSpreadDist(aab world, int i2, int j2, int k, int iSpreadDist) {
        CementTileEntity tileEntity = (CementTileEntity)world.r(i2, j2, k);
        tileEntity.setSpreadDist(iSpreadDist);
        world.f(i2, j2, k, this.cz);
        world.g(i2, j2, k, i2, j2, k);
    }

    public boolean isCementSourceBlock(aak blockAccess, int i2, int j2, int k) {
        return this.getCementSpreadDist(blockAccess, i2, j2, k) == 0;
    }

    public int getCementDryTime(aak blockAccess, int i2, int j2, int k) {
        aqp tileEntity;
        if (blockAccess.g(i2, j2, k) == this.cO && (tileEntity = blockAccess.r(i2, j2, k)) instanceof CementTileEntity) {
            CementTileEntity cementTileEntity = (CementTileEntity)blockAccess.r(i2, j2, k);
            return cementTileEntity.getDryTime();
        }
        return 0;
    }

    public void setCementDryTime(aab world, int i2, int j2, int k, int iDryTime) {
        CementTileEntity tileEntity = (CementTileEntity)world.r(i2, j2, k);
        tileEntity.setDryTime(iDryTime);
        world.f(i2, j2, k, this.cz);
        world.g(i2, j2, k, i2, j2, k);
    }

    public boolean isCementPartiallyDry(aak blockAccess, int i2, int j2, int k) {
        return this.getCementDryTime(blockAccess, i2, j2, k) >= 8;
    }

    private int checkNeighboursCloserToSourceForMinDryTime(aab world, int i2, int j2, int k) {
        int minDryTime = 1000;
        int distToSource = this.getCementSpreadDist(world, i2, j2, k);
        minDryTime = this.getLesserDryTimeIfCloserToSource(world, i2, j2 + 1, k, distToSource, minDryTime);
        minDryTime = this.getLesserDryTimeIfCloserToSource(world, i2 + 1, j2, k, distToSource, minDryTime);
        minDryTime = this.getLesserDryTimeIfCloserToSource(world, i2 - 1, j2, k, distToSource, minDryTime);
        minDryTime = this.getLesserDryTimeIfCloserToSource(world, i2, j2, k + 1, distToSource, minDryTime);
        minDryTime = this.getLesserDryTimeIfCloserToSource(world, i2, j2, k - 1, distToSource, minDryTime);
        return minDryTime;
    }

    private int getLesserDryTimeIfCloserToSource(aab world, int i2, int j2, int k, int distToSource, int dryTime) {
        int targetDryTime;
        int targetDistToSource;
        aif material = world.g(i2, j2, k);
        if (material == this.cO && (targetDistToSource = this.getCementSpreadDist(world, i2, j2, k)) < distToSource && (targetDryTime = this.getCementDryTime(world, i2, j2, k)) < dryTime) {
            return targetDryTime;
        }
        return dryTime;
    }

    private void attemptToSpreadToBlock(aab world, int i2, int j2, int k, int newSpreadDist) {
        if (this.isBlockOpenToSpread(world, i2, j2, k)) {
            int i1 = world.a(i2, j2, k);
            if (i1 > 0) {
                apa.r[i1].c(world, i2, j2, k, world.h(i2, j2, k), 0);
            }
            world.setBlockWithNotify(i2, j2, k, this.cz);
            this.setCementSpreadDist(world, i2, j2, k, newSpreadDist);
        }
    }

    private boolean[] checkSideBlocksForPotentialSpread(aab world, int i2, int j2, int k) {
        for (int sideNum = 0; sideNum < 4; ++sideNum) {
            int iSide = i2;
            int jSide = j2;
            int kSide = k;
            switch (sideNum) {
                case 0: {
                    --iSide;
                    break;
                }
                case 1: {
                    ++iSide;
                    break;
                }
                case 2: {
                    --kSide;
                    break;
                }
                default: {
                    ++kSide;
                }
            }
            this.tempSpreadToSideFlags[sideNum] = !this.blockBlocksFlow(world, iSide, jSide, kSide) && (world.g(iSide, jSide, kSide) != this.cO || !this.isCementSourceBlock(world, iSide, jSide, kSide));
        }
        return this.tempSpreadToSideFlags;
    }

    private boolean[] checkSideBlocksForDownslope(aab world, int i2, int j2, int k) {
        int tempSide;
        for (int sideNum = 0; sideNum < 4; ++sideNum) {
            this.tempClosestDownslopeToSideDist[sideNum] = 1000;
            int iSide = i2;
            int jSide = j2;
            int kSide = k;
            if (sideNum == 0) {
                --iSide;
            } else if (sideNum == 1) {
                ++iSide;
            } else if (sideNum == 2) {
                --kSide;
            } else if (sideNum == 3) {
                ++kSide;
            }
            if (this.blockBlocksFlow(world, iSide, jSide, kSide) || world.g(iSide, jSide, kSide) == this.cO && this.isCementSourceBlock(world, iSide, jSide, kSide)) continue;
            this.tempClosestDownslopeToSideDist[sideNum] = !this.blockBlocksFlow(world, iSide, jSide - 1, kSide) ? 0 : this.recursivelyCheckSideBlocksForDownSlope(world, iSide, jSide, kSide, 1, sideNum);
        }
        int minDistanceToDownslope = this.tempClosestDownslopeToSideDist[0];
        for (tempSide = 1; tempSide < 4; ++tempSide) {
            if (this.tempClosestDownslopeToSideDist[tempSide] >= minDistanceToDownslope) continue;
            minDistanceToDownslope = this.tempClosestDownslopeToSideDist[tempSide];
        }
        for (tempSide = 0; tempSide < 4; ++tempSide) {
            this.tempSpreadToSideFlags[tempSide] = this.tempClosestDownslopeToSideDist[tempSide] == minDistanceToDownslope;
        }
        return this.tempSpreadToSideFlags;
    }

    private int recursivelyCheckSideBlocksForDownSlope(aab world, int i2, int j2, int k, int recursionCount, int originSideNum) {
        int closestDownslope = 1000;
        for (int tempSideNum = 0; tempSideNum < 4; ++tempSideNum) {
            int tempSideClosestDownslope;
            if (tempSideNum == 0 && originSideNum == 1 || tempSideNum == 1 && originSideNum == 0 || tempSideNum == 2 && originSideNum == 3 || tempSideNum == 3 && originSideNum == 2) continue;
            int tempi = i2;
            int tempj = j2;
            int tempk = k;
            if (tempSideNum == 0) {
                --tempi;
            } else if (tempSideNum == 1) {
                ++tempi;
            } else if (tempSideNum == 2) {
                --tempk;
            } else if (tempSideNum == 3) {
                ++tempk;
            }
            if (this.blockBlocksFlow(world, tempi, tempj, tempk) || this.getCementSpreadDist(world, tempi, tempj, tempk) == 0) continue;
            if (!this.blockBlocksFlow(world, tempi, tempj - 1, tempk)) {
                return recursionCount;
            }
            if (recursionCount >= 4 || (tempSideClosestDownslope = this.recursivelyCheckSideBlocksForDownSlope(world, tempi, tempj, tempk, recursionCount + 1, tempSideNum)) >= closestDownslope) continue;
            closestDownslope = tempSideClosestDownslope;
        }
        return closestDownslope;
    }

    private boolean blockBlocksFlow(aab world, int i2, int j2, int k) {
        apa block = r[world.a(i2, j2, k)];
        return block != null && block.cO != this.cO && block.getPreventsFluidFlow(world, i2, j2, k, (apa)((Object)this));
    }

    protected int checkForLesserSpreadDist(aab world, int i2, int j2, int k, int sourceSpreadDist) {
        int targetSpreadDist = this.getCementSpreadDist(world, i2, j2, k);
        if (targetSpreadDist < 0) {
            return sourceSpreadDist;
        }
        if (sourceSpreadDist < 0 || targetSpreadDist < sourceSpreadDist) {
            return targetSpreadDist;
        }
        return sourceSpreadDist;
    }

    private boolean isBlockOpenToSpread(aab world, int i2, int j2, int k) {
        if (j2 < 0) {
            return false;
        }
        aif material = world.g(i2, j2, k);
        if (material == this.cO) {
            return false;
        }
        return !this.blockBlocksFlow(world, i2, j2, k);
    }

    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        if (this.isCementPartiallyDry(blockAccess, i2, j2, k)) {
            return this.iconDrying;
        }
        return this.cQ;
    }

    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("fcBlockCement");
        this.iconDrying = register.a("fcBlockCement_drying");
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        return this.renderCement(renderBlocks, renderBlocks.a, i2, j2, k, (apa)((Object)this));
    }

    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        aif material = blockAccess.g(iNeighborI, iNeighborJ, iNeighborK);
        if (material == this.cO) {
            return false;
        }
        if (material == aif.v) {
            return false;
        }
        if (iSide == 1) {
            return true;
        }
        return super.a(blockAccess, iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Environment(value=EnvType.CLIENT)
    public float f(aak iblockaccess, int i2, int j2, int k) {
        float f1;
        float f2 = iblockaccess.q(i2, j2, k);
        return f2 <= (f1 = iblockaccess.q(i2, j2 + 1, k)) ? f1 : f2;
    }

    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random random) {
        if (!this.isCementPartiallyDry(world, i2, j2, k) && random.nextInt(250) == 0) {
            world.playSound((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k + 0.5f, "mob.ghast.moan", 0.5f, 2.6f + (world.s.nextFloat() - world.s.nextFloat()) * 0.8f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderCement(bgf renderblocks, aak iblockaccess, int i2, int j2, int k, apa block) {
        boolean bRenderAllFaces = false;
        bgd tessellator = bgd.a;
        tessellator.a(1.0f, 1.0f, 1.0f);
        boolean bTopFaceFlag = block.a(iblockaccess, i2, j2 + 1, k, 1);
        boolean bBottomFaceFlag = block.a(iblockaccess, i2, j2 - 1, k, 0);
        boolean[] bSideFaceFlags = new boolean[]{block.a(iblockaccess, i2, j2, k - 1, 2), block.a(iblockaccess, i2, j2, k + 1, 3), block.a(iblockaccess, i2 - 1, j2, k, 4), block.a(iblockaccess, i2 + 1, j2, k, 5)};
        if (!(bTopFaceFlag || bBottomFaceFlag || bSideFaceFlags[0] || bSideFaceFlags[1] || bSideFaceFlags[2] || bSideFaceFlags[3])) {
            return false;
        }
        boolean hasRendered = false;
        float f2 = 0.5f;
        float f1 = 1.0f;
        float f22 = 0.8f;
        float f3 = 0.6f;
        float cornerHeight1 = this.renderCementGetCornerHeightFromNeighbours(iblockaccess, i2, j2, k);
        float cornerHeight2 = this.renderCementGetCornerHeightFromNeighbours(iblockaccess, i2, j2, k + 1);
        float cornerHeight3 = this.renderCementGetCornerHeightFromNeighbours(iblockaccess, i2 + 1, j2, k + 1);
        float cornerHeight4 = this.renderCementGetCornerHeightFromNeighbours(iblockaccess, i2 + 1, j2, k);
        if (bRenderAllFaces || bTopFaceFlag) {
            hasRendered = true;
            lx i1 = block.b_(iblockaccess, i2, j2, k, 1);
            double x1 = i1.e();
            double x2 = i1.f();
            double y1 = i1.g();
            double y2 = i1.h();
            tessellator.c(block.e(iblockaccess, i2, j2 + 1, k));
            tessellator.a(i2 + 0, (float)j2 + cornerHeight1, k + 0, x1, y1);
            tessellator.a(i2 + 0, (float)j2 + cornerHeight2, k + 1, x1, y2);
            tessellator.a(i2 + 1, (float)j2 + cornerHeight3, k + 1, x2, y2);
            tessellator.a(i2 + 1, (float)j2 + cornerHeight4, k + 0, x2, y1);
        }
        if (bRenderAllFaces || bBottomFaceFlag) {
            tessellator.c(block.e(iblockaccess, i2, j2 - 1, k));
            renderblocks.a(block, (double)i2, (double)j2, (double)k, block.b_(iblockaccess, i2, j2, k, 0));
            hasRendered = true;
        }
        for (int iSide = 0; iSide < 4; ++iSide) {
            float f18;
            float f16;
            float f17;
            float f14;
            float f12;
            float f10;
            int k1 = i2;
            int i22 = j2;
            int k2 = k;
            if (iSide == 0) {
                --k2;
            } else if (iSide == 1) {
                ++k2;
            } else if (iSide == 2) {
                --k1;
            } else if (iSide == 3) {
                ++k1;
            }
            if (!bRenderAllFaces && !bSideFaceFlags[iSide]) continue;
            if (iSide == 0) {
                f10 = cornerHeight1;
                f12 = cornerHeight4;
                f14 = i2;
                f17 = i2 + 1;
                f16 = k;
                f18 = k;
            } else if (iSide == 1) {
                f10 = cornerHeight3;
                f12 = cornerHeight2;
                f14 = i2 + 1;
                f17 = i2;
                f16 = k + 1;
                f18 = k + 1;
            } else if (iSide == 2) {
                f10 = cornerHeight2;
                f12 = cornerHeight1;
                f14 = i2;
                f17 = i2;
                f16 = k + 1;
                f18 = k;
            } else {
                f10 = cornerHeight4;
                f12 = cornerHeight3;
                f14 = i2 + 1;
                f17 = i2 + 1;
                f16 = k;
                f18 = k + 1;
            }
            hasRendered = true;
            lx l2 = block.b_(iblockaccess, i2, j2, k, iSide + 2);
            double d4 = l2.e();
            double d5 = l2.f();
            double d6 = l2.b((1.0 - (double)f10) * 16.0);
            double d7 = l2.b((double)(1.0f - f12) * 16.0);
            double d8 = l2.h();
            tessellator.c(block.e(iblockaccess, k1, i22, k2));
            tessellator.a(f14, (float)j2 + f10, f16, d4, d6);
            tessellator.a(f17, (float)j2 + f12, f18, d5, d7);
            tessellator.a(f17, j2 + 0, f18, d5, d8);
            tessellator.a(f14, j2 + 0, f16, d4, d8);
        }
        return hasRendered;
    }

    @Environment(value=EnvType.CLIENT)
    public float renderCementGetCornerHeightFromNeighbours(aak iblockaccess, int i2, int j2, int k) {
        int numFactorsCount = 0;
        float f2 = 0.0f;
        for (int tempSide = 0; tempSide < 4; ++tempSide) {
            int tempi = i2 - (tempSide & 1);
            int tempj = j2;
            int tempk = k - (tempSide >> 1 & 1);
            if (iblockaccess.g(tempi, tempj + 1, tempk) == BTWBlocks.cementMaterial) {
                return 1.0f;
            }
            aif material1 = iblockaccess.g(tempi, tempj, tempk);
            if (material1 == BTWBlocks.cementMaterial) {
                if (iblockaccess.t(tempi, tempj + 1, tempk)) {
                    return 1.0f;
                }
                if (this.isCementSourceBlock(iblockaccess, tempi, tempj, tempk)) {
                    f2 += this.getRenderHeight(iblockaccess, tempi, tempj, tempk) * 10.0f;
                    numFactorsCount += 10;
                }
                f2 += this.getRenderHeight(iblockaccess, tempi, tempj, tempk);
                ++numFactorsCount;
                continue;
            }
            if (material1.a()) continue;
            f2 += 0.6f;
            ++numFactorsCount;
        }
        if (numFactorsCount > 0) {
            return 1.0f - f2 / (float)numFactorsCount;
        }
        return 1.0f;
    }
}

