/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.item.BTWItems;
import btw.item.util.ItemUtils;
import btw.world.util.WorldUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class CandleBlock
extends apa {
    private int metaDropped;

    public CandleBlock(int id, int metaDropped, String name) {
        super(id, BTWBlocks.candleMaterial);
        this.c(0.0f);
        this.setPicksEffectiveOn(true);
        this.setAxesEffectiveOn(true);
        this.a(1.0f);
        this.a(j);
        this.c(name);
        this.metaDropped = metaDropped;
    }

    @Override
    public int a(int par1, Random rand, int par3) {
        return BTWItems.candle.cp;
    }

    @Override
    public int a(int meta) {
        return this.metaDropped;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean c(aab world, int x2, int y2, int z2) {
        int blockBelowID = world.a(x2, y2 - 1, z2);
        int blockBelowMetadata = world.h(x2, y2 - 1, z2);
        if (blockBelowID == BTWBlocks.aestheticNonOpaque.cz && blockBelowMetadata == 12) {
            return true;
        }
        return WorldUtils.doesBlockHaveSmallCenterHardpointToFacing(world, x2, y2 - 1, z2, 1, true);
    }

    @Override
    public boolean a(aab world, int x2, int y2, int z2, sq player, int side, float hitX, float hitY, float hitZ) {
        if (player.cd() == null) {
            int metadata = world.h(x2, y2, z2);
            wm stack = new wm(this.a(metadata, world.s, 0), 1, this.a(metadata));
            ItemUtils.givePlayerStackOrEject(player, stack, x2, y2, z2);
            this.setCandleCount(world, x2, y2, z2, this.getCandleCount(metadata) - 1);
            return true;
        }
        return false;
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, int neighborBlockID) {
        if (!this.c(world, x2, y2, z2)) {
            this.c(world, x2, y2, z2, world.h(x2, y2, z2), 0);
            world.setBlockWithNotify(x2, y2, z2, 0);
        }
    }

    @Override
    public boolean isBlockRestingOnThatBelow(aak blockAccess, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public void onNeighborDisrupted(aab world, int x2, int y2, int z2, int toFacing) {
        if (toFacing == 0) {
            this.c(world, x2, y2, z2, world.h(x2, y2, z2), 0);
            world.setBlockWithNotify(x2, y2, z2, 0);
        }
    }

    @Override
    public boolean getPreventsFluidFlow(aab world, int x2, int y2, int z2, apa fluidBlock) {
        return false;
    }

    @Override
    public aqx b(aab world, int x2, int y2, int z2) {
        return null;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int x2, int y2, int z2) {
        int candleCount = this.getCandleCount(blockAccess, x2, y2, z2);
        switch (candleCount) {
            case 1: {
                return aqx.a().a(0.4375, 0.0, 0.4375, 0.5625, 0.4375, 0.5625);
            }
            case 2: {
                return aqx.a().a(0.3125, 0.0, 0.375, 0.6875, 0.4375, 0.5625);
            }
            case 3: {
                return aqx.a().a(0.375, 0.0, 0.375, 0.6875, 0.4375, 0.6875);
            }
            case 4: {
                return aqx.a().a(0.3125, 0.0, 0.3125, 0.6875, 0.4375, 0.625);
            }
        }
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public int getLightValue(aak blockAccess, int x2, int y2, int z2) {
        if (this.isLit(blockAccess, x2, y2, z2)) {
            int candleCount = this.getCandleCount(blockAccess, x2, y2, z2);
            return (int)((float)v[this.cz] * ((float)candleCount / 4.0f));
        }
        return 0;
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, int metadata, float chance, int fortuneModifier) {
        if (!world.I) {
            this.dropItemsIndividually(world, x2, y2, z2, this.a(metadata, world.s, 0), this.getCandleCount(world, x2, y2, z2), this.a(metadata), 1.0f);
        }
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int x2, int y2, int z2, int fromSide) {
        int candleCount = this.getCandleCount(world, x2, y2, z2);
        int metadata = world.h(x2, y2, z2);
        this.setCandleCount(world, x2, y2, z2, candleCount - 1);
        this.dropItemsIndividually(world, x2, y2, z2, this.a(metadata, world.s, 0), 1, this.a(metadata), 1.0f);
        return true;
    }

    @Override
    public boolean getCanBeSetOnFireDirectly(aak blockAccess, int x2, int y2, int z2) {
        return !this.isLit(blockAccess, x2, y2, z2);
    }

    @Override
    public boolean setOnFireDirectly(aab world, int x2, int y2, int z2) {
        if (!this.isLit(world, x2, y2, z2)) {
            this.setLit(world, x2, y2, z2, true);
            world.a((double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, "mob.ghast.fireball", 0.1f + world.s.nextFloat() * 0.1f, world.s.nextFloat() * 0.25f + 1.25f);
            return true;
        }
        return false;
    }

    @Override
    public boolean getCanBlockLightItemOnFire(aak blockAccess, int x2, int y2, int z2) {
        return this.isLit(blockAccess, x2, y2, z2);
    }

    public int getCandleCount(aak blockAccess, int x2, int y2, int z2) {
        int meta = blockAccess.h(x2, y2, z2);
        return this.getCandleCount(meta);
    }

    public int getCandleCount(int metadata) {
        return (metadata & 3) + 1;
    }

    public void setCandleCount(aab world, int x2, int y2, int z2, int count) {
        if (count == 0) {
            world.setBlockWithNotify(x2, y2, z2, 0);
            return;
        }
        if (count > 4) {
            IllegalArgumentException e2 = new IllegalArgumentException("Cannot set candle count higher than 4");
            e2.printStackTrace();
            count = 4;
        }
        int meta = world.h(x2, y2, z2);
        int newMeta = meta & 4;
        world.setBlockMetadataWithNotify(x2, y2, z2, newMeta += count - 1);
    }

    public boolean isLit(aak blockAccess, int x2, int y2, int z2) {
        return blockAccess.h(x2, y2, z2) >> 2 == 1;
    }

    public void setLit(aab world, int x2, int y2, int z2, boolean isLit) {
        int meta = world.h(x2, y2, z2);
        int newMeta = isLit ? meta | 4 : meta & 3;
        world.setBlockMetadataWithNotify(x2, y2, z2, newMeta);
    }

    public int setLit(int meta, boolean isLit) {
        int newMeta = isLit ? meta | 4 : meta & 3;
        return newMeta;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aab par1World, int par2, int par3, int par4) {
        return BTWItems.candle.cp;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int x2, int y2, int z2, Random rand) {
        if (!this.isLit(world, x2, y2, z2)) {
            return;
        }
        int meta = world.h(x2, y2, z2);
        int candleCount = this.getCandleCount(world, x2, y2, z2);
        double xPos = (float)x2 + 0.0625f;
        double yPos = (float)y2 + 0.5f;
        double zPos = (float)z2 + 0.0625f;
        switch (candleCount) {
            case 1: {
                xPos = (float)x2 + 0.5f;
                yPos = (float)y2 + 0.5f;
                zPos = (float)z2 + 0.5f;
                this.spawnParticles(world, xPos, yPos, zPos);
                break;
            }
            case 2: {
                xPos = (float)x2 + 0.625f;
                yPos = (float)y2 + 0.5f;
                zPos = (float)z2 + 0.5f;
                this.spawnParticles(world, xPos, yPos, zPos);
                xPos = (float)x2 + 0.375f;
                yPos = (float)y2 + 0.4375f;
                zPos = (float)z2 + 0.4375f;
                this.spawnParticles(world, xPos, yPos, zPos);
                break;
            }
            case 3: {
                xPos = (float)x2 + 0.625f;
                yPos = (float)y2 + 0.5f;
                zPos = (float)z2 + 0.5f;
                this.spawnParticles(world, xPos, yPos, zPos);
                xPos = (float)x2 + 0.4375f;
                yPos = (float)y2 + 0.4375f;
                zPos = (float)z2 + 0.4375f;
                this.spawnParticles(world, xPos, yPos, zPos);
                xPos = (float)x2 + 0.5f;
                yPos = (float)y2 + 0.3125f;
                zPos = (float)z2 + 0.625f;
                this.spawnParticles(world, xPos, yPos, zPos);
                break;
            }
            case 4: {
                xPos = (float)x2 + 0.625f;
                yPos = (float)y2 + 0.5f;
                zPos = (float)z2 + 0.375f;
                this.spawnParticles(world, xPos, yPos, zPos);
                xPos = (float)x2 + 0.4375f;
                yPos = (float)y2 + 0.4375f;
                zPos = (float)z2 + 0.375f;
                this.spawnParticles(world, xPos, yPos, zPos);
                xPos = (float)x2 + 0.5625f;
                yPos = (float)y2 + 0.3125f;
                zPos = (float)z2 + 0.5625f;
                this.spawnParticles(world, xPos, yPos, zPos);
                xPos = (float)x2 + 0.375f;
                yPos = (float)y2 + 0.375f;
                zPos = (float)z2 + 0.5625f;
                this.spawnParticles(world, xPos, yPos, zPos);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnParticles(aab world, double xPos, double yPos, double zPos) {
        world.a("fcsmallflame", xPos, yPos, zPos, 0.0, 0.0, 0.0);
        world.a("fcsmallflame", xPos, yPos, zPos, 0.0, 0.0, 0.0);
        world.a("fcsmallflame", xPos, yPos, zPos, 0.0, 0.0, 0.0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf render, int x2, int y2, int z2) {
        return this.renderBlockCandle(render, this, x2, y2, z2);
    }

    @Environment(value=EnvType.CLIENT)
    private boolean renderBlockCandle(bgf render, apa block, int x2, int y2, int z2) {
        bgd tess = bgd.a;
        tess.c(block.e(render.a, x2, y2, z2));
        tess.a(1.0f, 1.0f, 1.0f);
        int meta = render.a.h(x2, y2, z2);
        lx icon = this.b_(render.a, x2, y2, z2, meta);
        int candleCount = this.getCandleCount(render.a, x2, y2, z2);
        double minU = icon.a(0.0);
        double maxU = icon.a(2.0);
        double minV = icon.b(8.0);
        double maxV = icon.b(14.0);
        double minXOffset = 0.0;
        double maxXOffset = 0.125;
        double minYOffset = 0.0;
        double maxYOffset = 0.375;
        double minZOffset = 0.0;
        double maxZOffset = 0.125;
        double minX = (double)x2 + minXOffset;
        double maxX = (double)x2 + maxXOffset;
        double minY = (double)y2 + minYOffset;
        double maxY = (double)y2 + maxYOffset;
        double minZ = (double)z2 + minZOffset;
        double maxZ = (double)z2 + maxZOffset;
        switch (candleCount) {
            case 1: {
                minX = (double)x2 + 0.4375;
                maxX = (double)x2 + 0.5625;
                minY = (double)y2 + 0.0;
                maxY = (double)y2 + 0.375;
                minZ = (double)z2 + 0.4375;
                maxZ = (double)z2 + 0.5625;
                this.drawCandle(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                this.drawWick(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                break;
            }
            case 2: {
                minX = (double)x2 + 0.5625;
                maxX = (double)x2 + 0.6875;
                minY = (double)y2 + 0.0;
                maxY = (double)y2 + 0.375;
                minZ = (double)z2 + 0.4375;
                maxZ = (double)z2 + 0.5625;
                this.drawCandle(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                this.drawWick(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                minX = (double)x2 + 0.3125;
                maxX = (double)x2 + 0.4375;
                minY = (double)y2 + 0.0;
                maxY = (double)y2 + 0.3125;
                minZ = (double)z2 + 0.375;
                maxZ = (double)z2 + 0.5;
                maxV = icon.b(13.0);
                this.drawCandle(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                this.drawWick(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                break;
            }
            case 3: {
                minX = (double)x2 + 0.5625;
                maxX = (double)x2 + 0.6875;
                minY = (double)y2 + 0.0;
                maxY = (double)y2 + 0.375;
                minZ = (double)z2 + 0.4375;
                maxZ = (double)z2 + 0.5625;
                this.drawCandle(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                this.drawWick(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                minX = (double)x2 + 0.375;
                maxX = (double)x2 + 0.5;
                minY = (double)y2 + 0.0;
                maxY = (double)y2 + 0.3125;
                minZ = (double)z2 + 0.375;
                maxZ = (double)z2 + 0.5;
                maxV = icon.b(13.0);
                this.drawCandle(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                this.drawWick(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                minX = (double)x2 + 0.4375;
                maxX = (double)x2 + 0.5625;
                minY = (double)y2 + 0.0;
                maxY = (double)y2 + 0.1875;
                minZ = (double)z2 + 0.5625;
                maxZ = (double)z2 + 0.6875;
                maxV = icon.b(11.0);
                this.drawCandle(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                this.drawWick(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                break;
            }
            case 4: {
                minX = (double)x2 + 0.5625;
                maxX = (double)x2 + 0.6875;
                minY = (double)y2 + 0.0;
                maxY = (double)y2 + 0.375;
                minZ = (double)z2 + 0.3125;
                maxZ = (double)z2 + 0.4375;
                this.drawCandle(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                this.drawWick(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                minX = (double)x2 + 0.375;
                maxX = (double)x2 + 0.5;
                minY = (double)y2 + 0.0;
                maxY = (double)y2 + 0.3125;
                minZ = (double)z2 + 0.3125;
                maxZ = (double)z2 + 0.4375;
                maxV = icon.b(13.0);
                this.drawCandle(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                this.drawWick(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                minX = (double)x2 + 0.5;
                maxX = (double)x2 + 0.625;
                minY = (double)y2 + 0.0;
                maxY = (double)y2 + 0.1875;
                minZ = (double)z2 + 0.5;
                maxZ = (double)z2 + 0.625;
                maxV = icon.b(11.0);
                this.drawCandle(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                this.drawWick(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                minX = (double)x2 + 0.3125;
                maxX = (double)x2 + 0.4375;
                minY = (double)y2 + 0.0;
                maxY = (double)y2 + 0.25;
                minZ = (double)z2 + 0.5;
                maxZ = (double)z2 + 0.625;
                maxV = icon.b(12.0);
                this.drawCandle(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
                this.drawWick(tess, minX, maxX, minY, maxY, minZ, maxZ, minU, maxU, minV, maxV, icon);
            }
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private boolean drawCandle(bgd tess, double minX, double maxX, double minY, double maxY, double minZ, double maxZ, double minU, double maxU, double minV, double maxV, lx icon) {
        tess.a(minX, minY, minZ, minU, maxV);
        tess.a(minX, minY, maxZ, maxU, maxV);
        tess.a(minX, maxY, maxZ, maxU, minV);
        tess.a(minX, maxY, minZ, minU, minV);
        tess.a(maxX, minY, maxZ, minU, maxV);
        tess.a(maxX, minY, minZ, maxU, maxV);
        tess.a(maxX, maxY, minZ, maxU, minV);
        tess.a(maxX, maxY, maxZ, minU, minV);
        tess.a(maxX, minY, minZ, minU, maxV);
        tess.a(minX, minY, minZ, maxU, maxV);
        tess.a(minX, maxY, minZ, maxU, minV);
        tess.a(maxX, maxY, minZ, minU, minV);
        tess.a(minX, minY, maxZ, minU, maxV);
        tess.a(maxX, minY, maxZ, maxU, maxV);
        tess.a(maxX, maxY, maxZ, maxU, minV);
        tess.a(minX, maxY, maxZ, minU, minV);
        minU = icon.e();
        maxU = icon.a(2.0);
        minV = icon.b(6.0);
        maxV = icon.b(8.0);
        tess.a(minX, maxY, maxZ, minU, maxV);
        tess.a(maxX, maxY, maxZ, maxU, maxV);
        tess.a(maxX, maxY, minZ, maxU, minV);
        tess.a(minX, maxY, minZ, minU, minV);
        tess.a(minX, minY, minZ, minU, minV);
        tess.a(maxX, minY, minZ, maxU, minV);
        tess.a(maxX, minY, maxZ, maxU, maxV);
        tess.a(minX, minY, maxZ, minU, maxV);
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private boolean drawWick(bgd tess, double minX, double maxX, double minY, double maxY, double minZ, double maxZ, double minU, double maxU, double minV, double maxV, lx icon) {
        minU = icon.a(0.0);
        maxU = icon.a(1.0);
        minV = icon.b(5.0);
        maxV = icon.b(6.0);
        maxX = (minX += 0.046875) + 0.03125;
        minY = maxY;
        maxZ = (minZ += 0.046875) + 0.03125;
        tess.a(minX, minY, minZ, minU, maxV);
        tess.a(minX, minY, maxZ, maxU, maxV);
        tess.a(minX, maxY += 0.0625, maxZ, maxU, minV);
        tess.a(minX, maxY, minZ, minU, minV);
        tess.a(maxX, minY, maxZ, minU, maxV);
        tess.a(maxX, minY, minZ, maxU, maxV);
        tess.a(maxX, maxY, minZ, maxU, minV);
        tess.a(maxX, maxY, maxZ, minU, minV);
        tess.a(maxX, minY, minZ, minU, maxV);
        tess.a(minX, minY, minZ, maxU, maxV);
        tess.a(minX, maxY, minZ, maxU, minV);
        tess.a(maxX, maxY, minZ, minU, minV);
        tess.a(minX, minY, maxZ, minU, maxV);
        tess.a(maxX, minY, maxZ, maxU, maxV);
        tess.a(maxX, maxY, maxZ, maxU, minV);
        tess.a(minX, maxY, maxZ, minU, minV);
        tess.a(minX, maxY, maxZ, minU, maxV);
        tess.a(maxX, maxY, maxZ, maxU, maxV);
        tess.a(maxX, maxY, minZ, maxU, minV);
        tess.a(minX, maxY, minZ, minU, minV);
        tess.a(minX, minY, minZ, minU, minV);
        tess.a(maxX, minY, minZ, maxU, minV);
        tess.a(maxX, minY, maxZ, maxU, maxV);
        tess.a(minX, minY, maxZ, minU, maxV);
        return true;
    }
}

