/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.model.BlockModel;
import btw.block.model.CampfireModel;
import btw.block.tileentity.CampfireTileEntity;
import btw.client.render.util.RenderUtils;
import btw.crafting.manager.CampfireCraftingManager;
import btw.crafting.util.FurnaceBurnTime;
import btw.item.BTWItems;
import btw.item.util.ItemUtils;
import btw.util.MiscUtils;
import btw.world.util.WorldUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class CampfireBlock
extends akz {
    public final int fireLevel;
    public static final int CAMPFIRE_FUEL_STATE_NORMAL = 0;
    public static final int CAMPFIRE_FUEL_STATE_BURNED_OUT = 1;
    public static final int CAMPFIRE_FUEL_STATE_SMOULDERING = 2;
    private CampfireModel modelCampfire = new CampfireModel();
    private BlockModel modelCollisionBase;
    private BlockModel modelCollisionWithSpit;
    public static CampfireBlock[] fireLevelBlockArray = new CampfireBlock[4];
    public static boolean campfireChangingState = false;
    private static final float SPIT_THICKNESS = 0.0625f;
    private static final float HALF_SPIT_THICKNESS = 0.03125f;
    private static final float SPIT_HEIGHT = 0.75f;
    private static final float SPIT_MIN_Y = 0.71875f;
    private static final float SPIT_MAX_Y = 0.78125f;
    private static final float SPIT_SUPPORT_WIDTH = 0.0625f;
    private static final float HALF_SPIT_SUPPORT_WIDTH = 0.03125f;
    private static final float SPIT_SUPPORT_BORDER = 0.03125f;
    private static final float SPIT_FORK_WIDTH = 0.0625f;
    private static final float SPIT_FORK_HEIGHT = 0.1875f;
    private static final float SPIT_FORK_HEIGHT_OFFSET = 0.0625f;
    private static final float SPIT_FORK_MIN_Y = 0.65625f;
    private static final float SPIT_FORK_MAX_Y = 0.84375f;
    private static final double SPIT_COLLISION_HEIGHT = 0.84375;
    private static final double SPIT_COLLISION_WIDTH = 0.1875;
    private static final double SPIT_COLLISION_HALF_WIDTH = 0.09375;
    @Environment(value=EnvType.CLIENT)
    private lx spitIcon;
    @Environment(value=EnvType.CLIENT)
    private lx spitSupportIcon;
    @Environment(value=EnvType.CLIENT)
    private lx burnedIcon;
    @Environment(value=EnvType.CLIENT)
    private lx embersIcon;
    @Environment(value=EnvType.CLIENT)
    static final double[] fireAnimationScaleArray = new double[]{0.0, 0.25, 0.5, 0.875};

    public CampfireBlock(int iBlockID, int iFireLevel) {
        super(iBlockID, aif.q);
        this.fireLevel = iFireLevel;
        CampfireBlock.fireLevelBlockArray[iFireLevel] = this;
        this.c(0.1f);
        this.setBuoyant();
        this.setFurnaceBurnTime(4 * FurnaceBurnTime.SHAFT.burnTime);
        this.a(g);
        this.setAlwaysStartlesAnimals();
        this.c("fcBlockCampfire");
        this.initModels();
    }

    public aqp b(aab world) {
        return new CampfireTileEntity();
    }

    public void a(aab world, int i2, int j2, int k, int iBlockID, int iMetadata) {
        if (!campfireChangingState) {
            CampfireTileEntity tileEntity = (CampfireTileEntity)world.r(i2, j2, k);
            tileEntity.ejectContents();
            super.a(world, i2, j2, k, iBlockID, iMetadata);
        }
    }

    public boolean c() {
        return false;
    }

    public boolean b() {
        return false;
    }

    public aqx b(aab world, int i2, int j2, int k) {
        return null;
    }

    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        if (this.getHasSpit(blockAccess, i2, j2, k)) {
            return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.84375, 1.0);
        }
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    protected boolean r_() {
        return false;
    }

    public boolean c(aab world, int i2, int j2, int k) {
        if (!WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(world, i2, j2 - 1, k, 1, true)) {
            return false;
        }
        return super.c(world, i2, j2, k);
    }

    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        return this.setIAligned(iMetadata, this.isFacingIAligned(iFacing));
    }

    public void a(aab world, int i2, int j2, int k, ng entityLiving, wm stack) {
        int iFacing = MiscUtils.convertOrientationToFlatBlockFacingReversed(entityLiving);
        this.setIAligned(world, i2, j2, k, this.isFacingIAligned(iFacing));
        world.notifyNearbyAnimalsOfPlayerBlockAddOrRemove((sq)entityLiving, (apa)((Object)this), i2, j2, k);
    }

    public int a(int iMetadata, Random rand, int iFortuneModifier) {
        if (this.fireLevel != 0 || this.getFuelState(iMetadata) != 0) {
            return 0;
        }
        return super.a(iMetadata, rand, iFortuneModifier);
    }

    public int a(aab world) {
        return 2;
    }

    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        if (!WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(world, i2, j2 - 1, k, 1, true)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    public void a(aab world, int i2, int j2, int k, Random rand) {
        if (!WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(world, i2, j2 - 1, k, 1, true)) {
            if (this.fireLevel > 0) {
                world.e(2227, i2, j2, k, 1);
            }
            this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
            world.i(i2, j2, k);
        }
    }

    public boolean getCanBeSetOnFireDirectly(aak blockAccess, int i2, int j2, int k) {
        return this.fireLevel == 0 && this.getFuelState(blockAccess, i2, j2, k) == 0;
    }

    public boolean setOnFireDirectly(aab world, int i2, int j2, int k) {
        if (this.getCanBeSetOnFireDirectly(world, i2, j2, k)) {
            if (!this.isRainingOnCampfire(world, i2, j2, k)) {
                int iBlockBelowID;
                this.changeFireLevel(world, i2, j2, k, 1, world.h(i2, j2, k));
                CampfireTileEntity tileEntity = (CampfireTileEntity)world.r(i2, j2, k);
                tileEntity.onFirstLit();
                world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "mob.ghast.fireball", 1.0f, world.s.nextFloat() * 0.4f + 0.8f);
                if (!(apa.bi.n_(world, i2, j2, k) || (iBlockBelowID = world.a(i2, j2 - 1, k)) != apa.bf.cz && iBlockBelowID != BTWBlocks.fallingNetherrack.cz)) {
                    world.setBlockWithNotify(i2, j2, k, apa.av.cz);
                }
            } else {
                world.e(2227, i2, j2, k, 0);
            }
            return true;
        }
        return false;
    }

    public int getChanceOfFireSpreadingDirectlyTo(aak blockAccess, int i2, int j2, int k) {
        if (this.fireLevel == 0 && this.getFuelState(blockAccess, i2, j2, k) == 0) {
            return 60;
        }
        return 0;
    }

    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        wm stack = player.cd();
        if (stack != null) {
            int iItemDamage;
            wk item = stack.b();
            if (!this.getHasSpit(world, i2, j2, k)) {
                if (item == BTWItems.pointyStick) {
                    this.setHasSpit(world, i2, j2, k, true);
                    CampfireTileEntity tileEntity = (CampfireTileEntity)world.r(i2, j2, k);
                    tileEntity.setSpitStack(stack);
                    --stack.a;
                    return true;
                }
            } else {
                CampfireTileEntity tileEntity = (CampfireTileEntity)world.r(i2, j2, k);
                wm cookStack = tileEntity.getCookStack();
                if (cookStack == null) {
                    if (this.isValidCookItem(stack)) {
                        wm spitStack = tileEntity.getSpitStack();
                        if (spitStack.k() == 0) {
                            tileEntity.setCookStack(stack);
                        } else {
                            tileEntity.setSpitStack(null);
                            this.setHasSpit(world, i2, j2, k, false);
                            if (!world.I) {
                                wm ejectStack = stack.m();
                                ejectStack.a = 1;
                                ItemUtils.ejectStackWithRandomOffset(world, i2, j2, k, ejectStack);
                                ItemUtils.ejectSingleItemWithRandomOffset(world, i2, j2, k, BTWItems.sawDust.cp, 0);
                                world.e(2271, i2, j2, k, 0);
                            }
                        }
                        --stack.a;
                        return true;
                    }
                } else if (cookStack.c == stack.c && stack.a < stack.e()) {
                    player.q.a((mp)player, "random.pop", 0.2f, ((player.ab.nextFloat() - player.ab.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    ++stack.a;
                    tileEntity.setCookStack(null);
                    return true;
                }
            }
            if ((this.fireLevel > 0 || this.getFuelState(world, i2, j2, k) == 2) && item.getCanBeFedDirectlyIntoCampfire(iItemDamage = stack.k())) {
                if (!world.I) {
                    CampfireTileEntity tileEntity = (CampfireTileEntity)world.r(i2, j2, k);
                    world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "mob.ghast.fireball", 0.2f + world.s.nextFloat() * 0.1f, world.s.nextFloat() * 0.25f + 1.25f);
                    tileEntity.addBurnTime(item.getCampfireBurnTime(iItemDamage));
                }
                --stack.a;
                return true;
            }
        } else {
            CampfireTileEntity tileEntity = (CampfireTileEntity)world.r(i2, j2, k);
            wm cookStack = tileEntity.getCookStack();
            if (cookStack != null) {
                ItemUtils.givePlayerStackOrEject(player, cookStack, i2, j2, k);
                tileEntity.setCookStack(null);
                return true;
            }
            wm spitStack = tileEntity.getSpitStack();
            if (spitStack != null) {
                ItemUtils.givePlayerStackOrEject(player, spitStack, i2, j2, k);
                tileEntity.setSpitStack(null);
                this.setHasSpit(world, i2, j2, k, false);
                return true;
            }
        }
        return false;
    }

    public boolean shouldDeleteTileEntityOnBlockChange(int iNewBlockID) {
        for (int iTempIndex = 0; iTempIndex < fireLevelBlockArray.length; ++iTempIndex) {
            if (CampfireBlock.fireLevelBlockArray[iTempIndex].cz != iNewBlockID) continue;
            return false;
        }
        return true;
    }

    public void a(aab world, int i2, int j2, int k, mp entity) {
        rh entityItem;
        wm targetStack;
        wk item;
        int iBurnTime;
        if (!world.I && entity.R() && (this.fireLevel > 0 || this.getFuelState(world, i2, j2, k) == 2) && entity instanceof rh && (iBurnTime = (item = (targetStack = (entityItem = (rh)entity).d()).b()).getCampfireBurnTime(targetStack.k())) > 0) {
            CampfireTileEntity tileEntity = (CampfireTileEntity)world.r(i2, j2, k);
            world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "mob.ghast.fireball", world.s.nextFloat() * 0.1f + 0.2f, world.s.nextFloat() * 0.25f + 1.25f);
            tileEntity.addBurnTime(iBurnTime *= targetStack.a);
            entity.w();
        }
    }

    public boolean getDoesFireDamageToEntities(aab world, int i2, int j2, int k, mp entity) {
        return this.fireLevel > 2 || this.fireLevel == 2 && entity instanceof ng;
    }

    public boolean getCanBlockLightItemOnFire(aak blockAccess, int i2, int j2, int k) {
        return this.fireLevel > 0;
    }

    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        int iMetadata = world.h(i2, j2, k);
        BlockModel collisionModel = this.modelCollisionBase;
        if (this.getHasSpit(iMetadata)) {
            collisionModel = this.modelCollisionWithSpit;
        }
        if (this.getIsIAligned(iMetadata)) {
            collisionModel = collisionModel.makeTemporaryCopy();
            collisionModel.rotateAroundYToFacing(4);
        }
        return collisionModel.collisionRayTrace(world, i2, j2, k, startRay, endRay);
    }

    public void onFluidFlowIntoBlock(aab world, int i2, int j2, int k, ane newBlock) {
        if (this.fireLevel > 0) {
            world.e(2227, i2, j2, k, 0);
        }
        super.onFluidFlowIntoBlock(world, i2, j2, k, newBlock);
    }

    public boolean canBeCrushedByFallingEntity(aab world, int i2, int j2, int k, rg entity) {
        return true;
    }

    public void onCrushedByFallingEntity(aab world, int i2, int j2, int k, rg entity) {
        if (!world.I && this.fireLevel > 0) {
            world.e(2227, i2, j2, k, 0);
        }
    }

    public int getFacing(int iMetadata) {
        if (this.getIsIAligned(iMetadata)) {
            return 4;
        }
        return 2;
    }

    public int setFacing(int iMetadata, int iFacing) {
        return this.setIAligned(iMetadata, this.isFacingIAligned(iFacing));
    }

    public boolean canRotateOnTurntable(aak iBlockAccess, int i2, int j2, int k) {
        return true;
    }

    public boolean rotateAroundJAxis(aab world, int i2, int j2, int k, boolean bReverse) {
        this.setIAligned(world, i2, j2, k, !this.getIsIAligned(world, i2, j2, k));
        return true;
    }

    public int rotateMetadataAroundJAxis(int iMetadata, boolean bReverse) {
        return this.setIAligned(iMetadata, !this.getIsIAligned(iMetadata));
    }

    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        return this.fireLevel == 0 && world.w(i2, j2 - 1, k);
    }

    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        return -1.0f;
    }

    public void setIAligned(aab world, int i2, int j2, int k, boolean bIAligned) {
        int iMetadata = this.setIAligned(world.h(i2, j2, k), bIAligned);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public int setIAligned(int iMetadata, boolean bIAligned) {
        iMetadata = bIAligned ? (iMetadata |= 1) : (iMetadata &= 0xFFFFFFFE);
        return iMetadata;
    }

    public boolean getIsIAligned(aak blockAccess, int i2, int j2, int k) {
        return this.getIsIAligned(blockAccess.h(i2, j2, k));
    }

    public boolean getIsIAligned(int iMetadata) {
        return (iMetadata & 1) != 0;
    }

    public boolean isFacingIAligned(int iFacing) {
        return iFacing >= 4;
    }

    public void setHasSpit(aab world, int i2, int j2, int k, boolean bHasSpit) {
        int iMetadata = this.setHasSpit(world.h(i2, j2, k), bHasSpit);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public int setHasSpit(int iMetadata, boolean bHasSpit) {
        iMetadata = bHasSpit ? (iMetadata |= 2) : (iMetadata &= 0xFFFFFFFD);
        return iMetadata;
    }

    public boolean getHasSpit(aak blockAccess, int i2, int j2, int k) {
        return this.getHasSpit(blockAccess.h(i2, j2, k));
    }

    public boolean getHasSpit(int iMetadata) {
        return (iMetadata & 2) != 0;
    }

    public void setFuelState(aab world, int i2, int j2, int k, int iCampfireState) {
        int iMetadata = this.setFuelState(world.h(i2, j2, k), iCampfireState);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public int setFuelState(int iMetadata, int iCampfireState) {
        return (iMetadata &= 0xFFFFFFF3) | iCampfireState << 2;
    }

    public int getFuelState(aak blockAccess, int i2, int j2, int k) {
        return this.getFuelState(blockAccess.h(i2, j2, k));
    }

    public int getFuelState(int iMetadata) {
        return (iMetadata & 0xC) >> 2;
    }

    public boolean isValidCookItem(wm stack) {
        return CampfireCraftingManager.instance.getRecipeResult(stack.b().cp) != null;
    }

    public void extinguishFire(aab world, int i2, int j2, int k, boolean bSmoulder) {
        int iMetadata = world.h(i2, j2, k);
        iMetadata = bSmoulder ? this.setFuelState(iMetadata, 2) : this.setFuelState(iMetadata, 1);
        this.changeFireLevel(world, i2, j2, k, 0, iMetadata);
        if (!world.I) {
            world.e(2227, i2, j2, k, 1);
        }
    }

    public void relightFire(aab world, int i2, int j2, int k) {
        this.changeFireLevel(world, i2, j2, k, 1, this.setFuelState(world.h(i2, j2, k), 0));
    }

    public void stopSmouldering(aab world, int i2, int j2, int k) {
        this.setFuelState(world, i2, j2, k, 1);
    }

    public void changeFireLevel(aab world, int i2, int j2, int k, int iFireLevel, int iMetadata) {
        campfireChangingState = true;
        world.setBlockAndMetadataWithNotify(i2, j2, k, CampfireBlock.fireLevelBlockArray[iFireLevel].cz, iMetadata);
        campfireChangingState = false;
    }

    public boolean isRainingOnCampfire(aab world, int i2, int j2, int k) {
        return world.isRainingAtPos(i2, j2, k);
    }

    private void initModels() {
        this.modelCollisionBase = new BlockModel();
        this.modelCollisionWithSpit = new BlockModel();
        this.modelCollisionBase.addBox(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        this.modelCollisionWithSpit.addBox(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        this.modelCollisionWithSpit.addBox(0.0, 0.0, 0.40625, 1.0, 0.84375, 0.59375);
    }

    @Environment(value=EnvType.CLIENT)
    public int d(aab world, int x2, int y2, int z2) {
        return BTWBlocks.unlitCampfire.cz;
    }

    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("fcBlockCampfire");
        this.spitIcon = register.a("fcBlockCampfire_spit");
        this.spitSupportIcon = register.a("fcBlockCampfire_support");
        this.burnedIcon = register.a("fcBlockCampfire_burned");
        this.embersIcon = register.a("fcOverlayEmbers");
    }

    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        if (this.renderCampfireModel(renderBlocks, i2, j2, k)) {
            if (this.getHasSpit(renderBlocks.a, i2, j2, k)) {
                this.renderSpit(renderBlocks, i2, j2, k);
            }
            if (this.fireLevel > 0 && !renderBlocks.b()) {
                this.renderFirePortion(renderBlocks, i2, j2, k);
            }
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf renderer, int i2, int j2, int k, boolean bFirstPassResult) {
        if (bFirstPassResult && this.fireLevel == 0 && this.getFuelState(renderer.a, i2, j2, k) == 2) {
            this.renderCampfireModelEmbers(renderer, i2, j2, k);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        this.modelCampfire.renderAsItemBlock(renderBlocks, (apa)((Object)this), iItemDamage);
    }

    @Environment(value=EnvType.CLIENT)
    private boolean renderCampfireModelEmbers(bgf renderBlocks, int i2, int j2, int k) {
        int iMetadata = renderBlocks.a.h(i2, j2, k);
        BlockModel transformedModel = !WorldUtils.isGroundCoverOnBlock(renderBlocks.a, i2, j2, k) ? this.modelCampfire.makeTemporaryCopy() : this.modelCampfire.modelInSnow.makeTemporaryCopy();
        if (this.getIsIAligned(iMetadata)) {
            transformedModel.rotateAroundYToFacing(4);
        }
        return transformedModel.renderAsBlockFullBrightWithTexture(renderBlocks, (apa)((Object)this), i2, j2, k, this.embersIcon);
    }

    @Environment(value=EnvType.CLIENT)
    private boolean renderCampfireModel(bgf renderBlocks, int i2, int j2, int k) {
        int iMetadata = renderBlocks.a.h(i2, j2, k);
        BlockModel transformedModel = !WorldUtils.isGroundCoverOnBlock(renderBlocks.a, i2, j2, k) ? this.modelCampfire.makeTemporaryCopy() : this.modelCampfire.modelInSnow.makeTemporaryCopy();
        if (this.getIsIAligned(iMetadata)) {
            transformedModel.rotateAroundYToFacing(4);
        }
        if (this.getFuelState(iMetadata) != 0 && !renderBlocks.b()) {
            return transformedModel.renderAsBlockWithTexture(renderBlocks, (apa)((Object)this), i2, j2, k, this.burnedIcon);
        }
        return transformedModel.renderAsBlock(renderBlocks, (apa)((Object)this), i2, j2, k);
    }

    @Environment(value=EnvType.CLIENT)
    private void renderSpit(bgf renderBlocks, int i2, int j2, int k) {
        boolean bIAligned = this.getIsIAligned(renderBlocks.a, i2, j2, k);
        RenderUtils.setRenderBoundsWithAxisAlignment(renderBlocks, 0.0f, 0.71875f, 0.46875f, 1.0f, 0.78125f, 0.53125f, bIAligned);
        RenderUtils.renderStandardBlockWithTexture(renderBlocks, (apa)((Object)this), i2, j2, k, this.spitIcon);
        boolean bRenderSupport = true;
        if (bIAligned && !WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(renderBlocks.a, i2, j2, k - 1, 3) || !bIAligned && !WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(renderBlocks.a, i2 - 1, j2, k, 5)) {
            this.renderSpitSupport(renderBlocks, i2, j2, k, 0.03125f);
        }
        if (bIAligned && !WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(renderBlocks.a, i2, j2, k + 1, 2) || !bIAligned && !WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(renderBlocks.a, i2 + 1, j2, k, 4)) {
            this.renderSpitSupport(renderBlocks, i2, j2, k, 0.90625f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void renderSpitSupport(bgf renderBlocks, int i2, int j2, int k, float fOffset) {
        boolean bIAligned = this.getIsIAligned(renderBlocks.a, i2, j2, k);
        RenderUtils.setRenderBoundsWithAxisAlignment(renderBlocks, fOffset, 0.0f, 0.46875f, fOffset + 0.0625f, 0.71875f, 0.53125f, bIAligned);
        RenderUtils.renderStandardBlockWithTexture(renderBlocks, (apa)((Object)this), i2, j2, k, this.spitSupportIcon);
        RenderUtils.setRenderBoundsWithAxisAlignment(renderBlocks, fOffset, 0.65625f, 0.53125f, fOffset + 0.0625f, 0.84375f, 0.59375f, bIAligned);
        RenderUtils.renderStandardBlockWithTexture(renderBlocks, (apa)((Object)this), i2, j2, k, this.spitSupportIcon);
        RenderUtils.setRenderBoundsWithAxisAlignment(renderBlocks, fOffset, 0.65625f, 0.40625f, fOffset + 0.0625f, 0.84375f, 0.46875f, bIAligned);
        RenderUtils.renderStandardBlockWithTexture(renderBlocks, (apa)((Object)this), i2, j2, k, this.spitSupportIcon);
    }

    @Environment(value=EnvType.CLIENT)
    private void renderFirePortion(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        bgd tesselator = bgd.a;
        double dScale = fireAnimationScaleArray[this.fireLevel];
        double dI = i2;
        double dJ = j2;
        double dK = k;
        lx fireTexture1 = apa.av.c(0);
        lx fireTexture2 = apa.av.c(1);
        if ((i2 + k & 1) != 0) {
            fireTexture1 = apa.av.c(1);
            fireTexture2 = apa.av.c(0);
        }
        tesselator.a(1.0f, 1.0f, 1.0f);
        tesselator.c(this.e(blockAccess, i2, j2, k));
        double dMinU = fireTexture1.e();
        double dMinV = fireTexture1.g();
        double dMaxU = fireTexture1.f();
        double dMaxV = fireTexture1.h();
        double dFireHeight = 1.4 * dScale;
        double dHorizontalMin = 0.5 - 0.5 * dScale;
        double dHorizontalMax = 0.5 + 0.5 * dScale;
        double dOffset = 0.2 * dScale;
        double var18 = dI + 0.5 + dOffset;
        double var20 = dI + 0.5 - dOffset;
        double var22 = dK + 0.5 + dOffset;
        double var24 = dK + 0.5 - dOffset;
        dOffset = 0.3 * dScale;
        double var26 = dI + 0.5 - dOffset;
        double var28 = dI + 0.5 + dOffset;
        double var30 = dK + 0.5 - dOffset;
        double var32 = dK + 0.5 + dOffset;
        tesselator.a(var26, dJ + dFireHeight, dK + dHorizontalMax, dMaxU, dMinV);
        tesselator.a(var18, dJ + 0.0, dK + dHorizontalMax, dMaxU, dMaxV);
        tesselator.a(var18, dJ + 0.0, dK + dHorizontalMin, dMinU, dMaxV);
        tesselator.a(var26, dJ + dFireHeight, dK + dHorizontalMin, dMinU, dMinV);
        tesselator.a(var28, dJ + dFireHeight, dK + dHorizontalMin, dMaxU, dMinV);
        tesselator.a(var20, dJ + 0.0, dK + dHorizontalMin, dMaxU, dMaxV);
        tesselator.a(var20, dJ + 0.0, dK + dHorizontalMax, dMinU, dMaxV);
        tesselator.a(var28, dJ + dFireHeight, dK + dHorizontalMax, dMinU, dMinV);
        dMinU = fireTexture2.e();
        dMinV = fireTexture2.g();
        dMaxU = fireTexture2.f();
        dMaxV = fireTexture2.h();
        tesselator.a(dI + dHorizontalMax, dJ + dFireHeight, var32, dMaxU, dMinV);
        tesselator.a(dI + dHorizontalMax, dJ + 0.0, var24, dMaxU, dMaxV);
        tesselator.a(dI + dHorizontalMin, dJ + 0.0, var24, dMinU, dMaxV);
        tesselator.a(dI + dHorizontalMin, dJ + dFireHeight, var32, dMinU, dMinV);
        tesselator.a(dI + dHorizontalMin, dJ + dFireHeight, var30, dMaxU, dMinV);
        tesselator.a(dI + dHorizontalMin, dJ + 0.0, var22, dMaxU, dMaxV);
        tesselator.a(dI + dHorizontalMax, dJ + 0.0, var22, dMinU, dMaxV);
        tesselator.a(dI + dHorizontalMax, dJ + dFireHeight, var30, dMinU, dMinV);
        dOffset = 0.5 * dScale;
        var18 = dI + 0.5 - dOffset;
        var20 = dI + 0.5 + dOffset;
        var22 = dK + 0.5 - dOffset;
        var24 = dK + 0.5 + dOffset;
        dOffset = 0.4 * dScale;
        var26 = dI + 0.5 - dOffset;
        var28 = dI + 0.5 + dOffset;
        var30 = dK + 0.5 - dOffset;
        var32 = dK + 0.5 + dOffset;
        tesselator.a(var26, dJ + dFireHeight, dK + dHorizontalMin, dMinU, dMinV);
        tesselator.a(var18, dJ + 0.0, dK + dHorizontalMin, dMinU, dMaxV);
        tesselator.a(var18, dJ + 0.0, dK + dHorizontalMax, dMaxU, dMaxV);
        tesselator.a(var26, dJ + dFireHeight, dK + dHorizontalMax, dMaxU, dMinV);
        tesselator.a(var28, dJ + dFireHeight, dK + dHorizontalMax, dMinU, dMinV);
        tesselator.a(var20, dJ + 0.0, dK + dHorizontalMax, dMinU, dMaxV);
        tesselator.a(var20, dJ + 0.0, dK + dHorizontalMin, dMaxU, dMaxV);
        tesselator.a(var28, dJ + dFireHeight, dK + dHorizontalMin, dMaxU, dMinV);
        dMinU = fireTexture1.e();
        dMinV = fireTexture1.g();
        dMaxU = fireTexture1.f();
        dMaxV = fireTexture1.h();
        tesselator.a(dI + dHorizontalMin, dJ + dFireHeight, var32, dMinU, dMinV);
        tesselator.a(dI + dHorizontalMin, dJ + 0.0, var24, dMinU, dMaxV);
        tesselator.a(dI + dHorizontalMax, dJ + 0.0, var24, dMaxU, dMaxV);
        tesselator.a(dI + dHorizontalMax, dJ + dFireHeight, var32, dMaxU, dMinV);
        tesselator.a(dI + dHorizontalMax, dJ + dFireHeight, var30, dMinU, dMinV);
        tesselator.a(dI + dHorizontalMax, dJ + 0.0, var22, dMinU, dMaxV);
        tesselator.a(dI + dHorizontalMin, dJ + 0.0, var22, dMaxU, dMaxV);
        tesselator.a(dI + dHorizontalMin, dJ + dFireHeight, var30, dMaxU, dMinV);
    }

    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random rand) {
        if (this.fireLevel > 1) {
            for (int iTempCount = 0; iTempCount < this.fireLevel; ++iTempCount) {
                double xPos = (float)i2 + rand.nextFloat();
                double yPos = (float)j2 + 0.5f + rand.nextFloat() * 0.5f;
                double zPos = (float)k + rand.nextFloat();
                world.a("smoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
            }
            CampfireTileEntity tileEntity = (CampfireTileEntity)world.r(i2, j2, k);
            if (tileEntity.getIsFoodBurning()) {
                for (int iTempCount = 0; iTempCount < 1; ++iTempCount) {
                    double xPos = (float)i2 + 0.375f + rand.nextFloat() * 0.25f;
                    double yPos = (float)j2 + 0.5f + rand.nextFloat() * 0.5f;
                    double zPos = (float)k + 0.375f + rand.nextFloat() * 0.25f;
                    world.a("largesmoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
                }
            } else if (tileEntity.getIsCooking()) {
                for (int iTempCount = 0; iTempCount < 1; ++iTempCount) {
                    double xPos = (float)i2 + 0.375f + rand.nextFloat() * 0.25f;
                    double yPos = (float)j2 + 0.5f + rand.nextFloat() * 0.5f;
                    double zPos = (float)k + 0.375f + rand.nextFloat() * 0.25f;
                    world.a("fcwhitesmoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
                }
            }
        } else if (this.fireLevel == 1 || this.getFuelState(world, i2, j2, k) == 2) {
            double xPos = (double)i2 + 0.375 + rand.nextDouble() * 0.25;
            double yPos = (double)j2 + 0.25 + rand.nextDouble() * 0.25;
            double zPos = (double)k + 0.375 + rand.nextDouble() * 0.25;
            world.a("smoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
        }
        if (this.fireLevel > 0 && rand.nextInt(24) == 0) {
            float fVolume = (float)this.fireLevel * 0.25f + rand.nextFloat();
            world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "fire.fire", fVolume, rand.nextFloat() * 0.7f + 0.3f, false);
        }
    }
}

