/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class BuddyBlock
extends apa {
    private static final int TICK_RATE = 5;
    @Environment(value=EnvType.CLIENT)
    private lx iconOn;
    @Environment(value=EnvType.CLIENT)
    private lx iconFront;
    @Environment(value=EnvType.CLIENT)
    private lx iconFrontOn;

    public BuddyBlock(int iBlockID) {
        super(iBlockID, aif.e);
        this.c(3.5f);
        this.b(true);
        this.a(j);
        this.c("fcBlockBuddyBlock");
        this.a(ve.d);
    }

    @Override
    public int a(aab world) {
        return 5;
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, 1);
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        return this.setFacing(iMetadata, apa.getOppositeFacing(iFacing));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, ng entityLiving, wm stack) {
        int iFacing = MiscUtils.convertPlacingEntityOrientationToBlockFacingReversed(entityLiving);
        this.setFacing(world, i2, j2, k, iFacing);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        apa neighborBlock;
        if (!this.isRedstoneOn(world, i2, j2, k) && (neighborBlock = r[iNeighborBlockID]) != null && neighborBlock.triggersBuddy() && !world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, 1);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        if (this.isRedstoneOn(world, i2, j2, k)) {
            this.setBlockRedstoneOn(world, i2, j2, k, false);
        } else {
            this.setBlockRedstoneOn(world, i2, j2, k, true);
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (this.isRedstoneOn(world, i2, j2, k) && !world.isUpdateScheduledForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    @Override
    public int b(aak blockAccess, int i2, int j2, int k, int iSide) {
        return this.getPowerProvided(blockAccess, i2, j2, k, iSide);
    }

    @Override
    public int c(aak blockAccess, int i2, int j2, int k, int iSide) {
        return this.getPowerProvided(blockAccess, i2, j2, k, iSide);
    }

    @Override
    public boolean f() {
        return true;
    }

    @Override
    public int getFacing(int iMetadata) {
        return (iMetadata & 0xFFFFFFFE) >> 1;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata = iMetadata & 1 | iFacing << 1;
        return iMetadata;
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iFacing = this.getFacing(world, i2, j2, k);
        iFacing = apa.cycleFacing(iFacing, bReverse);
        this.setFacing(world, i2, j2, k, iFacing);
        world.g(i2, j2, k, i2, j2, k);
        return true;
    }

    @Override
    public boolean triggersBuddy() {
        return false;
    }

    @Override
    public int onPreBlockPlacedByPiston(aab world, int i2, int j2, int k, int iMetadata, int iDirectionMoved) {
        BlockPos originPos = new BlockPos(i2, j2, k, BuddyBlock.getOppositeFacing(iDirectionMoved));
        this.notifyNeigborsToFacingOfPowerChange(world, originPos.x, originPos.y, originPos.z, this.getFacing(iMetadata));
        return iMetadata;
    }

    public int getPowerProvided(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (apa.getOppositeFacing(iSide) == iFacing && this.isRedstoneOn(blockAccess, i2, j2, k)) {
            return 15;
        }
        return 0;
    }

    public boolean isRedstoneOn(aak iblockaccess, int i2, int j2, int k) {
        return (iblockaccess.h(i2, j2, k) & 1) > 0;
    }

    public void setBlockRedstoneOn(aab world, int i2, int j2, int k, boolean bOn) {
        if (bOn != this.isRedstoneOn(world, i2, j2, k)) {
            int iMetaData = world.h(i2, j2, k);
            if (bOn) {
                iMetaData |= 1;
                world.e(2234, i2, j2, k, 0);
            } else {
                iMetaData &= 0xFFFFFFFE;
            }
            world.setBlockMetadataWithClient(i2, j2, k, iMetaData);
            int iFacing = this.getFacing(world, i2, j2, k);
            this.notifyNeigborsToFacingOfPowerChange(world, i2, j2, k, iFacing);
            world.g(i2, j2, k, i2, j2, k);
        }
    }

    public void notifyNeigborsToFacingOfPowerChange(aab world, int i2, int j2, int k, int iFacing) {
        BlockPos outputPos = new BlockPos(i2, j2, k);
        outputPos.addFacingAsOffset(iFacing);
        apa outputBlock = apa.r[world.a(outputPos.x, outputPos.y, outputPos.z)];
        if (outputBlock != null) {
            outputBlock.a(world, outputPos.x, outputPos.y, outputPos.z, this.cz);
        }
        world.f(outputPos.x, outputPos.y, outputPos.z, this.cz);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconOn = register.a("fcBlockBuddyBlock_on");
        this.iconFront = register.a("fcBlockBuddyBlock_front");
        this.iconFrontOn = register.a("fcBlockBuddyBlock_front_on");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 3) {
            return this.iconFront;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (iFacing == iSide) {
            if (this.isRedstoneOn(blockAccess, i2, j2, k)) {
                return this.iconFrontOn;
            }
            return this.iconFront;
        }
        if (this.isRedstoneOn(blockAccess, i2, j2, k)) {
            return this.iconOn;
        }
        return this.cQ;
    }
}

