/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.BucketBlock;
import btw.block.model.BucketFullModel;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public abstract class BucketBlockFull
extends BucketBlock {
    public BucketBlockFull(int iBlockID) {
        super(iBlockID);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        if (!this.checkForFall(world, i2, j2, k)) {
            this.checkForSpillContents(world, i2, j2, k);
        }
    }

    @Override
    protected void initModels() {
        this.model = new BucketFullModel();
        this.modelTransformed = this.model;
    }

    public void checkForSpillContents(aab world, int i2, int j2, int k) {
        int iFacing = this.getFacing(world, i2, j2, k);
        if (iFacing >= 2) {
            BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
            if (this.attemptToSpillIntoBlock(world, targetPos.x, targetPos.y, targetPos.z) && world.a(i2, j2, k) == this.cz) {
                world.setBlockAndMetadataWithNotify(i2, j2, k, BTWBlocks.placedBucket.cz, this.setFacing(0, iFacing));
            }
        }
    }

    public abstract boolean attemptToSpillIntoBlock(aab var1, int var2, int var3, int var4);

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldSideBeRenderedOnFallingBlock(int iSide, int iMetadata) {
        int iFacing = this.getFacing(iMetadata);
        int iActiveID = this.modelTransformed.getActivePrimitiveID();
        if (iActiveID == 4) {
            return iFacing == iSide;
        }
        return super.shouldSideBeRenderedOnFallingBlock(iSide, iMetadata);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (this.modelTransformed.getActivePrimitiveID() == 4) {
            return this.getContentsIcon();
        }
        return super.a(iSide, iMetadata);
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract lx getContentsIcon();
}

