/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.FallingBlock;
import btw.block.model.BlockModel;
import btw.block.model.BucketModel;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class BucketBlock
extends FallingBlock {
    protected BucketModel model;
    protected BlockModel modelTransformed;
    @Environment(value=EnvType.CLIENT)
    private lx iconOpenTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconOpenSide;
    @Environment(value=EnvType.CLIENT)
    private static aqx selectionBox = new aqx(0.28125, 0.0625, 0.28125, 0.71875, 0.5, 0.71875);

    public BucketBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.miscMaterial);
        this.c(0.0f);
        this.b(0.0f);
        this.initBlockBounds(0.28125, 0.0625, 0.28125, 0.71875, 0.5, 0.71875);
        this.a(apa.k);
        this.c("bucket");
        this.initModels();
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        iMetadata = this.setFacing(iMetadata, iFacing);
        return iMetadata;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, ng entityLiving, wm stack) {
        this.setFacing(world, i2, j2, k, 1);
    }

    @Override
    public int a(int iMetadata, Random rand, int iFortuneMod) {
        return wk.ax.cp;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChance) {
        this.dropItemsIndividually(world, i2, j2, k, wk.ax.cp, 1, 0, fChance);
        return true;
    }

    @Override
    public aqx b(aab world, int i2, int j2, int k) {
        return null;
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        this.modelTransformed = this.model.makeTemporaryCopy();
        int iFacing = this.getFacing(world, i2, j2, k);
        this.modelTransformed.tiltToFacingAlongY(iFacing);
        BucketModel.offsetModelForFacing(this.modelTransformed, iFacing);
        return this.modelTransformed.collisionRayTrace(world, i2, j2, k, startRay, endRay);
    }

    @Override
    public int getFacing(int iMetadata) {
        return iMetadata & 7;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        return (iMetadata &= 0xFFFFFFF8) | iFacing;
    }

    @Override
    public int onPreBlockPlacedByPiston(aab world, int i2, int j2, int k, int iMetadata, int iDirectionMoved) {
        if (!WorldUtils.doesBlockHaveCenterHardpointToFacing(world, i2, j2 - 1, k, 1, true) && iDirectionMoved >= 2) {
            int iFacing = this.getFacing(iMetadata);
            if (iFacing == 0) {
                iFacing = apa.getOppositeFacing(iDirectionMoved);
            } else if (iFacing == 1) {
                iFacing = iDirectionMoved;
            } else if (iFacing == iDirectionMoved) {
                iFacing = 0;
            } else if (iFacing == apa.getOppositeFacing(iDirectionMoved)) {
                iFacing = 1;
            }
            iMetadata = this.setFacing(iMetadata, iFacing);
        }
        return iMetadata;
    }

    @Override
    public boolean getPreventsFluidFlow(aab world, int i2, int j2, int k, apa fluidBlock) {
        return false;
    }

    @Override
    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        return world.w(i2, j2 - 1, k);
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        return -1.0f;
    }

    protected void initModels() {
        this.model = new BucketModel();
        this.modelTransformed = this.model;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("fcBlockBucketEmpty");
        this.iconOpenTop = register.a("fcBlockBucketEmpty_top");
        this.iconOpenSide = register.a("fcBlockBucketEmpty_top_side");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        int iFacing;
        if (this.modelTransformed.getActivePrimitiveID() == 2 && ((iFacing = this.getFacing(iMetadata)) == iSide || iFacing == apa.getOppositeFacing(iSide))) {
            if (iFacing < 2) {
                return this.iconOpenTop;
            }
            return this.iconOpenSide;
        }
        return super.a(iSide, iMetadata);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        BlockPos myPos = new BlockPos(iNeighborI, iNeighborJ, iNeighborK, apa.getOppositeFacing(iSide));
        int iMetadata = blockAccess.h(myPos.x, myPos.y, myPos.z);
        return this.shouldSideBeRenderedOnFallingBlock(iSide, iMetadata);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldSideBeRenderedOnFallingBlock(int iSide, int iMetadata) {
        int iFacing = this.getFacing(iMetadata);
        int iActiveID = this.modelTransformed.getActivePrimitiveID();
        if (iActiveID == 3) {
            return iSide != apa.getOppositeFacing(iFacing);
        }
        if (iSide == iFacing) {
            return iActiveID == 2;
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        this.modelTransformed = this.model.makeTemporaryCopy();
        int iFacing = this.getFacing(renderBlocks.a, i2, j2, k);
        this.modelTransformed.tiltToFacingAlongY(iFacing);
        BucketModel.offsetModelForFacing(this.modelTransformed, iFacing);
        return this.modelTransformed.renderAsBlock(renderBlocks, this, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        this.modelTransformed = this.model;
        this.modelTransformed.renderAsItemBlock(renderBlocks, this, iItemDamage);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderFallingBlock(bgf renderBlocks, int i2, int j2, int k, int iMetadata) {
        this.modelTransformed = this.model.makeTemporaryCopy();
        int iFacing = this.getFacing(iMetadata);
        this.modelTransformed.tiltToFacingAlongY(iFacing);
        BucketModel.offsetModelForFacing(this.modelTransformed, iFacing);
        this.modelTransformed.renderAsFallingBlock(renderBlocks, this, i2, j2, k, iMetadata);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockMovedByPiston(bgf renderBlocks, int i2, int j2, int k) {
        this.renderBlock(renderBlocks, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public aqx getSelectedBoundingBoxFromPool(aab world, ara rayTraceHit) {
        int i2 = rayTraceHit.b;
        int j2 = rayTraceHit.c;
        int k = rayTraceHit.d;
        int iFacing = this.getFacing(world, i2, j2, k);
        aqx tempBox = selectionBox.makeTemporaryCopy();
        if (iFacing != 1) {
            tempBox.tiltToFacingAlongY(iFacing);
            arc offset = BucketModel.getOffsetForFacing(iFacing);
            tempBox.translate(offset.c, offset.d, offset.e);
        }
        return tempBox.d(i2, j2, k);
    }
}

