/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.util.Flammability;
import btw.crafting.util.FurnaceBurnTime;
import btw.item.BTWItems;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class BloodWoodLogBlock
extends apa {
    private static final float HARDNESS = 2.0f;
    @Environment(value=EnvType.CLIENT)
    private lx iconSide;

    public BloodWoodLogBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.logMaterial);
        this.c(2.0f);
        this.setAxesEffectiveOn(true);
        this.setBuoyancy(1.0f);
        this.setFurnaceBurnTime(4 * FurnaceBurnTime.PLANKS_BLOOD.burnTime);
        this.setFireProperties(Flammability.EXTREME);
        this.b(true);
        this.a(BTWBlocks.stepSoundSquish);
        this.c("fcBlockBloodWood");
        this.a(ve.b);
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        iMetadata = this.setFacing(iMetadata, iFacing);
        return iMetadata;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID, int iMetadata) {
        world.e(2225, i2, j2, k, 0);
        this.notifySurroundingBloodLeavesOfBlockRemoval(world, i2, j2, k);
        super.a(world, i2, j2, k, iBlockID, iMetadata);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        if (this.getCanGrow(world, i2, j2, k)) {
            int iGrowthDirection = this.getFacing(world, i2, j2, k);
            if (iGrowthDirection != 0 && world.t.h == -1) {
                this.grow(world, i2, j2, k, random);
            }
            this.setCanGrow(world, i2, j2, k, false);
        }
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, 4, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.bark.cp, 1, 4, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.soulDust.cp, 1, 0, fChanceOfDrop);
        return true;
    }

    @Override
    public int getFacing(int iMetadata) {
        return iMetadata & 7;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata &= 0xFFFFFFF8;
        return iMetadata |= iFacing;
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iFacing = this.getFacing(world, i2, j2, k);
        iFacing = apa.cycleFacing(iFacing, bReverse);
        this.setFacing(world, i2, j2, k, iFacing);
        world.g(i2, j2, k, i2, j2, k);
        return true;
    }

    @Override
    public boolean isLog(aak blockAccess, int x2, int y2, int z2) {
        return true;
    }

    public boolean getCanGrow(aak blockAccess, int i2, int j2, int k) {
        return (blockAccess.h(i2, j2, k) & 8) > 0;
    }

    public void setCanGrow(aab world, int i2, int j2, int k, boolean bCanGrow) {
        int iMetaData = world.h(i2, j2, k) & 0xFFFFFFF7;
        if (bCanGrow) {
            iMetaData |= 8;
        }
        world.setBlockMetadata(i2, j2, k, iMetaData);
    }

    public void grow(aab world, int i2, int j2, int k, Random random) {
        if (this.countBloodWoodNeighboringOnBlockWithSoulSand(world, i2, j2, k) >= 2) {
            return;
        }
        int iGrowthDirection = this.getFacing(world, i2, j2, k);
        if (iGrowthDirection == 1) {
            int iRandomFactor = random.nextInt(100);
            if (iRandomFactor < 25) {
                this.attemptToGrowIntoBlock(world, i2, j2 + 1, k, 1);
            } else if (iRandomFactor < 90) {
                int iTargetFacing = random.nextInt(4) + 2;
                BlockPos targetPos = new BlockPos(i2, j2, k);
                targetPos.addFacingAsOffset(iTargetFacing);
                this.attemptToGrowIntoBlock(world, targetPos.x, targetPos.y, targetPos.z, iTargetFacing);
                this.attemptToGrowIntoBlock(world, i2, j2 + 1, k, 1);
            } else {
                for (int iTempCount = 0; iTempCount < 2; ++iTempCount) {
                    int iTargetFacing = random.nextInt(4) + 2;
                    BlockPos targetPos = new BlockPos(i2, j2, k);
                    targetPos.addFacingAsOffset(iTargetFacing);
                    this.attemptToGrowIntoBlock(world, targetPos.x, targetPos.y, targetPos.z, iTargetFacing);
                }
            }
        } else {
            int iRandomFactor = random.nextInt(100);
            if (iRandomFactor < 40) {
                this.attemptToGrowIntoBlock(world, i2, j2 + 1, k, iGrowthDirection);
                this.setFacing(world, i2, j2, k, 1);
            } else if (iRandomFactor < 65) {
                BlockPos targetPos = new BlockPos(i2, j2, k);
                targetPos.addFacingAsOffset(iGrowthDirection);
                this.attemptToGrowIntoBlock(world, targetPos.x, targetPos.y, targetPos.z, iGrowthDirection);
            } else if (iRandomFactor < 90) {
                int iTargetFacing = random.nextInt(4) + 2;
                if (iTargetFacing == iGrowthDirection) {
                    iTargetFacing = 1;
                }
                BlockPos targetPos = new BlockPos(i2, j2, k);
                targetPos.addFacingAsOffset(iTargetFacing);
                int iTargetGrowthDirection = iGrowthDirection;
                if (iTargetFacing >= 2) {
                    iTargetGrowthDirection = iTargetFacing;
                }
                this.attemptToGrowIntoBlock(world, targetPos.x, targetPos.y, targetPos.z, iTargetGrowthDirection);
                targetPos = new BlockPos(i2, j2, k);
                targetPos.addFacingAsOffset(iGrowthDirection);
                if (!this.attemptToGrowIntoBlock(world, targetPos.x, targetPos.y, targetPos.z, iGrowthDirection) && iTargetFacing == 1) {
                    this.setFacing(world, i2, j2, k, 1);
                }
            } else {
                int[] iGrowthDirections = new int[2];
                for (int iTempCount = 0; iTempCount < 2; ++iTempCount) {
                    iGrowthDirections[iTempCount] = 0;
                    int iTargetFacing = random.nextInt(4) + 2;
                    if (iTargetFacing == iGrowthDirection) {
                        iTargetFacing = 1;
                    }
                    BlockPos targetPos = new BlockPos(i2, j2, k);
                    targetPos.addFacingAsOffset(iTargetFacing);
                    int iTargetGrowthDirection = iGrowthDirection;
                    if (iTargetFacing >= 2) {
                        iTargetGrowthDirection = iTargetFacing;
                    }
                    if (!this.attemptToGrowIntoBlock(world, targetPos.x, targetPos.y, targetPos.z, iTargetGrowthDirection)) continue;
                    iGrowthDirections[iTempCount] = iTargetFacing;
                }
                if (iGrowthDirections[0] == 1 && iGrowthDirections[1] <= 1 || iGrowthDirections[1] == 1 && iGrowthDirections[0] == 0) {
                    this.setFacing(world, i2, j2, k, 1);
                }
            }
        }
    }

    public boolean attemptToGrowIntoBlock(aab world, int i2, int j2, int k, int iGrowthDirection) {
        if (!world.c(i2, j2, k) && !this.isBloodLeafBlock(world, i2, j2, k) || this.countBloodWoodNeighboringOnBlockWithSoulSand(world, i2, j2, k) >= 2) {
            return false;
        }
        world.setBlockAndMetadataWithNotify(i2, j2, k, this.cz, iGrowthDirection | 8);
        this.growLeaves(world, i2, j2, k);
        return true;
    }

    public void growLeaves(aab world, int i2, int j2, int k) {
        for (int tempI = i2 - 1; tempI <= i2 + 1; ++tempI) {
            for (int tempJ = j2 - 1; tempJ <= j2 + 1; ++tempJ) {
                for (int tempK = k - 1; tempK <= k + 1; ++tempK) {
                    if (!world.c(tempI, tempJ, tempK)) continue;
                    world.setBlockAndMetadataWithNotify(tempI, tempJ, tempK, BTWBlocks.bloodWoodLeaves.cz, 0);
                }
            }
        }
    }

    public boolean isBloodLeafBlock(aab world, int i2, int j2, int k) {
        int iSubType;
        int iBlockID = world.a(i2, j2, k);
        if (iBlockID == BTWBlocks.bloodWoodLeaves.cz) {
            return true;
        }
        return iBlockID == BTWBlocks.aestheticVegetation.cz && (iSubType = world.h(i2, j2, k)) == 3;
    }

    public int countBloodWoodNeighboringOnBlockWithSoulSand(aab world, int i2, int j2, int k) {
        int iNeighborWoodCount = 0;
        for (int iTempFacing = 0; iTempFacing < 6; ++iTempFacing) {
            BlockPos tempTargetPos = new BlockPos(i2, j2, k);
            tempTargetPos.addFacingAsOffset(iTempFacing);
            if (world.a(tempTargetPos.x, tempTargetPos.y, tempTargetPos.z) != this.cz) continue;
            ++iNeighborWoodCount;
        }
        if (world.a(i2, j2 - 1, k) == apa.bg.cz) {
            ++iNeighborWoodCount;
        }
        return iNeighborWoodCount;
    }

    public int countBloodWoodNeighboringOnBlockIncludingDiagnals(aab world, int i2, int j2, int k) {
        int iNeighborWoodCount = 0;
        for (int tempI = i2 - 1; tempI <= i2 + 1; ++tempI) {
            for (int tempJ = j2 - 1; tempJ <= j2 + 1; ++tempJ) {
                for (int tempK = k - 1; tempK <= k + 1; ++tempK) {
                    if (world.a(tempI, tempJ, tempK) != this.cz || tempI == i2 && tempJ == j2 && tempK == k) continue;
                    ++iNeighborWoodCount;
                }
            }
        }
        return iNeighborWoodCount;
    }

    public void notifySurroundingBloodLeavesOfBlockRemoval(aab world, int i2, int j2, int k) {
        int byte0 = 4;
        int l2 = byte0 + 1;
        if (world.e(i2 - l2, j2 - l2, k - l2, i2 + l2, j2 + l2, k + l2)) {
            for (int i1 = -byte0; i1 <= byte0; ++i1) {
                for (int j1 = -byte0; j1 <= byte0; ++j1) {
                    for (int k1 = -byte0; k1 <= byte0; ++k1) {
                        int i22;
                        int l1 = world.a(i2 + i1, j2 + j1, k + k1);
                        if (l1 != BTWBlocks.bloodWoodLeaves.cz || ((i22 = world.h(i2 + i1, j2 + j1, k + k1)) & 8) != 0) continue;
                        world.setBlockMetadata(i2 + i1, j2 + j1, k + k1, i22 | 8);
                    }
                }
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconSide = register.a("fcBlockBloodWood_side");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        int iFacing = iMetadata & 0xFFFFFFF7;
        if (iFacing < 2 ? iSide >= 2 : (iFacing < 4 ? iSide != 2 && iSide != 3 : iSide < 4)) {
            return this.iconSide;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        aak blockAccess = renderer.a;
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (iFacing == 2) {
            renderer.setUVRotateSouth(1);
            renderer.setUVRotateNorth(2);
        } else if (iFacing == 3) {
            renderer.setUVRotateSouth(2);
            renderer.setUVRotateNorth(1);
            renderer.setUVRotateTop(3);
            renderer.setUVRotateBottom(3);
        } else if (iFacing == 4) {
            renderer.setUVRotateEast(1);
            renderer.setUVRotateWest(2);
            renderer.setUVRotateTop(2);
            renderer.setUVRotateBottom(1);
        } else if (iFacing == 5) {
            renderer.setUVRotateEast(2);
            renderer.setUVRotateWest(1);
            renderer.setUVRotateTop(1);
            renderer.setUVRotateBottom(2);
        }
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        renderer.p(this, i2, j2, k);
        renderer.clearUVRotation();
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf renderBlocks, int i2, int j2, int k, boolean bFirstPassResult) {
        this.renderCookingByKiLnOverlay(renderBlocks, i2, j2, k, bFirstPassResult);
    }
}

