/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.MechanicalBlock;
import btw.block.util.MechPowerUtils;
import btw.item.BTWItems;
import btw.item.util.ItemUtils;
import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class BellowsBlock
extends apa
implements MechanicalBlock {
    private static final int BELLOWS_TICK_RATE = 35;
    public static final float BELLOWS_CONTRACTED_HEIGHT = 0.6875f;
    private static final double BLOW_ITEM_STRENGTH = 0.2;
    private static final double PARTICLE_SPEED = (double)0.1f;
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBySideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private lx iconFront;

    public BellowsBlock(int iBlockID) {
        super(iBlockID, aif.d);
        this.c(2.0f);
        this.setAxesEffectiveOn(true);
        this.setBuoyancy(1.0f);
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0);
        this.a(g);
        this.c("fcBlockBellows");
        this.b(true);
        this.a(ve.d);
    }

    @Override
    public int a(aab world) {
        return 35;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        if (iFacing < 2) {
            iFacing = 2;
        }
        return this.setFacing(iMetadata, iFacing);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, ng entityLiving, wm stack) {
        int iFacing = MiscUtils.convertOrientationToFlatBlockFacingReversed(entityLiving);
        this.setFacing(world, i2, j2, k, iFacing);
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, this.a(world));
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        if (this.isBlockMechanicalOn(blockAccess, i2, j2, k)) {
            return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0);
        }
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        boolean bUpdateAlreadyScheduled = world.isUpdateScheduledForBlock(i2, j2, k, this.cz);
        if (!bUpdateAlreadyScheduled) {
            if (!this.isCurrentStateValid(world, i2, j2, k) && !world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
                world.a(i2, j2, k, this.cz, this.a(world));
                this.setIsContinuousMechanicalStateChange(world, i2, j2, k, true);
            }
        } else {
            boolean bContinuousChange = this.isContinuousMechanicalStateChange(world, i2, j2, k);
            if (bContinuousChange && this.isCurrentStateValid(world, i2, j2, k)) {
                this.setIsContinuousMechanicalStateChange(world, i2, j2, k, false);
            }
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        boolean bReceivingMechanicalPower = this.isInputtingMechanicalPower(world, i2, j2, k);
        boolean bMechanicalOn = this.isBlockMechanicalOn(world, i2, j2, k);
        boolean bContinuousChange = this.isContinuousMechanicalStateChange(world, i2, j2, k);
        if (bMechanicalOn != bReceivingMechanicalPower) {
            if (bContinuousChange) {
                this.setIsContinuousMechanicalStateChange(world, i2, j2, k, false);
                this.setBlockMechanicalOn(world, i2, j2, k, bReceivingMechanicalPower);
                if (bReceivingMechanicalPower) {
                    this.blow(world, i2, j2, k);
                } else {
                    this.liftCollidingEntities(world, i2, j2, k);
                }
            } else {
                world.a(i2, j2, k, this.cz, this.a(world));
                this.setIsContinuousMechanicalStateChange(world, i2, j2, k, true);
            }
        } else if (bContinuousChange) {
            this.setIsContinuousMechanicalStateChange(world, i2, j2, k, false);
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (!this.isCurrentStateValid(world, i2, j2, k) && !world.isUpdateScheduledForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
            this.setIsContinuousMechanicalStateChange(world, i2, j2, k, true);
        }
    }

    @Override
    public int getFacing(int iMetadata) {
        return (iMetadata & 3) + 2;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata &= 0xFFFFFFFC;
        iFacing = iFacing >= 2 ? (iFacing -= 2) : 0;
        return iMetadata |= iFacing;
    }

    @Override
    public boolean canRotateOnTurntable(aak iBlockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean rotateAroundJAxis(aab world, int i2, int j2, int k, boolean bReverse) {
        if (super.rotateAroundJAxis(world, i2, j2, k, bReverse)) {
            world.a(i2, j2, k, this.cz, this.a(world));
            MechPowerUtils.destroyHorizontallyAttachedAxles(world, i2, j2, k);
            return true;
        }
        return false;
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return MechPowerUtils.isBlockPoweredByAxle(world, i2, j2, k, this) || MechPowerUtils.isBlockPoweredByHandCrank(world, i2, j2, k);
    }

    @Override
    public boolean canInputAxlePowerToFacing(aab world, int i2, int j2, int k, int iFacing) {
        int iBlockFacing = this.getFacing(world, i2, j2, k);
        return iFacing != iBlockFacing && iFacing != 1;
    }

    @Override
    public boolean isOutputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return false;
    }

    @Override
    public void overpower(aab world, int i2, int j2, int k) {
        this.breakBellows(world, i2, j2, k);
    }

    public boolean isBlockMechanicalOn(aak blockAccess, int i2, int j2, int k) {
        return this.getIsBlockMechanicalOnFromMetadata(blockAccess.h(i2, j2, k));
    }

    public void setBlockMechanicalOn(aab world, int i2, int j2, int k, boolean bOn) {
        int iMetadata = world.h(i2, j2, k) & 0xFFFFFFFB;
        if (bOn) {
            iMetadata |= 4;
        }
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public boolean getIsBlockMechanicalOnFromMetadata(int iMetadata) {
        return (iMetadata & 4) > 0;
    }

    public boolean isContinuousMechanicalStateChange(aak blockAccess, int i2, int j2, int k) {
        return (blockAccess.h(i2, j2, k) & 8) > 0;
    }

    public void setIsContinuousMechanicalStateChange(aab world, int i2, int j2, int k, boolean bContinuous) {
        int iMetadata = world.h(i2, j2, k) & 0xFFFFFFF7;
        if (bContinuous) {
            iMetadata |= 8;
        }
        world.setBlockMetadata(i2, j2, k, iMetadata);
    }

    public boolean isCurrentStateValid(aab world, int i2, int j2, int k) {
        boolean bMechanicalOn;
        boolean bReceivingMechanicalPower = this.isInputtingMechanicalPower(world, i2, j2, k);
        return bReceivingMechanicalPower == (bMechanicalOn = this.isBlockMechanicalOn(world, i2, j2, k));
    }

    private void blow(aab world, int i2, int j2, int k) {
        this.stokeFiresInFront(world, i2, j2, k);
        this.blowLightItemsInFront(world, i2, j2, k);
    }

    private void stokeFiresInFront(aab world, int i2, int j2, int k) {
        int iFacing = this.getFacing(world, i2, j2, k);
        int iFacingSide1 = apa.rotateFacingAroundY(iFacing, false);
        int iFacingSide2 = apa.rotateFacingAroundY(iFacing, true);
        BlockPos tempTargetPos = new BlockPos(i2, j2, k);
        for (int iTempCount = 0; iTempCount < 3; ++iTempCount) {
            tempTargetPos.addFacingAsOffset(iFacing);
            int tempBlockID = world.a(tempTargetPos.x, tempTargetPos.y, tempTargetPos.z);
            if (tempBlockID == apa.av.cz || tempBlockID == BTWBlocks.stokedFire.cz) {
                this.stokeFire(world, tempTargetPos.x, tempTargetPos.y, tempTargetPos.z);
            } else if (!world.c(tempTargetPos.x, tempTargetPos.y, tempTargetPos.z)) break;
            BlockPos tempSidePos1 = new BlockPos(tempTargetPos.x, tempTargetPos.y, tempTargetPos.z);
            tempSidePos1.addFacingAsOffset(iFacingSide1);
            tempBlockID = world.a(tempSidePos1.x, tempSidePos1.y, tempSidePos1.z);
            if (tempBlockID == apa.av.cz || tempBlockID == BTWBlocks.stokedFire.cz) {
                this.stokeFire(world, tempSidePos1.x, tempSidePos1.y, tempSidePos1.z);
            }
            BlockPos tempSidePos2 = new BlockPos(tempTargetPos.x, tempTargetPos.y, tempTargetPos.z);
            tempSidePos2.addFacingAsOffset(iFacingSide2);
            tempBlockID = world.a(tempSidePos2.x, tempSidePos2.y, tempSidePos2.z);
            if (tempBlockID != apa.av.cz && tempBlockID != BTWBlocks.stokedFire.cz) continue;
            this.stokeFire(world, tempSidePos2.x, tempSidePos2.y, tempSidePos2.z);
        }
    }

    private void blowLightItemsInFront(aab world, int i2, int j2, int k) {
        aqx blowBox;
        int iFacing = this.getFacing(world, i2, j2, k);
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iFacing);
        List collisionList = null;
        int iBlowRange = this.computeBlowRange(world, i2, j2, k);
        if (iBlowRange > 0 && (blowBox = this.createBlowBoundingBox(world, i2, j2, k, iBlowRange)) != null && (collisionList = world.a(rh.class, blowBox)) != null && collisionList.size() > 0) {
            arc blowVector = MiscUtils.convertBlockFacingToVector(iFacing);
            blowVector.c *= 0.2;
            blowVector.d *= 0.2;
            blowVector.e *= 0.2;
            for (int listIndex = 0; listIndex < collisionList.size(); ++listIndex) {
                wm stack;
                int iItemBlowDistance;
                rh targetEntityItem = (rh)collisionList.get(listIndex);
                if (targetEntityItem.M || (iItemBlowDistance = (stack = targetEntityItem.d()).b().getBellowsBlowDistance(stack.k())) <= 0 || iItemBlowDistance < iBlowRange && !this.isEntityWithinBlowRange(world, i2, j2, k, iItemBlowDistance, targetEntityItem)) continue;
                targetEntityItem.x += blowVector.c;
                targetEntityItem.y += blowVector.d;
                targetEntityItem.z += blowVector.e;
            }
        }
    }

    private boolean isEntityWithinBlowRange(aab world, int i2, int j2, int k, int iBlowRange, mp entity) {
        aqx blowBox = this.createBlowBoundingBox(world, i2, j2, k, iBlowRange);
        return blowBox.a(entity.E);
    }

    private aqx createBlowBoundingBox(aab world, int i2, int j2, int k, int iBlowRange) {
        aqx blowBox = null;
        if (iBlowRange > 0) {
            int iFacing = this.getFacing(world, i2, j2, k);
            BlockPos targetPos = new BlockPos(i2, j2, k);
            targetPos.addFacingAsOffset(iFacing);
            blowBox = aqx.a().a(targetPos.x, targetPos.y, targetPos.z, targetPos.x + 1, targetPos.y + 1, targetPos.z + 1);
            if (iBlowRange > 1) {
                arc blowVector = MiscUtils.convertBlockFacingToVector(iFacing);
                double dMultiplier = iBlowRange - 1;
                blowVector.c *= dMultiplier;
                blowVector.d *= dMultiplier;
                blowVector.e *= dMultiplier;
                blowBox = blowBox.a(blowVector.c, blowVector.d, blowVector.e);
            }
        }
        return blowBox;
    }

    private int computeBlowRange(aab world, int i2, int j2, int k) {
        int iBlowRange = 0;
        int iFacing = this.getFacing(world, i2, j2, k);
        BlockPos targetPos = new BlockPos(i2, j2, k);
        for (int iTempRange = 0; iTempRange < 3; ++iTempRange) {
            targetPos.addFacingAsOffset(iFacing);
            if (!this.canBlowThroughBlock(world, targetPos.x, targetPos.y, targetPos.z)) break;
            ++iBlowRange;
        }
        return iBlowRange;
    }

    private boolean canBlowThroughBlock(aab world, int i2, int j2, int k) {
        int iBlockID;
        return world.c(i2, j2, k) || (iBlockID = world.a(i2, j2, k)) == apa.av.cz || iBlockID == BTWBlocks.stokedFire.cz || iBlockID == apa.bo.cz || apa.r[iBlockID].b(world, i2, j2, k) == null;
    }

    private void stokeFire(aab world, int i2, int j2, int k) {
        if (world.a(i2, j2 - 1, k) == BTWBlocks.hibachi.cz) {
            if (world.a(i2, j2, k) == BTWBlocks.stokedFire.cz) {
                world.setBlockMetadata(i2, j2, k, 0);
            } else {
                world.setBlockWithNotify(i2, j2, k, BTWBlocks.stokedFire.cz);
            }
            if (world.c(i2, j2 + 1, k)) {
                world.setBlockWithNotify(i2, j2 + 1, k, BellowsBlock.av.cz);
            }
        } else {
            world.setBlockWithNotify(i2, j2, k, 0);
        }
    }

    private void liftCollidingEntities(aab world, int i2, int j2, int k) {
        List list = world.b(null, aqx.a().a(i2, (float)j2 + 0.6875f, k, i2 + 1, j2 + 1, k + 1));
        float extendedMaxY = j2 + 1;
        if (list != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                double tempEntityMinY;
                mp tempEntity = (mp)list.get(j1);
                if (tempEntity.M || !tempEntity.L() && !(tempEntity instanceof rh) || !((tempEntityMinY = tempEntity.E.b) < (double)extendedMaxY)) continue;
                double entityYOffset = (double)extendedMaxY - tempEntityMinY;
                tempEntity.b(tempEntity.u, tempEntity.v + entityYOffset, tempEntity.w);
            }
        }
    }

    public void breakBellows(aab world, int i2, int j2, int k) {
        int iTemp;
        for (iTemp = 0; iTemp < 2; ++iTemp) {
            ItemUtils.ejectSingleItemWithRandomOffset(world, i2, j2, k, BTWItems.woodSidingStubID, 0);
        }
        for (iTemp = 0; iTemp < 1; ++iTemp) {
            ItemUtils.ejectSingleItemWithRandomOffset(world, i2, j2, k, BTWItems.gear.cp, 0);
        }
        for (iTemp = 0; iTemp < 2; ++iTemp) {
            wm itemStack = new wm(BTWItems.tannedLeather.cp, 4, 0);
            ItemUtils.ejectStackWithRandomOffset(world, i2, j2, k, itemStack);
        }
        world.e(2235, i2, j2, k, 0);
        world.setBlockWithNotify(i2, j2, k, 0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        lx sideIcon;
        this.cQ = sideIcon = register.a("fcBlockBellows_side");
        this.iconBySideArray[0] = register.a("fcBlockBellows_bottom");
        this.iconBySideArray[1] = register.a("fcBlockBellows_top");
        this.iconBySideArray[2] = sideIcon;
        this.iconBySideArray[3] = sideIcon;
        this.iconBySideArray[4] = sideIcon;
        this.iconBySideArray[5] = sideIcon;
        this.iconFront = register.a("fcBlockBellows_front");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 3) {
            return this.iconFront;
        }
        return this.iconBySideArray[iSide];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (iSide == iFacing) {
            return this.iconFront;
        }
        return this.iconBySideArray[iSide];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientNotificationOfMetadataChange(aab world, int i2, int j2, int k, int iOldMetadata, int iNewMetadata) {
        if (!this.getIsBlockMechanicalOnFromMetadata(iOldMetadata) && this.getIsBlockMechanicalOnFromMetadata(iNewMetadata)) {
            this.blowLightItemsInFront(world, i2, j2, k);
            world.playSound((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "mob.cow.say4", 0.25f, world.s.nextFloat() * 0.4f + 2.0f);
            int iFacing = this.getFacing(iNewMetadata);
            this.emitBellowsParticles(world, i2, j2, k, iFacing, world.s);
        } else if (this.getIsBlockMechanicalOnFromMetadata(iOldMetadata) && !this.getIsBlockMechanicalOnFromMetadata(iNewMetadata)) {
            this.liftCollidingEntities(world, i2, j2, k);
            world.playSound((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "mob.cow.say2", 1.0f, world.s.nextFloat() * 0.4f + 2.0f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void emitBellowsParticles(aab world, int i2, int j2, int k, int iFacing, Random random) {
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iFacing);
        arc blowVector = MiscUtils.convertBlockFacingToVector(iFacing);
        blowVector.c *= (double)0.1f;
        blowVector.d *= (double)0.1f;
        blowVector.e *= (double)0.1f;
        for (int counter = 0; counter < 10; ++counter) {
            float smokeX = (float)targetPos.x + random.nextFloat();
            float smokeY = (float)targetPos.y + random.nextFloat() * 0.5f;
            float smokeZ = (float)targetPos.z + random.nextFloat();
            world.a("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, blowVector.c + (double)(random.nextFloat() * 0.1f) - (double)0.05f, blowVector.d + (double)(random.nextFloat() * 0.1f) - (double)0.05f, blowVector.e + (double)(random.nextFloat() * 0.1f) - (double)0.05f);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }
}

