/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.MechanicalBlock;
import btw.block.util.MechPowerUtils;
import btw.client.render.util.RenderUtils;
import btw.item.BTWItems;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class AxleBlock
extends apa {
    protected static final double AXLE_WIDTH = 0.25;
    protected static final double AXLE_HALF_WIDTH = 0.125;
    public static final int AXLE_TICK_RATE = 1;
    protected static final int[][] axleFacingsForAlignment = new int[][]{{0, 1}, {2, 3}, {4, 5}};
    @Environment(value=EnvType.CLIENT)
    public lx iconSide;
    @Environment(value=EnvType.CLIENT)
    public lx iconSideOn;
    @Environment(value=EnvType.CLIENT)
    public lx iconSideOnOverpowered;
    @Environment(value=EnvType.CLIENT)
    public boolean isPowerOnForCurrentRender;
    @Environment(value=EnvType.CLIENT)
    public boolean isOverpoweredForCurrentRender;

    public AxleBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.plankMaterial);
        this.c(2.0f);
        this.setAxesEffectiveOn(true);
        this.setBuoyancy(1.0f);
        this.initBlockBounds(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
        this.a(g);
        this.c("fcBlockAxle");
        this.a(ve.d);
    }

    @Override
    public int a(aab world) {
        return 1;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        return this.setAxisAlignmentInMetadataBasedOnFacing(iMetadata, iFacing);
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, this.a(world));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        this.setPowerLevel(world, i2, j2, k, 0);
        this.validatePowerLevel(world, i2, j2, k);
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iAxis = this.getAxisAlignment(blockAccess, i2, j2, k);
        switch (iAxis) {
            case 0: {
                return aqx.a().a(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
            }
            case 1: {
                return aqx.a().a(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
            }
        }
        return aqx.a().a(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        this.validatePowerLevel(world, i2, j2, k);
    }

    @Override
    public int h() {
        return 1;
    }

    @Override
    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return this.isAxleOrientedTowardsFacing(blockAccess, i2, j2, k, iFacing);
    }

    @Override
    public int getMechanicalPowerLevelProvidedToAxleAtFacing(aab world, int i2, int j2, int k, int iFacing) {
        int iAlignment = this.getAxisAlignment(world, i2, j2, k);
        if (iFacing >> 1 == iAlignment) {
            return this.getPowerLevel(world, i2, j2, k);
        }
        return 0;
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 2;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.hempFibers.cp, 4, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, 2, 0, fChanceOfDrop);
        return true;
    }

    @Override
    public int getFacing(int iMetadata) {
        return this.getAxisAlignmentFromMetadata(iMetadata) << 1;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        return this.setAxisAlignmentInMetadataBasedOnFacing(iMetadata, iFacing);
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iAxisAlignment = this.getAxisAlignment(world, i2, j2, k);
        if (!bReverse) {
            if (++iAxisAlignment > 2) {
                iAxisAlignment = 0;
            }
        } else if (--iAxisAlignment < 0) {
            iAxisAlignment = 2;
        }
        this.setAxisAlignment(world, i2, j2, k, iAxisAlignment);
        world.g(i2, j2, k, i2, j2, k);
        this.setPowerLevel(world, i2, j2, k, 0);
        this.validatePowerLevel(world, i2, j2, k);
        world.j(i2, j2, k);
        return true;
    }

    @Override
    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        return world.w(i2, j2 - 1, k);
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        return -1.0f;
    }

    public int getAxisAlignment(aak iBlockAccess, int i2, int j2, int k) {
        return iBlockAccess.h(i2, j2, k) >> 2;
    }

    public void setAxisAlignment(aab world, int i2, int j2, int k, int iAxisAlignment) {
        int iMetaData = world.h(i2, j2, k) & 3;
        world.setBlockMetadataWithNotify(i2, j2, k, iMetaData |= iAxisAlignment << 2);
    }

    public int getAxisAlignmentFromMetadata(int iMetadata) {
        return iMetadata >> 2;
    }

    public void setAxisAlignmentBasedOnFacing(aab world, int i2, int j2, int k, int iFacing) {
        int iAxis;
        switch (iFacing) {
            case 0: 
            case 1: {
                iAxis = 0;
                break;
            }
            case 2: 
            case 3: {
                iAxis = 1;
                break;
            }
            default: {
                iAxis = 2;
            }
        }
        int iMetaData = world.h(i2, j2, k) & 3;
        world.setBlockMetadataWithNotify(i2, j2, k, iMetaData |= iAxis << 2);
    }

    public int setAxisAlignmentInMetadataBasedOnFacing(int iMetadata, int iFacing) {
        int iAxis;
        switch (iFacing) {
            case 0: 
            case 1: {
                iAxis = 0;
                break;
            }
            case 2: 
            case 3: {
                iAxis = 1;
                break;
            }
            default: {
                iAxis = 2;
            }
        }
        iMetadata &= 3;
        return iMetadata |= iAxis << 2;
    }

    public int getPowerLevel(aak iBlockAccess, int i2, int j2, int k) {
        return this.getPowerLevelFromMetadata(iBlockAccess.h(i2, j2, k));
    }

    public int getPowerLevelFromMetadata(int iMetadata) {
        return iMetadata & 3;
    }

    public void setPowerLevel(aab world, int i2, int j2, int k, int iPowerLevel) {
        int iMetadata = world.h(i2, j2, k);
        iMetadata = this.setPowerLevelInMetadata(iMetadata, iPowerLevel);
        world.setBlockMetadataWithNotifyNoClient(i2, j2, k, iMetadata);
    }

    public int setPowerLevelInMetadata(int iMetadata, int iPowerLevel) {
        iMetadata &= 0xC;
        return iMetadata |= (iPowerLevel &= 3);
    }

    public void setPowerLevelWithoutNotify(aab world, int i2, int j2, int k, int iPowerLevel) {
        int iMetadata = world.h(i2, j2, k);
        iMetadata = this.setPowerLevelInMetadata(iMetadata, iPowerLevel);
        world.setBlockMetadata(i2, j2, k, iMetadata);
    }

    public boolean isAxleOrientedTowardsFacing(aak iBlockAccess, int i2, int j2, int k, int iFacing) {
        int iAxis = this.getAxisAlignment(iBlockAccess, i2, j2, k);
        switch (iAxis) {
            case 0: {
                if (iFacing != 0 && iFacing != 1) break;
                return true;
            }
            case 1: {
                if (iFacing != 2 && iFacing != 3) break;
                return true;
            }
            default: {
                if (iFacing != 4 && iFacing != 5) break;
                return true;
            }
        }
        return false;
    }

    public void breakAxle(aab world, int i2, int j2, int k) {
        if (world.a(i2, j2, k) == this.cz) {
            this.dropComponentItemsOnBadBreak(world, i2, j2, k, world.h(i2, j2, k), 1.0f);
            world.e(2235, i2, j2, k, 0);
            world.setBlockWithNotify(i2, j2, k, 0);
        }
    }

    protected void validatePowerLevel(aab world, int i2, int j2, int k) {
        int iCurrentPower = this.getPowerLevel(world, i2, j2, k);
        int iAxis = this.getAxisAlignment(world, i2, j2, k);
        int iMaxNeighborPower = 0;
        int iGreaterPowerNeighbors = 0;
        for (int iTempSourceIndex = 0; iTempSourceIndex < 2; ++iTempSourceIndex) {
            int iTempFacing = axleFacingsForAlignment[iAxis][iTempSourceIndex];
            BlockPos tempSourcePos = new BlockPos(i2, j2, k, iTempFacing);
            int iTempBlockID = world.a(tempSourcePos.x, tempSourcePos.y, tempSourcePos.z);
            if (iTempBlockID == 0) continue;
            apa tempBlock = apa.r[iTempBlockID];
            int iTempPowerLevel = tempBlock.getMechanicalPowerLevelProvidedToAxleAtFacing(world, tempSourcePos.x, tempSourcePos.y, tempSourcePos.z, apa.getOppositeFacing(iTempFacing));
            if (iTempPowerLevel > iMaxNeighborPower) {
                iMaxNeighborPower = iTempPowerLevel;
            }
            if (iTempPowerLevel <= iCurrentPower) continue;
            ++iGreaterPowerNeighbors;
        }
        if (iGreaterPowerNeighbors >= 2) {
            this.breakAxle(world, i2, j2, k);
            return;
        }
        int iNewPower = iCurrentPower;
        if (iMaxNeighborPower > iCurrentPower) {
            if (iMaxNeighborPower == 1) {
                this.breakAxle(world, i2, j2, k);
                return;
            }
            iNewPower = iMaxNeighborPower - 1;
        } else {
            iNewPower = 0;
        }
        if (iNewPower != iCurrentPower) {
            this.setPowerLevel(world, i2, j2, k, iNewPower);
        }
    }

    private void emitAxleParticles(aab world, int i2, int j2, int k, Random random) {
        for (int counter = 0; counter < 2; ++counter) {
            float smokeX = (float)i2 + random.nextFloat();
            float smokeY = (float)j2 + random.nextFloat() * 0.5f + 0.625f;
            float smokeZ = (float)k + random.nextFloat();
            world.a("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    public void overpower(aab world, int i2, int j2, int k) {
        int iAxis = this.getAxisAlignment(world, i2, j2, k);
        switch (iAxis) {
            case 0: {
                this.overpowerBlockToFacing(world, i2, j2, k, iAxis, 0);
                this.overpowerBlockToFacing(world, i2, j2, k, iAxis, 1);
                break;
            }
            case 1: {
                this.overpowerBlockToFacing(world, i2, j2, k, iAxis, 2);
                this.overpowerBlockToFacing(world, i2, j2, k, iAxis, 3);
                break;
            }
            default: {
                this.overpowerBlockToFacing(world, i2, j2, k, iAxis, 4);
                this.overpowerBlockToFacing(world, i2, j2, k, iAxis, 5);
            }
        }
    }

    private void overpowerBlockToFacing(aab world, int i2, int j2, int k, int iSourceAxis, int iFacing) {
        MechanicalBlock mechDevice;
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iFacing);
        int iTempBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
        if (iTempBlockID == BTWBlocks.axle.cz || iTempBlockID == BTWBlocks.axlePowerSource.cz) {
            int iTempAxis = this.getAxisAlignment(world, targetPos.x, targetPos.y, targetPos.z);
            if (iTempAxis == iSourceAxis) {
                this.overpowerBlockToFacing(world, targetPos.x, targetPos.y, targetPos.z, iSourceAxis, iFacing);
            }
        } else if (apa.r[iTempBlockID] instanceof MechanicalBlock && (mechDevice = (MechanicalBlock)((Object)apa.r[iTempBlockID])).canInputAxlePowerToFacing(world, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iFacing))) {
            mechDevice.overpower(world, targetPos.x, targetPos.y, targetPos.z);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("fcBlockAxle_end");
        this.iconSide = register.a("fcBlockAxle_side");
        this.iconSideOn = register.a("fcBlockAxle_side_on");
        this.iconSideOnOverpowered = register.a("fcBlockAxle_side_on_fast");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide != 2 && iSide != 3) {
            return this.iconSide;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iAxisAlignment = this.getAxisAlignment(blockAccess, i2, j2, k);
        if (iAxisAlignment == 0 ? iSide >= 2 : (iAxisAlignment == 1 ? iSide != 2 && iSide != 3 : iSide < 4)) {
            return this.getAxleSideTextureForOnState(this.isPowerOnForCurrentRender);
        }
        return this.cQ;
    }

    @Environment(value=EnvType.CLIENT)
    public lx getAxleSideTextureForOnState(boolean bIsOn) {
        if (bIsOn) {
            return this.iconSideOn;
        }
        return this.iconSide;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random random) {
        if (this.clientCheckIfPowered(world, i2, j2, k)) {
            this.emitAxleParticles(world, i2, j2, k, random);
            if (random.nextInt(200) == 0) {
                world.playSound((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "random.chestopen", 0.075f, random.nextFloat() * 0.1f + 0.5f);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean clientCheckIfPowered(aak blockAccess, int i2, int j2, int k) {
        int iCurrentPower = this.getPowerLevel(blockAccess, i2, j2, k);
        int iAxis = this.getAxisAlignment(blockAccess, i2, j2, k);
        block0: for (int iTempFacingIndex = 0; iTempFacingIndex < 2; ++iTempFacingIndex) {
            BlockPos targetPos = new BlockPos(i2, j2, k);
            int iFacingOfCheck = axleFacingsForAlignment[iAxis][iTempFacingIndex];
            for (int iTempDistance = 1; iTempDistance <= 3; ++iTempDistance) {
                targetPos.addFacingAsOffset(iFacingOfCheck);
                int iTempBlockID = blockAccess.a(targetPos.x, targetPos.y, targetPos.z);
                if (iTempBlockID == this.cz && this.getAxisAlignment(blockAccess, targetPos.x, targetPos.y, targetPos.z) == iAxis) continue;
                if (iTempBlockID == BTWBlocks.axlePowerSource.cz && this.getAxisAlignment(blockAccess, targetPos.x, targetPos.y, targetPos.z) == iAxis) {
                    return true;
                }
                if (!MechPowerUtils.isPoweredGearBox(blockAccess, targetPos.x, targetPos.y, targetPos.z)) continue block0;
                return true;
            }
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        BlockPos myPos = new BlockPos(iNeighborI, iNeighborJ, iNeighborK, AxleBlock.getOppositeFacing(iSide));
        if (this.isAxleOrientedTowardsFacing(blockAccess, myPos.x, myPos.y, myPos.z, iSide)) {
            int iNeighborBlockID = blockAccess.a(iNeighborI, iNeighborJ, iNeighborK);
            if (iNeighborBlockID == this.cz) {
                if (this.getAxisAlignment(blockAccess, myPos.x, myPos.y, myPos.z) == this.getAxisAlignment(blockAccess, iNeighborI, iNeighborJ, iNeighborK)) {
                    return false;
                }
            } else {
                return RenderUtils.shouldRenderNeighborFullFaceSide(blockAccess, iNeighborI, iNeighborJ, iNeighborK, iSide);
            }
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientBreakBlock(aab world, int i2, int j2, int k, int iBlockID, int iMetadata) {
        world.g(i2 - 3, j2 - 3, k - 3, i2 + 3, j2 + 3, k + 3);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientBlockAdded(aab world, int i2, int j2, int k) {
        world.g(i2 - 3, j2 - 3, k - 3, i2 + 3, j2 + 3, k + 3);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        aak blockAccess = renderer.a;
        int iAlignment = this.getAxisAlignment(blockAccess, i2, j2, k);
        if (iAlignment == 0) {
            renderer.setUVRotateEast(1);
            renderer.setUVRotateWest(1);
            renderer.setUVRotateSouth(1);
            renderer.setUVRotateNorth(1);
            renderer.setUVRotateTop(0);
            renderer.setUVRotateBottom(0);
        } else if (iAlignment == 1) {
            renderer.setUVRotateEast(0);
            renderer.setUVRotateWest(0);
            renderer.setUVRotateSouth(0);
            renderer.setUVRotateNorth(3);
            renderer.setUVRotateTop(2);
            renderer.setUVRotateBottom(2);
        } else {
            renderer.setUVRotateEast(0);
            renderer.setUVRotateWest(3);
            renderer.setUVRotateSouth(0);
            renderer.setUVRotateNorth(0);
            renderer.setUVRotateTop(3);
            renderer.setUVRotateBottom(0);
        }
        this.isPowerOnForCurrentRender = this.clientCheckIfPowered(blockAccess, i2, j2, k);
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        renderer.p(this, i2, j2, k);
        renderer.clearUVRotation();
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderer, int iItemDamage, float fBrightness) {
        renderer.setRenderBounds(this.getBlockBoundsFromPoolForItemRender(iItemDamage));
        renderer.setUVRotateEast(0);
        renderer.setUVRotateWest(0);
        renderer.setUVRotateSouth(0);
        renderer.setUVRotateNorth(3);
        renderer.setUVRotateTop(2);
        renderer.setUVRotateBottom(2);
        RenderUtils.renderInvBlockWithMetadata(renderer, this, -0.5f, -0.5f, -0.5f, iItemDamage);
        renderer.clearUVRotation();
    }
}

