/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.SlabBlock;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;

public abstract class AttachedSlabBlock
extends SlabBlock {
    protected AttachedSlabBlock(int iBlockID, aif material) {
        super(iBlockID, material);
    }

    @Override
    public boolean c(aab world, int i2, int j2, int k, int iSide) {
        if (iSide == 0 || iSide == 1 ? this.hasValidAnchorToFacing(world, i2, j2, k, apa.getOppositeFacing(iSide)) : this.hasValidAnchorToFacing(world, i2, j2, k, 0) || this.hasValidAnchorToFacing(world, i2, j2, k, 1)) {
            return super.c(world, i2, j2, k, iSide);
        }
        return false;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        if (iFacing == 0) {
            iMetadata = this.setIsUpsideDown(iMetadata, true);
        } else if (iFacing != 1) {
            if ((double)fClickY > 0.5) {
                if (this.hasValidAnchorToFacing(world, i2, j2, k, 1)) {
                    iMetadata = this.setIsUpsideDown(iMetadata, true);
                }
            } else if (!this.hasValidAnchorToFacing(world, i2, j2, k, 0)) {
                iMetadata = this.setIsUpsideDown(iMetadata, true);
            }
        }
        return iMetadata;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        int iAnchorSide = 0;
        if (this.getIsUpsideDown(world.h(i2, j2, k))) {
            iAnchorSide = 1;
        }
        if (!this.hasValidAnchorToFacing(world, i2, j2, k, iAnchorSide)) {
            this.onAnchorBlockLost(world, i2, j2, k);
        }
    }

    protected boolean hasValidAnchorToFacing(aab world, int i2, int j2, int k, int iFacing) {
        BlockPos attachedPos = new BlockPos(i2, j2, k, iFacing);
        return WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(world, attachedPos.x, attachedPos.y, attachedPos.z, apa.getOppositeFacing(iFacing), true);
    }

    protected abstract void onAnchorBlockLost(aab var1, int var2, int var3, int var4);
}

