/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.PlatformBlock;
import btw.block.tileentity.PulleyTileEntity;
import btw.client.render.util.RenderUtils;
import btw.entity.mechanical.platform.MovingAnchorEntity;
import btw.item.BTWItems;
import btw.item.util.ItemUtils;
import btw.world.util.BlockPos;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class AnchorBlock
extends apa {
    public static double anchorBaseHeight = 0.375;
    @Environment(value=EnvType.CLIENT)
    private lx iconFront;
    @Environment(value=EnvType.CLIENT)
    public lx iconNub;
    @Environment(value=EnvType.CLIENT)
    private lx iconRope;

    public AnchorBlock(int iBlockID) {
        super(iBlockID, aif.e);
        this.c(2.0f);
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, anchorBaseHeight, 1.0);
        this.a(j);
        this.c("fcBlockAnchor");
        this.a(ve.e);
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        switch (iFacing) {
            case 0: {
                return aqx.a().a(0.0, 1.0 - anchorBaseHeight, 0.0, 1.0, 1.0, 1.0);
            }
            case 1: {
                return aqx.a().a(0.0, 0.0, 0.0, 1.0, anchorBaseHeight, 1.0);
            }
            case 2: {
                return aqx.a().a(0.0, 0.0, 1.0 - anchorBaseHeight, 1.0, 1.0, 1.0);
            }
            case 3: {
                return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, anchorBaseHeight);
            }
            case 4: {
                return aqx.a().a(1.0 - anchorBaseHeight, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        return aqx.a().a(0.0, 0.0, 0.0, anchorBaseHeight, 1.0, 1.0);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        int iAnchorFacing = iFacing;
        return this.setFacing(iMetadata, iAnchorFacing);
    }

    @Override
    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        wm playerEquippedItem = player.cd();
        if (playerEquippedItem != null) {
            return false;
        }
        this.retractRope(world, i2, j2, k, player);
        return true;
    }

    @Override
    public int getFacing(int iMetadata) {
        return iMetadata;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        return iFacing;
    }

    @Override
    public boolean canRotateOnTurntable(aak blockAccess, int i2, int j2, int k) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        return iFacing != 0;
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iFacing = this.getFacing(world, i2, j2, k);
        iFacing = apa.cycleFacing(iFacing, bReverse);
        this.setFacing(world, i2, j2, k, iFacing);
        world.g(i2, j2, k, i2, j2, k);
        return true;
    }

    @Override
    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return apa.getOppositeFacing(iFacing) == this.getFacing(blockAccess, i2, j2, k);
    }

    void retractRope(aab world, int i2, int j2, int k, sq entityPlayer) {
        int iTempBlockID;
        for (int tempj = j2 - 1; tempj >= 0 && (iTempBlockID = world.a(i2, tempj, k)) == BTWBlocks.ropeBlock.cz; --tempj) {
            if (world.a(i2, tempj - 1, k) == BTWBlocks.ropeBlock.cz) continue;
            this.addRopeToPlayerInventory(world, i2, j2, k, entityPlayer);
            apa targetBlock = BTWBlocks.ropeBlock;
            if (world.I) break;
            world.e(2001, i2, j2, k, iTempBlockID);
            world.setBlockWithNotify(i2, tempj, k, 0);
            break;
        }
    }

    private void addRopeToPlayerInventory(aab world, int i2, int j2, int k, sq entityPlayer) {
        wm ropeStack = new wm(BTWItems.rope);
        if (entityPlayer.bK.a(ropeStack)) {
            world.a((mp)entityPlayer, "random.pop", 0.2f, ((world.s.nextFloat() - world.s.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        } else {
            ItemUtils.ejectStackWithRandomOffset(world, i2, j2, k, ropeStack);
        }
    }

    public boolean notifyAnchorBlockOfAttachedPulleyStateChange(PulleyTileEntity tileEntityPulley, aab world, int i2, int j2, int k) {
        int iMovementDirection = 0;
        if (tileEntityPulley.isRaising()) {
            if (world.a(i2, j2 + 1, k) == BTWBlocks.ropeBlock.cz) {
                iMovementDirection = 1;
            }
        } else if (tileEntityPulley.isLowering() && (world.c(i2, j2 - 1, k) || world.a(i2, j2 - 1, k) == BTWBlocks.platform.cz)) {
            iMovementDirection = -1;
        }
        if (iMovementDirection != 0) {
            this.convertAnchorToEntity(world, i2, j2, k, tileEntityPulley, iMovementDirection);
            return true;
        }
        return false;
    }

    private void convertAnchorToEntity(aab world, int i2, int j2, int k, PulleyTileEntity attachedTileEntityPulley, int iMovementDirection) {
        BlockPos pulleyPos = new BlockPos(attachedTileEntityPulley.l, attachedTileEntityPulley.m, attachedTileEntityPulley.n);
        MovingAnchorEntity entityAnchor = (MovingAnchorEntity)mv.createEntityOfType(MovingAnchorEntity.class, world, Float.valueOf((float)i2 + 0.5f), Float.valueOf((float)j2 + 0.5f), Float.valueOf((float)k + 0.5f), pulleyPos, iMovementDirection);
        world.d(entityAnchor);
        this.convertConnectedPlatformsToEntities(world, i2, j2, k, entityAnchor);
        world.setBlockWithNotify(i2, j2, k, 0);
    }

    private void convertConnectedPlatformsToEntities(aab world, int i2, int j2, int k, MovingAnchorEntity associatedAnchorEntity) {
        int iTargetJ = j2 - 1;
        int iTargetBlockID = world.a(i2, iTargetJ, k);
        if (iTargetBlockID == BTWBlocks.platform.cz) {
            ((PlatformBlock)BTWBlocks.platform).covertToEntitiesFromThisPlatform(world, i2, iTargetJ, k, associatedAnchorEntity);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconFront = register.a("fcBlockAnchor_front");
        this.iconNub = register.a("fcBlockAnchor_nub");
        this.iconRope = register.a("fcBlockRope");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide < 2) {
            return this.iconFront;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iFacing = blockAccess.h(i2, j2, k);
        if (iSide == iFacing || iSide == apa.getOppositeFacing(iFacing)) {
            return this.iconFront;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        aak blockAccess = renderer.a;
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        renderer.p(this, i2, j2, k);
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        double dHalfLength = 0.125;
        double dHalfWidth = 0.125;
        double dBlockHeight = 0.25;
        renderer.a(0.5 - dHalfWidth, anchorBaseHeight, 0.5 - dHalfLength, 0.5 + dHalfWidth, anchorBaseHeight + dBlockHeight, 0.5 + dHalfLength);
        RenderUtils.renderStandardBlockWithTexture(renderer, this, i2, j2, k, this.iconNub);
        boolean bRenderRope = false;
        dHalfLength = 0.0625;
        dHalfWidth = 0.0625;
        dBlockHeight = anchorBaseHeight;
        if (iFacing == 1) {
            int iBlockAboveId = blockAccess.a(i2, j2 + 1, k);
            if (iBlockAboveId == BTWBlocks.ropeBlock.cz || iBlockAboveId == BTWBlocks.pulley.cz) {
                renderer.a(0.5 - dHalfWidth, dBlockHeight, 0.5 - dHalfLength, 0.5 + dHalfWidth, 1.0, 0.5 + dHalfLength);
                bRenderRope = true;
            }
        } else if (blockAccess.a(i2, j2 - 1, k) == BTWBlocks.ropeBlock.cz) {
            renderer.a(0.5 - dHalfWidth, 0.0, 0.5 - dHalfLength, 0.5 + dHalfWidth, dBlockHeight, 0.5 + dHalfLength);
            bRenderRope = true;
        }
        if (bRenderRope) {
            RenderUtils.renderStandardBlockWithTexture(renderer, this, i2, j2, k, this.iconRope);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, anchorBaseHeight, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, this, -0.5f, -0.25f, -0.5f, 1);
        float fHalfLength = 0.125f;
        float fHalfWidth = 0.125f;
        float fBlockHeight = 0.25f;
        renderBlocks.a(0.5f - fHalfWidth, anchorBaseHeight, (double)(0.5f - fHalfLength), (double)(0.5f + fHalfWidth), anchorBaseHeight + (double)fBlockHeight, (double)(0.5f + fHalfLength));
        RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.25f, -0.5f, this.iconNub);
    }
}

