/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.BloodWoodLogBlock;
import btw.block.blocks.PlanterBlock;
import btw.block.util.Flammability;
import btw.client.render.util.RenderUtils;
import btw.entity.item.BloodWoodSaplingItemEntity;
import btw.item.items.ShearsItem;
import btw.world.util.BlockPos;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class AestheticVegetationBlock
extends apa {
    public static final int SUBTYPE_VINE_TRAP = 0;
    public static final int SUBTYPE_VINE_TRAP_TRIGGERED_BY_ENTITY = 1;
    public static final int SUBTYPE_BLOOD_WOOD_SAPLING = 2;
    public static final int SUBTYPE_BLOOD_LEAVES = 3;
    public static final int SUBTYPE_VINE_TRAP_UPSIDE_DOWN = 4;
    public static final int SUBTYPE_VINE_TRAP_UPSIDE_DOWN_TRIGGERED_BY_ENTITY = 5;
    public static final int NUM_SUBTYPES = 6;
    private static final double VINE_TRAP_HEIGHT = 0.125;
    private static final float HARDNESS = 0.2f;
    private static final int TICK_RATE = 10;
    public static final int BLOOD_WOOD_SAPLING_MIN_TRUNK_HEIGHT = 4;
    @Environment(value=EnvType.CLIENT)
    private static final int VINE_TRAP_TEXTURE_ID = 105;
    @Environment(value=EnvType.CLIENT)
    private static final int BLOOD_WOOD_SAPLING_TEXTURE_ID = 108;
    @Environment(value=EnvType.CLIENT)
    private static final int BLOOD_LEAVES_TEXTURE_ID = 109;
    @Environment(value=EnvType.CLIENT)
    private lx iconVineTrap;
    @Environment(value=EnvType.CLIENT)
    private lx iconSaplingBloodWood;
    @Environment(value=EnvType.CLIENT)
    private lx iconLeavesBloodWood;

    public AestheticVegetationBlock(int iBlockID) {
        super(iBlockID, aif.j);
        this.c(0.2f);
        this.setAxesEffectiveOn();
        this.setBuoyancy(1.0f);
        this.setFireProperties(Flammability.EXTREME);
        this.a(i);
        this.c("fcBlockAestheticVegetation");
        this.b(true);
        this.a(ve.c);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        int iSubtype = iMetadata;
        if (iSubtype == 0 && iFacing != 1) {
            boolean bUpsideDown = true;
            if (iFacing >= 2 && fClickY < 0.5f) {
                bUpsideDown = false;
            }
            if (bUpsideDown) {
                return 4;
            }
        }
        return iMetadata;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iChangedBlockID) {
        super.a(world, i2, j2, k, iChangedBlockID);
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if (iSubtype == 2) {
            this.validateBloodWoodSapling(world, i2, j2, k);
        }
    }

    @Override
    public boolean f(aab world, int i2, int j2, int k) {
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if (iSubtype == 2) {
            return this.canBloodwoodSaplingStayAtLocation(world, i2, j2, k);
        }
        return super.f(world, i2, j2, k);
    }

    @Override
    public int a(int iMetadata) {
        int iSubtype = iMetadata;
        switch (iSubtype) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                iSubtype = 0;
                break;
            }
            case 3: {
                iSubtype = 2;
            }
        }
        return iSubtype;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iMetaData, float fChance, int iFortuneModifier) {
        if (iMetaData == 3) {
            if (world.I) {
                return;
            }
            int iNumDropped = world.s.nextInt(20) != 0 ? 0 : 1;
            for (int iTempCount = 0; iTempCount < iNumDropped; ++iTempCount) {
                int iItemID;
                if (world.s.nextFloat() > fChance || (iItemID = this.a(iMetaData, world.s, iFortuneModifier)) <= 0) continue;
                this.b(world, i2, j2, k, new wm(iItemID, 1, this.a(iMetaData)));
            }
        } else {
            super.a(world, i2, j2, k, iMetaData, fChance, iFortuneModifier);
        }
    }

    @Override
    protected void b(aab world, int i2, int j2, int k, wm itemStack) {
        if (itemStack.c == this.cz && itemStack.k() == 2) {
            if (world.I) {
                return;
            }
            float f2 = 0.7f;
            double d2 = (double)(world.s.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
            double d1 = (double)(world.s.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
            double d22 = (double)(world.s.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
            rh entityitem = (rh)mv.createEntityOfType(BloodWoodSaplingItemEntity.class, world, (double)i2 + d2, (double)j2 + d1, (double)k + d22, itemStack);
            entityitem.b = 10;
            world.d(entityitem);
            return;
        }
        super.b(world, i2, j2, k, itemStack);
    }

    @Override
    public void a(aab world, sq entityPlayer, int i2, int j2, int k, int iMetaData) {
        if (!world.I && entityPlayer.cd() != null && entityPlayer.cd().b() instanceof ShearsItem && iMetaData == 3) {
            this.b(world, i2, j2, k, new wm(BTWBlocks.bloodWoodLeaves, 1, 0));
            entityPlayer.cd().a(1, (ng)entityPlayer);
        } else {
            super.a(world, entityPlayer, i2, j2, k, iMetaData);
        }
    }

    @Override
    public aqx b(aab world, int i2, int j2, int k) {
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if (iSubtype == 0 || iSubtype == 1 || iSubtype == 5 || iSubtype == 4 || iSubtype == 2) {
            return null;
        }
        return super.b(world, i2, j2, k);
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iSubtype = this.getSubtype(blockAccess, i2, j2, k);
        return this.getBlockBoundsFromPoolBasedOnSubtype(iSubtype);
    }

    @Override
    public int a(aab world) {
        return 10;
    }

    @Override
    public float getMovementModifier(aab world, int i2, int j2, int k) {
        return 0.8f;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, mp entity) {
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if ((iSubtype == 0 || iSubtype == 4 || iSubtype == 1 || iSubtype == 5 || iSubtype == 2) && entity.isAffectedByMovementModifiers() && entity.F) {
            entity.x *= 0.8;
            entity.z *= 0.8;
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if (iSubtype == 1 || iSubtype == 5) {
            this.setSubtype(world, i2, j2, k, iSubtype - 1);
        } else if (iSubtype == 2 && this.validateBloodWoodSapling(world, i2, j2, k) && random.nextInt(14) == 0 && world.t.h == -1) {
            this.attemptToGrowBloodwoodSapling(world, i2, j2, k, random);
        }
    }

    @Override
    public boolean onBlockSawed(aab world, int i2, int j2, int k) {
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if (iSubtype == 2) {
            return false;
        }
        return super.onBlockSawed(world, i2, j2, k);
    }

    @Override
    public boolean doesBlockHopperEject(aab world, int i2, int j2, int k) {
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if (iSubtype == 0 || iSubtype == 1 || iSubtype == 2 || iSubtype == 4 || iSubtype == 5) {
            return false;
        }
        return super.doesBlockHopperEject(world, i2, j2, k);
    }

    @Override
    public boolean a(aab world, int i2, int j2, int k, int iSide, wm stack) {
        if (stack != null && stack.k() == 2 && !this.canBloodwoodSaplingStayAtLocation(world, i2, j2, k)) {
            return false;
        }
        return super.a(world, i2, j2, k, iSide, stack);
    }

    public int getSubtype(aak blockAccess, int i2, int j2, int k) {
        return blockAccess.h(i2, j2, k);
    }

    public void setSubtype(aab world, int i2, int j2, int k, int iSubtype) {
        world.setBlockMetadata(i2, j2, k, iSubtype);
    }

    public aqx getBlockBoundsFromPoolBasedOnSubtype(int iSubtype) {
        switch (iSubtype) {
            case 0: 
            case 1: {
                return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
            }
            case 4: 
            case 5: {
                return aqx.a().a(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
            }
        }
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public boolean validateBloodWoodSapling(aab world, int i2, int j2, int k) {
        if (!this.f(world, i2, j2, k)) {
            this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
            world.setBlockWithNotify(i2, j2, k, 0);
            return false;
        }
        return true;
    }

    public void attemptToGrowBloodwoodSapling(aab world, int i2, int j2, int k, Random random) {
        int iTempJ;
        for (iTempJ = j2 + 1; iTempJ < j2 + 4; ++iTempJ) {
            if (iTempJ < 256 && world.c(i2, iTempJ, k)) continue;
            return;
        }
        for (iTempJ = j2; iTempJ < j2 + 4 - 1; ++iTempJ) {
            world.setBlockAndMetadataWithNotify(i2, iTempJ, k, BTWBlocks.bloodWoodLog.cz, 0);
        }
        BloodWoodLogBlock bloodWoodBlock = (BloodWoodLogBlock)BTWBlocks.bloodWoodLog;
        int iTrunkTopJ = j2 + 4 - 1;
        world.setBlockAndMetadataWithNotify(i2, iTrunkTopJ, k, BTWBlocks.bloodWoodLog.cz, 1);
        bloodWoodBlock.growLeaves(world, i2, iTrunkTopJ, k);
        bloodWoodBlock.grow(world, i2, iTrunkTopJ, k, random);
        for (int tempI = i2 - 1; tempI <= i2 + 1; ++tempI) {
            for (int tempJ = iTrunkTopJ; tempJ <= iTrunkTopJ + 1; ++tempJ) {
                for (int tempK = k - 1; tempK <= k + 1; ++tempK) {
                    int iGrowthDirection;
                    if (world.a(tempI, tempJ, tempK) != BTWBlocks.bloodWoodLog.cz || (iGrowthDirection = bloodWoodBlock.getFacing(world, tempI, tempJ, tempK)) == 0 || tempI == i2 && tempJ == iTrunkTopJ && tempK == k) continue;
                    bloodWoodBlock.grow(world, tempI, tempJ, tempK, random);
                }
            }
        }
        world.e(2228, i2, j2, k, 0);
    }

    public boolean canBloodwoodSaplingStayAtLocation(aab world, int i2, int j2, int k) {
        int iBlockBelowID = world.a(i2, j2 - 1, k);
        if (iBlockBelowID == apa.bg.cz) {
            return true;
        }
        return iBlockBelowID == BTWBlocks.planter.cz && ((PlanterBlock)BTWBlocks.planter).getPlanterType(world, i2, j2 - 1, k) == 8;
    }

    @Override
    public boolean attemptToAffectBlockWithSoul(aab world, int x2, int y2, int z2) {
        int iTargetSubType = world.h(x2, y2, z2);
        if (iTargetSubType == 2) {
            this.attemptToGrowBloodwoodSapling(world, x2, y2, z2, world.s);
            return true;
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        lx vineIcon;
        this.cQ = vineIcon = register.a("fcBlockVineTrap");
        this.iconVineTrap = vineIcon;
        this.iconSaplingBloodWood = register.a("fcBlockSaplingBloodWood");
        this.iconLeavesBloodWood = register.a("fcBlockLeavesBloodWood_old");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        int iSubtype = iMetadata;
        switch (iSubtype) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                return this.iconVineTrap;
            }
            case 2: {
                return this.iconSaplingBloodWood;
            }
            case 3: {
                return this.iconLeavesBloodWood;
            }
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int iBlockID, ve creativeTabs, List list) {
        list.add(new wm(iBlockID, 1, 0));
        list.add(new wm(iBlockID, 1, 2));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        if (iSide >= 2 && blockAccess.a(iNeighborI, iNeighborJ, iNeighborK) == this.cz) {
            int iTargetSubtype = blockAccess.h(iNeighborI, iNeighborJ, iNeighborK);
            if (iTargetSubtype == 0 || iTargetSubtype == 1) {
                BlockPos sourcePos = new BlockPos(iNeighborI, iNeighborJ, iNeighborK);
                sourcePos.addFacingAsOffset(apa.getOppositeFacing(iSide));
                int iSourceSubtype = blockAccess.h(sourcePos.x, sourcePos.y, sourcePos.z);
                if (iSourceSubtype == 0 || iSourceSubtype == 1) {
                    return false;
                }
            } else if (iTargetSubtype == 4 || iTargetSubtype == 5) {
                BlockPos sourcePos = new BlockPos(iNeighborI, iNeighborJ, iNeighborK);
                sourcePos.addFacingAsOffset(apa.getOppositeFacing(iSide));
                int iSourceSubtype = blockAccess.h(sourcePos.x, sourcePos.y, sourcePos.z);
                if (iSourceSubtype == 4 || iSourceSubtype == 5) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aab world, int i2, int j2, int k) {
        int iMetadata = world.h(i2, j2, k);
        if (iMetadata == 3) {
            return BTWBlocks.bloodWoodLeaves.cz;
        }
        return this.a(iMetadata, world.s, 0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int h(aab world, int i2, int j2, int k) {
        int iMetadata = world.h(i2, j2, k);
        if (iMetadata == 3) {
            return 0;
        }
        return super.h(world, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        int iSubtype = this.getSubtype(blockAccess, i2, j2, k);
        renderBlocks.setRenderBounds(this.getBlockBoundsFromPoolBasedOnSubtype(iSubtype));
        switch (iSubtype) {
            case 2: {
                return renderBlocks.k(this, i2, j2, k);
            }
        }
        return renderBlocks.p(this, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        renderBlocks.setRenderBounds(this.getBlockBoundsFromPoolBasedOnSubtype(iItemDamage));
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, this, -0.5f, -0.5f, -0.5f, iItemDamage);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean doesItemRenderAsBlock(int iItemDamage) {
        if (iItemDamage == 2) {
            return false;
        }
        return super.doesItemRenderAsBlock(iItemDamage);
    }
}

