/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.item.BTWItems;
import btw.item.items.HoeItem;
import btw.world.util.BlockPos;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class AestheticOpaqueEarthBlock
extends apa {
    public static final int SUBTYPE_BLIGHT_LEVEL_0 = 0;
    public static final int SUBTYPE_BLIGHT_LEVEL_1 = 1;
    public static final int SUBTYPE_BLIGHT_LEVEL_2 = 2;
    public static final int SUBTYPE_BLIGHT_ROOTS_LEVEL_2 = 3;
    public static final int SUBTYPE_BLIGHT_LEVEL_3 = 4;
    public static final int SUBTYPE_BLIGHT_ROOTS_LEVEL_3 = 5;
    public static final int SUBTYPE_PACKED_EARTH = 6;
    public static final int SUBTYPE_DUNG = 7;
    public static final int[] subtypeToBlightLevel = new int[]{0, 1, 2, 2, 3, 3, -1, -1};
    public static final int[] blightLevelToSubtype = new int[]{0, 1, 2, 4};
    public static final int M_I_NUM_SUBTYPES = 8;
    @Environment(value=EnvType.CLIENT)
    private lx iconDung;
    @Environment(value=EnvType.CLIENT)
    private lx iconPackedEarth;
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBlightLevel0SideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBlightLevel1SideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBlightLevel2SideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBlightLevel3SideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBlightRootsLevel2SideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private lx iconBlightRootsLevel3;

    public AestheticOpaqueEarthBlock(int iBlockID) {
        super(iBlockID, aif.c);
        this.c(0.6f);
        this.setShovelsEffectiveOn(true);
        this.setHoesEffectiveOn();
        this.b(true);
        this.a(h);
        this.a(ve.b);
        this.c("fcBlockAestheticOpaqueEarth");
    }

    @Override
    public int a(int iMetadata) {
        if (this.isBlightFromMetadata(iMetadata)) {
            return 0;
        }
        return iMetadata;
    }

    @Override
    public int a(int iMetadata, Random random, int iFortuneModifier) {
        if (this.isBlightFromMetadata(iMetadata)) {
            return BTWBlocks.looseDirt.cz;
        }
        return this.cz;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iMetadata, float fChance, int iFortuneModifier) {
        if (this.isBlightFromMetadata(iMetadata)) {
            if (!world.I) {
                int iNumDropped = 8;
                for (int iTempCount = 0; iTempCount < iNumDropped; ++iTempCount) {
                    this.b(world, i2, j2, k, new wm(BTWItems.dirtPile));
                }
            }
        } else {
            super.a(world, i2, j2, k, iMetadata, fChance, iFortuneModifier);
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        int iSubtype = world.h(i2, j2, k);
        if (this.isBlightFromMetadata(iSubtype)) {
            this.blightRandomUpdateTick(world, i2, j2, k, rand);
        }
    }

    @Override
    protected wm c_(int iMetadata) {
        int iItemDamage = iMetadata;
        if (iMetadata == 1 || iMetadata == 2 || iMetadata == 3) {
            iItemDamage = 0;
        } else if (iMetadata == 5) {
            iItemDamage = 4;
        }
        return new wm(this.cz, 1, iItemDamage);
    }

    @Override
    public float getMovementModifier(aab world, int i2, int j2, int k) {
        float fModifier = 1.0f;
        int iSubtype = world.h(i2, j2, k);
        if (iSubtype == 6) {
            fModifier = 1.2f;
        } else if (iSubtype == 7) {
            fModifier = 0.8f;
        }
        return fModifier;
    }

    @Override
    public ape getStepSound(aab world, int i2, int j2, int k) {
        int iSubtype = world.h(i2, j2, k);
        if (iSubtype == 7) {
            return BTWBlocks.stepSoundSquish;
        }
        return this.cM;
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        this.dropAsPiles(world, i2, j2, k, iMetadata, 1.0f);
        if (iMetadata != 7 && iMetadata != 6) {
            this.onDirtDugWithImproperTool(world, i2, j2, k);
        }
    }

    private void dropAsPiles(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfPileDrop) {
        wk itemToDrop = BTWItems.dirtPile;
        int iCountToDrop = 6;
        int iSubtype = iMetadata;
        if (iSubtype == 6) {
            iCountToDrop = 12;
        } else if (iSubtype == 7) {
            itemToDrop = BTWItems.dung;
            iCountToDrop = 8;
        }
        for (int iTempCount = 0; iTempCount < iCountToDrop; ++iTempCount) {
            if (!(world.s.nextFloat() <= fChanceOfPileDrop)) continue;
            wm tempStack = new wm(itemToDrop);
            this.b(world, i2, j2, k, tempStack);
        }
    }

    @Override
    public boolean a(zw par1Explosion) {
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        int iMetadata = world.h(i2, j2, k);
        float fChanceOfPileDrop = 1.0f;
        if (explosion != null) {
            fChanceOfPileDrop = 1.0f / explosion.g;
        }
        this.dropAsPiles(world, i2, j2, k, iMetadata, fChanceOfPileDrop);
        if (iMetadata != 7 && iMetadata != 6) {
            this.onDirtDugWithImproperTool(world, i2, j2, k);
        }
    }

    @Override
    public boolean canSaplingsGrowOnBlock(aab world, int i2, int j2, int k) {
        return this.isBlightFromMetadata(world.h(i2, j2, k));
    }

    @Override
    public boolean canBePistonShoveled(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        return stack != null && stack.b() instanceof HoeItem;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int i2, int j2, int k, int iFromSide) {
        if (this.isBlightFromMetadata(world.h(i2, j2, k))) {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.looseDirt.cz);
            if (!world.I) {
                world.e(2001, i2, j2, k, this.cz);
            }
            return true;
        }
        return false;
    }

    public boolean isSurfaceBlightFromMetadata(int iMetadata) {
        return iMetadata >= 0 && iMetadata <= 4 && iMetadata != 3;
    }

    public boolean isBlightFromMetadata(int iMetadata) {
        return iMetadata >= 0 && iMetadata <= 5;
    }

    private int getRootsSubtypeForLevel(int iLevel) {
        if (iLevel >= 3) {
            return 5;
        }
        return 3;
    }

    private void blightRandomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (!this.checkForBlightSurfaceConversions(world, i2, j2, k)) {
            int iBlockSubtype = world.h(i2, j2, k);
            if (iBlockSubtype == 1) {
                this.blightKillLeaves(world, i2, j2, k, rand);
            } else if (iBlockSubtype >= 2) {
                this.blightKillVinesAndLeaves(world, i2, j2, k, rand);
            }
            if (world.t.h != 1) {
                this.checkForBlightSpread(world, i2, j2, k, rand);
                this.checkForBlightEvolution(world, i2, j2, k, rand);
            }
        }
    }

    private void checkForSpreadToLocation(aab world, int i2, int j2, int k, int iBlightSubtype) {
        int iTargetBlockID = world.a(i2, j2, k);
        if (iTargetBlockID > 0) {
            int iBlightLevel = subtypeToBlightLevel[iBlightSubtype];
            if (iTargetBlockID == this.cz) {
                int iTargetMetadata = world.h(i2, j2, k);
                int iTargetBlightLevel = subtypeToBlightLevel[iTargetMetadata];
                if (iTargetBlightLevel < iBlightLevel && iTargetBlightLevel >= 0) {
                    if (this.isSurfaceBlightFromMetadata(iTargetMetadata)) {
                        iTargetBlightLevel = iBlightLevel == 3 ? 3 : ++iTargetBlightLevel;
                        world.setBlockMetadataWithNotify(i2, j2, k, blightLevelToSubtype[iTargetBlightLevel]);
                    } else {
                        world.setBlockMetadataWithNotify(i2, j2, k, 5);
                    }
                }
            } else {
                apa targetBlock = apa.r[iTargetBlockID];
                if (targetBlock.getCanBlightSpreadToBlock(world, i2, j2, k, iBlightLevel)) {
                    if (iBlightLevel < 3) {
                        if (apa.t[world.a(i2, j2 + 1, k)] <= 2) {
                            world.setBlockAndMetadataWithNotify(i2, j2, k, this.cz, 0);
                        }
                    } else if (apa.t[world.a(i2, j2 + 1, k)] <= 2) {
                        world.setBlockAndMetadataWithNotify(i2, j2, k, this.cz, 4);
                    } else {
                        world.setBlockAndMetadataWithNotify(i2, j2, k, this.cz, 5);
                    }
                }
            }
        }
    }

    private void checkForBlightSpread(aab world, int i2, int j2, int k, Random rand) {
        int iBlockSubtype = world.h(i2, j2, k);
        if (iBlockSubtype == 0) {
            int iRandI = i2 + rand.nextInt(3) - 1;
            int iRandJ = j2 + rand.nextInt(3) - 1;
            int iRandK = k + rand.nextInt(3) - 1;
            this.checkForSpreadToLocation(world, iRandI, iRandJ, iRandK, iBlockSubtype);
        } else if (iBlockSubtype == 1) {
            for (int iTempCount = 0; iTempCount < 2; ++iTempCount) {
                int iRandI = i2 + rand.nextInt(3) - 1;
                int iRandJ = j2 + rand.nextInt(4) - 1;
                int iRandK = k + rand.nextInt(3) - 1;
                this.checkForSpreadToLocation(world, iRandI, iRandJ, iRandK, iBlockSubtype);
            }
        } else {
            for (int iTempCount = 0; iTempCount < 4; ++iTempCount) {
                int iRandI = i2 + rand.nextInt(3) - 1;
                int iRandJ = j2 + rand.nextInt(5) - 2;
                int iRandK = k + rand.nextInt(3) - 1;
                this.checkForSpreadToLocation(world, iRandI, iRandJ, iRandK, iBlockSubtype);
            }
            int iRootsSubtype = this.getRootsSubtypeForLevel(subtypeToBlightLevel[iBlockSubtype]);
            if (world.a(i2, j2 - 1, k) == apa.z.cz) {
                world.setBlockAndMetadataWithNotify(i2, j2 - 1, k, this.cz, iRootsSubtype);
            }
            if (world.a(i2, j2 + 1, k) == apa.z.cz) {
                world.setBlockAndMetadataWithNotify(i2, j2 + 1, k, this.cz, iRootsSubtype);
            }
        }
    }

    private void checkForBlightEvolution(aab world, int i2, int j2, int k, Random rand) {
        int iRandK;
        int iRandJ;
        int iRandI;
        int iTargetBlockID;
        int iBlockSubtype = world.h(i2, j2, k);
        if (iBlockSubtype == 0) {
            int iRandomFacing = rand.nextInt(6);
            BlockPos targetPos = new BlockPos(i2, j2, k, iRandomFacing);
            if (world.g(targetPos.x, targetPos.y, targetPos.z) == aif.h) {
                world.setBlockMetadataWithNotify(i2, j2, k, 1);
            }
        } else if (iBlockSubtype == 1) {
            int iRandomFacing = rand.nextInt(6);
            BlockPos targetPos = new BlockPos(i2, j2, k, iRandomFacing);
            if (world.g(targetPos.x, targetPos.y, targetPos.z) == aif.i) {
                world.setBlockMetadataWithNotify(i2, j2, k, 2);
            }
        } else if ((iBlockSubtype == 2 || iBlockSubtype == 3) && (iTargetBlockID = world.a(iRandI = i2 + rand.nextInt(7) - 3, iRandJ = j2 + rand.nextInt(7) - 3, iRandK = k + rand.nextInt(7) - 3)) == apa.bi.cz) {
            if (iBlockSubtype == 2) {
                world.setBlockMetadataWithNotify(i2, j2, k, 4);
            } else {
                world.setBlockMetadataWithNotify(i2, j2, k, 5);
            }
        }
    }

    private boolean checkForBlightSurfaceConversions(aab world, int i2, int j2, int k) {
        int iBlightSubtype = world.h(i2, j2, k);
        int iBlockAboveID = world.a(i2, j2 + 1, k);
        if (apa.t[iBlockAboveID] > 2) {
            if (iBlightSubtype == 0) {
                world.setBlockWithNotify(i2, j2, k, apa.z.cz);
                return true;
            }
            if (iBlightSubtype == 2) {
                world.setBlockAndMetadataWithNotify(i2, j2, k, this.cz, 3);
                return true;
            }
            if (iBlightSubtype == 4) {
                world.setBlockAndMetadataWithNotify(i2, j2, k, this.cz, 5);
                return true;
            }
        } else {
            if (iBlightSubtype == 3) {
                world.setBlockAndMetadataWithNotify(i2, j2, k, this.cz, 2);
                return true;
            }
            if (iBlightSubtype == 5) {
                world.setBlockAndMetadataWithNotify(i2, j2, k, this.cz, 4);
                return true;
            }
        }
        return false;
    }

    private void blightKillLeaves(aab world, int i2, int j2, int k, Random rand) {
        for (int iTempCount = 0; iTempCount < 4; ++iTempCount) {
            int iRandK;
            int iRandJ;
            int iRandI = i2 + rand.nextInt(3) - 1;
            int iTargetBlockID = world.a(iRandI, iRandJ = j2 + rand.nextInt(9), iRandK = k + rand.nextInt(3) - 1);
            if (iTargetBlockID != apa.O.cz) continue;
            world.setBlockWithNotify(iRandI, iRandJ, iRandK, 0);
        }
    }

    private void blightKillVinesAndLeaves(aab world, int i2, int j2, int k, Random rand) {
        for (int iTempCount = 0; iTempCount < 4; ++iTempCount) {
            int iRandK;
            int iRandJ;
            int iRandI = i2 + rand.nextInt(3) - 1;
            int iTargetBlockID = world.a(iRandI, iRandJ = j2 + rand.nextInt(9), iRandK = k + rand.nextInt(3) - 1);
            if (iTargetBlockID != apa.O.cz && iTargetBlockID != apa.by.cz) continue;
            world.setBlockWithNotify(iRandI, iRandJ, iRandK, 0);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        lx sideIcon;
        this.cQ = register.a("dirt");
        this.iconDung = register.a("fcBlockDung");
        this.iconPackedEarth = register.a("FCBlockPackedEarth");
        this.iconBlightLevel0SideArray[0] = register.a("FCBlockBlightL0_bottom");
        this.iconBlightLevel0SideArray[1] = register.a("FCBlockBlightL0_top");
        this.iconBlightLevel0SideArray[2] = sideIcon = register.a("FCBlockBlightL0_side");
        this.iconBlightLevel0SideArray[3] = sideIcon;
        this.iconBlightLevel0SideArray[4] = sideIcon;
        this.iconBlightLevel0SideArray[5] = sideIcon;
        this.iconBlightLevel1SideArray[0] = register.a("FCBlockBlightL1_bottom");
        this.iconBlightLevel1SideArray[1] = register.a("FCBlockBlightL1_top");
        this.iconBlightLevel1SideArray[2] = sideIcon = register.a("FCBlockBlightL1_side");
        this.iconBlightLevel1SideArray[3] = sideIcon;
        this.iconBlightLevel1SideArray[4] = sideIcon;
        this.iconBlightLevel1SideArray[5] = sideIcon;
        this.iconBlightLevel2SideArray[0] = register.a("FCBlockBlightL2_bottom");
        this.iconBlightLevel2SideArray[1] = register.a("FCBlockBlightL2_top");
        this.iconBlightLevel2SideArray[2] = sideIcon = register.a("FCBlockBlightL2_side");
        this.iconBlightLevel2SideArray[3] = sideIcon;
        this.iconBlightLevel2SideArray[4] = sideIcon;
        this.iconBlightLevel2SideArray[5] = sideIcon;
        this.iconBlightLevel3SideArray[0] = register.a("FCBlockBlightL3_roots");
        this.iconBlightLevel3SideArray[1] = register.a("FCBlockBlightL3_top");
        this.iconBlightLevel3SideArray[2] = sideIcon = register.a("FCBlockBlightL3_side");
        this.iconBlightLevel3SideArray[3] = sideIcon;
        this.iconBlightLevel3SideArray[4] = sideIcon;
        this.iconBlightLevel3SideArray[5] = sideIcon;
        this.iconBlightRootsLevel2SideArray[0] = register.a("FCBlockBlightL2_bottom");
        this.iconBlightRootsLevel2SideArray[1] = sideIcon = register.a("FCBlockBlightL2_roots");
        this.iconBlightRootsLevel2SideArray[2] = sideIcon;
        this.iconBlightRootsLevel2SideArray[3] = sideIcon;
        this.iconBlightRootsLevel2SideArray[4] = sideIcon;
        this.iconBlightRootsLevel2SideArray[5] = sideIcon;
        this.iconBlightRootsLevel3 = register.a("FCBlockBlightL3_roots");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iMetadata == 0) {
            return this.iconBlightLevel0SideArray[iSide];
        }
        if (iMetadata == 1) {
            return this.iconBlightLevel1SideArray[iSide];
        }
        if (iMetadata == 2) {
            return this.iconBlightLevel2SideArray[iSide];
        }
        if (iMetadata == 3) {
            return this.iconBlightRootsLevel2SideArray[iSide];
        }
        if (iMetadata == 4) {
            return this.iconBlightLevel3SideArray[iSide];
        }
        if (iMetadata == 5) {
            return this.iconBlightRootsLevel3;
        }
        if (iMetadata == 6) {
            return this.iconPackedEarth;
        }
        if (iMetadata == 7) {
            return this.iconDung;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int blockID, ve creativeTabs, List list) {
        list.add(new wm(blockID, 1, 0));
        list.add(new wm(blockID, 1, 1));
        list.add(new wm(blockID, 1, 2));
        list.add(new wm(blockID, 1, 4));
        list.add(new wm(blockID, 1, 3));
        list.add(new wm(blockID, 1, 5));
        list.add(new wm(blockID, 1, 6));
        list.add(new wm(blockID, 1, 7));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int h(aab world, int x2, int y2, int z2) {
        int metadata = world.h(x2, y2, z2);
        if (metadata == 0 || metadata == 1 || metadata == 2 || metadata == 4 || metadata == 3 || metadata == 5) {
            return metadata;
        }
        return super.h(world, x2, y2, z2);
    }
}

