/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.UnfiredPotteryBlock;
import btw.client.render.util.RenderUtils;
import btw.item.BTWItems;
import btw.world.util.WorldUtils;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class AestheticNonOpaqueBlock
extends apa {
    public static final int SUBTYPE_URN = 0;
    public static final int SUBTYPE_COLUMN = 1;
    public static final int SUBTYPE_PEDESTAL_UP = 2;
    public static final int SUBTYPE_PEDESTAL_DOWN = 3;
    public static final int SUBTYPE_TABLE = 4;
    public static final int SUBTYPE_WICKER_SLAB = 5;
    public static final int SUBTYPE_GRATE = 6;
    public static final int SUBTYPE_WICKER = 7;
    public static final int SUBTYPE_SLATS = 8;
    public static final int SUBTYPE_WICKER_SLAB_UPSIDE_DOWN = 9;
    public static final int SUBTYPE_WHITE_COBBLE_SLAB = 10;
    public static final int SUBTYPE_WHITE_COBBLE_SLAB_UPSIDE_DOWN = 11;
    public static final int SUBTYPE_LIGHTNING_ROD = 12;
    public static final int NUM_SUBTYPES = 13;
    private static final float DEFAULT_HARDNESS = 2.0f;
    private static final float COLUM_WIDTH = 0.625f;
    private static final float COLUM_HALF_WIDTH = 0.3125f;
    private static final float PEDESTAL_BASE_HEIGHT = 0.75f;
    private static final float PEDESTAL_MIDDLE_HEIGHT = 0.125f;
    private static final float PEDESTAL_MIDDLE_WIDTH = 0.875f;
    private static final float PEDESTAL_MIDDLE_HALF_WIDTH = 0.4375f;
    private static final float PEDESTAL_TOP_HEIGHT = 0.125f;
    private static final float PEDESTAL_TOP_WIDTH = 0.75f;
    private static final float PEDESTAL_TOP_HALF_WIDTH = 0.375f;
    private static final float TABLE_TOP_HEIGHT = 0.125f;
    private static final float TABLE_LEG_HEIGHT = 0.875f;
    private static final float TABLE_LEG_WIDTH = 0.25f;
    private static final float TABLE_LEG_HALF_WIDTH = 0.125f;
    private static final float LIGHTNING_ROD_SHAFT_WIDTH = 0.0625f;
    private static final float LIGHTNING_ROD_SHAFT_HALF_WIDTH = 0.03125f;
    private static final float LIGHTNING_ROD_BASE_WIDTH = 0.25f;
    private static final float LIGHTNING_ROD_BASE_HALF_WIDTH = 0.125f;
    private static final float LIGHTNING_ROD_BASE_HEIGHT = 0.125f;
    private static final float LIGHTNING_ROD_BASE_HALF_HEIGHT = 0.0625f;
    private static final float LIGHTNING_ROD_BALL_WIDTH = 0.1875f;
    private static final float LIGHTNING_ROD_BALL_HALF_WIDTH = 0.09375f;
    private static final float LIGHTNING_ROD_BALL_VERTICAL_OFFSET = 0.625f;
    private static final float LIGHTNING_ROD_CANDLE_HOLDER_WIDTH = 0.25f;
    private static final float LIGHTNING_ROD_CANDLE_HOLDER_HALF_WIDTH = 0.125f;
    private static final float LIGHTNING_ROD_CANDLE_HOLDER_HEIGHT = 0.0625f;
    private static final float LIGHTNING_ROD_CANDLE_HOLDER_HALF_HEIGHT = 0.03125f;
    private static final float LIGHTNING_ROD_CANDLE_HOLDER_VERTICAL_OFFSET = 0.99609375f;
    @Environment(value=EnvType.CLIENT)
    private lx iconUrn;
    @Environment(value=EnvType.CLIENT)
    private lx iconColumnStoneTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconColumnStoneSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconPedestalStoneTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconPedestalStoneSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconSlabWicker;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrate;
    @Environment(value=EnvType.CLIENT)
    private lx iconWicker;
    @Environment(value=EnvType.CLIENT)
    private lx iconSlats;
    @Environment(value=EnvType.CLIENT)
    private lx iconSlatsSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconWhiteCobble;
    @Environment(value=EnvType.CLIENT)
    private lx iconLightningRod;
    @Environment(value=EnvType.CLIENT)
    public lx iconTableWoodOakTop;
    @Environment(value=EnvType.CLIENT)
    public lx iconTableWoodOakLeg;

    public AestheticNonOpaqueBlock(int blockID) {
        super(blockID, BTWBlocks.miscMaterial);
        this.c(2.0f);
        this.setAxesEffectiveOn(true);
        this.setPicksEffectiveOn(true);
        this.a(j);
        this.c("fcBlockAestheticNonOpaque");
        this.a(ve.c);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public int a(int metadata, Random random, int fortuneModifier) {
        if (metadata == 0) {
            return BTWItems.urn.cp;
        }
        if (metadata == 5 || metadata == 9) {
            return BTWBlocks.wickerSlab.cz;
        }
        if (metadata == 6) {
            return BTWBlocks.gratePane.cz;
        }
        if (metadata == 7) {
            return BTWBlocks.wickerPane.cz;
        }
        if (metadata == 8) {
            return BTWBlocks.slatsPane.cz;
        }
        if (metadata == 3 || metadata == 2 || metadata == 1) {
            return BTWBlocks.stoneMouldingAndDecorative.cz;
        }
        if (metadata == 4) {
            return BTWItems.woodMouldingDecorativeStubID;
        }
        return this.cz;
    }

    @Override
    public int a(int metadata) {
        if (metadata == 3 || metadata == 2) {
            metadata = 13;
        } else if (metadata == 1) {
            metadata = 12;
        } else if (metadata == 11) {
            metadata = 10;
        } else {
            if (metadata == 4) {
                return 8;
            }
            if (metadata == 0 || metadata == 5 || metadata == 9 || metadata == 6 || metadata == 7 || metadata == 8) {
                metadata = 0;
            }
        }
        return metadata;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int facing, float clickX, float clickY, float clickZ, int metadata) {
        if (metadata == 2) {
            if (facing == 0 || facing != 1 && (double)clickY > 0.5) {
                return 3;
            }
        } else if (metadata == 5) {
            if (facing == 0 || facing != 1 && (double)clickY > 0.5) {
                return 9;
            }
        } else if (metadata == 10 && (facing == 0 || facing != 1 && (double)clickY > 0.5)) {
            return 11;
        }
        return metadata;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iSubType = blockAccess.h(i2, j2, k);
        switch (iSubType) {
            case 4: {
                if (!this.isTableOnCorner(blockAccess, i2, j2, k)) {
                    return aqx.a().a(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
                }
                return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            case 6: 
            case 7: 
            case 8: {
                return this.getBlockBoundsFromPoolForPane(blockAccess, i2, j2, k, iSubType);
            }
            case 0: {
                aqx urnBox = aqx.a().a(0.3125, 0.0, 0.3125, 0.6875, 0.625, 0.6875);
                if (blockAccess.a(i2, j2 + 1, k) == BTWBlocks.hopper.cz) {
                    urnBox.d(0.0, 0.375, 0.0);
                }
                return urnBox;
            }
            case 1: {
                return aqx.a().a(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
            }
            case 5: 
            case 10: {
                return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
            }
            case 9: 
            case 11: {
                return aqx.a().a(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
            }
            case 12: {
                return aqx.a().a(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
            }
        }
        return super.getBlockBoundsFromPoolBasedOnState(blockAccess, i2, j2, k);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, aqx intersectingBox, List list, mp entity) {
        int iSubType = world.h(i2, j2, k);
        if (iSubType == 6 || iSubType == 7 || iSubType == 8) {
            aqx tempBox;
            boolean bKNeg = this.shouldPaneConnectToBlock(world, i2, j2, k - 1, iSubType);
            boolean bKPos = this.shouldPaneConnectToBlock(world, i2, j2, k + 1, iSubType);
            boolean bINeg = this.shouldPaneConnectToBlock(world, i2 - 1, j2, k, iSubType);
            boolean bIPos = this.shouldPaneConnectToBlock(world, i2 + 1, j2, k, iSubType);
            if ((!bINeg || !bIPos) && (bINeg || bIPos || bKNeg || bKPos)) {
                if (bINeg && !bIPos) {
                    tempBox = aqx.a().a(0.0, 0.0, 0.4375, 0.5, 1.0, 0.5625).d(i2, j2, k);
                    tempBox.addToListIfIntersects(intersectingBox, list);
                } else if (!bINeg && bIPos) {
                    tempBox = aqx.a().a(0.5, 0.0, 0.4375, 1.0, 1.0, 0.5625).d(i2, j2, k);
                    tempBox.addToListIfIntersects(intersectingBox, list);
                }
            } else {
                tempBox = aqx.a().a(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625).d(i2, j2, k);
                tempBox.addToListIfIntersects(intersectingBox, list);
            }
            if ((!bKNeg || !bKPos) && (bINeg || bIPos || bKNeg || bKPos)) {
                if (bKNeg && !bKPos) {
                    tempBox = aqx.a().a(0.4375, 0.0, 0.0, 0.5625, 1.0, 0.5).d(i2, j2, k);
                    tempBox.addToListIfIntersects(intersectingBox, list);
                } else if (!bKNeg && bKPos) {
                    tempBox = aqx.a().a(0.4375, 0.0, 0.5, 0.5625, 1.0, 1.0).d(i2, j2, k);
                    tempBox.addToListIfIntersects(intersectingBox, list);
                }
            } else {
                tempBox = aqx.a().a(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0).d(i2, j2, k);
                tempBox.addToListIfIntersects(intersectingBox, list);
            }
        } else {
            super.a(world, i2, j2, k, intersectingBox, list, entity);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int changedBlockID) {
        super.a(world, i2, j2, k, changedBlockID);
        int iSubtype = this.getSubtype(world, i2, j2, k);
        if (iSubtype == 12) {
            if (!AestheticNonOpaqueBlock.canLightningRodStay(world, i2, j2, k)) {
                if (world.a(i2, j2, k) == this.cz) {
                    this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
                    world.setBlockWithNotify(i2, j2, k, 0);
                }
            } else {
                world.g(i2, j2, k, i2, j2, k);
            }
        }
    }

    @Override
    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int facing, boolean ignoreTransparency) {
        int iSubtype = blockAccess.h(i2, j2, k);
        switch (iSubtype) {
            case 1: {
                return facing == 0 || facing == 1;
            }
            case 2: 
            case 3: {
                return true;
            }
        }
        return super.hasCenterHardPointToFacing(blockAccess, i2, j2, k, facing, ignoreTransparency);
    }

    @Override
    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int facing, boolean ignoreTransparency) {
        int iSubtype = blockAccess.h(i2, j2, k);
        switch (iSubtype) {
            case 2: {
                return facing == 0;
            }
            case 3: {
                return facing == 1;
            }
            case 5: 
            case 10: {
                return facing == 0;
            }
            case 9: 
            case 11: {
                return facing == 1;
            }
            case 4: {
                return facing == 1;
            }
        }
        return super.hasLargeCenterHardPointToFacing(blockAccess, i2, j2, k, facing, ignoreTransparency);
    }

    @Override
    public boolean hasSmallCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int facing, boolean ignoreTransparency) {
        int iSubtype = blockAccess.h(i2, j2, k);
        if (iSubtype == 12) {
            return facing == 1;
        }
        return super.hasSmallCenterHardPointToFacing(blockAccess, i2, j2, k, facing, ignoreTransparency);
    }

    @Override
    public boolean doesBlockBreakSaw(aab world, int i2, int j2, int k) {
        int iSubtype = world.h(i2, j2, k);
        return iSubtype != 0 && iSubtype != 4 && iSubtype != 5 && iSubtype != 9 && iSubtype != 6 && iSubtype != 7 && iSubtype != 8;
    }

    @Override
    public float getMovementModifier(aab world, int i2, int j2, int k) {
        return 1.2f;
    }

    @Override
    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        int iSubtype = world.h(i2, j2, k);
        if (iSubtype == 5 || iSubtype == 10) {
            return true;
        }
        if (iSubtype == 0) {
            return world.w(i2, j2 - 1, k);
        }
        return super.canGroundCoverRestOnBlock(world, i2, j2, k);
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        int iSubtype = blockAccess.h(i2, j2, k);
        if (iSubtype == 5 || iSubtype == 10) {
            return -0.5f;
        }
        if (iSubtype == 0) {
            return -1.0f;
        }
        return super.groundCoverRestingOnVisualOffset(blockAccess, i2, j2, k);
    }

    @Override
    public boolean canToolsStickInBlock(aak blockAccess, int i2, int j2, int k) {
        int iSubtype = blockAccess.h(i2, j2, k);
        return iSubtype != 5;
    }

    public int getSubtype(aak blockAccess, int i2, int j2, int k) {
        return blockAccess.h(i2, j2, k);
    }

    public void setSubtype(aab world, int i2, int j2, int k, int subtype) {
        world.setBlockMetadata(i2, j2, k, subtype);
    }

    public boolean isBlockTable(aak blockAccess, int i2, int j2, int k) {
        return blockAccess.a(i2, j2, k) == BTWBlocks.aestheticNonOpaque.cz && blockAccess.h(i2, j2, k) == 4;
    }

    public boolean isTableOnCorner(aak blockAccess, int i2, int j2, int k) {
        boolean positiveITable = this.isBlockTable(blockAccess, i2 + 1, j2, k);
        boolean negativeITable = this.isBlockTable(blockAccess, i2 - 1, j2, k);
        boolean positiveKTable = this.isBlockTable(blockAccess, i2, j2, k + 1);
        boolean negativeKTable = this.isBlockTable(blockAccess, i2, j2, k - 1);
        return !positiveITable && (!positiveKTable || !negativeKTable) || !negativeITable && (!positiveKTable || !negativeKTable);
    }

    private boolean shouldPaneConnectToBlock(aak blockAccess, int i2, int j2, int k, int subType) {
        int iBlockID = blockAccess.a(i2, j2, k);
        if (apa.s[iBlockID] || iBlockID == apa.Q.cz) {
            return true;
        }
        if (iBlockID == this.cz) {
            int iTargetSubType = blockAccess.h(i2, j2, k);
            return iTargetSubType == subType;
        }
        return false;
    }

    public aqx getBlockBoundsFromPoolForPane(aak blockAccess, int i2, int j2, int k, int subType) {
        float fXMin = 0.4375f;
        float fXMax = 0.5625f;
        float fZMin = 0.4375f;
        float fZMax = 0.5625f;
        boolean bKNeg = this.shouldPaneConnectToBlock(blockAccess, i2, j2, k - 1, subType);
        boolean bKPos = this.shouldPaneConnectToBlock(blockAccess, i2, j2, k + 1, subType);
        boolean bINeg = this.shouldPaneConnectToBlock(blockAccess, i2 - 1, j2, k, subType);
        boolean bIPos = this.shouldPaneConnectToBlock(blockAccess, i2 + 1, j2, k, subType);
        if ((!bINeg || !bIPos) && (bINeg || bIPos || bKNeg || bKPos)) {
            if (bINeg && !bIPos) {
                fXMin = 0.0f;
            } else if (!bINeg && bIPos) {
                fXMax = 1.0f;
            }
        } else {
            fXMin = 0.0f;
            fXMax = 1.0f;
        }
        if ((!bKNeg || !bKPos) && (bINeg || bIPos || bKNeg || bKPos)) {
            if (bKNeg && !bKPos) {
                fZMin = 0.0f;
            } else if (!bKNeg && bKPos) {
                fZMax = 1.0f;
            }
        } else {
            fZMin = 0.0f;
            fZMax = 1.0f;
        }
        return aqx.a().a(fXMin, 0.0, fZMin, fXMax, 1.0, fZMax);
    }

    public static boolean canLightningRodStay(aab world, int i2, int j2, int k) {
        int iBlockBelowID = world.a(i2, j2 - 1, k);
        if (iBlockBelowID == BTWBlocks.aestheticNonOpaque.cz && world.h(i2, j2 - 1, k) == 12) {
            return true;
        }
        return WorldUtils.doesBlockHaveCenterHardpointToFacing(world, i2, j2 - 1, k, 1, true);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("stone");
        this.iconUrn = register.a("fcBlockUrn");
        this.iconColumnStoneTop = register.a("fcBlockColumnStone_top");
        this.iconColumnStoneSide = register.a("fcBlockColumnStone_side");
        this.iconPedestalStoneTop = register.a("fcBlockPedestalStone_top");
        this.iconPedestalStoneSide = register.a("fcBlockPedestalStone_side");
        this.iconTableWoodOakTop = register.a("fcBlockTableWoodOak_top");
        this.iconTableWoodOakLeg = register.a("fcBlockTableWoodOak_leg");
        this.iconSlabWicker = register.a("fcBlockSlabWicker");
        this.iconGrate = register.a("fcBlockGrate");
        this.iconWicker = register.a("fcBlockWicker");
        this.iconSlats = register.a("fcBlockSlats");
        this.iconSlatsSide = register.a("fcBlockSlats_side");
        this.iconWhiteCobble = register.a("fcBlockWhiteCobble");
        this.iconLightningRod = register.a("fcBlockLightningRodOld");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int side, int metadata) {
        switch (metadata) {
            case 1: {
                if (side < 2) {
                    return this.iconColumnStoneTop;
                }
                return this.iconColumnStoneSide;
            }
            case 2: 
            case 3: {
                if (side < 2) {
                    return this.iconPedestalStoneTop;
                }
                return this.iconPedestalStoneSide;
            }
            case 4: {
                return this.iconTableWoodOakTop;
            }
            case 5: 
            case 9: {
                return this.iconSlabWicker;
            }
            case 6: {
                return this.iconGrate;
            }
            case 7: {
                return this.iconWicker;
            }
            case 8: {
                return this.iconSlats;
            }
            case 10: 
            case 11: {
                return this.iconWhiteCobble;
            }
            case 12: {
                return this.iconLightningRod;
            }
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int neighborI, int neighborJ, int neighborK, int side) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(neighborI, neighborJ, neighborK, side);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int blockID, ve creativeTabs, List list) {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aab world, int i2, int j2, int k) {
        return this.a(world.h(i2, j2, k), world.s, 0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        aak blockAccess = renderer.a;
        int iSubType = blockAccess.h(i2, j2, k);
        switch (iSubType) {
            case 0: {
                float fVerticalOffset = 0.0f;
                if (blockAccess.a(i2, j2 + 1, k) == BTWBlocks.hopper.cz) {
                    fVerticalOffset = 0.375f;
                }
                return UnfiredPotteryBlock.renderUnfiredUrn(renderer, blockAccess, i2, j2, k, this, this.iconUrn, fVerticalOffset);
            }
            case 2: {
                return this.renderPedestalUp(renderer, blockAccess, i2, j2, k, this);
            }
            case 3: {
                return this.renderPedestalDown(renderer, blockAccess, i2, j2, k, this);
            }
            case 4: {
                return this.renderTable(renderer, blockAccess, i2, j2, k, this);
            }
            case 6: 
            case 7: 
            case 8: {
                return this.renderPane(renderer, blockAccess, i2, j2, k, this, iSubType);
            }
            case 12: {
                return this.renderLightningRod(renderer, blockAccess, i2, j2, k, this);
            }
        }
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        return renderer.p(this, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int itemDamage, float brightness) {
        switch (itemDamage) {
            case 0: {
                UnfiredPotteryBlock.renderUnfiredUrnInvBlock(renderBlocks, this, itemDamage, this.iconUrn);
                return;
            }
            case 2: {
                this.renderPedestalUpInvBlock(renderBlocks, this);
                return;
            }
            case 3: {
                this.renderPedestalDownInvBlock(renderBlocks, this);
                return;
            }
            case 4: {
                this.renderTableInvBlock(renderBlocks, this);
                return;
            }
            case 12: {
                this.renderLightningRodInvBlock(renderBlocks, this);
                return;
            }
            case 1: {
                renderBlocks.a(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
                break;
            }
            case 5: 
            case 10: {
                renderBlocks.a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 9: 
            case 11: {
                renderBlocks.a(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
                break;
            }
            default: {
                renderBlocks.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, this, -0.5f, -0.5f, -0.5f, itemDamage);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderPedestalUp(bgf renderBlocks, aak blockAccess, int i2, int j2, int k, apa block) {
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.0625, 0.75, 0.0625, 0.9375, 0.875, 0.9375);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.125, 0.875, 0.125, 0.875, 1.0, 0.875);
        renderBlocks.p(block, i2, j2, k);
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderPedestalUpInvBlock(bgf renderBlocks, apa block) {
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 2);
        renderBlocks.a(0.0625, 0.75, 0.0625, 0.9375, 0.875, 0.9375);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 2);
        renderBlocks.a(0.125, 0.875, 0.125, 0.875, 1.0, 0.875);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 2);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderPedestalDown(bgf renderBlocks, aak blockAccess, int i2, int j2, int k, apa block) {
        renderBlocks.a(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.0625, 0.125, 0.0625, 0.9375, 0.25, 0.9375);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
        renderBlocks.p(block, i2, j2, k);
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderPedestalDownInvBlock(bgf renderBlocks, apa block) {
        renderBlocks.a(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 3);
        renderBlocks.a(0.0625, 0.125, 0.0625, 0.9375, 0.25, 0.9375);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 3);
        renderBlocks.a(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 3);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderTable(bgf renderBlocks, aak blockAccess, int i2, int j2, int k, apa block) {
        renderBlocks.a(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
        RenderUtils.renderStandardBlockWithTexture(renderBlocks, block, i2, j2, k, this.iconTableWoodOakTop);
        if (this.isTableOnCorner(blockAccess, i2, j2, k)) {
            renderBlocks.a(0.375, 0.0, 0.375, 0.625, 0.875, 0.625);
            RenderUtils.renderStandardBlockWithTexture(renderBlocks, block, i2, j2, k, this.iconTableWoodOakLeg);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderTableInvBlock(bgf renderBlocks, apa block) {
        renderBlocks.a(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, block, -0.5f, -0.5f, -0.5f, this.iconTableWoodOakTop);
        renderBlocks.a(0.375, 0.0, 0.375, 0.625, 0.875, 0.625);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, block, -0.5f, -0.5f, -0.5f, this.iconTableWoodOakLeg);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderPane(bgf renderBlocks, aak blockAccess, int i2, int j2, int k, apa block, int subType) {
        boolean var63;
        lx sideTexture;
        lx paneTexture;
        int iWorldHeight = 256;
        bgd tessellator = bgd.a;
        tessellator.c(block.e(blockAccess, i2, j2, k));
        int iColor = block.c(blockAccess, i2, j2, k);
        float iColorRed = (float)(iColor >> 16 & 0xFF) / 255.0f;
        float iColorGreen = (float)(iColor >> 8 & 0xFF) / 255.0f;
        float iColorBlue = (float)(iColor & 0xFF) / 255.0f;
        if (bfq.a) {
            iColorRed = (iColorRed * 30.0f + iColorGreen * 59.0f + iColorBlue * 11.0f) / 100.0f;
            iColorGreen = (iColorRed * 30.0f + iColorGreen * 70.0f) / 100.0f;
            iColorBlue = (iColorRed * 30.0f + iColorBlue * 70.0f) / 100.0f;
        }
        tessellator.a(iColorRed, iColorGreen, iColorBlue);
        if (renderBlocks.b()) {
            paneTexture = renderBlocks.getOverrideTexture();
            sideTexture = renderBlocks.getOverrideTexture();
        } else {
            int iMetadata = blockAccess.h(i2, j2, k);
            paneTexture = block.a(0, iMetadata);
            sideTexture = block.a(0, iMetadata);
            if (subType == 8) {
                sideTexture = this.iconSlatsSide;
            }
        }
        int iPaneTextureOriginX = paneTexture.a();
        int iPaneTextureOriginY = paneTexture.b();
        double dPaneTextureMinU = paneTexture.e();
        double dPaneTextureInterpolatedMidU = paneTexture.a(8.0);
        double dPaneTextureMaxU = paneTexture.f();
        double dPaneTextureMinV = paneTexture.g();
        double dPaneTextureMaxV = paneTexture.h();
        int iSideTextureOriginX = sideTexture.a();
        int iSideTextureOriginY = sideTexture.b();
        double dSideTextureInterpolatedMinU = sideTexture.a(7.0);
        double dSideTextureInterpolatedMaxU = sideTexture.a(9.0);
        double dSideTextureMinV = sideTexture.g();
        double dSideTextureInterpolatedMidV = sideTexture.b(8.0);
        double dSideTextureMaxV = sideTexture.h();
        double dPosXMin = i2;
        double dPosXMid = (double)i2 + 0.5;
        double dPosXMax = i2 + 1;
        double dPosZMin = k;
        double dPosZMid = (double)k + 0.5;
        double dPosZMax = k + 1;
        double var50 = (double)i2 + 0.5 - 0.0625;
        double var52 = (double)i2 + 0.5 + 0.0625;
        double var54 = (double)k + 0.5 - 0.0625;
        double var56 = (double)k + 0.5 + 0.0625;
        boolean var58 = this.shouldPaneConnectToBlock(blockAccess, i2, j2, k - 1, subType);
        boolean var59 = this.shouldPaneConnectToBlock(blockAccess, i2, j2, k + 1, subType);
        boolean var60 = this.shouldPaneConnectToBlock(blockAccess, i2 - 1, j2, k, subType);
        boolean var61 = this.shouldPaneConnectToBlock(blockAccess, i2 + 1, j2, k, subType);
        boolean var62 = !this.shouldPaneConnectToBlock(blockAccess, i2, j2 + 1, k, subType);
        boolean bl = var63 = !this.shouldPaneConnectToBlock(blockAccess, i2, j2 - 1, k, subType);
        if ((!var60 || !var61) && (var60 || var61 || var58 || var59)) {
            if (var60 && !var61) {
                tessellator.a(dPosXMin, j2 + 1, dPosZMid, dPaneTextureMinU, dPaneTextureMinV);
                tessellator.a(dPosXMin, j2 + 0, dPosZMid, dPaneTextureMinU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 1, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMinV);
                tessellator.a(dPosXMid, j2 + 1, dPosZMid, dPaneTextureMinU, dPaneTextureMinV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMid, dPaneTextureMinU, dPaneTextureMaxV);
                tessellator.a(dPosXMin, j2 + 0, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMaxV);
                tessellator.a(dPosXMin, j2 + 1, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMinV);
                if (!var59 && !var58) {
                    tessellator.a(dPosXMid, j2 + 1, var56, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(dPosXMid, j2 + 0, var56, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, j2 + 0, var54, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, j2 + 1, var54, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(dPosXMid, j2 + 1, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(dPosXMid, j2 + 0, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, j2 + 0, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, j2 + 1, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                }
                if (var62 || j2 < iWorldHeight - 1 && blockAccess.c(i2 - 1, j2 + 1, k)) {
                    tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                }
                if (var63 || j2 > 1 && blockAccess.c(i2 - 1, j2 - 1, k)) {
                    tessellator.a(dPosXMin, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMin, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMin, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMin, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                }
            } else if (!var60 && var61) {
                tessellator.a(dPosXMid, j2 + 1, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMinV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMaxV);
                tessellator.a(dPosXMax, j2 + 0, dPosZMid, dPaneTextureMaxU, dPaneTextureMaxV);
                tessellator.a(dPosXMax, j2 + 1, dPosZMid, dPaneTextureMaxU, dPaneTextureMinV);
                tessellator.a(dPosXMax, j2 + 1, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMinV);
                tessellator.a(dPosXMax, j2 + 0, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMid, dPaneTextureMaxU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 1, dPosZMid, dPaneTextureMaxU, dPaneTextureMinV);
                if (!var59 && !var58) {
                    tessellator.a(dPosXMid, j2 + 1, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(dPosXMid, j2 + 0, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, j2 + 0, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, j2 + 1, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(dPosXMid, j2 + 1, var56, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(dPosXMid, j2 + 0, var56, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, j2 + 0, var54, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, j2 + 1, var54, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                }
                if (var62 || j2 < iWorldHeight - 1 && blockAccess.c(i2 + 1, j2 + 1, k)) {
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                }
                if (var63 || j2 > 1 && blockAccess.c(i2 + 1, j2 - 1, k)) {
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(dPosXMax, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMax, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(dPosXMax, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMax, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                }
            }
        } else {
            tessellator.a(dPosXMin, j2 + 1, dPosZMid, dPaneTextureMinU, dPaneTextureMinV);
            tessellator.a(dPosXMin, j2 + 0, dPosZMid, dPaneTextureMinU, dPaneTextureMaxV);
            tessellator.a(dPosXMax, j2 + 0, dPosZMid, dPaneTextureMaxU, dPaneTextureMaxV);
            tessellator.a(dPosXMax, j2 + 1, dPosZMid, dPaneTextureMaxU, dPaneTextureMinV);
            tessellator.a(dPosXMax, j2 + 1, dPosZMid, dPaneTextureMinU, dPaneTextureMinV);
            tessellator.a(dPosXMax, j2 + 0, dPosZMid, dPaneTextureMinU, dPaneTextureMaxV);
            tessellator.a(dPosXMin, j2 + 0, dPosZMid, dPaneTextureMaxU, dPaneTextureMaxV);
            tessellator.a(dPosXMin, j2 + 1, dPosZMid, dPaneTextureMaxU, dPaneTextureMinV);
            if (var62) {
                tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
            } else {
                if (j2 < iWorldHeight - 1 && blockAccess.c(i2 - 1, j2 + 1, k)) {
                    tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMin, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                }
                if (j2 < iWorldHeight - 1 && blockAccess.c(i2 + 1, j2 + 1, k)) {
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMax, (double)(j2 + 1) + 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                }
            }
            if (var63) {
                tessellator.a(dPosXMin, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                tessellator.a(dPosXMax, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                tessellator.a(dPosXMax, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                tessellator.a(dPosXMin, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                tessellator.a(dPosXMax, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                tessellator.a(dPosXMin, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                tessellator.a(dPosXMin, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                tessellator.a(dPosXMax, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
            } else {
                if (j2 > 1 && blockAccess.c(i2 - 1, j2 - 1, k)) {
                    tessellator.a(dPosXMin, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMin, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMin, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(dPosXMin, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                }
                if (j2 > 1 && blockAccess.c(i2 + 1, j2 - 1, k)) {
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(dPosXMax, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMax, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(dPosXMax, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var56, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMid, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(dPosXMax, (double)j2 - 0.01, var54, dSideTextureInterpolatedMinU, dSideTextureMinV);
                }
            }
        }
        if ((!var58 || !var59) && (var60 || var61 || var58 || var59)) {
            if (var58 && !var59) {
                tessellator.a(dPosXMid, j2 + 1, dPosZMin, dPaneTextureMinU, dPaneTextureMinV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMin, dPaneTextureMinU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 1, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMinV);
                tessellator.a(dPosXMid, j2 + 1, dPosZMid, dPaneTextureMinU, dPaneTextureMinV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMid, dPaneTextureMinU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMin, dPaneTextureInterpolatedMidU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 1, dPosZMin, dPaneTextureInterpolatedMidU, dPaneTextureMinV);
                if (!var61 && !var60) {
                    tessellator.a(var50, j2 + 1, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(var50, j2 + 0, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var52, j2 + 0, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var52, j2 + 1, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(var52, j2 + 1, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(var52, j2 + 0, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var50, j2 + 0, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var50, j2 + 1, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                }
                if (var62 || j2 < iWorldHeight - 1 && blockAccess.c(i2, j2 + 1, k - 1)) {
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMinV);
                }
                if (var63 || j2 > 1 && blockAccess.c(i2, j2 - 1, k - 1)) {
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMinV);
                }
            } else if (!var58 && var59) {
                tessellator.a(dPosXMid, j2 + 1, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMinV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMid, dPaneTextureInterpolatedMidU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMax, dPaneTextureMaxU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 1, dPosZMax, dPaneTextureMaxU, dPaneTextureMinV);
                tessellator.a(dPosXMid, j2 + 1, dPosZMax, dPaneTextureInterpolatedMidU, dPaneTextureMinV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMax, dPaneTextureInterpolatedMidU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 0, dPosZMid, dPaneTextureMaxU, dPaneTextureMaxV);
                tessellator.a(dPosXMid, j2 + 1, dPosZMid, dPaneTextureMaxU, dPaneTextureMinV);
                if (!var61 && !var60) {
                    tessellator.a(var52, j2 + 1, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(var52, j2 + 0, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var50, j2 + 0, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var50, j2 + 1, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(var50, j2 + 1, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(var50, j2 + 0, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var52, j2 + 0, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var52, j2 + 1, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                }
                if (var62 || j2 < iWorldHeight - 1 && blockAccess.c(i2, j2 + 1, k + 1)) {
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                }
                if (var63 || j2 > 1 && blockAccess.c(i2, j2 - 1, k + 1)) {
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                }
            }
        } else {
            tessellator.a(dPosXMid, j2 + 1, dPosZMax, dPaneTextureMinU, dPaneTextureMinV);
            tessellator.a(dPosXMid, j2 + 0, dPosZMax, dPaneTextureMinU, dPaneTextureMaxV);
            tessellator.a(dPosXMid, j2 + 0, dPosZMin, dPaneTextureMaxU, dPaneTextureMaxV);
            tessellator.a(dPosXMid, j2 + 1, dPosZMin, dPaneTextureMaxU, dPaneTextureMinV);
            tessellator.a(dPosXMid, j2 + 1, dPosZMin, dPaneTextureMinU, dPaneTextureMinV);
            tessellator.a(dPosXMid, j2 + 0, dPosZMin, dPaneTextureMinU, dPaneTextureMaxV);
            tessellator.a(dPosXMid, j2 + 0, dPosZMax, dPaneTextureMaxU, dPaneTextureMaxV);
            tessellator.a(dPosXMid, j2 + 1, dPosZMax, dPaneTextureMaxU, dPaneTextureMinV);
            if (var62) {
                tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureMinV);
                tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureMinV);
                tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureMaxV);
            } else {
                if (j2 < iWorldHeight - 1 && blockAccess.c(i2, j2 + 1, k - 1)) {
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMinV);
                }
                if (j2 < iWorldHeight - 1 && blockAccess.c(i2, j2 + 1, k + 1)) {
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var52, (double)(j2 + 1) + 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                }
            }
            if (var63) {
                tessellator.a(var52, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                tessellator.a(var52, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                tessellator.a(var50, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureMinV);
                tessellator.a(var50, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                tessellator.a(var52, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                tessellator.a(var52, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                tessellator.a(var50, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureMinV);
                tessellator.a(var50, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureMaxV);
            } else {
                if (j2 > 1 && blockAccess.c(i2, j2 - 1, k - 1)) {
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureMinV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMinV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMin, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMinV);
                }
                if (j2 > 1 && blockAccess.c(i2, j2 - 1, k + 1)) {
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMinU, dSideTextureInterpolatedMidV);
                    tessellator.a(var50, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMinU, dSideTextureMaxV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMid, dSideTextureInterpolatedMaxU, dSideTextureMaxV);
                    tessellator.a(var52, (double)j2 - 0.005, dPosZMax, dSideTextureInterpolatedMaxU, dSideTextureInterpolatedMidV);
                }
            }
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderLightningRod(bgf renderBlocks, aak blockAccess, int i2, int j2, int k, apa block) {
        lx texture = this.iconLightningRod;
        renderBlocks.a(0.46875, 0.0, 0.46875, 0.53125, 1.0, 0.53125);
        RenderUtils.renderStandardBlockWithTexture(renderBlocks, block, i2, j2, k, this.iconLightningRod);
        if (blockAccess.a(i2, j2 - 1, k) != BTWBlocks.aestheticNonOpaque.cz || blockAccess.h(i2, j2 - 1, k) != 12) {
            renderBlocks.a(0.375, 0.0, 0.375, 0.625, 0.125, 0.625);
            RenderUtils.renderStandardBlockWithTexture(renderBlocks, block, i2, j2, k, this.iconLightningRod);
        }
        int iBlockAboveID = blockAccess.a(i2, j2 + 1, k);
        int iBlockAboveMetadata = blockAccess.h(i2, j2 + 1, k);
        if (iBlockAboveID != BTWBlocks.aestheticNonOpaque.cz || iBlockAboveMetadata != 12) {
            if (iBlockAboveID == BTWBlocks.legacyCandle.cz) {
                renderBlocks.a(0.375, 0.99609375, 0.375, 0.625, 1.05859375, 0.625);
            } else {
                renderBlocks.a(0.40625, 0.625, 0.40625, 0.59375, 0.8125, 0.59375);
            }
            RenderUtils.renderStandardBlockWithTexture(renderBlocks, block, i2, j2, k, this.iconLightningRod);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderLightningRodInvBlock(bgf renderBlocks, apa block) {
        lx texture = this.iconLightningRod;
        renderBlocks.a(0.46875, 0.0, 0.46875, 0.53125, 1.0, 0.53125);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, block, -0.5f, -0.5f, -0.5f, texture);
        renderBlocks.a(0.375, 0.0, 0.375, 0.625, 0.125, 0.625);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, block, -0.5f, -0.5f, -0.5f, texture);
        renderBlocks.a(0.40625, 0.625, 0.40625, 0.59375, 0.8125, 0.59375);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, block, -0.5f, -0.5f, -0.5f, texture);
    }
}

