/*
 * Decompiled with CFR 0.152.
 */
package btw;

import btw.AddonHandler;
import btw.network.packet.handler.CustomPacketHandler;
import btw.world.biome.BiomeDecoratorBase;
import btw.world.util.WorldData;
import btw.world.util.WorldUtils;
import btw.world.util.difficulty.Difficulties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;

public abstract class BTWAddon {
    protected String addonName;
    protected String versionString;
    protected String prefix;
    protected boolean isRequiredClientAndServer = false;
    protected boolean shouldVersionCheck = false;
    private boolean awaitingLoginAck = false;
    private int ticksSinceAckRequested = 0;
    private static final int MAX_TICKS_FOR_ACK_WAIT = 50;
    public String addonCustomPacketChannelVersionCheck;
    public String addonCustomPacketChannelVersionCheckAck;
    private ArrayList<String> configProperties = new ArrayList();
    private Map<String, String> configPropertyDefaults = new HashMap<String, String>();
    private Map<String, String> configPropertyComments = new HashMap<String, String>();
    private Map<BTWAddon, AddonHandler.DependencyType> dependencyList = new HashMap<BTWAddon, AddonHandler.DependencyType>();
    public final Set<BTWAddon> dependants = new HashSet<BTWAddon>();
    public boolean hasBeenInitialized = false;

    protected BTWAddon() {
        AddonHandler.addMod(this);
    }

    public BTWAddon(String addonName, String versionString, String prefix) {
        this();
        this.addonName = addonName;
        this.versionString = versionString;
        this.prefix = prefix;
        this.addonCustomPacketChannelVersionCheck = prefix + "|VC";
        this.addonCustomPacketChannelVersionCheckAck = prefix + "|VC_Ack";
        this.shouldVersionCheck = true;
        this.isRequiredClientAndServer = true;
    }

    public void preInitialize() {
    }

    public abstract void initialize();

    public void postInitialize() {
    }

    public void onLanguageLoaded(bp translator) {
    }

    public void handleConfigProperties(Map<String, String> propertyValues) {
    }

    public void serverPlayerConnectionInitialized(jh serverHandler, jc playerMP) {
    }

    @Deprecated
    public boolean serverCustomPacketReceived(jh handler, dk packet) {
        return false;
    }

    public WorldData createWorldData() {
        return null;
    }

    public void decorateWorld(BiomeDecoratorBase decorator, aab world, Random rand, int x2, int y2, aav biome) {
    }

    protected void registerProperty(String propertyName, String defaultValue, String comment) {
        if (!this.configPropertyDefaults.containsKey(propertyName)) {
            this.configProperties.add(propertyName);
            this.configPropertyDefaults.put(propertyName, defaultValue);
            this.configPropertyComments.put(propertyName, comment);
        } else {
            AddonHandler.logWarning("Cannot add config property \"" + propertyName + "\" for " + this.addonName + " because a property with that name has already been registered for this addon");
        }
    }

    protected void registerProperty(String propertyName, String defaultValue) {
        this.registerProperty(propertyName, defaultValue, "");
    }

    public void registerPacketHandler(String channel, CustomPacketHandler handler) {
        if (!channel.startsWith(this.prefix + "|")) {
            throw new IllegalArgumentException("Channel must be of the format \"<addon prefix>|<channel string>\"");
        }
        AddonHandler.registerPacketHandler(channel, handler);
    }

    public void registerAddonCommand(z command) {
        AddonHandler.registerCommand(command, false);
    }

    public String getName() {
        return this.addonName;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public Map<String, String> loadConfigProperties() {
        if (this.configPropertyDefaults.size() == 0) {
            return null;
        }
        String filename = this.prefix + ".properties";
        BufferedReader fileIn = null;
        try {
            fileIn = new BufferedReader(new FileReader("config/" + filename));
        }
        catch (FileNotFoundException e2) {
            try {
                Files.createDirectories(Paths.get("config", new String[0]), new FileAttribute[0]);
                File config = new File("config/" + filename);
                config.createNewFile();
                fileIn = new BufferedReader(new FileReader(config));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (fileIn != null) {
            HashMap<String, String> propertyValues = new HashMap<String, String>();
            try {
                String line;
                while ((line = fileIn.readLine()) != null) {
                    String[] lineSplit;
                    if (line.startsWith("#") || !this.configPropertyDefaults.containsKey((lineSplit = line.split("="))[0])) continue;
                    propertyValues.put(lineSplit[0], lineSplit[1]);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            for (String propertyName : this.configProperties) {
                if (propertyValues.containsKey(propertyName)) continue;
                propertyValues.put(propertyName, this.configPropertyDefaults.get(propertyName));
            }
            try {
                fileIn.close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
                return null;
            }
            return propertyValues;
        }
        return null;
    }

    public void repopulateConfigFile(Map<String, String> propertyValues) {
        String filename = this.prefix + ".properties";
        File config = new File("config/" + filename);
        try {
            BufferedWriter writer = Files.newBufferedWriter(config.toPath(), StandardOpenOption.TRUNCATE_EXISTING);
            for (String propertyName : this.configProperties) {
                String comment = this.configPropertyComments.get(propertyName);
                if (!comment.equals("")) {
                    writer.write("\n# " + comment + "\n");
                }
                String propertyValue = propertyValues.containsKey(propertyName) ? propertyValues.get(propertyName) : this.configPropertyDefaults.get(propertyName);
                writer.write(propertyName + "=" + propertyValue + "\n");
            }
            writer.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void sendVersionCheckToClient(jh serverHandler, jc playerMP) {
        if (!MinecraftServer.D().I()) {
            WorldUtils.sendPacketToPlayer(serverHandler, (ei)new cw("\u00a7f" + this.addonName + " V" + this.versionString));
            if (this.shouldVersionCheck) {
                ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
                DataOutputStream dataOutput = new DataOutputStream(byteArrayOutput);
                try {
                    dataOutput.writeUTF(this.versionString);
                }
                catch (Exception var9) {
                    var9.printStackTrace();
                }
                dk var4 = new dk(this.addonCustomPacketChannelVersionCheck, byteArrayOutput.toByteArray());
                WorldUtils.sendPacketToPlayer(serverHandler, (ei)var4);
                this.awaitingLoginAck = true;
            }
        } else {
            WorldUtils.sendPacketToPlayer(serverHandler, (ei)new cw("\u00a7f" + this.addonName + " V" + this.versionString));
        }
    }

    public void sendDifficultyToClient(jh serverHandler, jc playerMP) {
        if (!MinecraftServer.D().I()) {
            WorldUtils.sendPacketToPlayer(serverHandler, Difficulties.createDifficultyPacket(serverHandler.d));
        }
    }

    public boolean serverAckPacketReceived(jh serverHandler, dk packet) {
        if (this.addonCustomPacketChannelVersionCheckAck.equals(packet.a)) {
            WorldUtils.sendPacketToPlayer(serverHandler, (ei)new cw("\u00a7f" + this.addonName + " version check successful."));
            this.awaitingLoginAck = false;
            this.ticksSinceAckRequested = 0;
        }
        return false;
    }

    public boolean getAwaitingLoginAck() {
        return this.awaitingLoginAck;
    }

    public void incrementTicksSinceAckRequested() {
        ++this.ticksSinceAckRequested;
    }

    public boolean handleAckCheck() {
        if (this.ticksSinceAckRequested > 50) {
            this.awaitingLoginAck = false;
            this.ticksSinceAckRequested = 0;
            return false;
        }
        return true;
    }

    public String getLanguageFilePrefix() {
        return this.prefix;
    }

    @Deprecated
    @Environment(value=EnvType.CLIENT)
    public boolean clientCustomPacketReceived(Minecraft mcInstance, dk packet) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean interceptCustomClientPacket(Minecraft mc2, dk packet) {
        return false;
    }

    @Deprecated
    @Environment(value=EnvType.CLIENT)
    public boolean clientPlayCustomAuxFX(Minecraft mcInstance, aab world, sq player, int iFXID, int i2, int j2, int k, int iFXSpecificData) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public bet spawnCustomParticle(aab world, String particleType, double x2, double y2, double z2, double velX, double velY, double velZ) {
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public void registerAddonCommandClientOnly(z command) {
        AddonHandler.registerCommand(command, false);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean versionCheckPacketReceived(Minecraft mc2, dk packet) {
        try {
            bds world = mc2.e;
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(packet.c));
            String var33 = dataStream.readUTF();
            if (!var33.equals(this.versionString)) {
                mc2.g.b("\u00a74WARNING: " + this.getName() + " version mismatch detected! Local Version: " + this.versionString + " Server Version: " + var33);
            }
            ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
            DataOutputStream dataOutput = new DataOutputStream(byteArrayOutput);
            try {
                dataOutput.writeUTF(this.versionString);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            mc2.g.b("\u00a7f" + this.addonName + " version check successful.");
            return true;
        }
        catch (IOException var23) {
            var23.printStackTrace();
            return false;
        }
    }

    @Environment(value=EnvType.SERVER)
    public void registerAddonCommandServerOnly(z command) {
        if (MinecraftServer.getIsServer()) {
            MinecraftServer.D().commandManager.a(command);
        }
    }
}

