/*
 * Decompiled with CFR 0.152.
 */
package btw;

import btw.AddonFinder;
import btw.BTWAddon;
import btw.BTWMod;
import btw.client.fx.EffectHandler;
import btw.network.packet.handler.CustomPacketHandler;
import btw.world.biome.BiomeDecoratorBase;
import btw.world.util.WorldData;
import btw.world.util.WorldUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;

public class AddonHandler {
    public static Map<Class<? extends BTWAddon>, BTWAddon> modList = new LinkedHashMap<Class<? extends BTWAddon>, BTWAddon>();
    public static boolean modsInitialized = false;
    private static boolean loggerInitialized = false;
    public static final Logger logger = Logger.getLogger("BetterThanWolves");
    private static File logFile;
    private static FileHandler logFileHandler;
    private static jh netServerHandler;
    private static ArrayList<String> ackCheckFails;
    private static Map<String, CustomPacketHandler> packetHandlers;
    public static Map<Class<? extends BTWAddon>, WorldData> addonWorldDataMap;
    private static ArrayList<BTWAddon> loadOrder;
    private static Class<?> classDomain;
    public static ArrayList<z> commandList;

    public static void addMod(BTWAddon mod) {
        modList.put(mod.getClass(), mod);
    }

    public static URL getResource(URL url) {
        try {
            if (url.getPath().endsWith(".jar") || url.getPath().endsWith("zip")) {
                return new URL("jar:" + url + "!/");
            }
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
        return url;
    }

    public static boolean isFabricEnvironment() {
        return classDomain.getName().startsWith("net.fabricmc") || classDomain.getClassLoader().toString().contains("net.fabricmc");
    }

    public static void loadModClasses() {
        ClassLoader classLoader = classDomain.getClassLoader();
        try {
            List<String> classes;
            File[] files = new File(logFile.getParentFile().getCanonicalPath() + "/mods").listFiles();
            ArrayList<URL> mods = new ArrayList<URL>();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        mods.add(file.toURI().toURL());
                        continue;
                    }
                    if (!file.getPath().endsWith(".jar") && !file.getPath().endsWith(".zip")) continue;
                    mods.add(AddonHandler.getResource(file.toURI().toURL()));
                }
            }
            if ((classes = AddonFinder.getClasses(Collections.enumeration(mods))).size() > 0) {
                AddonHandler.loadClasses(classes, mods.toArray(new URL[mods.size()]));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void loadJarClasses() {
        URL baseURL = AddonHandler.getResource(classDomain.getProtectionDomain().getCodeSource().getLocation());
        AddonHandler.logMessage("Minecraft jar found: " + baseURL.toString());
        try {
            List<String> classes = AddonFinder.getClasses(Collections.enumeration(Collections.singleton(baseURL)));
            AddonHandler.loadClasses(classes, new URL[]{baseURL});
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void loadClasses(List<String> classes, URL[] resources) {
        ClassLoader loader = classDomain.getClassLoader();
        for (String name : classes) {
            Class<?> current = null;
            try {
                current = loader.loadClass(name);
            }
            catch (Throwable e2) {
                continue;
            }
            try {
                if (!BTWAddon.class.isAssignableFrom(current)) continue;
                Class<?> addonClass = Class.forName(name, true, loader);
                AddonHandler.logMessage("Found Add-on: " + addonClass.getSimpleName());
                if (modList.containsKey(addonClass)) continue;
                Constructor<?> constructor = addonClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                constructor.newInstance(new Object[0]);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void loadAddOns() {
        ClassLoader knot = classDomain.getClassLoader();
        AddonHandler.logMessage("Classloader: " + knot.getClass().getName());
        if (!AddonHandler.isFabricEnvironment()) {
            throw new RuntimeException("Something went wrong, Fabric not found!");
        }
        AddonHandler.loadJarClasses();
        AddonHandler.loadModClasses();
    }

    public static void initializeMods() {
        if (!modsInitialized) {
            AddonHandler.logMessage("...Add-On Handler Initializing...");
            AddonHandler.loadAddOns();
            addonWorldDataMap = AddonHandler.initWorldDataForAddon();
            AddonHandler.preInitializeMods();
            AddonHandler.loadModConfigs();
            BTWMod.instance.initialize();
            for (BTWAddon addon : modList.values()) {
                if (addon == BTWMod.instance) continue;
                addon.initialize();
            }
            AddonHandler.postInitializeMods();
            modsInitialized = true;
            AddonHandler.onLanguageLoaded(bp.a());
            AddonHandler.logMessage("...Add-On Handler Initialization Complete...");
        }
    }

    public static void initializeLogger() {
        if (loggerInitialized) {
            return;
        }
        try {
            logFile = MinecraftServer.getIsServer() ? new File(new File("."), "BTWLog.txt") : new File(Minecraft.b(), "BTWLog.txt");
            if ((logFile.exists() || logFile.createNewFile()) && logFile.canWrite()) {
                logFileHandler = new FileHandler(logFile.getPath());
                logFileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(logFileHandler);
                logger.setLevel(Level.FINE);
                loggerInitialized = true;
            }
        }
        catch (Throwable error) {
            throw new RuntimeException(error);
        }
    }

    public static void logMessage(String string) {
        System.out.println(string);
        if (MinecraftServer.D() != null) {
            MinecraftServer.D().al().a(string);
        }
        logger.fine(string);
    }

    public static void logWarning(String string) {
        System.out.println(string);
        if (MinecraftServer.D() != null) {
            MinecraftServer.D().al().b(string);
        }
        logger.fine(string);
    }

    public static void preInitializeMods() {
        BTWMod.instance.preInitialize();
        for (BTWAddon addon : modList.values()) {
            if (addon == BTWMod.instance) continue;
            addon.preInitialize();
        }
    }

    public static void postInitializeMods() {
        BTWMod.instance.postInitialize();
        for (BTWAddon addon : modList.values()) {
            if (addon == BTWMod.instance) continue;
            addon.postInitialize();
        }
    }

    public static void onLanguageLoaded(bp translator) {
        if (modsInitialized) {
            BTWMod.instance.onLanguageLoaded(translator);
            String prefix = BTWMod.instance.getLanguageFilePrefix();
            if (prefix != null) {
                AddonHandler.logMessage("...Add-On Handler Loading Custom Language File With Prefix: " + prefix + "...");
                translator.loadAddonLanguageExtension(prefix);
            }
            for (BTWAddon addon : modList.values()) {
                if (addon == BTWMod.instance) continue;
                addon.onLanguageLoaded(translator);
                prefix = addon.getLanguageFilePrefix();
                if (prefix == null) continue;
                AddonHandler.logMessage("...Add-On Handler Loading Custom Language File With Prefix: " + prefix + "...");
                translator.loadAddonLanguageExtension(prefix);
            }
        }
        if (modsInitialized) {
            for (BTWAddon mod : modList.values()) {
                mod.onLanguageLoaded(translator);
                String prefix = mod.getLanguageFilePrefix();
                if (prefix == null) continue;
                AddonHandler.logMessage("...Add-On Handler Loading Custom Language File With Prefix: " + prefix + "...");
                translator.loadAddonLanguageExtension(prefix);
            }
        }
    }

    public static void serverCustomPacketReceived(jh handler, dk packet) {
        if (packetHandlers.get(packet.a) != null) {
            try {
                packetHandlers.get(packet.a).handleCustomPacket(packet);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            for (BTWAddon mod : modList.values()) {
                if (!mod.serverCustomPacketReceived(handler, packet)) continue;
                return;
            }
        }
    }

    public static void serverPlayerConnectionInitialized(jh serverHandler, jc playerMP) {
        netServerHandler = serverHandler;
        BTWMod.instance.serverPlayerConnectionInitialized(serverHandler, playerMP);
        BTWMod.instance.sendVersionCheckToClient(serverHandler, playerMP);
        for (BTWAddon addon : modList.values()) {
            if (addon == BTWMod.instance) continue;
            addon.serverPlayerConnectionInitialized(serverHandler, playerMP);
            if (!addon.shouldVersionCheck) continue;
            addon.sendVersionCheckToClient(serverHandler, playerMP);
        }
        BTWMod.instance.sendDifficultyToClient(serverHandler, playerMP);
    }

    public static boolean getAwaitingLoginAck() {
        for (BTWAddon mod : modList.values()) {
            if (!mod.getAwaitingLoginAck()) continue;
            return true;
        }
        return false;
    }

    public static void incrementTicksSinceAckRequested() {
        for (BTWAddon mod : modList.values()) {
            mod.incrementTicksSinceAckRequested();
        }
    }

    public static void handleAckCheck() {
        for (BTWAddon mod : modList.values()) {
            if (mod.handleAckCheck()) continue;
            ackCheckFails.add(mod.getName());
        }
        if (!ackCheckFails.isEmpty()) {
            String message = "WARNING: Client missing the following addons, or very high latency connection: ";
            for (int i2 = 0; i2 < ackCheckFails.size(); ++i2) {
                if (i2 > 0) {
                    message = message + ", ";
                }
                message = message + ackCheckFails.get(i2);
            }
            WorldUtils.sendPacketToPlayer(netServerHandler, (ei)new cw(message));
        }
    }

    public static Map<Class<? extends BTWAddon>, WorldData> initWorldDataForAddon() {
        HashMap<Class<? extends BTWAddon>, WorldData> worldDataMap = new HashMap<Class<? extends BTWAddon>, WorldData>();
        for (BTWAddon mod : modList.values()) {
            WorldData worldData = mod.createWorldData();
            if (worldData == null) continue;
            worldDataMap.put(mod.getClass(), worldData);
        }
        return worldDataMap;
    }

    public static void loadModConfigs() {
        for (BTWAddon mod : modList.values()) {
            BTWAddon addon = mod;
            Map<String, String> addonConfigProperties = addon.loadConfigProperties();
            if (addonConfigProperties == null) continue;
            addon.repopulateConfigFile(addonConfigProperties);
            addon.handleConfigProperties(addonConfigProperties);
        }
    }

    public static void registerPacketHandler(String channel, CustomPacketHandler handler) {
        packetHandlers.put(channel, handler);
    }

    public static void registerCommand(z command, boolean clientOnly) {
        if (MinecraftServer.getIsServer()) {
            if (!clientOnly) {
                MinecraftServer.D().commandManager.a(command);
            }
        } else {
            commandList.add(command);
        }
    }

    public static WorldData getWorldDataForMod(Class<? extends BTWAddon> mod) {
        if (addonWorldDataMap.containsKey(mod)) {
            return addonWorldDataMap.get(mod);
        }
        return null;
    }

    public static void setWorldDataForMod(Class<? extends BTWAddon> mod, WorldData data) {
        addonWorldDataMap.put(mod, data);
    }

    public static void decorateWorld(BiomeDecoratorBase decorator, aab world, Random rand, int x2, int y2, aav biome) {
        Iterator<BTWAddon> iterator = modList.values().iterator();
        while (iterator.hasNext()) {
            BTWAddon mod;
            BTWAddon addon = mod = iterator.next();
            addon.decorateWorld(decorator, world, rand, x2, y2, biome);
        }
    }

    public static boolean isModInstalled(String name) {
        for (BTWAddon mod : modList.values()) {
            if (!mod.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static BTWAddon getModByName(String name) {
        for (BTWAddon mod : modList.values()) {
            if (!mod.getName().equals(name)) continue;
            return mod;
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientCustomPacketReceived(Minecraft mcInstance, dk packet) {
        if (packetHandlers.get(packet.a) != null) {
            try {
                packetHandlers.get(packet.a).handleCustomPacket(packet);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            for (BTWAddon mod : modList.values()) {
                if (packet.a == mod.addonCustomPacketChannelVersionCheck && mod.shouldVersionCheck && mod.versionCheckPacketReceived(mcInstance, packet)) {
                    return;
                }
                if (!mod.clientCustomPacketReceived(mcInstance, packet)) continue;
                return;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientPlayCustomAuxFX(Minecraft mcInstance, aab world, sq player, int iFXID, int i2, int j2, int k, int iFXSpecificData) {
        if (!EffectHandler.playEffect(iFXID, mcInstance, world, player, i2, j2, k, iFXSpecificData)) {
            for (BTWAddon mod : modList.values()) {
                if (!mod.clientPlayCustomAuxFX(mcInstance, world, player, iFXID, i2, j2, k, iFXSpecificData)) continue;
                return;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean interceptCustomClientPacket(Minecraft mc2, dk packet) {
        for (BTWAddon mod : modList.values()) {
            if (!mod.interceptCustomClientPacket(mc2, packet)) continue;
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static bet spawnCustomParticle(aab world, String particleType, double x2, double y2, double z2, double velX, double velY, double velZ) {
        for (BTWAddon mod : modList.values()) {
            bet particle = mod.spawnCustomParticle(world, particleType, x2, y2, z2, velX, velY, velZ);
            if (particle == null) continue;
            return particle;
        }
        return null;
    }

    static {
        logFileHandler = null;
        ackCheckFails = new ArrayList();
        packetHandlers = new HashMap<String, CustomPacketHandler>();
        loadOrder = new ArrayList();
        classDomain = AddonHandler.class;
        commandList = new ArrayList();
    }

    public static enum DependencyType {
        LOAD_BEFORE,
        LOAD_AFTER,
        INCOMPATIBLE,
        NO_DEPENDENCY;

    }
}

