/*
 * Decompiled with CFR 0.152.
 */
package btw;

import btw.AddonHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class AddonFinder {
    private static boolean debug = false;
    private static List<String> blacklist = Arrays.asList("net.minecraft.*", "argo.*", "com.jcraft.*", "com.prupe.mcpatcher.*", "paulscode.*", "org.bouncycastle.*");

    public static boolean isBlackListed(String name) {
        for (String pkg : blacklist) {
            if (!name.startsWith(pkg = pkg.replace("*", ""))) continue;
            return true;
        }
        return false;
    }

    public static List<String> getClasses(Enumeration<URL> resources) throws IOException {
        assert (resources != null);
        ArrayList<String> names = new ArrayList<String>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String proto = resource.getProtocol();
            if (debug) {
                AddonHandler.logMessage("RESOURCE: " + resource.getPath() + "\nPROTO: " + proto);
            }
            if ("file".equals(proto)) {
                File file = new File(resource.getFile());
                if (file.isDirectory()) {
                    names.addAll(AddonFinder.findFileClasses(file, ""));
                    continue;
                }
                names.addAll(AddonFinder.findFileClasses(new File[]{file}, ""));
                continue;
            }
            if ("jar".equals(proto)) {
                names.addAll(AddonFinder.findJarClasses(resource));
                continue;
            }
            AddonHandler.logWarning("Protocol " + proto + " not supported");
        }
        return names;
    }

    private static List<String> findJarClasses(URL packageResource) {
        ArrayList<String> classes;
        block14: {
            classes = new ArrayList<String>();
            try {
                URL fileUrl;
                String proto;
                if (debug) {
                    AddonHandler.logMessage("Jar URL Path is " + packageResource.getPath());
                }
                if ("file".equals(proto = (fileUrl = new URL(packageResource.getPath())).getProtocol())) {
                    String filePath = fileUrl.getPath();
                    try {
                        filePath = URLDecoder.decode(filePath, StandardCharsets.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException e1) {
                        e1.printStackTrace();
                    }
                    int jarTagPos = filePath.indexOf(".jar!/");
                    if (jarTagPos < 0) {
                        jarTagPos = filePath.indexOf(".zip!/");
                    }
                    if (jarTagPos < 0) {
                        AddonHandler.logWarning("Non-conformant jar file reference " + filePath + " !");
                    } else {
                        String packagePath = filePath.substring(jarTagPos + 6);
                        String jarFilename = filePath.substring(0, jarTagPos + 4);
                        if (debug) {
                            AddonHandler.logMessage("Package " + packagePath);
                            AddonHandler.logMessage("Jar file " + jarFilename);
                        }
                        String packagePrefix = packagePath.length() == 0 ? "" : packagePath + '/';
                        try {
                            JarEntry jarEntry;
                            JarInputStream jarFile = new JarInputStream(new FileInputStream(jarFilename));
                            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                                String className;
                                String classPath = jarEntry.getName();
                                if (!classPath.startsWith(packagePrefix) || !classPath.endsWith(".class") || (className = classPath.substring(0, classPath.length() - 6).replace('/', '.')).indexOf(".") < 0 || AddonFinder.isBlackListed(className)) continue;
                                if (debug) {
                                    AddonHandler.logMessage("Found entry " + jarEntry.getName());
                                }
                                classes.add(className);
                            }
                            jarFile.close();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block14;
                }
                AddonHandler.logWarning("Nested protocol " + proto + " not supprted!");
            }
            catch (MalformedURLException e3) {
                e3.printStackTrace();
            }
        }
        return classes;
    }

    private static List<String> findFileClasses(File directory, String packageName) {
        if (!directory.exists()) {
            AddonHandler.logWarning("Directory " + directory.getAbsolutePath() + " does not exist.");
            return new ArrayList<String>();
        }
        File[] files = directory.listFiles();
        if (debug) {
            AddonHandler.logMessage("Directory " + directory.getAbsolutePath() + " has " + files.length + " elements.");
        }
        return AddonFinder.findFileClasses(files, packageName);
    }

    private static List<String> findFileClasses(File[] files, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        if (packageName.length() > 0 && !packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        if (AddonFinder.isBlackListed(packageName)) {
            return classes;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(AddonFinder.findFileClasses(file.listFiles(), packageName + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class") || packageName.length() == 0) continue;
            String className = packageName + file.getName().substring(0, file.getName().length() - 6);
            classes.add(className);
        }
        return classes;
    }
}

