/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.mappings;

import com.google.common.base.Strings;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.FieldDef;
import net.fabricmc.mapping.tree.Mapped;
import net.fabricmc.mapping.tree.MethodDef;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.tinyremapper.IMappingProvider;

public class TinyRemapperMappingsHelper {
    private TinyRemapperMappingsHelper() {
    }

    private static IMappingProvider.Member memberOf(String className, String memberName, String descriptor) {
        return new IMappingProvider.Member(className, memberName, descriptor);
    }

    public static String tryName(Mapped mapping, String namespace, String fallback) {
        String name = mapping.getRawName(namespace);
        return !Strings.isNullOrEmpty((String)name) ? name : fallback;
    }

    public static IMappingProvider create(TinyTree mappings, String from, String to) {
        return acceptor -> {
            for (ClassDef classDef : mappings.getClasses()) {
                String className = classDef.getRawName(from);
                if (Strings.isNullOrEmpty((String)className)) continue;
                acceptor.acceptClass(className, TinyRemapperMappingsHelper.tryName((Mapped)classDef, to, className));
                for (FieldDef field : classDef.getFields()) {
                    String fieldName = field.getRawName(from);
                    if (Strings.isNullOrEmpty((String)fieldName)) continue;
                    acceptor.acceptField(TinyRemapperMappingsHelper.memberOf(className, fieldName, field.getDescriptor(from)), TinyRemapperMappingsHelper.tryName((Mapped)field, to, fieldName));
                }
                for (MethodDef method : classDef.getMethods()) {
                    String methodName = method.getRawName(from);
                    if (Strings.isNullOrEmpty((String)methodName)) continue;
                    acceptor.acceptMethod(TinyRemapperMappingsHelper.memberOf(className, methodName, method.getDescriptor(from)), TinyRemapperMappingsHelper.tryName((Mapped)method, to, methodName));
                }
            }
        };
    }
}

