/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.metadata;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.lib.gson.JsonReader;
import net.fabricmc.loader.lib.gson.JsonToken;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.metadata.ParseMetadataException;
import net.fabricmc.loader.metadata.ParseWarning;
import net.fabricmc.loader.metadata.V1ModMetadataParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModMetadataParser {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int LATEST_VERSION = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoaderModMetadata parseMetadata(Logger logger, Path modJson) throws IOException, ParseMetadataException {
        try {
            int schemaVersion = 0;
            try (JsonReader reader = new JsonReader(new InputStreamReader(Files.newInputStream(modJson, new OpenOption[0]), StandardCharsets.UTF_8));){
                if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                    throw new ParseMetadataException("Root of \"fabric.mod.json\" must be an object", reader);
                }
                reader.beginObject();
                boolean firstField = true;
                while (reader.hasNext()) {
                    if (reader.nextName().equals("schemaVersion")) {
                        if (reader.peek() != JsonToken.NUMBER) {
                            throw new ParseMetadataException("\"schemaVersion\" must be a number.", reader);
                        }
                        schemaVersion = reader.nextInt();
                        if (firstField) {
                            LoaderModMetadata loaderModMetadata = ModMetadataParser.readModMetadata(logger, reader, schemaVersion);
                            return loaderModMetadata;
                        }
                    } else {
                        reader.skipValue();
                    }
                    firstField = false;
                }
                reader.endObject();
            }
            reader = new JsonReader(new InputStreamReader(Files.newInputStream(modJson, new OpenOption[0]), StandardCharsets.UTF_8));
            var4_5 = null;
            try {
                reader.beginObject();
                LoaderModMetadata ret = ModMetadataParser.readModMetadata(logger, reader, schemaVersion);
                reader.endObject();
                if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                    LOGGER.warn(String.format("\"fabric.mod.json\" from mod %s did not have \"schemaVersion\" as first field.", ret.getId()));
                }
                LoaderModMetadata loaderModMetadata = ret;
                return loaderModMetadata;
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var4_5 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IllegalStateException e) {
            throw new ParseMetadataException(e);
        }
    }

    private static LoaderModMetadata readModMetadata(Logger logger, JsonReader reader, int schemaVersion) throws IOException, ParseMetadataException {
        switch (schemaVersion) {
            case 1: {
                return V1ModMetadataParser.parse(logger, reader);
            }
            case 0: {
                throw new UnsupportedOperationException("Loader 0.3 era fabric.mod.jsons (without a schemaVersion) are no longer supported");
            }
        }
        if (schemaVersion > 0) {
            throw new ParseMetadataException(String.format("This version of fabric-loader doesn't support the newer schema version of \"%s\"\nPlease update fabric-loader to be able to read this.", schemaVersion));
        }
        throw new ParseMetadataException(String.format("Invalid/Unsupported schema version \"%s\" was found", schemaVersion));
    }

    static void logWarningMessages(Logger logger, String id, List<ParseWarning> warnings) {
        if (warnings.isEmpty() || !FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("The mod \"").append(id).append("\" contains invalid entries in its mod json:");
        for (ParseWarning warning : warnings) {
            message.append("\n- ").append(warning.getReason()).append(" \"").append(warning.getKey()).append("\" at line ").append(warning.getLine()).append(" column ").append(warning.getColumn());
        }
        logger.warn(message.toString());
    }

    private ModMetadataParser() {
    }
}

