/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.FabricLoaderImpl;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.entrypoint.minecraft.hooks.EntrypointUtils;
import net.fabricmc.loader.game.MinecraftGameProvider;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.launch.common.FabricMixinBootstrap;
import net.fabricmc.loader.util.Arguments;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.Proxy;

public abstract class FabricTweaker
extends FabricLauncherBase
implements ITweaker {
    protected static Logger LOGGER = LogManager.getFormatterLogger((String)"Fabric|Tweaker");
    protected Arguments arguments;
    private LaunchClassLoader launchClassLoader;
    private boolean isDevelopment;
    private final boolean isPrimaryTweaker = ((List)Launch.blackboard.get("Tweaks")).isEmpty();

    @Override
    public String getEntrypoint() {
        return this.getLaunchTarget();
    }

    @Override
    public String getTargetNamespace() {
        return this.isDevelopment ? "named" : "intermediary";
    }

    public void acceptOptions(List<String> localArgs, File gameDir, File assetsDir, String profile) {
        this.arguments = new Arguments();
        this.arguments.parse(localArgs);
        if (!this.arguments.containsKey("gameDir") && gameDir != null) {
            this.arguments.put("gameDir", gameDir.getAbsolutePath());
        }
        if (this.getEnvironmentType() == EnvType.CLIENT && !this.arguments.containsKey("assetsDir") && assetsDir != null) {
            this.arguments.put("assetsDir", assetsDir.getAbsolutePath());
        }
        FabricLauncherBase.processArgumentMap(this.arguments, this.getEnvironmentType());
    }

    public void injectIntoClassLoader(LaunchClassLoader launchClassLoader) {
        this.isDevelopment = Boolean.parseBoolean(System.getProperty("fabric.development", "false"));
        Launch.blackboard.put("fabric.development", this.isDevelopment);
        FabricTweaker.setProperties(Launch.blackboard);
        this.launchClassLoader = launchClassLoader;
        launchClassLoader.addClassLoaderExclusion("org.objectweb.asm.");
        launchClassLoader.addClassLoaderExclusion("org.spongepowered.asm.");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.loader.");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.Environment");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.EnvType");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.ModInitializer");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.ClientModInitializer");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.DedicatedServerModInitializer");
        launchClassLoader.addClassLoaderExclusion("com.google.gson.");
        MinecraftGameProvider provider = new MinecraftGameProvider();
        if (!provider.locateGame(this.getEnvironmentType(), this.arguments.toArray(), (ClassLoader)launchClassLoader)) {
            throw new RuntimeException("Could not locate Minecraft: provider locate failed");
        }
        FabricLoaderImpl loader = FabricLoaderImpl.getInstance();
        loader.setGameProvider(provider);
        loader.load();
        loader.freeze();
        launchClassLoader.registerTransformer("net.fabricmc.loader.launch.FabricClassTransformer");
        if (!this.isDevelopment) {
            Launch.blackboard.put("fabric.development", false);
            try {
                String target = this.getLaunchTarget();
                URL loc = launchClassLoader.findResource(target.replace('.', '/') + ".class");
                JarURLConnection locConn = (JarURLConnection)loc.openConnection();
                File jarFile = UrlUtil.asFile(locConn.getJarFileURL());
                if (!jarFile.exists()) {
                    throw new RuntimeException("Could not locate Minecraft: " + jarFile.getAbsolutePath() + " not found");
                }
                Path obfuscated = jarFile.toPath();
                Path remapped = FabricLauncherBase.deobfuscate(provider.getGameId(), provider.getNormalizedGameVersion(), provider.getLaunchDirectory(), obfuscated, this);
                if (remapped != obfuscated) {
                    this.preloadRemappedJar(remapped);
                }
            }
            catch (IOException | UrlConversionException e) {
                throw new RuntimeException("Failed to deobfuscate Minecraft!", e);
            }
        }
        loader.loadAccessWideners();
        MinecraftGameProvider.TRANSFORMER.locateEntrypoints(this);
        MixinBootstrap.init();
        FabricMixinBootstrap.init(this.getEnvironmentType(), loader);
        MixinEnvironment.getDefaultEnvironment().setSide(this.getEnvironmentType() == EnvType.CLIENT ? MixinEnvironment.Side.CLIENT : MixinEnvironment.Side.SERVER);
        EntrypointUtils.invoke("preLaunch", PreLaunchEntrypoint.class, PreLaunchEntrypoint::onPreLaunch);
    }

    public String[] getLaunchArguments() {
        return this.isPrimaryTweaker ? this.arguments.toArray() : new String[]{};
    }

    @Override
    public void propose(URL url) {
        this.launchClassLoader.addURL(url);
    }

    @Override
    public Collection<URL> getLoadTimeDependencies() {
        return this.launchClassLoader.getSources();
    }

    @Override
    public boolean isClassLoaded(String name) {
        throw new RuntimeException("TODO isClassLoaded/launchwrapper");
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.launchClassLoader.getResourceAsStream(name);
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return this.launchClassLoader;
    }

    @Override
    public byte[] getClassByteArray(String name, boolean runTransformers) throws IOException {
        String transformedName = name.replace('/', '.');
        byte[] classBytes = this.launchClassLoader.getClassBytes(name);
        if (runTransformers) {
            for (IClassTransformer transformer : this.launchClassLoader.getTransformers()) {
                if (transformer instanceof Proxy) continue;
                classBytes = transformer.transform(name, transformedName, classBytes);
            }
        }
        return classBytes;
    }

    private void preloadRemappedJar(Path remappedJarFile) throws IOException {
        Map resourceCache = null;
        try {
            Field f = LaunchClassLoader.class.getDeclaredField("resourceCache");
            f.setAccessible(true);
            resourceCache = (Map)f.get(this.launchClassLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resourceCache == null) {
            LOGGER.warn("Resource cache not pre-populated - this will probably cause issues...");
            return;
        }
        try (FileInputStream jarFileStream = new FileInputStream(remappedJarFile.toFile());
             JarInputStream jarStream = new JarInputStream(jarFileStream);){
            JarEntry entry;
            while ((entry = jarStream.getNextJarEntry()) != null) {
                if (entry.getName().startsWith("net/minecraft/class_") || !entry.getName().endsWith(".class")) continue;
                String className = entry.getName();
                className = className.substring(0, className.length() - 6).replace('/', '.');
                LOGGER.debug("Appending " + className + " to resource cache...");
                resourceCache.put(className, this.toByteArray(jarStream));
            }
        }
    }

    private byte[] toByteArray(InputStream inputStream) throws IOException {
        int len;
        int estimate = inputStream.available();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(estimate < 32 ? 32768 : estimate);
        byte[] buffer = new byte[8192];
        while ((len = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
        }
        return outputStream.toByteArray();
    }

    @Override
    public boolean isDevelopment() {
        return this.isDevelopment;
    }
}

