/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.game;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;

final class GameProviderHelper {
    private GameProviderHelper() {
    }

    static Optional<Path> getSource(ClassLoader loader, String filename) {
        URL url = loader.getResource(filename);
        if (url != null) {
            try {
                URL urlSource = UrlUtil.getSource(filename, url);
                Path classSourceFile = UrlUtil.asPath(urlSource);
                return Optional.of(classSourceFile);
            }
            catch (UrlConversionException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    static List<Path> getSources(ClassLoader loader, String filename) {
        try {
            Enumeration<URL> urls = loader.getResources(filename);
            ArrayList<Path> paths = new ArrayList<Path>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    URL urlSource = UrlUtil.getSource(filename, url);
                    paths.add(UrlUtil.asPath(urlSource));
                }
                catch (UrlConversionException e) {
                    e.printStackTrace();
                }
            }
            return paths;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    static Optional<EntrypointResult> findFirstClass(ClassLoader loader, List<String> classNames) {
        for (String className : classNames) {
            String classFilename = className.replace('.', '/').concat(".class");
            Optional<Path> classSourcePath = GameProviderHelper.getSource(loader, classFilename);
            if (!classSourcePath.isPresent()) continue;
            return classSourcePath.map(sourcePath -> new EntrypointResult(className, (Path)sourcePath));
        }
        return Optional.empty();
    }

    public static class EntrypointResult {
        public final String entrypointName;
        public final Path entrypointPath;

        EntrypointResult(String entrypointName, Path entrypointPath) {
            this.entrypointName = entrypointName;
            this.entrypointPath = entrypointPath;
        }
    }
}

