/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.entrypoint.minecraft.hooks;

import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.loader.FabricLoaderImpl;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;

public final class EntrypointUtils {
    public static <T> void invoke(String name, Class<T> type, Consumer<? super T> invoker) {
        FabricLoaderImpl loader = FabricLoaderImpl.getInstance();
        if (!loader.hasEntrypoints(name)) {
            loader.getLogger().debug("No subscribers for entrypoint '" + name + "'");
        } else {
            EntrypointUtils.invoke0(name, type, invoker);
        }
    }

    private static <T> void invoke0(String name, Class<T> type, Consumer<? super T> invoker) {
        FabricLoaderImpl loader = FabricLoaderImpl.getInstance();
        Throwable exception = null;
        List<EntrypointContainer<T>> entrypoints = loader.getEntrypointContainers(name, type);
        loader.getLogger().debug("Iterating over entrypoint '" + name + "'");
        for (EntrypointContainer entrypointContainer : entrypoints) {
            try {
                invoker.accept(entrypointContainer.getEntrypoint());
            }
            catch (Throwable t) {
                if (exception == null) {
                    exception = new RuntimeException("Could not execute entrypoint stage '" + name + "' due to errors, provided by '" + entrypointContainer.getProvider().getMetadata().getId() + "'!", t);
                    continue;
                }
                exception.addSuppressed(t);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

