/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.discovery;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.discovery.ModCandidate;
import net.fabricmc.loader.launch.common.FabricLauncher;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.util.FileSystemUtil;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.fabricmc.loader.util.mappings.TinyRemapperMappingsHelper;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.objectweb.asm.commons.Remapper;

public final class RuntimeModRemapper {
    public static Collection<ModCandidate> remap(Collection<ModCandidate> modCandidates, FileSystem fileSystem) {
        Stream<ModCandidate> modsToSkip;
        List modsToRemap = modCandidates.stream().filter(ModCandidate::requiresRemap).collect(Collectors.toList());
        if (modsToRemap.isEmpty()) {
            return modCandidates;
        }
        FabricLauncher launcher = FabricLauncherBase.getLauncher();
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(TinyRemapperMappingsHelper.create(launcher.getMappingConfiguration().getMappings(), "intermediary", launcher.getTargetNamespace())).renameInvalidLocals(false).build();
        try {
            remapper.readClassPathAsync(RuntimeModRemapper.getRemapClasspath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to populate remap classpath", e);
        }
        ArrayList<ModCandidate> remappedMods = new ArrayList<ModCandidate>();
        try {
            HashMap<ModCandidate, RemapInfo> infoMap = new HashMap<ModCandidate, RemapInfo>();
            for (ModCandidate modCandidate : modsToRemap) {
                RemapInfo info = new RemapInfo(remapper.createInputTag(), UrlUtil.asPath(modCandidate.getOriginUrl()));
                infoMap.put(modCandidate, info);
                remapper.readInputsAsync(info.tag, new Path[]{info.inputPath});
            }
            for (RemapInfo remapInfo : infoMap.values()) {
                do {
                    remapInfo.outputPath = fileSystem.getPath(UUID.randomUUID() + ".jar", new String[0]);
                } while (Files.exists(remapInfo.outputPath, new LinkOption[0]));
                OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(remapInfo.outputPath).build();
                FileSystemUtil.FileSystemDelegate delegate = FileSystemUtil.getJarFileSystem(remapInfo.inputPath, false);
                if (delegate.get() == null) {
                    throw new RuntimeException("Could not open JAR file " + remapInfo.inputPath.getFileName() + " for NIO reading!");
                }
                Path inputJar = delegate.get().getRootDirectories().iterator().next();
                outputConsumer.addNonClassFiles(inputJar, NonClassCopyMode.FIX_META_INF, remapper);
                remapInfo.outputConsumerPath = outputConsumer;
                remapper.apply((BiConsumer)outputConsumer, new InputTag[]{remapInfo.tag});
            }
            for (Map.Entry entry : infoMap.entrySet()) {
                ModCandidate mod2 = (ModCandidate)entry.getKey();
                String accessWidener = mod2.getInfo().getAccessWidener();
                if (accessWidener == null) continue;
                RemapInfo info = (RemapInfo)entry.getValue();
                info.accessWidenerPath = accessWidener;
                FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(info.inputPath, false);
                Throwable throwable = null;
                try {
                    FileSystem fs = jarFs.get();
                    info.accessWidener = RuntimeModRemapper.remapAccessWidener(Files.readAllBytes(fs.getPath(accessWidener, new String[0])), (Remapper)remapper.getRemapper());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFs == null) continue;
                    if (throwable != null) {
                        try {
                            jarFs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFs.close();
                }
            }
            remapper.finish();
            for (Map.Entry entry : infoMap.entrySet()) {
                ModCandidate mod2 = (ModCandidate)entry.getKey();
                RemapInfo info = (RemapInfo)entry.getValue();
                info.outputConsumerPath.close();
                if (info.accessWidenerPath != null) {
                    try (FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(info.outputPath, false);){
                        FileSystem fs = jarFs.get();
                        Files.delete(fs.getPath(info.accessWidenerPath, new String[0]));
                        Files.write(fs.getPath(info.accessWidenerPath, new String[0]), info.accessWidener, new OpenOption[0]);
                    }
                }
                remappedMods.add(new ModCandidate(mod2.getInfo(), UrlUtil.asUrl(info.outputPath), 0, false));
            }
            modsToSkip = modCandidates.stream().filter(mod -> !infoMap.containsKey(mod));
        }
        catch (IOException | UrlConversionException e) {
            remapper.finish();
            throw new RuntimeException("Failed to remap mods", e);
        }
        return Stream.concat(remappedMods.stream(), modsToSkip).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private static byte[] remapAccessWidener(byte[] input, Remapper remapper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Path[] getRemapClasspath() throws IOException {
        String remapClasspathFile = System.getProperty("fabric.remapClasspathFile");
        if (remapClasspathFile == null) {
            throw new RuntimeException("No remapClasspathFile provided");
        }
        String content = new String(Files.readAllBytes(Paths.get(remapClasspathFile, new String[0])), StandardCharsets.UTF_8);
        return (Path[])Arrays.stream(content.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).toArray(Path[]::new);
    }

    private static class RemapInfo {
        final InputTag tag;
        final Path inputPath;
        Path outputPath;
        OutputConsumerPath outputConsumerPath;
        String accessWidenerPath;
        byte[] accessWidener;

        public RemapInfo(InputTag tag, Path inputPath) {
            this.tag = tag;
            this.inputPath = inputPath;
        }
    }
}

