/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.discovery;

import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.ZipError;
import net.fabricmc.loader.FabricLoaderImpl;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.Person;
import net.fabricmc.loader.discovery.ModCandidate;
import net.fabricmc.loader.discovery.ModCandidateFinder;
import net.fabricmc.loader.discovery.ModCandidateSet;
import net.fabricmc.loader.discovery.ModResolutionException;
import net.fabricmc.loader.discovery.ModResolver;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.lib.gson.MalformedJsonException;
import net.fabricmc.loader.metadata.EntrypointMetadata;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.metadata.ModMetadataParser;
import net.fabricmc.loader.metadata.NestedJarEntry;
import net.fabricmc.loader.metadata.ParseMetadataException;
import net.fabricmc.loader.metadata.V1ModMetadata;
import net.fabricmc.loader.util.FileSystemUtil;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.fabricmc.loader.util.version.StringVersion;

public class CoremodResolver
extends ModResolver {
    @Override
    public Map<String, ModCandidate> resolve(FabricLoaderImpl loader) throws ModResolutionException {
        ConcurrentHashMap candidatesById = new ConcurrentHashMap();
        long time1 = System.currentTimeMillis();
        ConcurrentLinkedQueue allActions = new ConcurrentLinkedQueue();
        ForkJoinPool pool = new ForkJoinPool(Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        for (ModCandidateFinder f : this.candidateFinders) {
            f.findCandidates(loader, (u, requiresRemap) -> {
                UrlProcessActionCore action = new UrlProcessActionCore(loader, candidatesById, (URL)u, 0, (boolean)requiresRemap);
                allActions.add(action);
                pool.execute(action);
            });
        }
        boolean tookTooLong = false;
        Throwable exception = null;
        try {
            pool.shutdown();
            pool.awaitTermination(30L, TimeUnit.SECONDS);
            for (ModResolver.UrlProcessAction action : allActions) {
                if (!action.isDone()) {
                    tookTooLong = true;
                    continue;
                }
                Throwable t = action.getException();
                if (t == null) continue;
                if (exception == null) {
                    exception = t;
                    continue;
                }
                exception.addSuppressed(t);
            }
        }
        catch (InterruptedException e) {
            throw new ModResolutionException("Mod resolution took too long!", e);
        }
        if (tookTooLong) {
            throw new ModResolutionException("Mod resolution took too long!");
        }
        if (exception != null) {
            throw new ModResolutionException("Mod resolution failed!", exception);
        }
        long time2 = System.currentTimeMillis();
        HashMap<String, ModCandidate> result = new HashMap<String, ModCandidate>();
        for (String s : candidatesById.keySet()) {
            result.put(s, ((ModCandidateSet)candidatesById.get(s)).toSortedSet().iterator().next());
        }
        long time3 = System.currentTimeMillis();
        loader.getLogger().debug("Mod resolution detection time: " + (time2 - time1) + "ms");
        loader.getLogger().debug("Mod resolution time: " + (time3 - time2) + "ms");
        for (ModCandidate candidate : result.values()) {
            if (candidate.getInfo().getSchemaVersion() < 1) {
                loader.getLogger().warn("Mod ID " + candidate.getInfo().getId() + " uses outdated schema version: " + candidate.getInfo().getSchemaVersion() + " < " + 1);
            }
            candidate.getInfo().emitFormatWarnings(loader.getLogger());
        }
        return result;
    }

    static class UrlProcessActionCore
    extends ModResolver.UrlProcessAction {
        UrlProcessActionCore(FabricLoaderImpl loader, Map<String, ModCandidateSet> candidatesById, URL url, int depth, boolean requiresRemap) {
            super(loader, candidatesById, url, depth, requiresRemap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void compute() {
            Object recommends;
            LoaderModMetadata[] info;
            Path rootDir;
            Path modJson;
            URL normalizedUrl;
            Path path;
            this.loader.getLogger().debug("Testing " + this.url);
            try {
                path = UrlUtil.asPath(this.url).normalize();
                normalizedUrl = UrlUtil.asUrl(path);
            }
            catch (UrlConversionException e) {
                throw new RuntimeException("Failed to convert URL " + this.url + "!", e);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                modJson = path.resolve("fabric.mod.json");
                rootDir = path;
                if (this.loader.isDevelopmentEnvironment() && !Files.exists(modJson, new LinkOption[0])) {
                    this.loader.getLogger().warn("Adding directory " + path + " to mod classpath in development environment - workaround for Gradle splitting mods into two directories");
                    Object e = ModResolver.launcherSyncObject;
                    synchronized (e) {
                        FabricLauncherBase.getLauncher().propose(this.url);
                    }
                }
            } else {
                try {
                    FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(path, false);
                    modJson = jarFs.get().getPath("fabric.mod.json", new String[0]);
                    rootDir = jarFs.get().getRootDirectories().iterator().next();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to open mod JAR at " + path + "!");
                }
                catch (ZipError e) {
                    throw new RuntimeException("Jar at " + path + " is corrupted, please redownload it!");
                }
            }
            try {
                info = new LoaderModMetadata[]{ModMetadataParser.parseMetadata(this.loader.getLogger(), modJson)};
            }
            catch (ParseMetadataException.MissingRequired e) {
                throw new RuntimeException(String.format("Mod at \"%s\" has an invalid fabric.mod.json file! The mod is missing the following required field!", path), e);
            }
            catch (MalformedJsonException | ParseMetadataException e) {
                throw new RuntimeException(String.format("Mod at \"%s\" has an invalid fabric.mod.json file!", path), e);
            }
            catch (NoSuchFileException e) {
                this.loader.getLogger().warn(String.format("Non-Fabric mod JAR at \"%s\", adding it anyway", path));
                ArrayList<String> provides = new ArrayList<String>();
                ModEnvironment environment = ModEnvironment.UNIVERSAL;
                HashMap<String, List<EntrypointMetadata>> entrypoints = new HashMap<String, List<EntrypointMetadata>>();
                ArrayList<NestedJarEntry> jars = new ArrayList<NestedJarEntry>();
                ArrayList<V1ModMetadata.MixinEntry> mixins = new ArrayList<V1ModMetadata.MixinEntry>();
                String accessWidener = null;
                HashMap<String, ModDependency> depends = new HashMap<String, ModDependency>();
                recommends = new HashMap();
                HashMap<String, ModDependency> suggests = new HashMap<String, ModDependency>();
                HashMap<String, ModDependency> conflicts = new HashMap<String, ModDependency>();
                HashMap<String, ModDependency> breaks = new HashMap<String, ModDependency>();
                HashMap<String, ModDependency> requires = new HashMap<String, ModDependency>();
                String name = null;
                String description = null;
                ArrayList<Person> authors = new ArrayList<Person>();
                ArrayList<Person> contributors = new ArrayList<Person>();
                ContactInformation contact = null;
                ArrayList<String> license = new ArrayList<String>();
                V1ModMetadata.IconEntry icon = null;
                HashMap<String, String> languageAdapters = new HashMap<String, String>();
                HashMap<String, CustomValue> customValues = new HashMap<String, CustomValue>();
                info = new LoaderModMetadata[]{new V1ModMetadata("coremod" + path.getFileName().toString().replace(".jar", "").toLowerCase().replaceAll("[^a-z]", ""), new StringVersion("1.0.0"), provides, environment, entrypoints, jars, mixins, accessWidener, depends, (Map<String, ModDependency>)recommends, suggests, conflicts, breaks, requires, name, description, authors, contributors, contact, license, icon, languageAdapters, customValues)};
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to open fabric.mod.json for mod at \"%s\"!", path), e);
            }
            catch (Throwable t) {
                throw new RuntimeException(String.format("Failed to parse mod metadata for mod at \"%s\"", path), t);
            }
            for (LoaderModMetadata i : info) {
                ModCandidate candidate = new ModCandidate(i, normalizedUrl, this.depth, this.requiresRemap);
                if (candidate.getInfo().getId() == null || candidate.getInfo().getId().isEmpty()) {
                    throw new RuntimeException(String.format("Mod file `%s` has no id", candidate.getOriginUrl().getFile()));
                }
                if (!ModResolver.MOD_ID_PATTERN.matcher(candidate.getInfo().getId()).matches()) {
                    ArrayList errorList = new ArrayList();
                    ModResolver.isModIdValid(candidate.getInfo().getId(), errorList);
                    StringBuilder fullError = new StringBuilder("Mod id `");
                    fullError.append(candidate.getInfo().getId()).append("` does not match the requirements because");
                    if (errorList.size() == 1) {
                        fullError.append(" it ").append((String)errorList.get(0));
                    } else {
                        fullError.append(":");
                        recommends = errorList.iterator();
                        while (recommends.hasNext()) {
                            String error = (String)recommends.next();
                            fullError.append("\n  - It ").append(error);
                        }
                    }
                    throw new RuntimeException(fullError.toString());
                }
                for (String provides : candidate.getInfo().getProvides()) {
                    if (ModResolver.MOD_ID_PATTERN.matcher(provides).matches()) continue;
                    ArrayList<String> errorList = new ArrayList<String>();
                    ModResolver.isModIdValid(provides, errorList);
                    StringBuilder fullError = new StringBuilder("Mod id provides `");
                    fullError.append(provides).append("` does not match the requirements because");
                    if (errorList.size() == 1) {
                        fullError.append(" it ").append((String)errorList.get(0));
                    } else {
                        fullError.append(":");
                        for (String error : errorList) {
                            fullError.append("\n  - It ").append(error);
                        }
                    }
                    throw new RuntimeException(fullError.toString());
                }
                boolean added = this.candidatesById.computeIfAbsent(candidate.getInfo().getId(), ModCandidateSet::new).add(candidate);
                if (!added) {
                    this.loader.getLogger().debug(candidate.getOriginUrl() + " already present as " + candidate);
                    continue;
                }
                this.loader.getLogger().debug("Adding " + candidate.getOriginUrl() + " as " + candidate);
                List jarInJars = ModResolver.inMemoryCache.computeIfAbsent(candidate.getOriginUrl().toString(), u -> {
                    this.loader.getLogger().debug("Searching for nested JARs in " + candidate);
                    this.loader.getLogger().debug(u);
                    Collection<NestedJarEntry> jars = candidate.getInfo().getJars();
                    ArrayList list = new ArrayList(jars.size());
                    jars.stream().map(j -> rootDir.resolve(j.getFile().replace("/", rootDir.getFileSystem().getSeparator()))).forEach(modPath -> {
                        if (!Files.isDirectory(modPath, new LinkOption[0]) && modPath.toString().endsWith(".jar")) {
                            this.loader.getLogger().debug("Found nested JAR: " + modPath);
                            Path dest = ModResolver.inMemoryFs.getPath(UUID.randomUUID() + ".jar", new String[0]);
                            try {
                                Files.copy(modPath, dest, new CopyOption[0]);
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failed to load nested JAR " + modPath + " into memory (" + dest + ")!", e);
                            }
                            list.add(dest);
                        }
                    });
                    return list;
                });
                if (jarInJars.isEmpty()) continue;
                UrlProcessActionCore.invokeAll(jarInJars.stream().map(p -> {
                    try {
                        return new ModResolver.UrlProcessAction(this.loader, this.candidatesById, UrlUtil.asUrl(p.normalize()), this.depth + 1, this.requiresRemap);
                    }
                    catch (UrlConversionException e) {
                        throw new RuntimeException("Failed to turn path '" + p.normalize() + "' into URL!", e);
                    }
                }).collect(Collectors.toList()));
            }
        }
    }
}

