/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.util.mappings.TinyRemapperMappingsHelper;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.Descriptored;
import net.fabricmc.mapping.tree.Mapped;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.mappings.EntryTriple;

class FabricMappingResolver
implements MappingResolver {
    private final Supplier<TinyTree> mappingsSupplier;
    private final Set<String> namespaces;
    private final Map<String, NamespaceData> namespaceDataMap = new HashMap<String, NamespaceData>();
    private final String targetNamespace;

    FabricMappingResolver(Supplier<TinyTree> mappingsSupplier, String targetNamespace) {
        this.mappingsSupplier = mappingsSupplier;
        this.targetNamespace = targetNamespace;
        this.namespaces = Collections.unmodifiableSet(new HashSet(mappingsSupplier.get().getMetadata().getNamespaces()));
    }

    protected final NamespaceData getNamespaceData(String namespace) {
        return this.namespaceDataMap.computeIfAbsent(namespace, fromNamespace -> {
            if (!this.namespaces.contains(fromNamespace)) {
                throw new IllegalArgumentException("Unknown namespace: " + fromNamespace);
            }
            NamespaceData data = new NamespaceData();
            TinyTree mappings = this.mappingsSupplier.get();
            for (ClassDef classEntry : mappings.getClasses()) {
                String fromClass = FabricMappingResolver.replaceSlashesWithDots(Strings.nullToEmpty((String)classEntry.getRawName(fromNamespace)));
                if (fromClass.isEmpty()) continue;
                String toClass = FabricMappingResolver.replaceSlashesWithDots(Strings.nullToEmpty((String)classEntry.getRawName(this.targetNamespace)));
                if (toClass.isEmpty()) {
                    toClass = fromClass;
                }
                data.classNames.put(fromClass, toClass);
                data.classNamesInverse.put(toClass, fromClass);
                this.recordMember((String)fromNamespace, classEntry.getFields(), data.fieldNames, fromClass);
                this.recordMember((String)fromNamespace, classEntry.getMethods(), data.methodNames, fromClass);
            }
            return data;
        });
    }

    private static String replaceSlashesWithDots(String cname) {
        return cname.replace('/', '.');
    }

    private <T extends Descriptored> void recordMember(String fromNamespace, Collection<T> descriptoredList, Map<EntryTriple, String> putInto, String fromClass) {
        for (Descriptored descriptored : descriptoredList) {
            String memberName = descriptored.getRawName(fromNamespace);
            if (Strings.isNullOrEmpty((String)memberName)) continue;
            EntryTriple fromEntry = new EntryTriple(fromClass, memberName, descriptored.getDescriptor(fromNamespace));
            putInto.put(fromEntry, TinyRemapperMappingsHelper.tryName((Mapped)descriptored, this.targetNamespace, memberName));
        }
    }

    @Override
    public Collection<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getCurrentRuntimeNamespace() {
        return this.targetNamespace;
    }

    @Override
    public String mapClassName(String namespace, String className) {
        if (className.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + className);
        }
        return this.getNamespaceData(namespace).classNames.getOrDefault(className, className);
    }

    @Override
    public String unmapClassName(String namespace, String className) {
        if (className.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + className);
        }
        return this.getNamespaceData(namespace).classNamesInverse.getOrDefault(className, className);
    }

    @Override
    public String mapFieldName(String namespace, String owner, String name, String descriptor) {
        if (owner.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + owner);
        }
        return this.getNamespaceData(namespace).fieldNames.getOrDefault(new EntryTriple(owner, name, descriptor), name);
    }

    @Override
    public String mapMethodName(String namespace, String owner, String name, String descriptor) {
        if (owner.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + owner);
        }
        return this.getNamespaceData(namespace).methodNames.getOrDefault(new EntryTriple(owner, name, descriptor), name);
    }

    private static class NamespaceData {
        private final Map<String, String> classNames = new HashMap<String, String>();
        private final Map<String, String> classNamesInverse = new HashMap<String, String>();
        private final Map<EntryTriple, String> fieldNames = new HashMap<EntryTriple, String>();
        private final Map<EntryTriple, String> methodNames = new HashMap<EntryTriple, String>();

        private NamespaceData() {
        }
    }
}

